/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.thecoolcraft11.config.ConfigManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LikedScreenshotsScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(LikedScreenshotsScreen.class);
    private final class_437 parent;
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<Path> imagePaths = new ArrayList<Path>();
    private static final List<JsonObject> metaDatas = new ArrayList<JsonObject>();
    private static final List<Boolean> isServerScreenshot = new ArrayList<Boolean>();
    private static final int IMAGES_PER_ROW = ConfigManager.getClientConfig().imagesPerRow;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = ConfigManager.getClientConfig().imageGap;
    private static int TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
    private static boolean isImageClicked = false;
    private static int clickedImageIndex = -1;
    private int scrollOffset;
    private double zoomLevel = 1.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private class_4185 openInAppButton;
    private class_4185 filterAllButton;
    private class_4185 filterLocalButton;
    private class_4185 filterServerButton;
    private FilterMode currentFilter = FilterMode.ALL;
    private static final String LOCAL_FILE_PATH = "./config/screenshotUploader/data/local.json";
    private static final String SERVER_DIR_PATH = "./screenshots_cache/";

    public LikedScreenshotsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.liked_screenshots.title"));
        this.parent = parent;
        this.initializeScreen();
    }

    private void initializeScreen() {
        imageIds.clear();
        imagePaths.clear();
        metaDatas.clear();
        isServerScreenshot.clear();
        clickedImageIndex = -1;
        isImageClicked = false;
        this.scrollOffset = 0;
    }

    protected void method_25426() {
        super.method_25426();
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonY = this.field_22790 - buttonHeight - 5;
        class_4185 backButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.liked_screenshots.back"), button -> {
            if (isImageClicked) {
                isImageClicked = false;
                clickedImageIndex = -1;
            } else if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(5, 5, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_app"), button -> this.openImageInApp()).method_46434(2 * buttonWidth + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        this.filterAllButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.liked_screenshots.all"), button -> {
            this.currentFilter = FilterMode.ALL;
            this.updateFilterButtons();
            this.loadLikedScreenshots();
        }).method_46434(this.field_22789 - buttonWidth * 3 - 15, 5, buttonWidth, buttonHeight).method_46431();
        this.filterLocalButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.liked_screenshots.local"), button -> {
            this.currentFilter = FilterMode.LOCAL;
            this.updateFilterButtons();
            this.loadLikedScreenshots();
        }).method_46434(this.field_22789 - buttonWidth * 2 - 10, 5, buttonWidth, buttonHeight).method_46431();
        this.filterServerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.liked_screenshots.server"), button -> {
            this.currentFilter = FilterMode.SERVER;
            this.updateFilterButtons();
            this.loadLikedScreenshots();
        }).method_46434(this.field_22789 - buttonWidth - 5, 5, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)backButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.filterAllButton);
        this.method_37063((class_364)this.filterLocalButton);
        this.method_37063((class_364)this.filterServerButton);
        this.openInAppButton.field_22764 = false;
        this.updateFilterButtons();
        if (class_310.method_1551() != null) {
            class_310.method_1551().execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.loadLikedScreenshots();
            });
        }
    }

    private void updateFilterButtons() {
        this.filterAllButton.field_22763 = this.currentFilter != FilterMode.ALL;
        this.filterLocalButton.field_22763 = this.currentFilter != FilterMode.LOCAL;
        this.filterServerButton.field_22763 = this.currentFilter != FilterMode.SERVER;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (isImageClicked) {
                int imageWidth = (int)((double)IMAGE_WIDTH * this.zoomLevel);
                int imageHeight = (int)((double)IMAGE_HEIGHT * this.zoomLevel);
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                isImageClicked = false;
                clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / IMAGES_PER_ROW;
                int col = i % IMAGES_PER_ROW;
                int x = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                isImageClicked = true;
                clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (isImageClicked && clickedImageIndex >= 0) {
            double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
            double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
            double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
            double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
            this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
            double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
            double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
            this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
            this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
            return true;
        }
        if (verticalAmount < 0.0) {
            this.scrollOffset += GAP + IMAGE_HEIGHT;
        } else if (verticalAmount > 0.0) {
            this.scrollOffset -= GAP + IMAGE_HEIGHT;
        }
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, (imageIds.size() / IMAGES_PER_ROW + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (isImageClicked && clickedImageIndex >= 0) {
            this.renderEnlargedImage(context);
            this.openInAppButton.field_22764 = true;
        } else {
            this.renderGallery(context, mouseX, mouseY);
            this.openInAppButton.field_22764 = false;
            if (this.field_22787 != null) {
                String titleText = "Liked Screenshots";
                switch (this.currentFilter.ordinal()) {
                    case 1: {
                        titleText = "Local Liked Screenshots";
                        break;
                    }
                    case 2: {
                        titleText = "Server Liked Screenshots";
                        break;
                    }
                }
                context.method_25300(this.field_22787.field_1772, titleText, this.field_22789 / 2, TOP_PADDING / 2, 0xFFFFFF);
            }
            if (imageIds.isEmpty() && this.field_22787 != null) {
                context.method_25300(this.field_22787.field_1772, "No liked screenshots found", this.field_22789 / 2, this.field_22790 / 2, 0xAAAAAA);
            }
        }
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        if (imageIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < imageIds.size(); ++i) {
            int row = i / IMAGES_PER_ROW;
            int col = i % IMAGES_PER_ROW;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            int borderColor = isServerScreenshot.get(i) != false ? -7829249 : -7798904;
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, borderColor);
            class_2960 imageId = imageIds.get(i);
            context.method_25290(class_1921::method_62277, imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX > x && mouseX < x + IMAGE_WIDTH && mouseY > y && mouseY < y + IMAGE_HEIGHT) {
                context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
            }
            if (this.field_22787 == null || i >= metaDatas.size()) continue;
            context.method_51433(this.field_22787.field_1772, "\u2764", x + 5, y + IMAGE_HEIGHT - 15, 0xFF0000, true);
            String sourceIcon = isServerScreenshot.get(i) != false ? "S" : "L";
            int iconColor = isServerScreenshot.get(i) != false ? 0x8888FF : 0x88FF88;
            context.method_51433(this.field_22787.field_1772, sourceIcon, x + IMAGE_WIDTH - 10, y + 5, iconColor, true);
        }
    }

    private void renderEnlargedImage(class_332 context) {
        if (clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(clickedImageIndex);
        int imageWidth = (int)((double)IMAGE_WIDTH * this.zoomLevel);
        int imageHeight = (int)((double)IMAGE_HEIGHT * this.zoomLevel);
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        int borderColor = isServerScreenshot.get(clickedImageIndex) != false ? -7829249 : -7798904;
        context.method_25294(x - 5, y - 5, x + imageWidth + 5, y + imageHeight + 5, borderColor);
        context.method_25290(class_1921::method_62277, clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        if (clickedImageIndex < metaDatas.size() && this.field_22787 != null) {
            JsonObject metadata = metaDatas.get(clickedImageIndex);
            int textY = y + imageHeight + 10;
            String source = isServerScreenshot.get(clickedImageIndex) != false ? "Server Screenshot" : "Local Screenshot";
            context.method_51433(this.field_22787.field_1772, source, x, textY, 0xFFFFFF, false);
            if (metadata.has("screenshotUrl")) {
                String path = metadata.get("screenshotUrl").getAsString();
                String fileName = new File(path).getName();
                context.method_51433(this.field_22787.field_1772, fileName, x, textY + 15, 0xCCCCCC, false);
            }
            if (metadata.has("screenshotId")) {
                String id = metadata.get("screenshotId").getAsString();
                context.method_51433(this.field_22787.field_1772, "ID: " + id, x, textY + 30, 0xAAAAAA, false);
            }
        }
    }

    private void loadLikedScreenshots() {
        this.initializeScreen();
        CompletableFuture.runAsync(() -> {
            ArrayList<JsonObject> localLikedScreenshots;
            HashMap<CallSite, Path> serverScreenshotsMap;
            block26: {
                File localFile;
                serverScreenshotsMap = new HashMap<CallSite, Path>();
                localLikedScreenshots = new ArrayList<JsonObject>();
                File serverDir = new File(SERVER_DIR_PATH);
                if (serverDir.exists() && serverDir.isDirectory()) {
                    for (File file : Objects.requireNonNull(serverDir.listFiles())) {
                        if (!file.isFile() || !file.getName().endsWith(".png")) continue;
                        String hash = file.getName().replace(".png", "");
                        serverScreenshotsMap.put((CallSite)((Object)("webimage:temp/" + hash)), file.toPath());
                    }
                }
                if ((localFile = new File(LOCAL_FILE_PATH)).exists()) {
                    try (FileReader reader = new FileReader(localFile, StandardCharsets.UTF_8);){
                        JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                        for (JsonElement element : jsonArray) {
                            if (!element.isJsonObject()) continue;
                            JsonObject obj = element.getAsJsonObject();
                            localLikedScreenshots.add(obj);
                        }
                    }
                    catch (IOException e) {
                        logger.error("Failed to load liked screenshots: {}", (Object)e.getMessage());
                    }
                }
                try {
                    File[] jsonFiles = new File("./config/screenshotUploader/data/").listFiles((dir, name) -> name.endsWith(".json") && !name.equals("local.json"));
                    if (jsonFiles == null) break block26;
                    for (File jsonFile : jsonFiles) {
                        try (FileReader reader = new FileReader(jsonFile, StandardCharsets.UTF_8);){
                            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                            for (JsonElement element : jsonArray) {
                                String screenshotId;
                                JsonObject obj;
                                if (!element.isJsonObject() || !(obj = element.getAsJsonObject()).has("screenshotId") || !serverScreenshotsMap.containsKey(screenshotId = obj.get("screenshotId").getAsString())) continue;
                                localLikedScreenshots.add(obj);
                            }
                        }
                        catch (JsonSyntaxException | IOException e) {
                            logger.error("Failed to load server liked screenshots from {}: {}", (Object)jsonFile.getName(), (Object)e.getMessage());
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Error processing server JSON files: {}", (Object)e.getMessage());
                }
            }
            for (JsonObject entry : localLikedScreenshots) {
                String hash;
                Path imagePath;
                if (!entry.has("screenshotId") || !entry.has("screenshotUrl")) continue;
                String screenshotId = entry.get("screenshotId").getAsString();
                String screenshotUrl = entry.get("screenshotUrl").getAsString();
                boolean isServer = screenshotId.startsWith("webimage:temp/");
                if (this.currentFilter == FilterMode.LOCAL && isServer || this.currentFilter == FilterMode.SERVER && !isServer || (isServer ? (imagePath = (Path)serverScreenshotsMap.get(screenshotId)) == null && !Files.exists(imagePath = Paths.get(SERVER_DIR_PATH, (hash = screenshotId.replace("webimage:temp/", "")) + ".png"), new LinkOption[0]) : !Files.exists(imagePath = Paths.get(screenshotUrl, new String[0]), new LinkOption[0]))) continue;
                try {
                    Path finalImagePath = imagePath;
                    CompletableFuture.runAsync(() -> {
                        try {
                            class_1011 image;
                            String fileName = finalImagePath.getFileName().toString().toLowerCase();
                            if (fileName.endsWith(".png")) {
                                image = class_1011.method_4309((InputStream)Files.newInputStream(finalImagePath, new OpenOption[0]));
                            } else {
                                image = this.loadNonPngImage(finalImagePath.toFile());
                                if (image == null) {
                                    logger.error("Failed to load non-PNG image: {}", (Object)finalImagePath);
                                    return;
                                }
                            }
                            class_2960 textureId = class_2960.method_60655((String)"gallery", (String)("textures/" + finalImagePath.getFileName().toString()));
                            if (this.field_22787 != null) {
                                this.field_22787.execute(() -> {
                                    this.field_22787.method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, image));
                                    imageIds.add(textureId);
                                    imagePaths.add(finalImagePath);
                                    metaDatas.add(entry);
                                    isServerScreenshot.add(isServer);
                                });
                            }
                        }
                        catch (IOException e) {
                            logger.error("Failed to load image {}: {}", (Object)finalImagePath, (Object)e.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("Error processing screenshot {}: {}", (Object)imagePath, (Object)e.getMessage());
                }
            }
        });
    }

    private class_1011 loadNonPngImage(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return null;
            }
            int width = bufferedImage.getWidth();
            int height = bufferedImage.getHeight();
            class_1011 nativeImage = new class_1011(width, height, true);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int alpha = rgb >> 24 & 0xFF;
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    nativeImage.method_4305(x, y, alpha << 24 | red << 16 | green << 8 | blue);
                }
            }
            return nativeImage;
        }
        catch (IOException e) {
            logger.error("Failed to load non-PNG image {}: {}", (Object)file.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private void openImageInApp() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            Path imagePath = imagePaths.get(clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("explorer", imagePath.toAbsolutePath().toString());
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", imagePath.toAbsolutePath().toString());
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", imagePath.toAbsolutePath().toString());
                } else {
                    logger.error("Unsupported operating system for opening the image.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open image with external application: {}", (Object)e.getMessage());
            }
        }
    }

    public void method_25419() {
        if (isImageClicked) {
            isImageClicked = false;
            clickedImageIndex = -1;
        } else if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
        imageIds.clear();
        imagePaths.clear();
        metaDatas.clear();
        isServerScreenshot.clear();
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    private static enum FilterMode {
        ALL,
        LOCAL,
        SERVER;

    }
}

