/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotScreen.class);
    private static class_2960 screenshotIdentifier;
    private double zoomLevel = 1.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private final String screenshotUrl;
    boolean loaded = false;
    private double scrollSpeedMultiplier = 1.0;
    private long lastScrollTime = 0L;

    public ScreenshotScreen(String screenshotUrl) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_screen.title"));
        this.screenshotUrl = screenshotUrl;
        screenshotIdentifier = null;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (screenshotIdentifier != null) {
            this.renderEnlargedImage(context);
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_screen.no_image"), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.screenshotUrl), this.field_22789 / 2, this.field_22790 / 2 + 10, 0xFFFFFF);
            if (!this.loaded) {
                ScreenshotScreen.loadWebImage(this.screenshotUrl);
                this.loaded = true;
            }
        }
    }

    private static void loadWebImage(String imageUrl) {
        block48: {
            String cacheFileName = "screenshots_cache/" + imageUrl.hashCode() + ".png";
            File cachedImage = new File(cacheFileName);
            if (cachedImage.exists()) {
                try (InputStream fileInputStream2 = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                     class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream2);){
                    class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                    if (class_310.method_1551() != null) {
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, loadedImage));
                        screenshotIdentifier = textureId;
                    }
                }
                catch (IOException fileInputStream2) {}
            } else {
                try {
                    String redirectUrl;
                    URI uri = new URI(imageUrl);
                    if (!uri.isAbsolute()) {
                        return;
                    }
                    URL url = uri.toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestProperty("User-Agent", "ScreenshotUploader/2.0");
                    connection.setInstanceFollowRedirects(false);
                    connection.setRequestMethod("HEAD");
                    connection.setConnectTimeout(3000);
                    connection.setReadTimeout(3000);
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    if (!(responseCode != 302 && responseCode != 301 && responseCode != 303 || (redirectUrl = connection.getHeaderField("Location")) == null || redirectUrl.isEmpty())) {
                        logger.info("Following redirect: {} -> {}", (Object)imageUrl, (Object)redirectUrl);
                        imageUrl = redirectUrl;
                        url = new URI(redirectUrl).toURL();
                    }
                    connection.disconnect();
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("User-Agent", "ScreenshotUploader/2.0");
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    connection.connect();
                    if (connection.getResponseCode() != 200) break block48;
                    try (InputStream inputStream = connection.getInputStream();){
                        BufferedImage bufferedImage = ImageIO.read(inputStream);
                        if (bufferedImage == null) break block48;
                        File cacheFolder = new File("screenshots_cache");
                        if (!cacheFolder.exists() && cacheFolder.mkdirs()) {
                            logger.info("Created web screenshots cache folder");
                        }
                        ImageIO.write((RenderedImage)bufferedImage, "PNG", cachedImage);
                        try (class_1011 nativeImage = new class_1011(bufferedImage.getWidth(), bufferedImage.getHeight(), false);){
                            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                                for (int x = 0; x < bufferedImage.getWidth(); ++x) {
                                    int rgb = bufferedImage.getRGB(x, y);
                                    int alpha = rgb >> 24 & 0xFF;
                                    int red = rgb >> 16 & 0xFF;
                                    int green = rgb >> 8 & 0xFF;
                                    int blue = rgb & 0xFF;
                                    int argb = alpha << 24 | red << 16 | green << 8 | blue;
                                    nativeImage.method_61941(x, y, argb);
                                }
                            }
                            try (InputStream fileInputStream = Files.newInputStream(cachedImage.toPath(), new OpenOption[0]);
                                 class_1011 loadedImage = class_1011.method_4309((InputStream)fileInputStream);){
                                class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                                if (class_310.method_1551() != null) {
                                    class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, loadedImage));
                                    screenshotIdentifier = textureId;
                                }
                            }
                        }
                    }
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        }
    }

    private void renderEnlargedImage(class_332 context) {
        class_2960 clickedImageId = screenshotIdentifier;
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        context.method_25290(class_1921::method_62277, clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.zoomAndRepositionImage(mouseX, mouseY, verticalAmount);
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void zoomAndRepositionImage(double mouseX, double mouseY, double verticalAmount) {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastScroll = currentTime - this.lastScrollTime;
        this.lastScrollTime = currentTime;
        this.scrollSpeedMultiplier = timeSinceLastScroll < 200L ? Math.min(this.scrollSpeedMultiplier * 1.25, 5.0) : 1.0;
        double scrollStep = 0.1 * this.scrollSpeedMultiplier;
        double zoomChange = verticalAmount > 0.0 ? scrollStep : -scrollStep;
        double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
        double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
        double imageWidth = 192.0 * this.zoomLevel;
        double imageHeight = 108.0 * this.zoomLevel;
        double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
        double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
        this.zoomLevel = Math.min(Math.max(this.zoomLevel + zoomChange, 0.05), 512.0);
        double newImageWidth = 192.0 * this.zoomLevel;
        double newImageHeight = 108.0 * this.zoomLevel;
        this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
        this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            boolean insideImage;
            int imageWidth = 0;
            int imageHeight = 0;
            if (this.field_22787 != null) {
                imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
            }
            int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
            int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
            boolean bl = insideImage = mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight);
            if (!insideImage) {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(null);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

