/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotTaggingScreen
extends class_437 {
    private final class_437 parent;
    private final String screenshotPath;
    private class_342 tagInputField;
    private final List<String> currentTags = new ArrayList<String>();
    private int scrollOffset = 0;
    private final int maxVisible = 10;
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotTaggingScreen.class);
    private final Gson gson = new Gson();

    public ScreenshotTaggingScreen(class_437 parent, String screenshotPath) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.title"));
        this.parent = parent;
        this.screenshotPath = screenshotPath;
        this.loadExistingTags();
    }

    protected void method_25426() {
        super.method_25426();
        this.tagInputField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 50, 200, 20, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.input"));
        this.tagInputField.method_1880(12);
        this.method_25429((class_364)this.tagInputField);
        this.method_48265((class_364)this.tagInputField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.add_tag"), button -> this.addTag()).method_46434(this.field_22789 / 2 - 100, 75, 200, 20).method_46431());
        class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.save"), button -> {
            this.saveTags();
            class_310.method_1551().method_1507(this.parent);
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431();
        this.method_37063((class_364)saveButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        this.tagInputField.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.current_tags"), this.field_22789 / 2, 110, 0xFFFFFF);
        int yPos = 130;
        int tagsAreaHeight = this.field_22790 - 170;
        int totalEntries = this.currentTags.size();
        if (totalEntries > 0) {
            for (int i = this.scrollOffset; i < Math.min(this.currentTags.size(), this.scrollOffset + 10); ++i) {
                String tag = this.currentTags.get(i);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)tag), this.field_22789 / 2, yPos, 0xAAAAAA);
                if (mouseX >= this.field_22789 / 2 + 110 && mouseX <= this.field_22789 / 2 + 120 && mouseY >= yPos - 5 && mouseY <= yPos + 5) {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2715"), this.field_22789 / 2 + 115, yPos, 0xFF0000);
                } else {
                    context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2715"), this.field_22789 / 2 + 115, yPos, 0x999999);
                }
                yPos += 20;
            }
            if (totalEntries > 10) {
                int scrollBarHeight = Math.max(20, tagsAreaHeight * 10 / totalEntries);
                int scrollBarY = 130 + (tagsAreaHeight - scrollBarHeight) * this.scrollOffset / (totalEntries - 10);
                context.method_25294(this.field_22789 / 2 + 130, 130, this.field_22789 / 2 + 135, this.field_22790 - 40, 0x33FFFFFF);
                context.method_25294(this.field_22789 / 2 + 130, scrollBarY, this.field_22789 / 2 + 135, scrollBarY + scrollBarHeight, -1711276033);
            }
        } else {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.tagging_screen.no_tags"), this.field_22789 / 2, yPos + 30, 0x888888);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.currentTags.size() > 10) {
            if (verticalAmount > 0.0) {
                if (this.scrollOffset > 0) {
                    --this.scrollOffset;
                }
            } else if (verticalAmount < 0.0 && this.scrollOffset < this.currentTags.size() - 10) {
                ++this.scrollOffset;
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int yPos = 130;
        for (int i = this.scrollOffset; i < Math.min(this.currentTags.size(), this.scrollOffset + 10); ++i) {
            if (mouseX >= (double)this.field_22789 / 2.0 + 110.0 && mouseX <= (double)this.field_22789 / 2.0 + 120.0 && mouseY >= (double)(yPos - 5) && mouseY <= (double)(yPos + 5)) {
                this.currentTags.remove(i);
                return true;
            }
            yPos += 20;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void addTag() {
        String tag = this.tagInputField.method_1882().trim();
        if (!tag.isEmpty() && !this.currentTags.contains(tag)) {
            this.currentTags.add(tag);
            this.tagInputField.method_1852("");
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.tagInputField.method_25370() && keyCode == 257) {
            this.addTag();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void loadExistingTags() {
        block17: {
            try {
                File jsonFile = new File(this.screenshotPath.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                if (!jsonFile.exists()) {
                    boolean wasCreated = jsonFile.createNewFile();
                    if (wasCreated) {
                        try (FileWriter writer = new FileWriter(jsonFile);){
                            writer.write("{}");
                        }
                    } else {
                        logger.error("File already exists.");
                    }
                }
                if (!jsonFile.exists()) break block17;
                try (JsonReader reader = new JsonReader((Reader)new FileReader(jsonFile));){
                    JsonObject json = (JsonObject)this.gson.fromJson(reader, JsonObject.class);
                    if (json.has("tags")) {
                        JsonArray tagsArray = json.getAsJsonArray("tags");
                        for (JsonElement tag : tagsArray) {
                            this.currentTags.add(tag.getAsString());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error loading tags: {}", (Object)e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void saveTags() {
        try {
            jsonFile = new File(this.screenshotPath.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
            if (jsonFile.exists()) {
                reader = new JsonReader((Reader)new FileReader(jsonFile));
                try {
                    json = (JsonObject)this.gson.fromJson(reader, JsonObject.class);
                    if (json != null) ** GOTO lbl14
                    json = new JsonObject();
                }
                finally {
                    reader.close();
                }
            } else {
                json = new JsonObject();
            }
lbl14:
            // 3 sources

            tagsArray = new JsonArray();
            this.currentTags.forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(java.lang.String ), (Ljava/lang/String;)V)((JsonArray)tagsArray));
            json.add("tags", (JsonElement)tagsArray);
            writer = new FileWriter(jsonFile);
            try {
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            ScreenshotTaggingScreen.logger.error("Error saving tags: {}", (Object)e.getMessage());
        }
    }
}

