/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.data.Album;
import de.thecoolcraft11.screen.AlbumConfigScreen;
import de.thecoolcraft11.screen.GalleryScreen;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectAlbumScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(SelectAlbumScreen.class);
    private final class_437 parent;
    private final String screenshotPath;
    private final List<Album> albums = new ArrayList<Album>();
    private int selectedAlbumIndex = -1;
    private int scrollOffset = 0;
    private final int maxAlbumsVisible = 6;
    private boolean setAsCover = false;
    private class_4185 setAsCoverButton;

    public SelectAlbumScreen(class_437 parent, String screenshotPath) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.select_album.title"));
        this.parent = parent;
        this.screenshotPath = screenshotPath;
        if (parent instanceof GalleryScreen) {
            GalleryScreen galleryScreen = (GalleryScreen)parent;
            galleryScreen.cancelAllAsyncTasks();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.albums.clear();
        this.albums.addAll(AlbumManager.getAllAlbums());
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof GalleryScreen) {
            GalleryScreen galleryScreen = (GalleryScreen)class_4372;
            galleryScreen.cancelAllAsyncTasks();
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int buttonWidth = 200;
        int buttonHeight = this.field_22790 / 20;
        if (this.selectedAlbumIndex >= 0 && this.selectedAlbumIndex < this.albums.size()) {
            Album selectedAlbum = this.albums.get(this.selectedAlbumIndex);
            this.setAsCover = selectedAlbum.getCoverScreenshotName() == null || selectedAlbum.getCoverScreenshotName().isEmpty() || this.doesCoverImageNotExist(selectedAlbum);
            this.setAsCoverButton.method_25355(this.getSetAsCoverToggleText());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b2"), button -> {
            if (this.scrollOffset > 0) {
                --this.scrollOffset;
            }
        }).method_46433(centerX + 110, centerY - 100).method_46437(20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25bc"), button -> {
            if (this.scrollOffset < Math.max(0, this.albums.size() - 6)) {
                ++this.scrollOffset;
            }
        }).method_46433(centerX + 110, centerY + 80).method_46437(20, 20).method_46431());
        this.setAsCoverButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)this.getSetAsCoverToggleText(), button -> {
            this.setAsCover = !this.setAsCover;
            button.method_25355(this.getSetAsCoverToggleText());
        }).method_46433(centerX - 100, centerY + 90).method_46437(buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.select_album.assign"), button -> {
            if (this.selectedAlbumIndex >= 0 && this.selectedAlbumIndex < this.albums.size()) {
                UUID albumUuid = this.albums.get(this.selectedAlbumIndex).getUuid();
                this.assignScreenshotToAlbum(albumUuid);
                if (this.setAsCover) {
                    this.assignScreenshotAsAlbumCover(albumUuid);
                }
                if (this.field_22787 != null) {
                    class_437 patt0$temp = this.parent;
                    if (patt0$temp instanceof GalleryScreen) {
                        GalleryScreen galleryScreen = (GalleryScreen)patt0$temp;
                        galleryScreen.cancelAllAsyncTasks();
                        this.field_22787.method_1507((class_437)new GalleryScreen());
                    } else {
                        this.field_22787.method_1507(this.parent);
                    }
                }
            }
        }).method_46433(centerX - 100, centerY + 90 + buttonHeight + 5).method_46437(buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.method_25419()).method_46433(centerX - 100, centerY + 90 + (buttonHeight + 5) * 3).method_46437(buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.select_album.create"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new AlbumConfigScreen(this));
            }
        }).method_46433(centerX - 100, centerY + 90 + (buttonHeight + 5) * 2).method_46437(buttonWidth, buttonHeight).method_46431());
    }

    private class_2561 getSetAsCoverToggleText() {
        return class_2561.method_43471((String)"gui.screenshot_uploader.select_album.set_as_cover").method_27693(": ").method_10852((class_2561)(this.setAsCover ? class_2561.method_43471((String)"options.on") : class_2561.method_43471((String)"options.off")));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        context.method_27534(this.field_22793, this.field_22785, centerX, 20, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.select_album.album_prompt"), centerX - 100, 50, 0xAAAAAA);
        int y = centerY - 70;
        int visibleCount = Math.min(6, this.albums.size() - this.scrollOffset);
        for (int i = 0; i < visibleCount; ++i) {
            int albumIndex = i + this.scrollOffset;
            Album album = this.albums.get(albumIndex);
            boolean isSelected = albumIndex == this.selectedAlbumIndex;
            int bgColor = isSelected ? -2139062144 : 0x20808080;
            context.method_25294(centerX - 100, y - 2, centerX + 100, y + 22, bgColor);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)album.getTitle()), centerX - 90, y + 3, 0xFFFFFF);
            Object desc = album.getDescription();
            if (desc != null && !((String)desc).isEmpty()) {
                if (((String)desc).length() > 30) {
                    desc = ((String)desc).substring(0, 27) + "...";
                }
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)desc), centerX - 90, y + 14, 0xAAAAAA);
            }
            try {
                String albumColor = album.getColor();
                if (albumColor != null && albumColor.startsWith("#")) {
                    int colorInt = Integer.parseInt(albumColor.substring(1), 16);
                    context.method_25294(centerX + 70, y, centerX + 95, y + 20, 0xFF000000 | colorInt);
                }
            }
            catch (Exception e) {
                context.method_25294(centerX + 70, y, centerX + 95, y + 20, -65536);
            }
            y += 30;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int y = centerY - 70;
        if (mouseX >= (double)(centerX - 100) && mouseX <= (double)(centerX + 100)) {
            int visibleCount = Math.min(6, this.albums.size() - this.scrollOffset);
            for (int i = 0; i < visibleCount; ++i) {
                if (mouseY >= (double)(y - 2) && mouseY <= (double)(y + 22)) {
                    int newSelectedIndex = i + this.scrollOffset;
                    if (newSelectedIndex != this.selectedAlbumIndex) {
                        this.selectedAlbumIndex = newSelectedIndex;
                        if (this.selectedAlbumIndex >= 0 && this.selectedAlbumIndex < this.albums.size()) {
                            Album selectedAlbum = this.albums.get(this.selectedAlbumIndex);
                            this.setAsCover = selectedAlbum.getCoverScreenshotName() == null || selectedAlbum.getCoverScreenshotName().isEmpty() || this.doesCoverImageNotExist(selectedAlbum);
                            this.setAsCoverButton.method_25355(this.getSetAsCoverToggleText());
                        }
                    }
                    return true;
                }
                y += 30;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (verticalAmount < 0.0) {
            if (this.scrollOffset < Math.max(0, this.albums.size() - 6)) {
                ++this.scrollOffset;
                return true;
            }
        } else if (verticalAmount > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void assignScreenshotToAlbum(UUID albumUuid) {
        try {
            JsonObject metaData;
            String jsonPath = this.screenshotPath.substring(0, this.screenshotPath.lastIndexOf(46)) + ".json";
            File jsonFile = new File(jsonPath);
            if (jsonFile.exists()) {
                try (FileReader reader = new FileReader(jsonFile);){
                    metaData = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                }
            } else {
                metaData = new JsonObject();
            }
            metaData.addProperty("album", albumUuid.toString());
            try (FileWriter writer = new FileWriter(jsonFile);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)metaData, (Appendable)writer);
            }
            logger.info("Assigned screenshot {} to album {}", (Object)this.screenshotPath, (Object)albumUuid);
        }
        catch (IOException e) {
            logger.error("Error updating screenshot metadata file", (Throwable)e);
        }
    }

    private void assignScreenshotAsAlbumCover(UUID albumUuid) {
        try {
            File screenshotFile = new File(this.screenshotPath);
            String screenshotName = screenshotFile.getName();
            Album album = AlbumManager.getAlbum(albumUuid);
            if (album != null) {
                album.setCoverScreenshotName(screenshotName);
                AlbumManager.updateAlbum(album);
                logger.info("Set screenshot {} as cover for album {}", (Object)screenshotName, (Object)album.getTitle());
            } else {
                logger.error("Could not find album with UUID: {}", (Object)albumUuid);
            }
        }
        catch (Exception e) {
            logger.error("Error setting screenshot as album cover", (Throwable)e);
        }
    }

    private boolean doesCoverImageNotExist(Album album) {
        boolean exists;
        if (album == null) {
            logger.error("Cannot check cover image - album is null");
            return true;
        }
        String coverName = album.getCoverScreenshotName();
        if (coverName == null || coverName.isEmpty()) {
            return true;
        }
        File coverFile = new File(System.getProperty("user.dir"), "screenshots" + File.separator + coverName);
        boolean bl = exists = coverFile.exists() && coverFile.isFile();
        if (!exists) {
            logger.warn("Cover image does not exist at path: {}", (Object)coverFile.getAbsolutePath());
        }
        return !exists;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            class_437 class_4372 = this.parent;
            if (class_4372 instanceof GalleryScreen) {
                GalleryScreen galleryScreen = (GalleryScreen)class_4372;
                galleryScreen.cancelAllAsyncTasks();
                this.field_22787.method_1507((class_437)new GalleryScreen());
            } else {
                this.field_22787.method_1507(this.parent);
            }
        }
    }
}

