/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.thecoolcraft11.screen.ConfigScreen;
import de.thecoolcraft11.screen.ConfirmationScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class ServerManagerScreen
extends class_437 {
    public static final String GUI_SCREENSHOT_UPLOADER_SERVER_MANAGER_UNSAVED = "gui.screenshot_uploader.server_manager.unsaved";
    private final class_437 parent;
    private final JsonObject serversConfig;
    private final Map<String, JsonObject> servers = new LinkedHashMap<String, JsonObject>();
    private final List<String> serverNames = new ArrayList<String>();
    private String selectedServer = null;
    private boolean isChanged = false;
    private int scrollOffset = 0;
    private static final int ENTRY_HEIGHT = 30;
    private static final int SERVER_LIST_WIDTH = 200;
    private class_342 nameField;
    private class_342 uploadField;
    private class_342 galleryField;
    private class_342 homeField;
    private class_4185 addServerButton;
    private class_4185 updateServerButton;
    private class_4185 deleteServerButton;
    private class_4185 saveButton;

    public ServerManagerScreen(class_437 parent, JsonObject serversConfig) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.title"));
        this.parent = parent;
        this.serversConfig = serversConfig;
        this.loadServers();
    }

    private void loadServers() {
        this.servers.clear();
        this.serverNames.clear();
        for (Map.Entry entry : this.serversConfig.entrySet()) {
            String serverName = (String)entry.getKey();
            JsonObject serverData = ((JsonElement)entry.getValue()).getAsJsonObject();
            this.servers.put(serverName, serverData);
            this.serverNames.add(serverName);
        }
        Collections.sort(this.serverNames);
    }

    protected void method_25426() {
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int leftPanelX = centerX - 210;
        int rightPanelX = centerX + 10;
        int topY = 60;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.add_new"), button -> this.selectNewServer()).method_46434(leftPanelX, 60, 200, 20).method_46431());
        int serverListY = topY;
        for (String serverName : this.serverNames) {
            int yPos = serverListY + this.scrollOffset + 40;
            if (yPos >= topY && yPos < this.field_22790 - 60) {
                class_4185 serverButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)serverName), button -> this.selectServer(serverName)).method_46434(leftPanelX, yPos, 200, 20).method_46431();
                if (serverName.equals(this.selectedServer)) {
                    serverButton.method_25355((class_2561)class_2561.method_43470((String)("> " + serverName + " <")).method_27692(class_124.field_1054));
                }
                this.method_37063((class_364)serverButton);
            }
            serverListY += 30;
        }
        int fieldWidth = 300;
        int fieldSpacing = 40;
        this.nameField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, rightPanelX, topY, fieldWidth, 20, class_2561.method_30163((String)"Server Name")));
        this.nameField.method_1880(64);
        this.uploadField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, rightPanelX, topY + fieldSpacing, fieldWidth, 20, class_2561.method_30163((String)"Upload URL")));
        this.uploadField.method_1880(256);
        this.uploadField.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"URL for uploading screenshots")));
        this.galleryField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, rightPanelX, topY + fieldSpacing * 2, fieldWidth, 20, class_2561.method_30163((String)"Gallery URL")));
        this.galleryField.method_1880(256);
        this.galleryField.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"URL to view screenshot gallery")));
        this.homeField = (class_342)this.method_37063((class_364)new class_342(this.field_22793, rightPanelX, topY + fieldSpacing * 3, fieldWidth, 20, class_2561.method_30163((String)"Home URL")));
        this.homeField.method_1880(256);
        this.homeField.method_47400(class_7919.method_47407((class_2561)class_2561.method_30163((String)"Base URL for the server")));
        this.nameField.method_1863(s -> this.checkFields());
        this.uploadField.method_1863(s -> this.checkFields());
        this.galleryField.method_1863(s -> this.checkFields());
        this.homeField.method_1863(s -> this.checkFields());
        int buttonY = topY + fieldSpacing * 4 + 10;
        this.addServerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.add"), button -> this.addServer()).method_46434(rightPanelX, buttonY, 140, 20).method_46431());
        this.updateServerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.update"), button -> this.updateServer()).method_46434(rightPanelX + 160, buttonY, 140, 20).method_46431());
        this.deleteServerButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.delete"), button -> this.deleteServer()).method_46434(rightPanelX, buttonY + 30, 300, 20).method_46431());
        this.saveButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.save"), button -> this.saveChanges()).method_46434(centerX - 155, this.field_22790 - 30, 150, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.back"), button -> this.method_25419()).method_46434(centerX + 5, this.field_22790 - 30, 150, 20).method_46431());
        this.updateButtonStates();
        if (this.selectedServer != null) {
            this.loadServerData(this.selectedServer);
        } else {
            this.resetFields();
        }
    }

    private void updateButtonStates() {
        boolean hasSelection = this.selectedServer != null;
        boolean isValidInput = !this.nameField.method_1882().trim().isEmpty() && !this.uploadField.method_1882().trim().isEmpty() && !this.galleryField.method_1882().trim().isEmpty() && !this.homeField.method_1882().trim().isEmpty();
        this.addServerButton.field_22763 = isValidInput && this.selectedServer == null;
        this.updateServerButton.field_22763 = isValidInput && hasSelection;
        this.deleteServerButton.field_22763 = hasSelection;
        this.saveButton.field_22763 = this.isChanged;
    }

    private void checkFields() {
        this.updateButtonStates();
    }

    private void selectServer(String serverName) {
        this.selectedServer = serverName;
        this.loadServerData(serverName);
        this.method_25426();
    }

    private void selectNewServer() {
        this.selectedServer = null;
        this.resetFields();
        this.method_25426();
    }

    private void loadServerData(String serverName) {
        JsonObject serverData = this.servers.get(serverName);
        this.nameField.method_1852(serverName);
        this.uploadField.method_1852(serverData.has("upload") ? serverData.get("upload").getAsString() : "");
        this.galleryField.method_1852(serverData.has("gallery") ? serverData.get("gallery").getAsString() : "");
        this.homeField.method_1852(serverData.has("home") ? serverData.get("home").getAsString() : "");
    }

    private void resetFields() {
        this.nameField.method_1852("");
        this.uploadField.method_1852("");
        this.galleryField.method_1852("");
        this.homeField.method_1852("");
    }

    private void addServer() {
        String name = this.nameField.method_1882().trim();
        if (name.isEmpty() || this.servers.containsKey(name)) {
            return;
        }
        JsonObject serverData = new JsonObject();
        serverData.addProperty("upload", this.uploadField.method_1882().trim());
        serverData.addProperty("gallery", this.galleryField.method_1882().trim());
        serverData.addProperty("home", this.homeField.method_1882().trim());
        this.servers.put(name, serverData);
        this.serverNames.add(name);
        Collections.sort(this.serverNames);
        this.selectedServer = name;
        this.isChanged = true;
        this.method_25426();
    }

    private void updateServer() {
        if (this.selectedServer == null) {
            return;
        }
        String newName = this.nameField.method_1882().trim();
        if (newName.isEmpty()) {
            return;
        }
        JsonObject serverData = new JsonObject();
        serverData.addProperty("upload", this.uploadField.method_1882().trim());
        serverData.addProperty("gallery", this.galleryField.method_1882().trim());
        serverData.addProperty("home", this.homeField.method_1882().trim());
        if (!newName.equals(this.selectedServer)) {
            this.servers.remove(this.selectedServer);
            this.serverNames.remove(this.selectedServer);
            this.servers.put(newName, serverData);
            this.serverNames.add(newName);
            Collections.sort(this.serverNames);
            this.selectedServer = newName;
        } else {
            this.servers.put(this.selectedServer, serverData);
        }
        this.isChanged = true;
        this.method_25426();
    }

    private void deleteServer() {
        if (this.selectedServer == null) {
            return;
        }
        this.servers.remove(this.selectedServer);
        this.serverNames.remove(this.selectedServer);
        this.selectedServer = null;
        this.isChanged = true;
        this.resetFields();
        this.method_25426();
    }

    private void saveChanges() {
        JsonObject updatedServersConfig = new JsonObject();
        for (Map.Entry<String, JsonObject> entry : this.servers.entrySet()) {
            updatedServersConfig.add(entry.getKey(), (JsonElement)entry.getValue());
        }
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof ConfigScreen) {
            ConfigScreen configScreen = (ConfigScreen)class_4372;
            configScreen.changeConfig(updatedServersConfig);
            this.isChanged = false;
            this.updateButtonStates();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int centerX = this.field_22789 / 2;
        context.method_25294(centerX - 5, 40, centerX + 5, this.field_22790 - 40, 0x66FFFFFF);
        context.method_27534(this.field_22793, this.field_22785, centerX, 10, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.server_list"), centerX - 210, 35, 0xCCCCCC);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.server_details"), centerX + 10, 35, 0xCCCCCC);
        int rightPanelX = centerX + 10;
        int topY = 60;
        int fieldSpacing = 40;
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.name"), rightPanelX, topY - 15, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.upload_url"), rightPanelX, topY + fieldSpacing - 15, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.gallery_url"), rightPanelX, topY + fieldSpacing * 2 - 15, 0xAAAAAA);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.home_url"), rightPanelX, topY + fieldSpacing * 3 - 15, 0xAAAAAA);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scrollOffset += (int)(verticalAmount * 10.0);
        int maxScroll = Math.max(0, this.serverNames.size() * 30 - (this.field_22790 - 150));
        this.scrollOffset = Math.max(-maxScroll, Math.min(0, this.scrollOffset));
        this.method_25426();
        return true;
    }

    public void method_25419() {
        if (!this.isChanged) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            return;
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new ConfirmationScreen(confirmed -> {
                if (confirmed.booleanValue()) {
                    this.saveChanges();
                    this.field_22787.method_1507(this.parent);
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)GUI_SCREENSHOT_UPLOADER_SERVER_MANAGER_UNSAVED), (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_manager.unsaved_detail")));
        }
    }
}

