/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class ServerStatisticsScreen
extends class_437 {
    private JsonObject statisticsData;
    private boolean isLoading = true;
    private String errorMessage = null;
    private final List<StatisticsSection> sections = new ArrayList<StatisticsSection>();
    private int scrollOffset = 0;
    private static final int SECTION_SPACING = 15;
    private int currentTab = 0;
    private final String[] tabs = new String[]{"Overview", "Users", "Screenshots", "Performance", "Heatmap"};
    private String selectedUser = null;
    private final Map<String, List<StatisticsSection>> userDetailSections = new HashMap<String, List<StatisticsSection>>();
    private String serverUrl;
    private final class_437 parent;
    private boolean isHeatmapActive = false;
    private final List<LocationPoint> locationPoints = new ArrayList<LocationPoint>();
    private static final String[] DIMENSIONS = new String[]{"minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"};
    private static final int MAX_POINT_SIZE = 30;
    private static final int MIN_POINT_SIZE = 5;
    private int heatmapOffsetX = 0;
    private int heatmapOffsetY = 0;
    private float heatmapScale = 1.0f;
    private String selectedDimension = "minecraft:overworld";
    private boolean isDraggingMap = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private int dragStartOffsetX = 0;
    private int dragStartOffsetY = 0;

    public ServerStatisticsScreen(class_437 parent, String serverUrl) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.statistics.title"));
        this.serverUrl = serverUrl;
        this.parent = parent;
        this.fetchStatistics();
    }

    private void fetchStatistics() {
        CompletableFuture.runAsync(() -> {
            block15: {
                try {
                    URL url;
                    if (!this.serverUrl.endsWith("/")) {
                        this.serverUrl = this.serverUrl.substring(0, this.serverUrl.lastIndexOf(47) + 1);
                    }
                    try {
                        url = new URI(this.serverUrl + "statistics").toURL();
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    int responseCode = connection.getResponseCode();
                    if (responseCode == 200) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                            String line;
                            StringBuilder response = new StringBuilder();
                            while ((line = reader.readLine()) != null) {
                                response.append(line);
                            }
                            this.statisticsData = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                            this.processStatisticsData();
                            break block15;
                        }
                    }
                    this.errorMessage = "Failed to fetch statistics: HTTP " + responseCode;
                }
                catch (IOException e) {
                    this.errorMessage = "Error: " + e.getMessage();
                }
                finally {
                    this.isLoading = false;
                }
            }
        });
    }

    private void processStatisticsData() {
        this.sections.clear();
        this.userDetailSections.clear();
        if (this.statisticsData == null) {
            return;
        }
        try {
            if (this.statisticsData.has("globalStats")) {
                JsonObject globalStats = this.statisticsData.getAsJsonObject("globalStats");
                if (globalStats.has("serverStats")) {
                    JsonObject serverStats = globalStats.getAsJsonObject("serverStats");
                    StatisticsSection serverSection = new StatisticsSection("Server Statistics", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.server_statistics"));
                    int totalScreenshots = serverStats.has("totalScreenshots") ? serverStats.get("totalScreenshots").getAsInt() : 0;
                    serverSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.total_screenshots"), class_2561.method_30163((String)String.valueOf(totalScreenshots)));
                    if (serverStats.has("totalFileSizeBytes")) {
                        long totalSize = serverStats.get("totalFileSizeBytes").getAsLong();
                        serverSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.total_size"), class_2561.method_30163((String)this.formatFileSize(totalSize)));
                    }
                    if (serverStats.has("averageFileSizeBytes")) {
                        double avgSize = serverStats.get("averageFileSizeBytes").getAsDouble();
                        serverSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.average_size"), class_2561.method_30163((String)this.formatFileSize((long)avgSize)));
                    }
                    this.sections.add(serverSection);
                }
                if (globalStats.has("fileStats")) {
                    JsonObject fileStats = globalStats.getAsJsonObject("fileStats");
                    StatisticsSection fileSection = new StatisticsSection("File Statistics", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.file_statistics"));
                    if (fileStats.has("typeDistribution")) {
                        JsonObject typeDistribution = fileStats.getAsJsonObject("typeDistribution");
                        fileSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.file_types"), (class_2561)class_2561.method_43473());
                        for (Map.Entry entry : typeDistribution.entrySet()) {
                            fileSection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), class_2561.method_30163((String)((JsonElement)entry.getValue()).getAsString()));
                        }
                    }
                    if (fileStats.has("sizeDistribution")) {
                        JsonObject sizeDistribution = fileStats.getAsJsonObject("sizeDistribution");
                        fileSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.file_distribution"), (class_2561)class_2561.method_43473());
                        for (Map.Entry entry : sizeDistribution.entrySet()) {
                            fileSection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), class_2561.method_30163((String)((JsonElement)entry.getValue()).getAsString()));
                        }
                    }
                    this.sections.add(fileSection);
                }
                if (globalStats.has("worldStats")) {
                    JsonObject worldStats = globalStats.getAsJsonObject("worldStats");
                    StatisticsSection worldSection = new StatisticsSection("World Statistics", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.world_statistics"));
                    if (worldStats.has("dimensions")) {
                        JsonObject dimensions = worldStats.getAsJsonObject("dimensions");
                        worldSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.dimensions"), (class_2561)class_2561.method_43473());
                        for (Map.Entry entry : dimensions.entrySet()) {
                            worldSection.addEntry((class_2561)class_2561.method_43471((String)("  " + (String)entry.getKey())), class_2561.method_30163((String)((JsonElement)entry.getValue()).getAsString()));
                        }
                    }
                    if (worldStats.has("biomes")) {
                        JsonObject biomes = worldStats.getAsJsonObject("biomes");
                        worldSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.biomes"), (class_2561)class_2561.method_43473());
                        ArrayList sortedBiomes = new ArrayList(biomes.entrySet());
                        sortedBiomes.sort((e1, e2) -> ((JsonElement)e2.getValue()).getAsInt() - ((JsonElement)e1.getValue()).getAsInt());
                        int biomeCount = 0;
                        for (Map.Entry entry : sortedBiomes) {
                            if (biomeCount++ >= 5) continue;
                            worldSection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), class_2561.method_30163((String)((JsonElement)entry.getValue()).getAsString()));
                        }
                    }
                    this.sections.add(worldSection);
                }
            }
            if (this.statisticsData.has("userStats")) {
                JsonObject userStats = this.statisticsData.getAsJsonObject("userStats");
                this.processUserGeneralStatistics(userStats);
                this.processUserDetailStatistics(userStats);
            }
            if (this.statisticsData.has("performanceStats")) {
                JsonObject performanceStats = this.statisticsData.getAsJsonObject("performanceStats");
                StatisticsSection performanceSection = new StatisticsSection("Performance Statistics", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.performance_statistics"));
                if (performanceStats.has("uploadsPerDay")) {
                    JsonObject uploadsPerDay = performanceStats.getAsJsonObject("uploadsPerDay");
                    performanceSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.average_daily_upload"), class_2561.method_30163((String)this.calculateAverageUploads(uploadsPerDay)));
                    performanceSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.daily_upload_count"), class_2561.method_30163((String)this.calculateAverageUploads(uploadsPerDay)));
                    ArrayList sortedUploads = new ArrayList(uploadsPerDay.entrySet());
                    sortedUploads.sort(Map.Entry.comparingByKey().reversed());
                    int dayCount = 0;
                    for (Map.Entry entry : sortedUploads) {
                        if (dayCount++ >= 7) continue;
                        performanceSection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.performance_statistics.uploads_per_day", (Object[])new Object[]{((JsonElement)entry.getValue()).getAsInt()}));
                    }
                }
                if (performanceStats.has("weeklyMovingAverage")) {
                    JsonObject weeklyAverage = performanceStats.getAsJsonObject("weeklyMovingAverage");
                    performanceSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.weekly_moving_average"), (class_2561)class_2561.method_43473());
                    ArrayList sortedWeekly = new ArrayList(weeklyAverage.entrySet());
                    sortedWeekly.sort(Map.Entry.comparingByKey().reversed());
                    int weekCount = 0;
                    for (Map.Entry entry : sortedWeekly) {
                        if (weekCount++ >= 5) continue;
                        performanceSection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.performance_statistics.weekly_average", (Object[])new Object[]{((JsonElement)entry.getValue()).getAsInt()}));
                    }
                }
                this.sections.add(performanceSection);
            }
            if (this.statisticsData.has("recentUploads")) {
                StatisticsSection recentSection = new StatisticsSection("gui.screenshot_uploader.server", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.recent_uploads"));
                int count = 0;
                for (JsonElement element : this.statisticsData.getAsJsonArray("recentUploads")) {
                    if (count++ >= 5) continue;
                    JsonObject upload = element.getAsJsonObject();
                    String username = upload.has("username") ? upload.get("username").getAsString() : "Unknown";
                    String string = upload.has("date") ? upload.get("date").getAsString() : "Unknown date";
                    recentSection.addEntry(class_2561.method_30163((String)username), class_2561.method_30163((String)string));
                }
                this.sections.add(recentSection);
            }
            this.processLocationData();
        }
        catch (Exception e) {
            this.errorMessage = "Error processing data: " + e.getMessage();
        }
    }

    private void processUserGeneralStatistics(JsonObject userStats) {
        StatisticsSection userSection = new StatisticsSection("User Statistics", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.users_statistics"));
        userSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.total_users"), class_2561.method_30163((String)String.valueOf(userStats.size())));
        int totalUploads = 0;
        for (Map.Entry entry : userStats.entrySet()) {
            JsonObject userData = ((JsonElement)entry.getValue()).getAsJsonObject();
            totalUploads += userData.get("uploadCount").getAsInt();
        }
        userSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.total_uploads"), class_2561.method_30163((String)String.valueOf(totalUploads)));
        double avgUploadsPerUser = !userStats.isEmpty() ? (double)totalUploads / (double)userStats.size() : 0.0;
        userSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.average_upload_per_user"), (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.user_statistics.average_uploads_per_user", (Object[])new Object[]{avgUploadsPerUser}));
        ArrayList sortedUsers = new ArrayList(userStats.entrySet());
        sortedUsers.sort((u1, u2) -> {
            int count1 = ((JsonElement)u1.getValue()).getAsJsonObject().get("uploadCount").getAsInt();
            int count2 = ((JsonElement)u2.getValue()).getAsJsonObject().get("uploadCount").getAsInt();
            return count2 - count1;
        });
        userSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.top_contributors"), (class_2561)class_2561.method_43473());
        int userCount = 0;
        for (Map.Entry entry : sortedUsers) {
            if (userCount++ >= 10) continue;
            JsonObject userData = ((JsonElement)entry.getValue()).getAsJsonObject();
            int uploadCount = userData.get("uploadCount").getAsInt();
            String username = (String)entry.getKey();
            class_2561 class_25612 = class_2561.method_30163((String)username);
            userSection.addEntry(class_25612, (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.user_statistics.top_contributors.entry", (Object[])new Object[]{uploadCount}));
            userSection.makeEntryClickable(class_25612, () -> {
                this.selectedUser = username;
                this.scrollOffset = 0;
            });
        }
        StatisticsSection activitySection = new StatisticsSection("User Activity Patterns", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.activity_patterns"));
        HashMap<String, Integer> activityByHour = new HashMap<String, Integer>();
        for (Map.Entry userEntry : userStats.entrySet()) {
            JsonObject userData = ((JsonElement)userEntry.getValue()).getAsJsonObject();
            if (!userData.has("activityByHour")) continue;
            JsonObject jsonObject = userData.getAsJsonObject("activityByHour");
            for (Map.Entry hourEntry : jsonObject.entrySet()) {
                String hour = (String)hourEntry.getKey();
                int count = ((JsonElement)hourEntry.getValue()).getAsInt();
                activityByHour.put(hour, activityByHour.getOrDefault(hour, 0) + count);
            }
        }
        ArrayList sortedHours = new ArrayList(activityByHour.entrySet());
        sortedHours.sort(Map.Entry.comparingByValue().reversed());
        activitySection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.peak_activity_times"), (class_2561)class_2561.method_43473());
        int hourCount = 0;
        for (Map.Entry entry : sortedHours) {
            if (hourCount++ >= 5) continue;
            activitySection.addEntry(class_2561.method_30163((String)("  " + (String)entry.getKey())), (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.activity_patterns.entry", (Object[])new Object[]{entry.getValue()}));
        }
        this.sections.add(userSection);
        this.sections.add(activitySection);
    }

    private void processUserDetailStatistics(JsonObject userStats) {
        for (Map.Entry entry : userStats.entrySet()) {
            String username = (String)entry.getKey();
            JsonObject userData = ((JsonElement)entry.getValue()).getAsJsonObject();
            ArrayList<StatisticsSection> userSections = new ArrayList<StatisticsSection>();
            StatisticsSection overviewSection = new StatisticsSection(username + "'s Statistics", (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.user_statistics", (Object[])new Object[]{username}));
            overviewSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.total_uploads"), class_2561.method_30163((String)String.valueOf(userData.get("uploadCount").getAsInt())));
            if (userData.has("totalSizeBytes")) {
                long totalSize = userData.get("totalSizeBytes").getAsLong();
                overviewSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.totalSize"), class_2561.method_30163((String)this.formatFileSize(totalSize)));
            }
            if (userData.has("averageFileSizeBytes")) {
                double avgSize = userData.get("averageFileSizeBytes").getAsDouble();
                overviewSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.average_file_size"), class_2561.method_30163((String)this.formatFileSize((long)avgSize)));
            }
            if (userData.has("mostActiveTime")) {
                overviewSection.addEntry((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.most_active_time"), class_2561.method_30163((String)userData.get("mostActiveTime").getAsString()));
            }
            userSections.add(overviewSection);
            if (userData.has("activityByHour")) {
                StatisticsSection activitySection = new StatisticsSection("Activity By Hour", (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_statistics.activity_by_hour"));
                JsonObject hourData = userData.getAsJsonObject("activityByHour");
                ArrayList sortedHours = new ArrayList(hourData.entrySet());
                sortedHours.sort((h1, h2) -> ((JsonElement)h2.getValue()).getAsInt() - ((JsonElement)h1.getValue()).getAsInt());
                for (Map.Entry hourEntry : sortedHours) {
                    String hour = (String)hourEntry.getKey();
                    int count = ((JsonElement)hourEntry.getValue()).getAsInt();
                    activitySection.addEntry(class_2561.method_30163((String)hour), (class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.server_statistics.activity_by_hour.entry", (Object[])new Object[]{count}));
                }
                userSections.add(activitySection);
            }
            StatisticsSection navigationSection = new StatisticsSection("", (class_2561)class_2561.method_43473());
            userSections.add(navigationSection);
            this.userDetailSections.put(username, userSections);
        }
    }

    private void processLocationData() {
        this.locationPoints.clear();
        if (this.statisticsData == null || !this.statisticsData.has("globalStats")) {
            return;
        }
        JsonObject globalStats = this.statisticsData.getAsJsonObject("globalStats");
        if (!globalStats.has("worldStats")) {
            return;
        }
        JsonObject worldStats = globalStats.getAsJsonObject("worldStats");
        if (!worldStats.has("clusteredLocations")) {
            return;
        }
        for (JsonElement element : worldStats.getAsJsonArray("clusteredLocations")) {
            JsonObject point = element.getAsJsonObject();
            if (!point.has("x") || !point.has("z") || !point.has("dimension")) continue;
            int x = point.get("x").getAsInt();
            int y = point.has("y") ? point.get("y").getAsInt() : 64;
            int z = point.get("z").getAsInt();
            String dimension = point.get("dimension").getAsString();
            int count = point.has("count") ? point.get("count").getAsInt() : 1;
            this.locationPoints.add(new LocationPoint(x, y, z, dimension, count));
        }
        this.isHeatmapActive = true;
    }

    private String calculateAverageUploads(JsonObject uploadsPerDay) {
        if (uploadsPerDay.isEmpty()) {
            return "0";
        }
        int total = 0;
        for (Map.Entry entry : uploadsPerDay.entrySet()) {
            total += ((JsonElement)entry.getValue()).getAsInt();
        }
        double average = (double)total / (double)uploadsPerDay.size();
        return String.format("%.1f", average);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        if (this.selectedUser != null) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2190 Back to Statistics"), button -> {
                this.selectedUser = null;
                this.scrollOffset = 0;
                this.method_25426();
            }).method_46434(10, 25, 120, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), button -> this.method_25419()).method_46434(this.field_22789 - 60, 25, 50, 20).method_46431());
            return;
        }
        int buttonWidth = 80;
        int totalTabsWidth = buttonWidth * this.tabs.length;
        int startX = (this.field_22789 - totalTabsWidth) / 2;
        for (int i = 0; i < this.tabs.length; ++i) {
            int tabIndex = i;
            class_4185 tabButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)this.tabs[i]), button -> {
                this.currentTab = tabIndex;
                this.scrollOffset = 0;
                this.method_25426();
            }).method_46434(startX + buttonWidth * i, 25, buttonWidth, 20).method_46431();
            this.method_37063((class_364)tabButton);
        }
        String playerName = class_310.method_1551().method_1548().method_1676();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"My Statistics"), button -> {
            this.selectedUser = playerName;
            this.scrollOffset = 0;
            this.method_25426();
        }).method_46434(10, this.field_22790 - 30, 100, 20).method_46431());
        if (this.currentTab == 4) {
            int dimensionButtonWidth = 100;
            int dimensionButtonSpacing = 10;
            int totalDimensionButtonsWidth = DIMENSIONS.length * dimensionButtonWidth + (DIMENSIONS.length - 1) * dimensionButtonSpacing;
            int dimensionStartX = (this.field_22789 - totalDimensionButtonsWidth) / 2;
            for (int i = 0; i < DIMENSIONS.length; ++i) {
                String dimension = DIMENSIONS[i];
                class_4185 dimensionButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)this.formatDimensionName(dimension)), button -> {
                    this.selectedDimension = dimension;
                    this.heatmapOffsetX = 0;
                    this.heatmapOffsetY = 0;
                }).method_46434(dimensionStartX + i * (dimensionButtonWidth + dimensionButtonSpacing), 60, dimensionButtonWidth, 20).method_46431();
                if (dimension.equals(this.selectedDimension)) {
                    dimensionButton.field_22763 = false;
                }
                this.method_37063((class_364)dimensionButton);
            }
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Refresh"), button -> {
            this.isLoading = true;
            this.errorMessage = null;
            this.fetchStatistics();
        }).method_46434(this.field_22789 - 80, 25, 70, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), button -> this.method_25419()).method_46434(10, 25, 50, 20).method_46431());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        if (this.currentTab == 4 && this.isHeatmapActive && !this.isLoading && this.errorMessage == null) {
            this.renderHeatmap(context, mouseX, mouseY);
        }
        if (this.isLoading) {
            String loadingText = "Loading statistics...";
            context.method_25300(this.field_22793, loadingText, this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            return;
        }
        if (this.errorMessage != null) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage).method_27692(class_124.field_1061), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            return;
        }
        if (this.sections.isEmpty() && this.selectedUser == null || this.selectedUser != null && !this.userDetailSections.containsKey(this.selectedUser)) {
            context.method_25300(this.field_22793, "No statistics available", this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            return;
        }
        if (this.selectedUser != null) {
            this.renderUserDetails(context, mouseX, mouseY);
            return;
        }
        List<StatisticsSection> filteredSections = this.getTabSections();
        int y = 55 - this.scrollOffset;
        for (StatisticsSection section : filteredSections) {
            if (y + section.getHeight() < 50 || y > this.field_22790) {
                y += section.getHeight() + 15;
                continue;
            }
            context.method_25294(this.field_22789 / 2 - 160, y - 5, this.field_22789 / 2 + 160, y + section.getHeight() + 5, Integer.MIN_VALUE);
            context.method_25294(this.field_22789 / 2 - 160, y - 5, this.field_22789 / 2 - 159, y + section.getHeight() + 5, -5592406);
            context.method_25294(this.field_22789 / 2 + 159, y - 5, this.field_22789 / 2 + 160, y + section.getHeight() + 5, -5592406);
            context.method_25294(this.field_22789 / 2 - 160, y - 5, this.field_22789 / 2 + 160, y - 4, -5592406);
            context.method_25294(this.field_22789 / 2 - 160, y + section.getHeight() + 4, this.field_22789 / 2 + 160, y + section.getHeight() + 5, -5592406);
            context.method_27535(this.field_22793, section.translatedTitle, this.field_22789 / 2 - 150, y, 0xFFAA00);
            y += 12;
            for (StatisticsEntry entry : section.entries) {
                if (y >= 50 && y <= this.field_22790) {
                    boolean isHovering = entry.isClickable && mouseX >= this.field_22789 / 2 - 145 && mouseX <= this.field_22789 / 2 + 145 && mouseY >= y - 1 && mouseY <= y + 9;
                    int keyColor = isHovering ? 0xFFFF55 : 0xFFFFFF;
                    context.method_27535(this.field_22793, entry.key, this.field_22789 / 2 - 145, y, keyColor);
                    context.method_27535(this.field_22793, entry.value, this.field_22789 / 2 + 30, y, 0xAAAAAA);
                    if (entry.isClickable) {
                        int textWidth = this.field_22793.method_27525((class_5348)entry.key);
                        context.method_25294(this.field_22789 / 2 - 145, y + 9, this.field_22789 / 2 - 145 + textWidth, y + 10, isHovering ? -171 : -5592406);
                    }
                }
                y += 10;
            }
            y += 15;
        }
        int contentHeight = this.getTotalContentHeight(filteredSections);
        if (contentHeight > this.field_22790 - 80) {
            if (this.scrollOffset > 0) {
                context.method_25300(this.field_22793, "\u25b2", this.field_22789 / 2, 50, 0xFFFFFF);
            }
            if (this.scrollOffset < contentHeight - (this.field_22790 - 80)) {
                context.method_25300(this.field_22793, "\u25bc", this.field_22789 / 2, this.field_22790 - 10, 0xFFFFFF);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void renderHeatmap(class_332 context, int mouseX, int mouseY) {
        if (this.locationPoints.isEmpty()) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxCount = 0;
        ArrayList<LocationPoint> pointsInCurrentDimension = new ArrayList<LocationPoint>();
        for (LocationPoint point : this.locationPoints) {
            if (!point.dimension.equals(this.selectedDimension)) continue;
            pointsInCurrentDimension.add(point);
            minX = Math.min(minX, point.x);
            maxX = Math.max(maxX, point.x);
            minZ = Math.min(minZ, point.z);
            maxZ = Math.max(maxZ, point.z);
            maxCount = Math.max(maxCount, point.count);
        }
        if (pointsInCurrentDimension.isEmpty()) {
            context.method_25300(this.field_22793, "No data available for dimension: " + this.formatDimensionName(this.selectedDimension), this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            return;
        }
        int centerX = (minX + maxX) / 2;
        int centerZ = (minZ + maxZ) / 2;
        int rangeX = Math.max(1, maxX - minX);
        int rangeZ = Math.max(1, maxZ - minZ);
        float scaleFactor = Math.min((float)(this.field_22789 - 100) / (float)rangeX, (float)(this.field_22790 - 150) / (float)rangeZ) * this.heatmapScale * 0.8f;
        int mapCenterX = this.field_22789 / 2 + this.heatmapOffsetX;
        int mapCenterY = this.field_22790 / 2 + 30 + this.heatmapOffsetY;
        int mapWidth = (int)((float)rangeX * scaleFactor);
        int mapHeight = (int)((float)rangeZ * scaleFactor);
        context.method_25294(mapCenterX - mapWidth / 2 - 5, mapCenterY - mapHeight / 2 - 5, mapCenterX + mapWidth / 2 + 5, mapCenterY + mapHeight / 2 + 5, Integer.MIN_VALUE);
        int gridSize = 100;
        int gridColor = 0x40FFFFFF;
        for (int x = minX / gridSize * gridSize; x <= maxX; x += gridSize) {
            int screenX = mapCenterX + (int)((float)(x - centerX) * scaleFactor);
            context.method_25294(screenX, mapCenterY - mapHeight / 2, screenX + 1, mapCenterY + mapHeight / 2, gridColor);
            if (x % 500 != 0) continue;
            context.method_25303(this.field_22793, String.valueOf(x), screenX - this.field_22793.method_1727(String.valueOf(x)) / 2, mapCenterY + mapHeight / 2 + 5, 0xFFFFFF);
        }
        for (int z = minZ / gridSize * gridSize; z <= maxZ; z += gridSize) {
            int screenY = mapCenterY + (int)((float)(z - centerZ) * scaleFactor);
            context.method_25294(mapCenterX - mapWidth / 2, screenY, mapCenterX + mapWidth / 2, screenY + 1, gridColor);
            if (z % 500 != 0) continue;
            String string = String.valueOf(z);
            int n = mapCenterX - mapWidth / 2 - 25;
            Objects.requireNonNull(this.field_22793);
            context.method_25303(this.field_22793, string, n, screenY - 9 / 2, 0xFFFFFF);
        }
        context.method_25300(this.field_22793, "X", mapCenterX, mapCenterY + mapHeight / 2 + 20, 0xFFFFFF);
        context.method_25303(this.field_22793, "Z", mapCenterX - mapWidth / 2 - 20, mapCenterY, 0xFFFFFF);
        int spawnX = mapCenterX + (int)((float)(-centerX) * scaleFactor);
        int spawnZ = mapCenterY + (int)((float)(-centerZ) * scaleFactor);
        if (spawnX >= mapCenterX - mapWidth / 2 && spawnX <= mapCenterX + mapWidth / 2 && spawnZ >= mapCenterY - mapHeight / 2 && spawnZ <= mapCenterY + mapHeight / 2) {
            context.method_25294(spawnX - 3, spawnZ - 3, spawnX + 3, spawnZ + 3, -1);
            context.method_25303(this.field_22793, "Spawn (0,0)", spawnX + 5, spawnZ - 5, 0xFFFFFF);
        }
        LocationPoint hoveredPoint = null;
        int hoveredDistance = Integer.MAX_VALUE;
        for (LocationPoint point : pointsInCurrentDimension) {
            int screenX = mapCenterX + (int)((float)(point.x - centerX) * scaleFactor);
            int n = mapCenterY + (int)((float)(point.z - centerZ) * scaleFactor);
            if (screenX < mapCenterX - mapWidth / 2 - 15 || screenX > mapCenterX + mapWidth / 2 + 15 || n < mapCenterY - mapHeight / 2 - 15 || n > mapCenterY + mapHeight / 2 + 15) continue;
            float normalizedCount = (float)point.count / (float)maxCount;
            int pointSize = (int)(5.0f + normalizedCount * 25.0f);
            int color = this.getHeatmapColor(normalizedCount);
            this.drawFilledCircle(context, screenX, n, pointSize / 2, color);
            int distance = (int)Math.sqrt(Math.pow(mouseX - screenX, 2.0) + Math.pow(mouseY - n, 2.0));
            if (distance >= pointSize / 2 + 2 || distance >= hoveredDistance) continue;
            hoveredPoint = point;
            hoveredDistance = distance;
        }
        if (hoveredPoint != null) {
            void var28_36;
            ArrayList<CallSite> tooltipLines = new ArrayList<CallSite>();
            tooltipLines.add((CallSite)((Object)("Position: X:" + hoveredPoint.x + " Y:" + hoveredPoint.y + " Z:" + hoveredPoint.z)));
            tooltipLines.add((CallSite)((Object)("Screenshots: " + hoveredPoint.count)));
            tooltipLines.add((CallSite)((Object)("Dimension: " + this.formatDimensionName(hoveredPoint.dimension))));
            int tooltipWidth = 0;
            for (String string : tooltipLines) {
                tooltipWidth = Math.max(tooltipWidth, this.field_22793.method_1727(string));
            }
            int tooltipX = mouseX + 10;
            if (tooltipX + tooltipWidth + 10 > this.field_22789) {
                tooltipX = mouseX - tooltipWidth - 10;
            }
            context.method_25294(tooltipX - 3, mouseY - 3, tooltipX + tooltipWidth + 3, mouseY + tooltipLines.size() * 10 + 3, -267386864);
            context.method_25294(tooltipX - 2, mouseY - 2, tooltipX + tooltipWidth + 2, mouseY + tooltipLines.size() * 10 + 2, -267386864);
            boolean bl = false;
            while (var28_36 < tooltipLines.size()) {
                context.method_25303(this.field_22793, (String)tooltipLines.get((int)var28_36), tooltipX, mouseY + var28_36 * 10, 0xFFFFFF);
                ++var28_36;
            }
        }
        context.method_25300(this.field_22793, "Dimension: " + this.formatDimensionName(this.selectedDimension) + " | Scale: " + String.format("%.1fx", Float.valueOf(this.heatmapScale)), this.field_22789 / 2, this.field_22790 - 40, 0xFFFFFF);
        context.method_25300(this.field_22793, "scroll to zoom / move", this.field_22789 / 2, this.field_22790 - 25, 0xAAAAAA);
    }

    private void drawFilledCircle(class_332 context, int centerX, int centerY, int radius, int color) {
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                if (x * x + y * y > radius * radius) continue;
                context.method_25294(centerX + x, centerY + y, centerX + x + 1, centerY + y + 1, color);
            }
        }
    }

    private int getHeatmapColor(float intensity) {
        int g;
        int r;
        if ((double)intensity < 0.5) {
            float adjIntensity = intensity * 2.0f;
            r = (int)(255.0f * adjIntensity);
            g = 255;
        } else {
            float adjIntensity = (intensity - 0.5f) * 2.0f;
            r = 255;
            g = (int)(255.0f * (1.0f - adjIntensity));
        }
        int b = 0;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private String formatDimensionName(String dimension) {
        return switch (dimension) {
            case "minecraft:overworld" -> "Overworld";
            case "minecraft:the_nether" -> "The Nether";
            case "minecraft:the_end" -> "The End";
            default -> dimension.substring(0, 1).toUpperCase() + dimension.substring(1).replace('_', ' ');
        };
    }

    private void renderUserDetails(class_332 context, int mouseX, int mouseY) {
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("User Profile: " + this.selectedUser)).method_27692(class_124.field_1065), this.field_22789 / 2, 55, 0xFFFFFF);
        List<StatisticsSection> userSections = this.userDetailSections.get(this.selectedUser);
        int y = 75 - this.scrollOffset;
        for (StatisticsSection section : userSections) {
            if (y + section.getHeight() < 50 || y > this.field_22790) {
                y += section.getHeight() + 15;
                continue;
            }
            if (!section.title.isEmpty()) {
                context.method_25303(this.field_22793, section.title, this.field_22789 / 2 - 150, y, 0xFFAA00);
                y += 12;
            }
            for (StatisticsEntry entry : section.entries) {
                if (y >= 50 && y <= this.field_22790) {
                    boolean isHovering = entry.isClickable && mouseX >= this.field_22789 / 2 - 145 && mouseX <= this.field_22789 / 2 + 145 && mouseY >= y - 1 && mouseY <= y + 9;
                    int keyColor = isHovering ? 0xFFFF55 : 0xFFFFFF;
                    context.method_27535(this.field_22793, entry.key, this.field_22789 / 2 - 145, y, keyColor);
                    context.method_27535(this.field_22793, entry.value, this.field_22789 / 2 + 30, y, 0xAAAAAA);
                    if (entry.isClickable) {
                        int textWidth = this.field_22793.method_27525((class_5348)entry.key);
                        context.method_25294(this.field_22789 / 2 - 145, y + 9, this.field_22789 / 2 - 145 + textWidth, y + 10, isHovering ? -171 : -5592406);
                    }
                }
                y += 10;
            }
            y += 15;
        }
        int contentHeight = this.getTotalContentHeight(userSections);
        if (contentHeight > this.field_22790 - 100) {
            if (this.scrollOffset > 0) {
                context.method_25300(this.field_22793, "\u25b2", this.field_22789 / 2, 50, 0xFFFFFF);
            }
            if (this.scrollOffset < contentHeight - (this.field_22790 - 100)) {
                context.method_25300(this.field_22793, "\u25bc", this.field_22789 / 2, this.field_22790 - 10, 0xFFFFFF);
            }
        }
    }

    private List<StatisticsSection> getTabSections() {
        ArrayList<StatisticsSection> filtered = new ArrayList<StatisticsSection>();
        switch (this.currentTab) {
            case 0: {
                for (StatisticsSection section : this.sections) {
                    if (!section.title.contains("Server Statistics") && !section.title.contains("Recent Uploads")) continue;
                    filtered.add(section);
                }
                break;
            }
            case 1: {
                for (StatisticsSection section : this.sections) {
                    if (!section.title.contains("User Statistics") && !section.title.contains("Activity Patterns")) continue;
                    filtered.add(section);
                }
                break;
            }
            case 2: {
                for (StatisticsSection section : this.sections) {
                    if (!section.title.contains("File Statistics") && !section.title.contains("World Statistics")) continue;
                    filtered.add(section);
                }
                break;
            }
            case 3: {
                for (StatisticsSection section : this.sections) {
                    if (!section.title.contains("Performance Statistics")) continue;
                    filtered.add(section);
                }
                break;
            }
        }
        return filtered;
    }

    private int getTotalContentHeight(List<StatisticsSection> sections) {
        int height = 0;
        for (StatisticsSection section : sections) {
            height += section.getHeight() + 15;
        }
        return height;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount, double verticalAmount) {
        int visibleHeight;
        if (this.currentTab == 4 && this.isHeatmapActive && !this.isLoading && this.errorMessage == null) {
            float oldScale = this.heatmapScale;
            float zoomFactor = 0.1f;
            this.heatmapScale += (float)(verticalAmount * (double)zoomFactor);
            this.heatmapScale = Math.max(0.25f, Math.min(10.0f, this.heatmapScale));
            int mapCenterX = this.field_22789 / 2 + this.heatmapOffsetX;
            int mapCenterY = this.field_22790 / 2 + 30 + this.heatmapOffsetY;
            double relX = mouseX - (double)mapCenterX;
            double relY = mouseY - (double)mapCenterY;
            double scaleRatio = this.heatmapScale / oldScale;
            this.heatmapOffsetX -= (int)((scaleRatio - 1.0) * relX);
            this.heatmapOffsetY -= (int)((scaleRatio - 1.0) * relY);
            return true;
        }
        List<StatisticsSection> relevantSections = this.selectedUser != null ? this.userDetailSections.get(this.selectedUser) : this.getTabSections();
        int contentHeight = this.getTotalContentHeight(relevantSections);
        int n = visibleHeight = this.selectedUser != null ? this.field_22790 - 100 : this.field_22790 - 80;
        if (contentHeight > visibleHeight) {
            int scrollSpeed = 20;
            this.scrollOffset -= (int)(verticalAmount * (double)scrollSpeed);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, contentHeight - visibleHeight));
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isLoading || this.errorMessage != null) {
            return false;
        }
        if (this.currentTab == 4 && this.isHeatmapActive && button == 0 && mouseY > 90.0 && mouseY < (double)(this.field_22790 - 50)) {
            this.isDraggingMap = true;
            this.dragStartX = (int)mouseX;
            this.dragStartY = (int)mouseY;
            this.dragStartOffsetX = this.heatmapOffsetX;
            this.dragStartOffsetY = this.heatmapOffsetY;
            return true;
        }
        List<StatisticsSection> sectionsToCheck = this.selectedUser != null ? this.userDetailSections.getOrDefault(this.selectedUser, Collections.emptyList()) : this.getTabSections();
        int y = (this.selectedUser != null ? 75 : 55) - this.scrollOffset;
        for (StatisticsSection section : sectionsToCheck) {
            if (y + section.getHeight() < 50 || y > this.field_22790) {
                y += section.getHeight() + 15;
                continue;
            }
            y += 12;
            for (StatisticsEntry entry : section.entries) {
                if (y >= 50 && y <= this.field_22790 && entry.isClickable && mouseX >= (double)this.field_22789 / 2.0 - 145.0 && mouseX <= (double)this.field_22789 / 2.0 + 145.0 && mouseY >= (double)(y - 1) && mouseY <= (double)(y + 9)) {
                    entry.onClick.run();
                    if (entry.key.getString().contains("Back to") || entry.key.getString().contains(this.selectedUser)) {
                        this.method_25426();
                    }
                    return true;
                }
                y += 10;
            }
            y += 15;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.isDraggingMap && button == 0 && this.currentTab == 4 && this.isHeatmapActive) {
            this.heatmapOffsetX = this.dragStartOffsetX + (int)(mouseX - (double)this.dragStartX);
            this.heatmapOffsetY = this.dragStartOffsetY + (int)(mouseY - (double)this.dragStartY);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isDraggingMap && button == 0) {
            this.isDraggingMap = false;
            return true;
        }
        return false;
    }

    private String formatFileSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "B";
        return String.format("%.1f %s", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
        super.method_25419();
    }

    private static class StatisticsSection {
        private final String title;
        private final List<StatisticsEntry> entries = new ArrayList<StatisticsEntry>();
        private final class_2561 translatedTitle;

        public StatisticsSection(String title, class_2561 translatedTitle) {
            this.title = title;
            this.translatedTitle = translatedTitle;
        }

        public void addEntry(class_2561 key, class_2561 value) {
            this.entries.add(new StatisticsEntry(key, value));
        }

        public void makeEntryClickable(class_2561 key, Runnable onClick) {
            for (StatisticsEntry entry : this.entries) {
                if (!entry.key.method_44745(key)) continue;
                entry.isClickable = true;
                entry.onClick = onClick;
                break;
            }
        }

        public int getHeight() {
            return 12 + this.entries.size() * 10;
        }
    }

    private record LocationPoint(int x, int y, int z, String dimension, int count) {
    }

    private static class StatisticsEntry {
        private final class_2561 key;
        private final class_2561 value;
        private boolean isClickable = false;
        private Runnable onClick = () -> {};

        public StatisticsEntry(class_2561 key, class_2561 value) {
            this.key = key;
            this.value = value;
        }
    }
}

