/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.thecoolcraft11.config.AlbumManager;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.config.data.Album;
import de.thecoolcraft11.util.ReceivePackets;
import de.thecoolcraft11.util.ScreenshotUploadHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadToServerScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(UploadToServerScreen.class);
    private static class_437 parent;
    private static Path screenshotPath;
    private static class_1011 screenshotImage;
    private class_2960 textureId;
    private JsonObject metadata;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private static final int BORDER_WIDTH = 5;
    private static final int METADATA_PANEL_WIDTH = 300;
    private int scrollOffset = 0;
    private final Map<String, String> serverOptions = new HashMap<String, String>();
    private String selectedServer = null;
    private boolean isServerPanelOpen = false;
    private int serverPanelScroll = 0;
    private static final int SERVER_PANEL_WIDTH = 200;
    private static final int SERVER_PANEL_HEIGHT = 150;
    private static final int SERVER_BUTTON_WIDTH = 120;
    private static final int SERVER_BUTTON_HEIGHT = 20;
    private static final int SERVER_BUTTON_SPACING = 10;
    private final List<class_4185> serverButtons = new ArrayList<class_4185>();

    public UploadToServerScreen(class_437 passedParent, Path passedScreenshotPath) {
        super((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.uploading.title"));
        parent = passedParent;
        screenshotPath = passedScreenshotPath;
        this.loadMetadata();
    }

    protected void method_25426() {
        super.method_25426();
        this.serverButtons.clear();
        this.loadScreenshotImage();
        int buttonWidth = 100;
        int buttonHeight = 20;
        int buttonSpacing = 10;
        int buttonsY = this.field_22790 - buttonHeight - 20;
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.cancel"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(parent);
            }
        }).method_46434(this.field_22789 / 2 - buttonWidth - buttonSpacing / 2, buttonsY, buttonWidth, buttonHeight).method_46431();
        class_4185 uploadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.upload"), button -> this.uploadScreenshot()).method_46434(this.field_22789 / 2 + buttonSpacing / 2, buttonsY, buttonWidth, buttonHeight).method_46431();
        Map<String, Map<String, String>> uploadUrls = ConfigManager.getClientConfig().upload_urls;
        if (uploadUrls != null && !uploadUrls.isEmpty()) {
            for (Map.Entry<String, Map<String, String>> entry : uploadUrls.entrySet()) {
                if (!entry.getValue().containsKey("upload")) continue;
                this.serverOptions.put(entry.getKey(), entry.getValue().get("upload"));
            }
        }
        this.method_37063((class_364)cancelButton);
        this.method_37063((class_364)uploadButton);
        class_4185 selectServerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.select_server"), button -> this.toggleServerPanel()).method_46434(10, 10, 150, 20).method_46431();
        this.method_37063((class_364)selectServerButton);
        this.initializeServerButtons();
    }

    private void initializeServerButtons() {
        int serverY = this.field_22790 - 20 - 60;
        int startX = (this.field_22789 - 380) / 2;
        if (ReceivePackets.serverSiteAddress != null) {
            class_4185 currentServerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Current Server"), button -> {
                this.selectedServer = "Current Server";
                this.updateServerButtonStates();
            }).method_46434(startX, serverY, 120, 20).method_46431();
            this.serverButtons.add(currentServerButton);
            this.method_37063((class_364)currentServerButton);
            startX += 130;
        }
        int buttonsPerRow = 3;
        int currentColumn = ReceivePackets.serverSiteAddress != null ? 1 : 0;
        for (String serverName : this.serverOptions.keySet()) {
            class_4185 serverButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)serverName), button -> {
                this.selectedServer = serverName;
                this.updateServerButtonStates();
            }).method_46434(startX, serverY, 120, 20).method_46431();
            this.serverButtons.add(serverButton);
            this.method_37063((class_364)serverButton);
            if (++currentColumn >= buttonsPerRow) {
                currentColumn = 0;
                serverY += 25;
                startX = (this.field_22789 - 380) / 2;
                continue;
            }
            startX += 130;
        }
        if (!this.serverButtons.isEmpty() && this.selectedServer == null) {
            if (ReceivePackets.serverSiteAddress != null) {
                this.selectedServer = "Current Server";
            } else if (!this.serverOptions.isEmpty()) {
                this.selectedServer = this.serverOptions.keySet().iterator().next();
            }
            this.updateServerButtonStates();
        }
    }

    private void toggleServerPanel() {
        this.isServerPanelOpen = !this.isServerPanelOpen;
    }

    private void loadScreenshotImage() {
        if (screenshotPath == null) {
            logger.error("Screenshot path is null");
            return;
        }
        try {
            screenshotImage = class_1011.method_4309((InputStream)Files.newInputStream(screenshotPath, new OpenOption[0]));
            this.textureId = class_2960.method_60655((String)"screenshot_uploader", (String)("textures/screenshots/" + screenshotPath.getFileName().toString()));
            if (this.field_22787 != null) {
                this.field_22787.method_1531().method_4616(this.textureId, (class_1044)new class_1043(String::new, screenshotImage));
                float aspectRatio = (float)screenshotImage.method_4307() / (float)screenshotImage.method_4323();
                this.imageHeight = Math.min(this.field_22790 - 100, 400);
                this.imageWidth = (int)((float)this.imageHeight * aspectRatio);
                if (this.imageWidth > this.field_22789 - 300 - 40) {
                    this.imageWidth = this.field_22789 - 300 - 40;
                    this.imageHeight = (int)((float)this.imageWidth / aspectRatio);
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed to load screenshot image: {}", (Object)e.getMessage());
        }
    }

    private void loadMetadata() {
        File jsonData;
        this.metadata = new JsonObject();
        if (screenshotPath != null && (jsonData = new File(screenshotPath.getParent().toString(), screenshotPath.getFileName().toString().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"))).exists()) {
            try (FileReader reader = new FileReader(jsonData, StandardCharsets.UTF_8);){
                this.metadata = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                logger.error("Error reading metadata: {}", (Object)e.getMessage());
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX > (double)(this.field_22789 - 300) && this.hasScrollableContent()) {
            int maxScroll = this.getScrollableContentHeight() - this.imageHeight + 50;
            this.scrollOffset = verticalAmount < 0.0 ? Math.min(this.scrollOffset + 15, maxScroll) : Math.max(this.scrollOffset - 15, 0);
            return true;
        }
        if (this.isServerPanelOpen && mouseX < 200.0 && mouseY < 150.0) {
            this.serverPanelScroll = verticalAmount < 0.0 ? Math.min(this.serverPanelScroll + 15, Math.max(0, this.serverOptions.size() * 20 - 150)) : Math.max(this.serverPanelScroll - 15, 0);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private boolean hasScrollableContent() {
        return this.getMetadataEntries().size() * 25 + 40 > this.imageHeight - 50;
    }

    private int getScrollableContentHeight() {
        return this.getMetadataEntries().size() * 25 + 40;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.textureId != null && screenshotImage != null) {
            int imageX = (this.field_22789 - this.imageWidth - 300) / 2;
            int imageY = 50;
            context.method_25294(imageX - 5, imageY - 5, imageX + this.imageWidth + 5, imageY + this.imageHeight + 5, -1);
            context.method_25290(class_1921::method_62277, this.textureId, imageX, imageY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
            this.renderMetadataPanel(context, imageX + this.imageWidth + 20, imageY);
            if (this.hasScrollableContent()) {
                int indicatorY = imageY + 5;
                int indicatorHeight = 10;
                context.method_25294(this.field_22789 - 10, indicatorY, this.field_22789 - 5, indicatorY + indicatorHeight, -5592406);
            }
        } else {
            String errorMessage = "Could not load screenshot image.";
            context.method_25300(this.field_22793, errorMessage, this.field_22789 / 2, this.field_22790 / 2, 0xFF0000);
        }
        if (this.isServerPanelOpen) {
            this.renderServerSelectionPanel(context);
        }
    }

    private void renderServerSelectionPanel(class_332 context) {
        int panelX = 10;
        int panelY = 40;
        context.method_25294(panelX, panelY, panelX + 200, panelY + 150, Integer.MIN_VALUE);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.server_selection"), panelX + 10, panelY + 10, 0xFFFFFF);
        context.method_44379(panelX, panelY + 30, panelX + 200 - 10, panelY + 150 - 10);
        int serverY = panelY + 30 - this.serverPanelScroll;
        int serverLineHeight = 20;
        for (Map.Entry<String, String> serverEntry : this.serverOptions.entrySet()) {
            if (serverY + 20 < panelY + 30) {
                serverY += 20;
                continue;
            }
            if (serverY > panelY + 150 - 10) break;
            int buttonColor = serverEntry.getKey().equals(this.selectedServer) ? -5592406 : -1;
            context.method_25294(panelX + 5, serverY, panelX + 200 - 5, serverY + 20, buttonColor);
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)serverEntry.getKey()), panelX + 10, serverY + 5, 0);
            serverY += 20;
        }
        context.method_44380();
    }

    private void renderMetadataPanel(class_332 context, int x, int y) {
        context.method_25294(x, y, x + 300, y + this.imageHeight, Integer.MIN_VALUE);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.title"), x + 10, y + 10, 0xFFFFFF);
        context.method_44379(x, y + 30, x + 300 - 10, y + this.imageHeight - 40);
        LinkedHashMap<class_2561, class_2561> metadataEntries = this.getMetadataEntries();
        int entryY = y + 30 - this.scrollOffset;
        int lineHeight = 12;
        for (Map.Entry<class_2561, class_2561> entry : metadataEntries.entrySet()) {
            if (entryY + 24 < y + 30) {
                entryY += 29;
                continue;
            }
            if (entryY > y + this.imageHeight - 40) break;
            context.method_27535(this.field_22793, entry.getKey(), x + 10, entryY, 0xAAAAAA);
            List<class_2561> wrappedValue = this.wrapText(entry.getValue().getString());
            int valueY = entryY + 12;
            for (class_2561 line : wrappedValue) {
                context.method_27535(this.field_22793, line, x + 10, valueY, 0xFFFFFF);
                valueY += 12;
            }
            entryY = valueY + 5;
        }
        context.method_44380();
        String uploadInfoText = "Selected server: " + (this.selectedServer != null ? this.selectedServer : "None");
        context.method_25303(this.field_22793, uploadInfoText, x + 10, y + this.imageHeight - 30, 0xFFFFFF);
    }

    private List<class_2561> wrapText(String text) {
        String[] words;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (text.length() <= 30 || this.field_22793 == null) {
            lines.add((class_2561)class_2561.method_43470((String)text));
            return lines;
        }
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            if (this.field_22793.method_1727(String.valueOf(currentLine) + " " + word) > 270 && !currentLine.isEmpty()) {
                lines.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
                currentLine = new StringBuilder(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add((class_2561)class_2561.method_43470((String)currentLine.toString()));
        }
        return lines;
    }

    private LinkedHashMap<class_2561, class_2561> getMetadataEntries() {
        LinkedHashMap<class_2561, class_2561> entries = new LinkedHashMap<class_2561, class_2561>();
        entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.filename"), (class_2561)class_2561.method_43470((String)screenshotPath.getFileName().toString()));
        if (this.metadata.has("username")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.username"), (class_2561)class_2561.method_43470((String)this.metadata.get("username").getAsString()));
        }
        if (this.metadata.has("uuid")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.uuid"), (class_2561)class_2561.method_43470((String)this.metadata.get("uuid").getAsString()));
        }
        if (this.metadata.has("accountType")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.accountType"), (class_2561)class_2561.method_43470((String)this.metadata.get("accountType").getAsString()));
        }
        if (this.metadata.has("dimension")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.dimension"), (class_2561)class_2561.method_43470((String)this.metadata.get("dimension").getAsString()));
        }
        if (this.metadata.has("world_name")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.world"), (class_2561)class_2561.method_43470((String)this.metadata.get("world_name").getAsString()));
        }
        if (this.metadata.has("world_seed")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.seed"), (class_2561)class_2561.method_43470((String)this.metadata.get("world_seed").getAsString()));
        }
        if (this.metadata.has("biome")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.biome"), (class_2561)class_2561.method_43470((String)this.metadata.get("biome").getAsString()));
        }
        if (this.metadata.has("coordinates")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.location"), (class_2561)class_2561.method_43470((String)this.metadata.get("coordinates").getAsString()));
        }
        if (this.metadata.has("facing_direction")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.facing"), (class_2561)class_2561.method_43470((String)this.metadata.get("facing_direction").getAsString()));
        }
        if (this.metadata.has("world_info")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.worldInfo"), (class_2561)class_2561.method_43470((String)this.metadata.get("world_info").getAsString()));
        }
        if (this.metadata.has("player_state")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.playerState"), (class_2561)class_2561.method_43470((String)this.metadata.get("player_state").getAsString()));
        }
        if (this.metadata.has("chunk_info")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.chunkInfo"), (class_2561)class_2561.method_43470((String)this.metadata.get("chunk_info").getAsString()));
        }
        if (this.metadata.has("entities_info")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.entitiesInfo"), (class_2561)class_2561.method_43470((String)this.metadata.get("entities_info").getAsString()));
        }
        if (this.metadata.has("server_address")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.serverAddress"), (class_2561)class_2561.method_43470((String)this.metadata.get("server_address").getAsString()));
        }
        if (this.metadata.has("client_settings")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.clientSettings"), (class_2561)class_2561.method_43470((String)this.metadata.get("client_settings").getAsString()));
        }
        if (this.metadata.has("system_info")) {
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.systemInfo"), (class_2561)class_2561.method_43470((String)this.metadata.get("system_info").getAsString()));
        }
        if (this.metadata.has("album") && this.metadata.get("album").isJsonPrimitive()) {
            String albumUUID = this.metadata.get("album").getAsString();
            try {
                Album album = AlbumManager.getAlbum(UUID.fromString(albumUUID));
                if (album != null) {
                    entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.album"), (class_2561)class_2561.method_43470((String)album.getTitle()));
                }
            }
            catch (Exception e) {
                logger.error("Error processing album: {}", (Object)e.getMessage());
            }
        }
        if (this.metadata.has("current_time")) {
            long timestamp = this.metadata.get("current_time").getAsLong();
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.time"), (class_2561)class_2561.method_43470((String)this.formatTimestamp(timestamp)));
        } else if (this.metadata.has("date")) {
            long timestamp = this.metadata.get("date").getAsLong();
            entries.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.time"), (class_2561)class_2561.method_43470((String)this.formatTimestamp(timestamp)));
        }
        return entries;
    }

    private String formatTimestamp(long millis) {
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        LocalDateTime timestampDateTime = LocalDateTime.ofInstant(timestampInstant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return timestampDateTime.format(formatter);
    }

    private void uploadScreenshot() {
        logger.info("Uploading screenshot: {}", (Object)screenshotPath);
        String uploadServer = this.serverOptions.get(this.selectedServer);
        if (this.selectedServer.equals("Current Server")) {
            uploadServer = ReceivePackets.serverSiteAddress;
        }
        String metadataString = this.metadata.isJsonObject() ? new Gson().toJson((JsonElement)this.metadata) : this.metadata.getAsString();
        ScreenshotUploadHelper.uploadScreenshot(screenshotImage, metadataString, List.of(uploadServer));
        if (this.field_22787 != null) {
            this.field_22787.method_1507(parent);
        }
    }

    private void updateServerButtonStates() {
        for (class_4185 button : this.serverButtons) {
            button.field_22763 = !button.method_25369().getString().equals(this.selectedServer);
        }
    }

    public void method_25419() {
        if (screenshotImage != null) {
            screenshotImage.close();
        }
        super.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isServerPanelOpen && button == 0) {
            int clickedY;
            int serverIndex;
            int panelX = 10;
            int panelY = 40;
            if (mouseX >= (double)(panelX + 5) && mouseX <= (double)(panelX + 200 - 5) && mouseY >= (double)(panelY + 30) && mouseY <= (double)(panelY + 150 - 10) && (serverIndex = (clickedY = (int)mouseY - (panelY + 30) + this.serverPanelScroll) / 20) >= 0 && serverIndex < this.serverOptions.size()) {
                int i = 0;
                for (String serverName : this.serverOptions.keySet()) {
                    if (i == serverIndex) {
                        this.selectedServer = serverName;
                        this.isServerPanelOpen = false;
                        return true;
                    }
                    ++i;
                }
            }
            if (mouseX >= (double)panelX && mouseX <= (double)(panelX + 200) && mouseY >= (double)panelY && mouseY <= (double)(panelY + 150)) {
                return true;
            }
            this.isServerPanelOpen = false;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

