/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.screen;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.packet.CommentPayload;
import de.thecoolcraft11.packet.DeletionPacket;
import de.thecoolcraft11.screen.GalleryScreen;
import de.thecoolcraft11.screen.ScreenshotWebTaggingScreen;
import de.thecoolcraft11.screen.ServerStatisticsScreen;
import de.thecoolcraft11.util.ReceivePackets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGalleryScreen
extends class_437 {
    private static final Logger logger = LoggerFactory.getLogger(WebGalleryScreen.class);
    private static final List<class_2960> imageIds = new ArrayList<class_2960>();
    private static final List<String> imagePaths = new ArrayList<String>();
    private static final List<JsonObject> metaDatas = new ArrayList<JsonObject>();
    private static final List<String> newImagePaths = new ArrayList<String>();
    private static final int IMAGES_PER_ROW = ConfigManager.getClientConfig().imagesPerRow;
    private static int IMAGE_WIDTH = 192;
    private static int IMAGE_HEIGHT = 108;
    private static int GAP = ConfigManager.getClientConfig().imageGap;
    private static int TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
    private static boolean isImageClicked = false;
    private static int clickedImageIndex = -1;
    private int scrollOffset = 0;
    private double zoomLevel = 1.0;
    private double imageOffsetX = 0.0;
    private double imageOffsetY = 0.0;
    private final class_437 parent;
    private final String webserverUrl;
    private final String initialImageName;
    private class_4185 openInBrowserButton;
    private final List<class_4185> navigatorButtons = new ArrayList<class_4185>();
    private final List<class_4185> buttonsToHideOnOverlap = new ArrayList<class_4185>();
    private class_4185 saveButton;
    private class_4185 openInAppButton;
    private class_4185 shareButton;
    private static class_4185 likeButton;
    private class_4185 sendCommentButton;
    private class_4185 sortByButton;
    private class_4185 sortOrderButton;
    private class_4185 deleteButton;
    private class_4185 serverStatsButton;
    private class_4185 viewTagsButton;
    private class_342 commentWidget;
    private class_342 searchField;
    private String lastSearchQuery = "";
    private Runnable searchDebounceTask = null;
    private CompletableFuture<?> asyncSortFuture;
    private final AtomicInteger sortTaskId = new AtomicInteger();
    private SortBy sortBy = SortBy.DEFAULT;
    private SortOrder sortOrder = SortOrder.ASCENDING;
    private static String FILE_PATH;
    private int starY = 0;
    private boolean goingUp = true;

    public WebGalleryScreen(class_437 parent, String webserverUrl, String initialImageName) {
        super((class_2561)class_2561.method_43469((String)"gui.screenshot_uploader.screenshot_gallery.web_title", (Object[])new Object[]{webserverUrl}));
        this.parent = Objects.requireNonNullElseGet(parent, GalleryScreen::new);
        this.webserverUrl = webserverUrl;
        this.initialImageName = initialImageName;
        FILE_PATH = "./config/screenshotUploader/data/" + webserverUrl.hashCode() + ".json";
    }

    protected void method_25426() {
        super.method_25426();
        this.initializeScreen();
        GAP = ConfigManager.getClientConfig().imageGap;
        TOP_PADDING = ConfigManager.getClientConfig().imageTopPadding;
        int scaledHeight = this.field_22790 / 6;
        int scaledWidth = scaledHeight * 16 / 9;
        int scaledGap = scaledHeight / 10;
        TOP_PADDING = this.field_22790 / 20 + TOP_PADDING;
        IMAGE_WIDTH = scaledWidth;
        IMAGE_HEIGHT = scaledHeight;
        GAP = scaledGap;
        this.asyncSortFuture = CompletableFuture.runAsync(() -> WebGalleryScreen.loadScreenshotsFromServer(this.webserverUrl)).exceptionally(e -> {
            logger.error("Error loading screenshots: {}", (Object)e.getMessage());
            return null;
        });
        int buttonWidth = this.field_22789 / 8;
        int buttonHeight = this.field_22790 / 25;
        int buttonSpacing = buttonWidth / 5;
        int xPosition = (this.field_22789 - (buttonWidth * (this.navigatorButtons.size() + 1) + buttonSpacing * (this.navigatorButtons.size() - 1))) / 5;
        int buttonY = (int)((double)this.field_22790 * 0.9);
        int navigatorY = (int)((double)this.field_22790 * 0.01);
        this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.my_gallery"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            } else {
                logger.error("Failed to get client");
            }
        }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
        xPosition += buttonWidth + buttonSpacing;
        if (ReceivePackets.gallerySiteAddress != null) {
            if (!ReceivePackets.gallerySiteAddress.equals(this.webserverUrl)) {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_gallery"), button -> {
                    String webserverUrl = ReceivePackets.gallerySiteAddress;
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                    } else {
                        logger.error("Failed to get client trying to open Server Gallery with URL {}", (Object)webserverUrl);
                    }
                }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            } else {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
                this.openInBrowserButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_browser"), button -> this.openBrowser(ReceivePackets.homeSiteAddress)).method_46434(this.field_22789 - buttonWidth, buttonY, buttonWidth, buttonHeight).method_46431();
            }
            xPosition += buttonWidth + buttonSpacing;
        }
        for (Map.Entry<String, Map<String, String>> entry : ConfigManager.getClientConfig().upload_urls.entrySet()) {
            String webserverUrl = entry.getValue().get("gallery");
            String webserverUrlHome = entry.getValue().get("home");
            String buttonLabel = entry.getKey();
            if (webserverUrl == null || webserverUrl.isEmpty() || webserverUrlHome == null || webserverUrlHome.isEmpty()) continue;
            if (!this.webserverUrl.equals(webserverUrl)) {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)buttonLabel), button -> {
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new WebGalleryScreen(this, webserverUrl, null));
                    } else {
                        logger.error("Failed to get client trying to open Gallery for {}", (Object)webserverUrl);
                    }
                }).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            } else {
                this.navigatorButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"), button -> {}).method_46434(xPosition, navigatorY, buttonWidth, buttonHeight).method_46431());
            }
            if (this.openInBrowserButton == null) {
                this.openInBrowserButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_in_browser"), button -> this.openBrowser(webserverUrlHome)).method_46434(this.field_22789 - buttonWidth, buttonY, buttonWidth, buttonHeight).method_46431();
            }
            xPosition += buttonWidth + buttonSpacing;
        }
        this.navigatorButtons.forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        this.method_37063((class_364)this.openInBrowserButton);
        this.navigatorButtons.forEach(buttonWidget -> {
            buttonWidget.field_22764 = true;
        });
        this.navigatorButtons.stream().filter(buttonWidget -> buttonWidget.method_25369().equals((Object)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.current"))).forEach(buttonWidget -> {
            buttonWidget.field_22763 = false;
        });
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.save"), button -> this.downloadImage()).method_46434(5, buttonY, buttonWidth, buttonHeight).method_46431();
        this.openInAppButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.open_sc_in_browser"), button -> this.openInBrowser()).method_46434(buttonWidth + 10, buttonY, buttonWidth, buttonHeight).method_46431();
        this.shareButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.share_screenshot"), button -> this.shareScreenshot()).method_46434(buttonWidth * 2 + 15, buttonY, buttonWidth, buttonHeight).method_46431();
        likeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(0x2A2A2A), button -> WebGalleryScreen.likeScreenshot()).method_46434(buttonWidth * 3 + 20, buttonY, 20, 20).method_46431();
        this.deleteButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.delete_screenshot"), button -> this.deleteScreenshot()).method_46434(buttonWidth * 4 - (buttonWidth - 20) + 25, buttonY, buttonWidth, buttonHeight).method_46431();
        this.serverStatsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.server_stats"), button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ServerStatisticsScreen(this, this.webserverUrl));
            }
        }).method_46434(5, 5, buttonWidth / 2, buttonHeight).method_46431();
        this.commentWidget = new class_342(this.field_22793, 0, 0, 100, 20, class_2561.method_30163((String)""));
        this.method_25429((class_364)this.commentWidget);
        this.sendCommentButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.send_comment"), button -> this.sendComment()).method_46434(buttonWidth * 3 + 20, buttonY, buttonWidth, buttonHeight).method_46431();
        this.sortByButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortBy.toString()), button -> {
            this.sortBy = SortBy.values()[(this.sortBy.ordinal() + 1) % SortBy.values().length];
            this.sortByButton.method_25355(class_2561.method_30163((String)this.sortBy.toString()));
            this.loadScreenshotsSorted(this.sortOrder, this.sortBy);
        }).method_46434(5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.sortOrderButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.sortOrder.toString()), button -> {
            this.sortOrder = SortOrder.values()[(this.sortOrder.ordinal() + 1) % SortOrder.values().length];
            this.sortOrderButton.method_25355(class_2561.method_30163((String)this.sortOrder.toString()));
            this.loadScreenshotsSorted(this.sortOrder, this.sortBy);
        }).method_46434(5 + buttonWidth + 5, this.field_22790 - buttonHeight - 5, buttonWidth, buttonHeight).method_46431();
        this.searchField = new class_342(this.field_22793, 5 + 2 * buttonWidth + 10, this.field_22790 - buttonHeight - 5, buttonWidth * 2, buttonHeight, (class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.search"));
        this.searchField.method_1863(query -> {
            if (this.searchDebounceTask != null) {
                class_310.method_1551().method_63588(this.searchDebounceTask);
            }
            this.searchDebounceTask = () -> this.performSearch((String)query);
            class_310.method_1551().method_63588(this.searchDebounceTask);
        });
        this.viewTagsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.view_tags"), button -> {
            JsonObject metaData;
            String screenshotName = null;
            if (imagePaths.get(clickedImageIndex) != null) {
                screenshotName = imagePaths.get(clickedImageIndex);
            }
            JsonArray tags = new JsonArray();
            if (metaDatas.size() > clickedImageIndex && (metaData = metaDatas.get(clickedImageIndex)).has("tags")) {
                tags = metaData.getAsJsonArray("tags");
            }
            if (screenshotName != null && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ScreenshotWebTaggingScreen(this, screenshotName, tags));
            }
        }).method_46434(this.field_22789 - 150, this.field_22790 - 40, 100, 20).method_46431();
        this.method_37063((class_364)this.sortByButton);
        this.method_37063((class_364)this.sortOrderButton);
        this.method_37063((class_364)this.saveButton);
        this.method_37063((class_364)this.openInAppButton);
        this.method_37063((class_364)this.shareButton);
        this.method_37063((class_364)this.sendCommentButton);
        this.method_37063((class_364)likeButton);
        this.method_37063((class_364)this.searchField);
        if (ReceivePackets.allowDelete || ReceivePackets.allowDeleteOwn) {
            this.method_37063((class_364)this.deleteButton);
        }
        this.method_37063((class_364)this.serverStatsButton);
        this.method_37063((class_364)this.viewTagsButton);
        this.saveButton.field_22764 = false;
        this.openInAppButton.field_22764 = false;
        this.shareButton.field_22764 = false;
        this.commentWidget.method_1880(1024);
        this.commentWidget.field_22764 = false;
        this.sendCommentButton.field_22764 = false;
        WebGalleryScreen.likeButton.field_22764 = false;
        this.searchField.field_22764 = true;
        this.searchField.method_1880(100);
        this.deleteButton.field_22764 = false;
        this.serverStatsButton.field_22764 = true;
        this.viewTagsButton.field_22764 = false;
        this.buttonsToHideOnOverlap.add(this.saveButton);
        this.buttonsToHideOnOverlap.add(this.openInAppButton);
        this.buttonsToHideOnOverlap.add(this.shareButton);
        this.buttonsToHideOnOverlap.add(likeButton);
        this.buttonsToHideOnOverlap.add(this.deleteButton);
        int initialImageIndex = imagePaths.indexOf(this.initialImageName);
        if (initialImageIndex >= 0) {
            isImageClicked = true;
            clickedImageIndex = initialImageIndex;
            this.zoomLevel = 1.0;
            this.imageOffsetX = 0.0;
            this.imageOffsetY = 0.0;
        }
    }

    private void initializeScreen() {
        imageIds.clear();
        imagePaths.clear();
        this.navigatorButtons.clear();
        metaDatas.clear();
        newImagePaths.clear();
        clickedImageIndex = -1;
        isImageClicked = false;
        this.scrollOffset = 0;
        this.cancelAllAsyncTasks();
        this.sortTaskId.incrementAndGet();
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        if (this.searchDebounceTask != null) {
            class_310.method_1551().method_63588(() -> {
                this.searchDebounceTask = null;
            });
        }
        this.sortTaskId.incrementAndGet();
    }

    public void cancelAllAsyncTasks() {
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        if (this.searchDebounceTask != null) {
            class_310.method_1551().method_63588(() -> {
                this.searchDebounceTask = null;
            });
        }
    }

    private static void likeScreenshot() {
        boolean dirsCreated;
        if (imageIds.isEmpty() || clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            System.err.println("Invalid image index or list is empty.");
            return;
        }
        String screenshotId = String.valueOf(imageIds.get(clickedImageIndex));
        String screenshotUrl = String.valueOf(imagePaths.get(clickedImageIndex));
        File file = new File(FILE_PATH);
        File parentDir = file.getParentFile();
        if (parentDir != null && !parentDir.exists() && (dirsCreated = parentDir.mkdirs())) {
            logger.info("Created missing directories: {}", (Object)parentDir.getAbsolutePath());
        }
        JsonArray jsonArray = new JsonArray();
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
                jsonArray = new JsonArray();
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
                return;
            }
        }
        boolean screenshotAlreadyLiked = false;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject existingLike = jsonArray.get(i).getAsJsonObject();
            if (!existingLike.has("screenshotId") || !existingLike.get("screenshotId").getAsString().equals(screenshotId)) continue;
            jsonArray.remove(i);
            screenshotAlreadyLiked = true;
            break;
        }
        if (!screenshotAlreadyLiked) {
            JsonObject newLike = new JsonObject();
            newLike.addProperty("screenshotId", screenshotId);
            newLike.addProperty("screenshotUrl", screenshotUrl);
            jsonArray.add((JsonElement)newLike);
        }
        try (FileWriter writer = new FileWriter(FILE_PATH, StandardCharsets.UTF_8);){
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonArray));
        }
        catch (IOException e) {
            logger.error("Error while saving likes.", (Throwable)e);
        }
        isImageClicked = false;
        clickedImageIndex = -1;
    }

    private void shareScreenshot() {
        StringBuilder template = new StringBuilder(ConfigManager.getClientConfig().shareText);
        int placeholderIndex = template.indexOf("{sharedLink}");
        if (placeholderIndex != -1) {
            int endIndex = placeholderIndex + "{sharedLink}".length();
            template.replace(placeholderIndex, endIndex, imagePaths.get(clickedImageIndex));
        }
        String message = template.toString();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.method_1562() != null) {
            client.method_1562().method_45729(message);
            client.method_1507(null);
        }
    }

    private void openBrowser(String url) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            ProcessBuilder processBuilder;
            if (os.contains("win")) {
                processBuilder = new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url);
            } else if (os.contains("mac")) {
                processBuilder = new ProcessBuilder("open", url);
            } else if (os.contains("nix") || os.contains("nux")) {
                processBuilder = new ProcessBuilder("xdg-open", url);
            } else {
                logger.error("Unsupported operating system for opening the home URL.");
                return;
            }
            processBuilder.start();
        }
        catch (IOException e) {
            logger.error("Failed to open the home URL {}: {}", (Object)url, (Object)e.getMessage());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (isImageClicked) {
                int imageWidth = (int)(1920.0 * this.zoomLevel);
                int imageHeight = (int)(1080.0 * this.zoomLevel);
                if (this.field_22787 != null) {
                    imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
                    imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
                }
                int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
                int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
                if (mouseX >= (double)x && mouseX <= (double)(x + imageWidth) && mouseY >= (double)y && mouseY <= (double)(y + imageHeight)) {
                    return false;
                }
                for (class_364 buttonWidget : this.method_25396()) {
                    if (buttonWidget == null || !buttonWidget.method_25405(mouseX, mouseY)) continue;
                    return super.method_25402(mouseX, mouseY, button);
                }
                isImageClicked = false;
                clickedImageIndex = -1;
                return true;
            }
            int totalImages = imageIds.size();
            for (int i = 0; i < totalImages; ++i) {
                int row = i / IMAGES_PER_ROW;
                int col = i % IMAGES_PER_ROW;
                int x = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2 + col * (IMAGE_WIDTH + GAP);
                int y = TOP_PADDING + 20 + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
                if (!(mouseX > (double)x) || !(mouseX < (double)(x + IMAGE_WIDTH)) || !(mouseY > (double)y) || !(mouseY < (double)(y + IMAGE_HEIGHT))) continue;
                isImageClicked = true;
                clickedImageIndex = i;
                this.zoomLevel = 1.0;
                this.imageOffsetX = 0.0;
                this.imageOffsetY = 0.0;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (isImageClicked && clickedImageIndex >= 0) {
            this.zoomAndRepositionImage(mouseX, mouseY, verticalAmount);
            return true;
        }
        this.scrollOffset += verticalAmount > 0.0 ? -(IMAGE_HEIGHT + GAP) : IMAGE_HEIGHT + GAP;
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.calculateMaxScrollOffset()));
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void zoomAndRepositionImage(double mouseX, double mouseY, double verticalAmount) {
        double mouseXRelative = mouseX - (double)this.field_22789 / 2.0;
        double mouseYRelative = mouseY - (double)this.field_22790 / 2.0;
        double imageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
        double imageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
        double mouseXInImage = -(mouseXRelative - this.imageOffsetX);
        double mouseYInImage = -(mouseYRelative - this.imageOffsetY);
        this.zoomLevel = Math.min(Math.max(this.zoomLevel + (verticalAmount > 0.0 ? 0.1 : -0.1), 0.5), 10.0);
        double newImageWidth = (double)IMAGE_WIDTH * this.zoomLevel;
        double newImageHeight = (double)IMAGE_HEIGHT * this.zoomLevel;
        this.imageOffsetX += mouseXInImage * (newImageWidth / imageWidth - 1.0);
        this.imageOffsetY += mouseYInImage * (newImageHeight / imageHeight - 1.0);
    }

    private int calculateMaxScrollOffset() {
        return (imageIds.size() / IMAGES_PER_ROW + 2) * (IMAGE_HEIGHT + GAP) - this.field_22790 + TOP_PADDING;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.commentWidget.method_25394(context, mouseX, mouseY, delta);
        if (isImageClicked && clickedImageIndex >= 0) {
            this.saveButton.field_22764 = true;
            this.openInAppButton.field_22764 = true;
            this.shareButton.field_22764 = true;
            WebGalleryScreen.likeButton.field_22764 = true;
            this.renderEnlargedImage(context);
            this.openInBrowserButton.field_22764 = false;
            this.commentWidget.field_22764 = true;
            this.sendCommentButton.field_22764 = true;
            this.searchField.field_22764 = false;
            this.serverStatsButton.field_22764 = false;
            this.viewTagsButton.field_22764 = true;
            boolean isAllowDelete = false;
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                isAllowDelete = metaDatas.get(clickedImageIndex).has("uuid") && metaDatas.get(clickedImageIndex).get("uuid").getAsString().equals(this.field_22787.field_1724.method_5667().toString());
            }
            this.deleteButton.field_22764 = ReceivePackets.allowDelete || ReceivePackets.allowDeleteOwn && isAllowDelete;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = false;
            });
        } else {
            this.saveButton.field_22764 = false;
            this.openInAppButton.field_22764 = false;
            this.shareButton.field_22764 = false;
            this.renderGallery(context, mouseX, mouseY);
            this.openInBrowserButton.field_22764 = true;
            this.commentWidget.field_22764 = false;
            this.sendCommentButton.field_22764 = false;
            WebGalleryScreen.likeButton.field_22764 = false;
            this.searchField.field_22764 = true;
            this.deleteButton.field_22764 = false;
            this.serverStatsButton.field_22764 = true;
            this.viewTagsButton.field_22764 = false;
            this.navigatorButtons.forEach(buttonWidget -> {
                buttonWidget.field_22764 = true;
            });
        }
        boolean isImageOverlappingButtons = clickedImageIndex >= 0 && this.isImageOverlappingButtons();
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185) || !this.buttonsToHideOnOverlap.contains(button)) continue;
            if (isImageClicked) {
                ((class_4185)button).field_22764 = !isImageOverlappingButtons;
                continue;
            }
            ((class_4185)button).field_22764 = false;
        }
    }

    private boolean isImageOverlappingButtons() {
        if (!isImageClicked || clickedImageIndex < 0) {
            return false;
        }
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        for (class_364 button : this.method_25396()) {
            if (button instanceof class_4185 && this.isButtonCoveredByImage((class_4185)button, x, y, imageWidth, imageHeight)) {
                return true;
            }
            if (!(button instanceof class_342) || !this.isTextFieldCoveredByImage((class_342)button, x, y, imageWidth, imageHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean isButtonCoveredByImage(class_4185 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private boolean isTextFieldCoveredByImage(class_342 button, int imageX, int imageY, int imageWidth, int imageHeight) {
        int buttonX = button.method_46426();
        int buttonY = button.method_46427();
        int buttonWidth = button.method_25368();
        int buttonHeight = button.method_25364();
        return buttonX + buttonWidth >= imageX && buttonX <= imageX + imageWidth && buttonY + buttonHeight >= imageY && buttonY <= imageY + imageHeight;
    }

    private void renderGallery(class_332 context, int mouseX, int mouseY) {
        int startX = (this.field_22789 - (IMAGES_PER_ROW * IMAGE_WIDTH + (IMAGES_PER_ROW - 1) * GAP)) / 2;
        int startY = TOP_PADDING + 20;
        for (int i = 0; i < imageIds.size(); ++i) {
            JsonObject metadata;
            int row = i / IMAGES_PER_ROW;
            int col = i % IMAGES_PER_ROW;
            int x = startX + col * (IMAGE_WIDTH + GAP);
            int y = startY + row * (IMAGE_HEIGHT + GAP) - this.scrollOffset;
            context.method_25294(x - 2, y - 2, x + IMAGE_WIDTH + 2, y + IMAGE_HEIGHT + 2, -7829368);
            class_2960 imageId = imageIds.get(i);
            context.method_25290(class_1921::method_62277, imageId, x, y, 0.0f, 0.0f, IMAGE_WIDTH, IMAGE_HEIGHT, IMAGE_WIDTH, IMAGE_HEIGHT);
            if (mouseX > x && mouseX < x + IMAGE_WIDTH && mouseY > y && mouseY < y + IMAGE_HEIGHT) {
                context.method_25294(x, y, x + IMAGE_WIDTH, y + IMAGE_HEIGHT, -2130706433);
            }
            String username = WebGalleryScreen.getString(i);
            if (this.field_22787 != null) {
                int textX = x + 5;
                int textY = y + IMAGE_HEIGHT - 10;
                int usernameWidth = this.field_22787.field_1772.method_1727(username);
                int padding = 2;
                Objects.requireNonNull(this.field_22787.field_1772);
                context.method_25294(textX - padding, textY - padding, textX + usernameWidth + padding, textY + 9 + padding, -1610612656);
                context.method_25294(textX - padding - 1, textY - padding - 1, textX + usernameWidth + padding + 1, textY - padding, -5592406);
                Objects.requireNonNull(this.field_22787.field_1772);
                Objects.requireNonNull(this.field_22787.field_1772);
                context.method_25294(textX - padding - 1, textY + 9 + padding, textX + usernameWidth + padding + 1, textY + 9 + padding + 1, -5592406);
                Objects.requireNonNull(this.field_22787.field_1772);
                context.method_25294(textX - padding - 1, textY - padding, textX - padding, textY + 9 + padding, -5592406);
                Objects.requireNonNull(this.field_22787.field_1772);
                context.method_25294(textX + usernameWidth + padding, textY - padding, textX + usernameWidth + padding + 1, textY + 9 + padding, -5592406);
                context.method_51433(this.field_22787.field_1772, username, textX, textY, 0xFFFFFF, false);
                if (metaDatas.size() > i && metaDatas.get(i).has("liked") && metaDatas.get(i).get("liked").getAsBoolean()) {
                    context.method_51433(this.field_22787.field_1772, "\u2764", textX + usernameWidth + 10, textY, 0xFFFFFF, false);
                }
                if (imagePaths.size() > i && newImagePaths.contains(imagePaths.get(i))) {
                    context.method_51433(this.field_22787.field_1772, "\u2605", textX + usernameWidth + 20, textY - this.starY, 0xFFFF00, false);
                }
            }
            if (i < metaDatas.size() && metaDatas.get(i) != null && (metadata = metaDatas.get(i)).has("tags") && metadata.get("tags").isJsonArray()) {
                JsonArray tags = metadata.getAsJsonArray("tags");
                if (this.field_22787 != null && !tags.isEmpty()) {
                    String firstTag = tags.get(0).getAsString();
                    int tagWidth = this.field_22787.field_1772.method_1727(firstTag);
                    int tagX = x + IMAGE_WIDTH - tagWidth - 5;
                    int tagY = y + IMAGE_HEIGHT - 12;
                    int padding = 2;
                    Objects.requireNonNull(this.field_22787.field_1772);
                    context.method_25294(tagX - padding, tagY - padding, tagX + tagWidth + padding, tagY + 9 + padding, -1605361664);
                    context.method_25294(tagX - padding - 1, tagY - padding - 1, tagX + tagWidth + padding + 1, tagY - padding, -2236963);
                    Objects.requireNonNull(this.field_22787.field_1772);
                    Objects.requireNonNull(this.field_22787.field_1772);
                    context.method_25294(tagX - padding - 1, tagY + 9 + padding, tagX + tagWidth + padding + 1, tagY + 9 + padding + 1, -2236963);
                    Objects.requireNonNull(this.field_22787.field_1772);
                    context.method_25294(tagX - padding - 1, tagY - padding, tagX - padding, tagY + 9 + padding, -2236963);
                    Objects.requireNonNull(this.field_22787.field_1772);
                    context.method_25294(tagX + tagWidth + padding, tagY - padding, tagX + tagWidth + padding + 1, tagY + 9 + padding, -2236963);
                    context.method_51433(this.field_22787.field_1772, firstTag, tagX + 1, tagY + 1, 0, false);
                    context.method_51433(this.field_22787.field_1772, firstTag, tagX, tagY, 0xFFFFFF, false);
                }
            }
            if (i >= metaDatas.size() || metaDatas.get(i) == null || !metaDatas.get(i).has("uuid")) continue;
            String playerHead = this.getPlayerHeadTexture(UUID.fromString(metaDatas.get(i).get("uuid").getAsString()));
            class_2960 playerHeadId = null;
            if (playerHead != null && !playerHead.isEmpty()) {
                playerHeadId = WebGalleryScreen.loadHeadImage(playerHead);
            }
            if (playerHeadId == null) continue;
            int headSize = 20;
            int headX = x + 5;
            int headY = y + 5;
            context.method_25290(class_1921::method_62277, playerHeadId, headX, headY, 0.0f, 0.0f, headSize, headSize, headSize, headSize);
        }
    }

    private static String getString(int i) {
        String username = "Unknown";
        if (metaDatas.size() > i && metaDatas.get(i) != null) {
            JsonObject metaData = metaDatas.get(i);
            if (metaData.has("username") && !metaData.get("username").isJsonNull()) {
                username = metaData.get("username").getAsString();
            } else if (metaData.has("fileUsername") && !metaData.get("fileUsername").isJsonNull()) {
                username = metaData.get("fileUsername").getAsString();
            }
        }
        return username;
    }

    private void renderEnlargedImage(class_332 context) {
        if (clickedImageIndex < 0 || clickedImageIndex >= imageIds.size()) {
            return;
        }
        class_2960 clickedImageId = imageIds.get(clickedImageIndex);
        newImagePaths.remove(imagePaths.get(clickedImageIndex));
        int imageWidth = (int)(1920.0 * this.zoomLevel);
        int imageHeight = (int)(1080.0 * this.zoomLevel);
        if (this.field_22787 != null) {
            imageWidth = (int)((double)this.field_22787.method_22683().method_4480() / 4.0 * this.zoomLevel);
            imageHeight = (int)((double)this.field_22787.method_22683().method_4507() / 4.0 * this.zoomLevel);
        }
        int x = (this.field_22789 - imageWidth) / 2 + (int)this.imageOffsetX;
        int y = (this.field_22790 - imageHeight) / 2 + (int)this.imageOffsetY;
        context.method_25294(0, 0, this.field_22789, this.field_22790, Integer.MIN_VALUE);
        int borderWidth = 5;
        context.method_25294(x - borderWidth, y - borderWidth, x + imageWidth + borderWidth, y + imageHeight + borderWidth, -1);
        context.method_25290(class_1921::method_62277, clickedImageId, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        int sidebarWidth = 300;
        int sidebarHeight = imageHeight;
        int sidebarXLeft = x - sidebarWidth;
        context.method_25294(sidebarXLeft, y, sidebarXLeft + sidebarWidth, y + sidebarHeight, -872415232);
        if (clickedImageIndex >= 0 && clickedImageIndex < metaDatas.size()) {
            LinkedHashMap<class_2561, class_2561> drawableInfo = this.getStringStringMap();
            int textXLeft = sidebarXLeft + 10;
            int textYLeft = y + 20;
            for (class_2561 info : drawableInfo.keySet()) {
                context.method_51439(this.field_22787.field_1772, (class_2561)info.method_27661().method_10852((class_2561)drawableInfo.get(info)), textXLeft, textYLeft, 0xFFFFFF, false);
                textYLeft += 10;
            }
        }
        int sidebarXRight = x + imageWidth;
        context.method_25294(sidebarXRight, y, sidebarXRight + sidebarWidth, y + sidebarHeight, Integer.MIN_VALUE);
        Map<String, UUID> comments = this.getComments(metaDatas.get(clickedImageIndex));
        int commentListY = y + 20;
        for (String comment : comments.keySet()) {
            String[] commentParts = comment.split(": ", 2);
            if (commentParts.length > 1) {
                String playerName = commentParts[0];
                String playerComment = commentParts[1];
                String playerHead = this.getPlayerHeadTexture(comments.get(comment));
                class_2960 playerHeadId = null;
                if (playerHead != null && !playerHead.isEmpty()) {
                    playerHeadId = WebGalleryScreen.loadHeadImage(playerHead);
                }
                int headSize = 20;
                int headX = sidebarXRight + 10;
                int headY = commentListY - 10;
                if (playerHeadId != null) {
                    context.method_25290(class_1921::method_62277, playerHeadId, (int)((double)headX + ((double)headSize - (double)headSize * 0.25) / 2.0), (int)((double)headY + ((double)headSize - (double)headSize * 0.25) / 2.0), 0.0f, 0.0f, (int)((double)headSize - (double)headSize * 0.25), (int)((double)headSize - (double)headSize * 0.25), (int)((double)headSize - (double)headSize * 0.25), (int)((double)headSize - (double)headSize * 0.25));
                }
                context.method_51439(this.field_22787.field_1772, (class_2561)class_2561.method_43470((String)(playerName + ": " + playerComment)), headX + headSize + 5, commentListY, 0xFFFFFF, false);
            }
            commentListY += 20;
        }
        int textFieldX = sidebarXRight + 10;
        int textFieldY = Math.min(commentListY + 10, y + imageHeight - 20 - 10);
        this.commentWidget.method_46421(textFieldX);
        this.commentWidget.method_46419(textFieldY);
        this.commentWidget.method_1880(200);
        this.commentWidget.method_1862(true);
        this.commentWidget.method_1888(true);
        this.sendCommentButton.method_46421(textFieldX + this.commentWidget.method_25368() + 5);
        this.sendCommentButton.method_46419(textFieldY);
        likeButton.method_25355((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.screenshot_gallery.like_screenshot").method_54663(metaDatas.get(clickedImageIndex).has("liked") && metaDatas.get(clickedImageIndex).get("liked").getAsBoolean() ? 0xFFFFFF : 0x2A2A2A));
    }

    private String getPlayerHeadTexture(UUID playerUUID) {
        try {
            Iterator textures;
            ProfileResult result = class_310.method_1551().method_1495().fetchProfile(playerUUID, false);
            if (result != null && result.profile() != null && result.profile().getProperties().containsKey((Object)"textures") && (textures = result.profile().getProperties().get((Object)"textures").iterator()).hasNext()) {
                String textureValue = ((Property)textures.next()).value();
                String decodedJson = new String(Base64.getDecoder().decode(textureValue));
                return decodedJson.split("\"url\" : \"")[1].split("\"")[0];
            }
        }
        catch (Exception e) {
            logger.error("Error while downloading player head image: {}", (Object)e.getMessage());
        }
        return "";
    }

    @NotNull
    private LinkedHashMap<class_2561, class_2561> getStringStringMap() {
        JsonObject metaData = metaDatas.get(clickedImageIndex);
        LinkedHashMap<class_2561, class_2561> drawableInfo = new LinkedHashMap<class_2561, class_2561>();
        if (metaData.has("username")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.username"), (class_2561)(metaData.has("username") && metaData.get("username").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("username").getAsString()) : (metaData.has("fileUsername") && metaData.get("fileUsername").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("fileUsername").getAsString()) : class_2561.method_43470((String)"N/A"))));
        }
        if (metaData.has("server_address")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.serverAddress"), (class_2561)(metaData.has("server_address") && metaData.get("server_address").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("server_address").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_name")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.world"), (class_2561)(metaData.has("world_name") && metaData.get("world_name").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_name").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("coordinates")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.location"), (class_2561)(metaData.has("coordinates") && metaData.get("coordinates").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("coordinates").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("facing_direction")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.facing"), (class_2561)(metaData.has("facing_direction") && metaData.get("facing_direction").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("facing_direction").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("player_state")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.playerState"), (class_2561)(metaData.has("player_state") && metaData.get("player_state").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("player_state").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("biome")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.biome"), (class_2561)(metaData.has("biome") && metaData.get("biome").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("biome").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_info")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.worldInfo"), (class_2561)(metaData.has("world_info") && metaData.get("world_info").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_info").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        if (metaData.has("world_seed")) {
            drawableInfo.put((class_2561)class_2561.method_43471((String)"gui.screenshot_uploader.metadata.seed"), (class_2561)(metaData.has("world_seed") && metaData.get("world_seed").isJsonPrimitive() ? class_2561.method_43470((String)metaData.get("world_seed").getAsString()) : class_2561.method_43470((String)"N/A")));
        }
        drawableInfo.put((class_2561)class_2561.method_43470((String)" "), (class_2561)class_2561.method_43470((String)" "));
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? WebGalleryScreen.getTimestamp(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? WebGalleryScreen.getTimestamp(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        if (metaData.has("current_time")) {
            drawableInfo.put((class_2561)(metaData.has("current_time") ? WebGalleryScreen.getTimeAgo(metaData.get("current_time").getAsLong()) : (metaData.has("date") ? WebGalleryScreen.getTimeAgo(metaData.get("date").getAsLong()) : class_2561.method_43470((String)"N/A"))), (class_2561)class_2561.method_43470((String)""));
        }
        return drawableInfo;
    }

    private Map<String, UUID> getComments(JsonObject metaData) {
        LinkedHashMap<String, UUID> commentList = new LinkedHashMap<String, UUID>();
        if (!metaData.has("comments")) {
            return commentList;
        }
        JsonArray comments = metaData.get("comments").getAsJsonArray();
        comments.forEach(comment -> {
            JsonObject commentObject = comment.getAsJsonObject();
            commentList.put(commentObject.get("author").getAsString() + ": " + commentObject.get("comment").getAsString(), commentObject.get("authorUUID") != null ? UUID.fromString(commentObject.get("authorUUID").getAsString()) : UUID.randomUUID());
        });
        return commentList;
    }

    private static void loadWebImage(String imageUrl) {
        block17: {
            String cacheFileName = "screenshots_cache/" + imageUrl.hashCode() + ".png";
            File cachedImage = new File(cacheFileName);
            if (cachedImage.exists()) {
                try {
                    class_1011 finalLoadedImage = class_1011.method_4309((InputStream)Files.newInputStream(cachedImage.toPath(), new OpenOption[0]));
                    class_310.method_1551().execute(() -> {
                        try {
                            class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                            if (class_310.method_1551() != null) {
                                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, finalLoadedImage));
                                imageIds.add(textureId);
                            } else {
                                logger.error("Failed to get client while loading web image!");
                                finalLoadedImage.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("Error while registering cached texture: {}", (Object)e.getMessage());
                            finalLoadedImage.close();
                        }
                    });
                }
                catch (IOException e) {
                    logger.error("Failed to load cached image: {}", (Object)e.getMessage());
                }
            } else {
                try {
                    URI uri = new URI(imageUrl);
                    URL url = uri.toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.connect();
                    if (connection.getResponseCode() == 200) {
                        try (InputStream inputStream = connection.getInputStream();){
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            if (bufferedImage != null) {
                                File cacheFolder = new File("screenshots_cache");
                                if (!cacheFolder.exists() && cacheFolder.mkdirs()) {
                                    logger.info("Created web screenshots cache folder for Screenshots");
                                }
                                ImageIO.write((RenderedImage)bufferedImage, "PNG", cachedImage);
                                logger.info("Image saved to cache: {}", (Object)cachedImage.getAbsolutePath());
                                try {
                                    class_1011 finalLoadedImage = class_1011.method_4309((InputStream)Files.newInputStream(cachedImage.toPath(), new OpenOption[0]));
                                    class_310.method_1551().execute(() -> {
                                        try {
                                            class_2960 textureId = class_2960.method_60655((String)"webimage", (String)("temp/" + imageUrl.hashCode()));
                                            if (class_310.method_1551() != null) {
                                                newImagePaths.add(imageUrl);
                                                class_310.method_1551().method_1531().method_4616(textureId, (class_1044)new class_1043(String::new, finalLoadedImage));
                                                imageIds.add(textureId);
                                            } else {
                                                logger.error("Failed to get client while saving the web image!");
                                                finalLoadedImage.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            logger.error("Error while registering texture: {}", (Object)e.getMessage());
                                            finalLoadedImage.close();
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    logger.error("Failed to load image from cache after saving: {}", (Object)e.getMessage());
                                }
                            }
                            break block17;
                        }
                    }
                    logger.error("Failed to load image from URL: {}", (Object)imageUrl);
                }
                catch (IOException | URISyntaxException e) {
                    logger.error("Failed to download web screenshots: {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static class_2960 loadHeadImage(String imageUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadScreenshotsFromServer(String server) {
        metaDatas.clear();
        imagePaths.clear();
        Set<String> likedScreenshots = WebGalleryScreen.loadLikedScreenshots();
        List<AbstractMap.SimpleEntry<String, JsonObject>> screenshotData = WebGalleryScreen.requestScreenshotListFromServer(server);
        screenshotData.sort(Comparator.comparing(entry -> likedScreenshots.contains(entry.getKey()) ? 0 : 1));
        screenshotData.forEach(entry -> {
            String url = (String)entry.getKey();
            JsonObject metaData = (JsonObject)entry.getValue();
            metaData.addProperty("liked", Boolean.valueOf(likedScreenshots.contains(url)));
            imagePaths.add(url);
            metaDatas.add(metaData);
            WebGalleryScreen.loadWebImage(url);
        });
    }

    private void loadScreenshotsSorted(SortOrder sortOrder, SortBy sortBy) {
        CompletableFuture.runAsync(() -> {
            List<AbstractMap.SimpleEntry<String, JsonObject>> entries = WebGalleryScreen.requestScreenshotListFromServer(this.webserverUrl);
            Set<String> likedScreenshotsSet = WebGalleryScreen.loadLikedScreenshots();
            entries.sort((entry1, entry2) -> {
                int result;
                if (sortBy == SortBy.DEFAULT) {
                    boolean liked1 = likedScreenshotsSet.contains(entry1.getKey());
                    boolean liked2 = likedScreenshotsSet.contains(entry2.getKey());
                    result = Boolean.compare(!liked1, !liked2);
                } else {
                    result = switch (sortBy.ordinal()) {
                        case 0 -> ((String)entry1.getKey()).compareTo((String)entry2.getKey());
                        case 1 -> {
                            long date1 = ((JsonObject)entry1.getValue()).get("date").getAsLong();
                            long date2 = ((JsonObject)entry2.getValue()).get("date").getAsLong();
                            yield Long.compare(date2, date1);
                        }
                        case 2 -> {
                            String player1 = ((JsonObject)entry1.getValue()).get("username") != null ? ((JsonObject)entry1.getValue()).get("username").getAsString() : ((JsonObject)entry1.getValue()).get("fileUsername").getAsString();
                            String player2 = ((JsonObject)entry2.getValue()).get("username") != null ? ((JsonObject)entry2.getValue()).get("username").getAsString() : ((JsonObject)entry2.getValue()).get("fileUsername").getAsString();
                            yield player1.compareTo(player2);
                        }
                        case 4 -> {
                            String dimension1 = ((JsonObject)entry1.getValue()).get("world_name") != null ? ((JsonObject)entry1.getValue()).get("world_name").getAsString() : "N/A";
                            String dimension2 = ((JsonObject)entry2.getValue()).get("world_name") != null ? ((JsonObject)entry2.getValue()).get("world_name").getAsString() : "N/A";
                            yield dimension1.compareTo(dimension2);
                        }
                        case 5 -> {
                            String biome1 = ((JsonObject)entry1.getValue()).get("biome") != null ? ((JsonObject)entry1.getValue()).get("biome").getAsString() : "N/A";
                            String biome2 = ((JsonObject)entry2.getValue()).get("biome") != null ? ((JsonObject)entry2.getValue()).get("biome").getAsString() : "N/A";
                            yield biome1.compareTo(biome2);
                        }
                        case 6 -> {
                            if (((JsonObject)entry1.getValue()).get("coordinates") == null || ((JsonObject)entry2.getValue()).get("coordinates") == null) {
                                yield 0;
                            }
                            String[] pos1 = ((JsonObject)entry1.getValue()).get("coordinates").getAsString().split(", ");
                            String[] pos2 = ((JsonObject)entry2.getValue()).get("coordinates").getAsString().split(", ");
                            int x1 = Integer.parseInt(pos1[0].split(": ")[1]);
                            int y1 = Integer.parseInt(pos1[1].split(": ")[1]);
                            int z1 = Integer.parseInt(pos1[2].split(": ")[1]);
                            int x2 = Integer.parseInt(pos2[0].split(": ")[1]);
                            int y2 = Integer.parseInt(pos2[1].split(": ")[1]);
                            int z2 = Integer.parseInt(pos2[2].split(": ")[1]);
                            class_2338 pos1Block = new class_2338(x1, y1, z1);
                            class_2338 pos2Block = new class_2338(x2, y2, z2);
                            yield pos1Block.method_10265((class_2382)pos2Block);
                        }
                        default -> 0;
                    };
                }
                return sortOrder == SortOrder.ASCENDING ? result : -result;
            });
            class_310.method_1551().execute(() -> {
                imageIds.clear();
                imagePaths.clear();
                metaDatas.clear();
                for (AbstractMap.SimpleEntry entry : entries) {
                    imagePaths.add((String)entry.getKey());
                    metaDatas.add((JsonObject)entry.getValue());
                    WebGalleryScreen.loadWebImage((String)entry.getKey());
                }
            });
        }).exceptionally(e -> {
            logger.error("Error loading sorted screenshots: {}", (Object)e.getMessage());
            return null;
        });
    }

    private static List<AbstractMap.SimpleEntry<String, JsonObject>> requestScreenshotListFromServer(String server) {
        ArrayList<AbstractMap.SimpleEntry<String, JsonObject>> screenshotData = new ArrayList<AbstractMap.SimpleEntry<String, JsonObject>>();
        try {
            URI uri = new URI(server);
            URL url = uri.toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 Minecraft Screenshot Uploader");
            int status = connection.getResponseCode();
            if (status == 200) {
                String line;
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                JsonArray jsonArray = JsonParser.parseString((String)response.toString()).getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject screenshot = jsonArray.get(i).getAsJsonObject();
                    String urlStr = screenshot.get("url").getAsString();
                    JsonObject metaData = screenshot.get("metaData").isJsonObject() ? screenshot.get("metaData").getAsJsonObject() : new JsonObject();
                    metaData.add("fileUsername", screenshot.get("username"));
                    metaData.add("date", screenshot.get("date"));
                    screenshotData.add(new AbstractMap.SimpleEntry<String, JsonObject>(urlStr, metaData));
                }
            } else {
                logger.error("Failed to fetch data. HTTP Status: {}", (Object)status);
            }
        }
        catch (Exception e) {
            logger.error("Failed to request screenshot list: {}", (Object)e.getMessage());
        }
        return screenshotData;
    }

    private static Set<String> loadLikedScreenshots() {
        HashSet<String> likedScreenshots = new HashSet<String>();
        File file = new File(FILE_PATH);
        if (file.exists() && file.length() > 0L) {
            try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
                JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject obj = element.getAsJsonObject();
                    if (!obj.has("screenshotUrl")) continue;
                    likedScreenshots.add(obj.get("screenshotUrl").getAsString());
                }
            }
            catch (JsonSyntaxException e) {
                logger.error("Corrupt JSON file detected. Resetting it.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error reading the like file.", (Throwable)e);
            }
        }
        return likedScreenshots;
    }

    private void downloadImage() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            try {
                URI imageUri = new URI(imagePaths.get(clickedImageIndex));
                URL imageUrl = imageUri.toURL();
                Path savePath = Paths.get(System.getProperty("user.home"), "Desktop", "Downloaded_" + String.valueOf(Paths.get(imageUri.getPath(), new String[0]).getFileName()));
                try (InputStream inputStream = imageUrl.openStream();){
                    Files.copy(inputStream, savePath, new CopyOption[0]);
                    logger.info("Image downloaded to: {}", (Object)savePath);
                }
            }
            catch (Exception e) {
                logger.error("Failed to download image: {}", (Object)e.getMessage());
            }
        } else {
            logger.warn("Invalid image while downloading index: {}", (Object)clickedImageIndex);
        }
    }

    private void openInBrowser() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imagePaths.size()) {
            String os = System.getProperty("os.name").toLowerCase();
            String url = imagePaths.get(clickedImageIndex);
            try {
                ProcessBuilder processBuilder;
                if (os.contains("win")) {
                    processBuilder = new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url);
                } else if (os.contains("mac")) {
                    processBuilder = new ProcessBuilder("open", url);
                } else if (os.contains("nix") || os.contains("nux")) {
                    processBuilder = new ProcessBuilder("xdg-open", url);
                } else {
                    logger.error("Unsupported operating system for opening the image URL.");
                    return;
                }
                processBuilder.start();
            }
            catch (IOException e) {
                logger.error("Failed to open the image URL {}: {}", (Object)url, (Object)e.getMessage());
            }
        } else {
            logger.warn("Invalid image index while opening: {}", (Object)clickedImageIndex);
        }
    }

    private void sendComment() {
        String comment = this.commentWidget.method_1882();
        String screenshot = imagePaths.get(clickedImageIndex);
        int lastSlash = screenshot.lastIndexOf("/");
        String string = screenshot = lastSlash != -1 ? screenshot.substring(lastSlash + 1) : null;
        if (comment != null && !comment.isEmpty() && screenshot != null && !screenshot.isEmpty()) {
            if (ReceivePackets.commentSiteAddress == null || ReceivePackets.commentSiteAddress.isEmpty()) {
                ClientPlayNetworking.send((class_8710)new CommentPayload(comment, screenshot));
                this.commentWidget.method_1852("");
                this.performSearch(this.lastSearchQuery);
            } else {
                try {
                    int responseCode = WebGalleryScreen.getCommentResponse(comment, screenshot);
                    if (responseCode == 200) {
                        this.commentWidget.method_1852("");
                        this.performSearch(this.lastSearchQuery);
                    } else {
                        logger.error("Failed to send comment. Response code: {}", (Object)responseCode);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while sending comment: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static int getCommentResponse(String comment, String screenshot) throws URISyntaxException, IOException {
        URI uri = new URI(ReceivePackets.commentSiteAddress);
        URL url = uri.toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        JsonObject commentJson = new JsonObject();
        commentJson.addProperty("comment", comment);
        commentJson.addProperty("screenshot", screenshot);
        commentJson.addProperty("author", class_310.method_1551().method_1548().method_1676());
        commentJson.addProperty("authorUUID", class_310.method_1551().method_1548().method_44717().toString());
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = commentJson.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        return connection.getResponseCode();
    }

    private void deleteScreenshot() {
        if (clickedImageIndex >= 0 && clickedImageIndex < imageIds.size()) {
            String screenshotId = String.valueOf(imagePaths.get(clickedImageIndex));
            if (ReceivePackets.deletionSiteAddress == null || ReceivePackets.deletionSiteAddress.isEmpty()) {
                ClientPlayNetworking.send((class_8710)new DeletionPacket(screenshotId));
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(null);
                }
            } else {
                try {
                    int responseCode = WebGalleryScreen.getDeletionResponse(screenshotId);
                    if (responseCode == 200) {
                        imageIds.remove(clickedImageIndex);
                        imagePaths.remove(clickedImageIndex);
                        metaDatas.remove(clickedImageIndex);
                        clickedImageIndex = -1;
                        this.scrollOffset = 0;
                        this.performSearch(this.lastSearchQuery);
                    } else {
                        logger.error("Failed to delete screenshot. Response code: {}", (Object)responseCode);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while deleting screenshot: {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static int getDeletionResponse(String screenshotId) throws URISyntaxException, IOException {
        URI uri = new URI(ReceivePackets.deletionSiteAddress);
        URL url = uri.toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        JsonObject deletionJson = new JsonObject();
        deletionJson.addProperty("screenshotId", screenshotId);
        deletionJson.addProperty("author", class_310.method_1551().method_1548().method_1676());
        deletionJson.addProperty("authorUUID", class_310.method_1551().method_1548().method_44717().toString());
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = deletionJson.toString().getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        return connection.getResponseCode();
    }

    public static class_2561 getTimestamp(long millis) {
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        LocalDateTime timestampDateTime = LocalDateTime.ofInstant(timestampInstant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return class_2561.method_43470((String)timestampDateTime.format(formatter)).method_27694(style -> style.method_30938(Boolean.valueOf(true)));
    }

    private static class_2561 getTimeAgo(long millis) {
        Instant nowInstant;
        Instant timestampInstant = Instant.ofEpochMilli(millis);
        Duration duration = Duration.between(timestampInstant, nowInstant = Instant.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.seconds_ago", (Object[])new Object[]{seconds}).method_27693(")"));
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.minutes_ago", (Object[])new Object[]{minutes}).method_27693(")"));
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            long minutes = seconds % 3600L / 60L;
            return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.hours_ago", (Object[])new Object[]{hours, minutes}).method_27693(")"));
        }
        long days = seconds / 86400L;
        return class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43469((String)"message.screenshot_uploader.days_ago", (Object[])new Object[]{days}).method_27693(")"));
    }

    private void performSearch(String query) {
        if (query.equals(this.lastSearchQuery)) {
            return;
        }
        this.lastSearchQuery = query;
        if (query.isEmpty()) {
            imageIds.clear();
            metaDatas.clear();
            imagePaths.clear();
            WebGalleryScreen.loadScreenshotsFromServer(this.webserverUrl);
            return;
        }
        List<SearchTerm> searchTerms = this.parseSearchTerms(query);
        this.asyncSortFuture = CompletableFuture.runAsync(() -> {
            ArrayList<String> matchingPaths = new ArrayList<String>();
            ArrayList<JsonObject> matchingMetadata = new ArrayList<JsonObject>();
            ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
            for (int i = 0; i < metaDatas.size(); ++i) {
                JsonObject metaData = metaDatas.get(i);
                String path = imagePaths.get(i);
                boolean matchesAllTerms = true;
                for (SearchTerm term : searchTerms) {
                    if (this.matchesTerm(metaData, term)) continue;
                    matchesAllTerms = false;
                    break;
                }
                if (!matchesAllTerms) continue;
                matchingPaths.add(path);
                matchingMetadata.add(metaData);
                matchingIndices.add(i);
            }
            class_310.method_1551().execute(() -> {
                ArrayList<class_2960> newImageIds = new ArrayList<class_2960>();
                for (Integer index : matchingIndices) {
                    if (index >= imageIds.size()) continue;
                    newImageIds.add(imageIds.get(index));
                }
                imageIds.clear();
                imageIds.addAll(newImageIds);
                imagePaths.clear();
                imagePaths.addAll(matchingPaths);
                metaDatas.clear();
                metaDatas.addAll(matchingMetadata);
                this.scrollOffset = 0;
            });
        });
    }

    private List<SearchTerm> parseSearchTerms(String query) {
        String[] terms;
        ArrayList<SearchTerm> searchTerms = new ArrayList<SearchTerm>();
        Map<String, String> fieldMappings = WebGalleryScreen.getSearchFieldTerms();
        for (String term : terms = query.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
            if ((term = term.trim()).isEmpty()) continue;
            String fieldName = null;
            String fieldValue = term.toLowerCase();
            for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
                if (!term.toLowerCase().startsWith(entry.getKey())) continue;
                fieldName = entry.getValue();
                fieldValue = term.substring(entry.getKey().length()).trim().toLowerCase();
                break;
            }
            searchTerms.add(new SearchTerm(fieldName, fieldValue));
        }
        return searchTerms;
    }

    private boolean matchesTerm(JsonObject metaData, SearchTerm term) {
        String searchFieldName = term.fieldName;
        String searchFieldValue = term.fieldValue;
        String operator = this.extractComparisonOperator(searchFieldValue);
        String actualValue = searchFieldValue;
        if (!operator.isEmpty()) {
            actualValue = searchFieldValue.substring(operator.length()).trim();
        }
        if (searchFieldName == null) {
            for (Map.Entry field : metaData.entrySet()) {
                if (!((JsonElement)field.getValue()).isJsonPrimitive() || !((JsonElement)field.getValue()).getAsString().toLowerCase().contains(actualValue)) continue;
                return true;
            }
            return false;
        }
        if (searchFieldName.equals("date")) {
            if (metaData.has("current_time") && metaData.get("current_time").isJsonPrimitive()) {
                return this.compareDate(metaData.get("current_time").getAsLong(), operator, actualValue);
            }
            if (metaData.has("date") && metaData.get("date").isJsonPrimitive()) {
                return this.compareDate(metaData.get("date").getAsLong(), operator, actualValue);
            }
            return false;
        }
        if (metaData.has(searchFieldName) && metaData.get(searchFieldName).isJsonPrimitive()) {
            String fieldValue = metaData.get(searchFieldName).getAsString().toLowerCase();
            if (operator.isEmpty()) {
                return fieldValue.contains(actualValue);
            }
            return this.compareValues(fieldValue, operator, actualValue);
        }
        switch (searchFieldName) {
            case "health": 
            case "food": 
            case "air": 
            case "speed": {
                if (!metaData.has("player_state") || !metaData.get("player_state").isJsonPrimitive()) break;
                String playerState = metaData.get("player_state").getAsString().toLowerCase();
                return this.matchesNestedField(playerState, searchFieldName, operator, actualValue);
            }
            case "time": 
            case "weather": 
            case "difficulty": {
                if (!metaData.has("world_info") || !metaData.get("world_info").isJsonPrimitive()) break;
                String worldInfo = metaData.get("world_info").getAsString().toLowerCase();
                return this.matchesNestedField(worldInfo, searchFieldName, operator, actualValue);
            }
            case "x": 
            case "y": 
            case "z": {
                if (!metaData.has("coordinates") || !metaData.get("coordinates").isJsonPrimitive()) break;
                String coordinates = metaData.get("coordinates").getAsString().toLowerCase();
                return this.matchesNestedField(coordinates, searchFieldName, operator, actualValue);
            }
        }
        return false;
    }

    private String extractComparisonOperator(String searchValue) {
        if ((searchValue = searchValue.trim()).startsWith(">=") || searchValue.startsWith("<=")) {
            return searchValue.substring(0, 2);
        }
        if (searchValue.startsWith(">") || searchValue.startsWith("<") || searchValue.startsWith("=")) {
            return searchValue.substring(0, 1);
        }
        return "";
    }

    private boolean matchesNestedField(String fieldString, String subFieldName, String operator, String searchValue) {
        String pattern = subFieldName + ": ";
        int pos = fieldString.indexOf(pattern);
        if (pos == -1) {
            pattern = subFieldName + ":";
            pos = fieldString.indexOf(pattern);
        }
        if (pos != -1) {
            int valueStart = pos + pattern.length();
            int valueEnd = fieldString.indexOf(44, valueStart);
            if (valueEnd == -1) {
                valueEnd = fieldString.length();
            }
            String extractedValue = fieldString.substring(valueStart, valueEnd).trim();
            if (operator.isEmpty()) {
                return extractedValue.contains(searchValue);
            }
            return this.compareValues(extractedValue, operator, searchValue);
        }
        return false;
    }

    private boolean compareDate(long timestamp, String operator, String searchValue) {
        LocalDate screenshotDate = Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDate();
        try {
            if (searchValue.equals("today")) {
                LocalDate today = LocalDate.now();
                return this.compareDateWithOperator(screenshotDate, operator, today);
            }
            if (searchValue.equals("yesterday")) {
                LocalDate yesterday = LocalDate.now().minusDays(1L);
                return this.compareDateWithOperator(screenshotDate, operator, yesterday);
            }
            if (searchValue.contains("week")) {
                LocalDate aWeekAgo = LocalDate.now().minusWeeks(1L);
                if (operator.isEmpty()) {
                    return !screenshotDate.isBefore(aWeekAgo);
                }
                return this.compareDateWithOperator(screenshotDate, operator, aWeekAgo);
            }
            if (searchValue.contains("month")) {
                LocalDate aMonthAgo = LocalDate.now().minusMonths(1L);
                if (operator.isEmpty()) {
                    return !screenshotDate.isBefore(aMonthAgo);
                }
                return this.compareDateWithOperator(screenshotDate, operator, aMonthAgo);
            }
            LocalDate searchDate = null;
            if (searchValue.matches("\\d{1,2}\\.\\d{1,2}\\.\\d{4}")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
                searchDate = LocalDate.parse(searchValue, formatter);
            } else if (searchValue.matches("\\d{1,2}\\.\\d{4}")) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM.yyyy");
                YearMonth queryYearMonth = YearMonth.parse(searchValue, formatter);
                searchDate = queryYearMonth.atDay(1);
            } else if (searchValue.matches("\\d{4}")) {
                int year = Integer.parseInt(searchValue);
                searchDate = LocalDate.of(year, 1, 1);
            }
            if (searchDate != null) {
                return this.compareDateWithOperator(screenshotDate, operator, searchDate);
            }
        }
        catch (Exception searchDate) {
            // empty catch block
        }
        String formattedDate = screenshotDate.format(DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        return formattedDate.contains(searchValue);
    }

    private boolean compareDateWithOperator(LocalDate screenshotDate, String operator, LocalDate referenceDate) {
        return switch (operator) {
            case ">" -> screenshotDate.isAfter(referenceDate);
            case "<" -> screenshotDate.isBefore(referenceDate);
            case ">=" -> {
                if (screenshotDate.isAfter(referenceDate) || screenshotDate.isEqual(referenceDate)) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (screenshotDate.isBefore(referenceDate) || screenshotDate.isEqual(referenceDate)) {
                    yield true;
                }
                yield false;
            }
            default -> screenshotDate.isEqual(referenceDate);
        };
    }

    private boolean compareValues(String fieldValue, String operator, String searchValue) {
        try {
            double fieldNumeric = Double.parseDouble(fieldValue.replaceAll("[^0-9.-]", ""));
            double searchNumeric = Double.parseDouble(searchValue.replaceAll("[^0-9.-]", ""));
            return switch (operator) {
                case ">" -> {
                    if (fieldNumeric > searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (fieldNumeric < searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (fieldNumeric >= searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (fieldNumeric <= searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                case "=" -> {
                    if (fieldNumeric == searchNumeric) {
                        yield true;
                    }
                    yield false;
                }
                default -> fieldValue.contains(searchValue);
            };
        }
        catch (NumberFormatException e) {
            return fieldValue.contains(searchValue);
        }
    }

    @NotNull
    private static Map<String, String> getSearchFieldTerms() {
        HashMap<String, String> fieldMappings = new HashMap<String, String>();
        fieldMappings.put("seed:", "world_seed");
        fieldMappings.put("biome:", "biome");
        fieldMappings.put("world:", "world_name");
        fieldMappings.put("server:", "server_address");
        fieldMappings.put("username:", "username");
        fieldMappings.put("coordinates:", "coordinates");
        fieldMappings.put("location:", "coordinates");
        fieldMappings.put("facing:", "facing_direction");
        fieldMappings.put("player:", "player_state");
        fieldMappings.put("date:", "date");
        fieldMappings.put("day:", "date");
        fieldMappings.put("time:", "date");
        fieldMappings.put("health:", "health");
        fieldMappings.put("food:", "food");
        fieldMappings.put("air:", "air");
        fieldMappings.put("speed:", "speed");
        fieldMappings.put("worldtime:", "time");
        fieldMappings.put("weather:", "weather");
        fieldMappings.put("difficulty:", "difficulty");
        fieldMappings.put("x:", "x");
        fieldMappings.put("y:", "y");
        fieldMappings.put("z:", "z");
        return fieldMappings;
    }

    public void method_25410(class_310 client, int width, int height) {
        client.method_1507(null);
        super.method_25410(client, width, height);
    }

    public void method_25419() {
        if (isImageClicked) {
            isImageClicked = false;
            clickedImageIndex = -1;
        } else if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
        if (this.asyncSortFuture != null && !this.asyncSortFuture.isDone()) {
            this.asyncSortFuture.cancel(true);
        }
        imageIds.clear();
        imagePaths.clear();
        metaDatas.clear();
        this.lastSearchQuery = "";
        super.method_25419();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_25370() && this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 70 && (modifiers & 2) != 0) {
            this.searchField.method_25365(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        if (this.goingUp) {
            this.starY += 4;
            if (this.starY >= 12) {
                this.goingUp = false;
            }
        } else {
            this.starY -= 4;
            if (this.starY <= 0) {
                this.goingUp = true;
            }
        }
    }

    private static enum SortBy {
        NAME,
        DATE,
        PLAYER,
        DEFAULT,
        DIMENSION,
        BIOME,
        POSITION;

    }

    private static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }

    private record SearchTerm(String fieldName, String fieldValue) {
    }
}

