/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.util;

import com.google.gson.Gson;
import de.thecoolcraft11.ScreenshotData;
import de.thecoolcraft11.config.ConfigManager;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Unique;

public class ScreenshotDataHelper {
    public static String getJSONData(class_310 client) {
        boolean sendWorldData = ConfigManager.getClientConfig().sendWorldData;
        boolean sendSystemData = ConfigManager.getClientConfig().sendSystemInfo;
        String username = client.method_1548().method_1676();
        String uuid = String.valueOf(client.method_1548().method_44717());
        String accountType = String.valueOf(client.method_1548().method_35718());
        String worldName = sendWorldData ? ScreenshotDataHelper.getWorldName(client) : "N/A";
        String seed = sendWorldData ? ScreenshotDataHelper.getWorldSeed(client) : "N/A";
        String coordinates = sendWorldData ? ScreenshotDataHelper.getPlayerCoordinates(client) : "N/A";
        String biome = sendWorldData ? ScreenshotDataHelper.getPlayerBiome(client) : "N/A";
        String facingDirection = sendWorldData ? ScreenshotDataHelper.getPlayerFacingDirection(client) : "N/A";
        String dimension = sendWorldData ? ScreenshotDataHelper.getCurrentDimension(client) : "N/A";
        String playerState = sendWorldData ? ScreenshotDataHelper.getPlayerState(client) : "N/A";
        String chunkInfo = sendWorldData ? ScreenshotDataHelper.getChunkInfo(client) : "N/A";
        String entitiesInfo = sendWorldData ? ScreenshotDataHelper.getEntitiesInfo(client) : "N/A";
        String worldInfo = sendWorldData ? ScreenshotDataHelper.getWorldInfo(client) : "N/A";
        String serverAddress = sendWorldData ? ScreenshotDataHelper.getServerAddress(client) : "N/A";
        String clientSettings = sendWorldData ? ScreenshotDataHelper.getClientSettings(client) : "N/A";
        String systemInfo = sendSystemData ? ScreenshotDataHelper.getSystemInfo() : "N/A";
        String currentTime = "" + System.currentTimeMillis();
        ScreenshotData data = new ScreenshotData(username, uuid, accountType, worldName, seed, coordinates, biome, facingDirection, dimension, playerState, chunkInfo, entitiesInfo, worldInfo, serverAddress, clientSettings, systemInfo, currentTime);
        return ScreenshotDataHelper.serializeToJson(data);
    }

    @Unique
    private static String getWorldName(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown World";
    }

    @Unique
    private static String getWorldSeed(class_310 client) {
        if (client.method_1576() != null) {
            return String.valueOf(client.method_1576().method_30002().method_8412());
        }
        return "Unknown Seed";
    }

    @Unique
    private static String getPlayerCoordinates(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            return String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return "Unknown Coordinates";
    }

    @Unique
    private static String getPlayerBiome(class_310 client) {
        if (client.field_1687 != null && client.field_1724 != null) {
            class_6880 biomeEntry = client.field_1687.method_23753(client.field_1724.method_24515());
            String biomeName = biomeEntry.method_55840();
            Object formattedName = biomeName.split(":")[1];
            formattedName = ((String)formattedName).replace("_", " ");
            formattedName = ((String)formattedName).substring(0, 1).toUpperCase() + ((String)formattedName).substring(1);
            return formattedName;
        }
        return "Unknown Biome";
    }

    @Unique
    private static String getPlayerFacingDirection(class_310 client) {
        if (client.field_1724 != null) {
            class_2350 direction = client.field_1724.method_5735();
            return direction.method_15434();
        }
        return "Unknown Direction";
    }

    @Unique
    private static String getCurrentDimension(class_310 client) {
        return client.field_1687 != null ? client.field_1687.method_27983().method_29177().toString() : "Unknown Dimension";
    }

    @Unique
    private static String getPlayerState(class_310 client) {
        if (client.field_1724 != null) {
            return String.format("Speed: %.2f b/s, Health: %.2f, Food: %d, Air: %d", client.field_1724.method_18798().method_1033() * 20.0, Float.valueOf(client.field_1724.method_6032()), client.field_1724.method_7344().method_7586() / 2, client.field_1724.method_5669());
        }
        return "Unknown State";
    }

    @Unique
    private static String getChunkInfo(class_310 client) {
        if (client.field_1724 != null) {
            class_2338 pos = client.field_1724.method_24515();
            int chunkX = pos.method_10263() >> 4;
            int chunkZ = pos.method_10260() >> 4;
            return String.format("Chunk: [%d, %d]", chunkX, chunkZ);
        }
        return "Unknown Chunk Info";
    }

    @Unique
    private static String getEntitiesInfo(class_310 client) {
        if (client.field_1687 != null) {
            Iterable entities = client.field_1687.method_18112();
            int entityCount = 0;
            for (class_1297 ignored : entities) {
                ++entityCount;
            }
            return String.format("Loaded Entities: %d", entityCount);
        }
        return "No Entity Info";
    }

    @Unique
    private static String getWorldInfo(class_310 client) {
        if (client.field_1687 != null) {
            class_638.class_5271 properties = client.field_1687.method_28104();
            return String.format("Time: %s, Weather: %s, Difficulty: %s", ScreenshotDataHelper.convertMinecraftTimeToHumanReadable(properties.method_217()), client.field_1687.method_8419() ? "Raining" : "Clear", client.field_1687.method_8407().method_5460());
        }
        return "No World Info";
    }

    @Unique
    private static String convertMinecraftTimeToHumanReadable(long ticks) {
        int hours = (int)((ticks / 1000L + 6L) % 24L);
        int minutes = (int)(ticks % 1000L * 60L / 1000L);
        return String.format("%02d:%02d", hours, minutes);
    }

    @Unique
    private static String getServerAddress(class_310 client) {
        String singlePlayerWorldName;
        class_642 serverInfo = client.method_1558();
        String string = singlePlayerWorldName = client.method_1576() != null ? client.method_1576().method_27728().method_150() : "Singleplayer";
        return !client.method_1542() ? (serverInfo != null ? serverInfo.field_3761 : "Unknown Server") : singlePlayerWorldName;
    }

    @Unique
    private static String getClientSettings(class_310 client) {
        return String.format("Graphics: %s, V-Sync: %b, Fullscreen: %b, Language: %s, FPS: %d / %d, Render Distance: %d", client.field_1690.method_42534().method_41753(), client.field_1690.method_42433().method_41753(), client.field_1690.method_42447(), client.method_1526().method_4669(), client.method_47599(), client.field_1690.method_42524().method_41753(), client.field_1690.method_42503().method_41753());
    }

    @Unique
    private static String getSystemInfo() {
        return String.format("OS: %s %s (%s), Java: %s, Version: %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version"), ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString());
    }

    @Unique
    private static String serializeToJson(ScreenshotData data) {
        Gson gson = new Gson();
        return gson.toJson((Object)data);
    }
}

