/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.util;

import com.google.gson.JsonObject;
import de.thecoolcraft11.packet.ScreenshotChunkPayload;
import de.thecoolcraft11.packet.ScreenshotPayload;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1011;
import net.minecraft.class_8710;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotUploadHelper {
    private static final Logger logger = LoggerFactory.getLogger(ScreenshotUploadHelper.class);

    public static List<JsonObject> uploadScreenshot(class_1011 nativeImage, String jsonData, List<String> uploadUrls) {
        File tempFile;
        ArrayList<JsonObject> resultList = new ArrayList<JsonObject>();
        try {
            tempFile = File.createTempFile("screenshot", ".png");
            nativeImage.method_4325(tempFile);
        }
        catch (IOException e) {
            JsonObject result = new JsonObject();
            logger.error("Failed to create temporary file for screenshot", (Throwable)e);
            result.addProperty("status", "error");
            result.addProperty("message", "Failed to create temporary file.");
            resultList.add(result);
            return resultList;
        }
        for (String uploadUrl : uploadUrls) {
            if (uploadUrl.contains("mcserver://this")) {
                ScreenshotUploadHelper.sendScreenshotPacket(tempFile, jsonData, false);
                continue;
            }
            if (uploadUrl.contains("mcserver://chunked")) {
                ScreenshotUploadHelper.sendScreenshotPacket(tempFile, jsonData, true);
                continue;
            }
            JsonObject result = ScreenshotUploadHelper.uploadToUrl(tempFile, jsonData, uploadUrl.equals("true") ? "http://localhost:4567/upload" : uploadUrl);
            resultList.add(result);
        }
        if (tempFile.exists() && !tempFile.delete()) {
            logger.warn("Failed to delete temporary file: {}", (Object)tempFile.getAbsolutePath());
        }
        return resultList;
    }

    private static JsonObject uploadToUrl(File tempFile, String jsonData, String uploadUrl) {
        JsonObject result = new JsonObject();
        try {
            String boundary = Long.toHexString(System.currentTimeMillis());
            String CRLF = "\r\n";
            URI uploadUri = URI.create(uploadUrl);
            HttpURLConnection conn = (HttpURLConnection)uploadUri.toURL().openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream os = conn.getOutputStream();
                 PrintWriter writer = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
                writer.append(String.format("--%s", boundary)).append(CRLF);
                writer.append(String.format("Content-Disposition: form-data; name=\"file\"; filename=\"%s\"", tempFile.getName())).append(CRLF);
                writer.append(String.format("Content-Type: %s", HttpURLConnection.guessContentTypeFromName(tempFile.getName()))).append(CRLF);
                writer.append(CRLF).flush();
                try (FileInputStream fis = new FileInputStream(tempFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
                os.flush();
                writer.append(CRLF).flush();
                writer.append(String.format("--%s", boundary)).append(CRLF);
                writer.append("Content-Disposition: form-data; name=\"jsonData\"").append(CRLF);
                writer.append("Content-Type: application/json").append(CRLF);
                writer.append(CRLF).flush();
                writer.append(jsonData).flush();
                writer.append(CRLF).flush();
                writer.append(String.format("--%s--", boundary)).append(CRLF).flush();
            }
            int responseCode = conn.getResponseCode();
            String responseMessage = conn.getResponseMessage();
            if (responseCode == 200) {
                InputStream responseStream = conn.getInputStream();
                String responseBody = new BufferedReader(new InputStreamReader(responseStream)).lines().reduce("", (acc, line) -> acc + line);
                result.addProperty("status", "success");
                result.addProperty("responseCode", (Number)responseCode);
                result.addProperty("responseBody", responseBody);
            } else {
                result.addProperty("status", "error");
                result.addProperty("responseCode", (Number)responseCode);
                result.addProperty("message", responseMessage);
            }
        }
        catch (IOException e) {
            logger.error("IOException occurred while uploading screenshot to {}: {}", (Object)uploadUrl, (Object)e.getMessage());
            result.addProperty("status", "error");
            result.addProperty("message", e.getMessage());
        }
        return result;
    }

    public static void sendScreenshotPacket(File tempFile, String json, boolean useChunking) {
        try {
            BufferedImage originalImage = ImageIO.read(tempFile);
            if (originalImage.getColorModel().hasAlpha()) {
                BufferedImage rgbImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 1);
                Graphics2D graphics = rgbImage.createGraphics();
                graphics.setColor(Color.WHITE);
                graphics.fillRect(0, 0, originalImage.getWidth(), originalImage.getHeight());
                graphics.drawImage((Image)originalImage, 0, 0, null);
                graphics.dispose();
                originalImage = rgbImage;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(0.7f);
            writer.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            writer.write(null, new IIOImage(originalImage, null, null), param);
            writer.dispose();
            byte[] compressedImageBytes = byteArrayOutputStream.toByteArray();
            if (useChunking) {
                ScreenshotUploadHelper.sendChunkedScreenshotPacket(compressedImageBytes, json);
            } else {
                ClientPlayNetworking.send((class_8710)new ScreenshotPayload(compressedImageBytes, json));
            }
            logger.info("Screenshot sent to server: {} bytes using {} mode", (Object)compressedImageBytes.length, (Object)(useChunking ? "chunked" : "legacy"));
            if (!tempFile.delete()) {
                logger.warn("Failed to delete temporary file while sending packet: {}", (Object)tempFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compress and send screenshot", e);
        }
    }

    private static void sendChunkedScreenshotPacket(byte[] imageBytes, String json) {
        int MAX_CHUNK_SIZE = 25000;
        String transferId = UUID.randomUUID().toString();
        int totalChunks = (int)Math.ceil((double)imageBytes.length / 25000.0);
        ClientPlayNetworking.send((class_8710)new ScreenshotChunkPayload(transferId, totalChunks, json));
        logger.debug("Sent init packet for transfer {}: {} chunks", (Object)transferId, (Object)totalChunks);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 25000;
            int length = Math.min(25000, imageBytes.length - start);
            byte[] chunk = new byte[length];
            System.arraycopy(imageBytes, start, chunk, 0, length);
            ClientPlayNetworking.send((class_8710)new ScreenshotChunkPayload(transferId, totalChunks, i, chunk));
            logger.info("Sent chunk {}/{} of transfer {}: {} bytes", new Object[]{i + 1, totalChunks, transferId, length});
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        ClientPlayNetworking.send((class_8710)new ScreenshotChunkPayload(transferId));
        logger.debug("Sent final packet for transfer {}", (Object)transferId);
    }
}

