/*
 * Decompiled with CFR 0.152.
 */
package de.thecoolcraft11.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.thecoolcraft11.config.ConfigManager;
import de.thecoolcraft11.util.GalleryBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Map<String, String> shortenedUrls = new HashMap<String, String>();
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int CODE_LENGTH = 6;
    private static final Random RANDOM = new Random();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String SHORTENED_URLS_FILE = "screenshotUploader/shortened_urls.json";
    private static final Logger logger = LoggerFactory.getLogger(WebServer.class);

    public static void startWebServer(String ipAddress, int port, String urlString) throws Exception {
        WebServer.loadShortenedUrls();
        HttpServer server = HttpServer.create(new InetSocketAddress(ipAddress, port), 0);
        server.createContext("/", new RootHandler());
        server.createContext("/random-screenshot", new RandomScreenshotHandler());
        server.createContext("/delete", new DeleteFileHandler());
        server.createContext("/static", new StaticFileHandler());
        server.createContext("/scr", new ScreenshotFileHandler());
        server.createContext("/screenshots", new ScreenshotFileHandler());
        server.createContext("/screenshot-list", new ScreenshotListHandler(urlString));
        server.createContext("/comments", new GetCommentsHandler());
        server.createContext("/statistics", new StatisticsHandler());
        server.createContext("/shorten", new UrlShortenerHandler(urlString));
        server.createContext("/s", new ShortUrlRedirectHandler());
        server.createContext("/shortener", new ShortenerPageHandler());
        server.start();
    }

    private static String generateShortCode() {
        StringBuilder sb = new StringBuilder(6);
        for (int i = 0; i < 6; ++i) {
            sb.append(CHARS.charAt(RANDOM.nextInt(CHARS.length())));
        }
        return sb.toString();
    }

    private static void loadShortenedUrls() {
        if (!ConfigManager.getServerConfig().saveShortenedUrlsToFile) {
            return;
        }
        File file = new File(SHORTENED_URLS_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Map loadedUrls = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
                if (loadedUrls != null) {
                    shortenedUrls.putAll(loadedUrls);
                }
            }
            catch (IOException e) {
                logger.error("Failed to load shortened URLs: {}", (Object)e.getMessage());
            }
        }
    }

    private static void saveShortenedUrls() {
        if (!ConfigManager.getServerConfig().saveShortenedUrlsToFile) {
            return;
        }
        File file = new File(SHORTENED_URLS_FILE);
        boolean wasCreated = file.getParentFile().mkdirs();
        if (wasCreated) {
            logger.info("Created directory for shortened URLs file: {}", (Object)file.getParent());
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(shortenedUrls, (Appendable)writer);
        }
        catch (IOException e) {
            logger.error("Failed to save shortened URLs: {}", (Object)e.getMessage());
        }
    }

    private static class RootHandler
    implements HttpHandler {
        private RootHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            File dir = new File("./screenshotUploader/screenshots/");
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".jpg") || name.endsWith(".png"));
            String response = GalleryBuilder.buildGallery(files, ConfigManager.getServerConfig().allowDelete, ConfigManager.getServerConfig().deletionPassphrase.isEmpty(), ConfigManager.getServerConfig().useOldCss);
            exchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(200, response.getBytes().length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        }
    }

    private static class RandomScreenshotHandler
    implements HttpHandler {
        private RandomScreenshotHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            File screenshotsDir = new File("screenshotUploader");
            if (!screenshotsDir.exists() || !screenshotsDir.isDirectory()) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            File[] files = screenshotsDir.listFiles();
            if (files == null || files.length == 0) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            Random random = new Random();
            File randomFile = files[random.nextInt(files.length)];
            String response = "{ \"filename\": \"" + randomFile.getName() + "\" }";
            exchange.sendResponseHeaders(200, response.getBytes().length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        }
    }

    private static class DeleteFileHandler
    implements HttpHandler {
        private static final Pattern DELETE_PATTERN = Pattern.compile("/delete/([^/]+)");

        private DeleteFileHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"DELETE".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            if (!ConfigManager.getServerConfig().allowDelete) {
                exchange.sendResponseHeaders(403, -1L);
                return;
            }
            String providedPassphrase = exchange.getRequestHeaders().getFirst("X-Delete-Passphrase");
            String configuredPassphrase = ConfigManager.getServerConfig().deletionPassphrase;
            if (!(configuredPassphrase == null || configuredPassphrase.isEmpty() || providedPassphrase != null && providedPassphrase.equals(configuredPassphrase))) {
                exchange.sendResponseHeaders(401, -1L);
                return;
            }
            String requestURI = exchange.getRequestURI().toString();
            Matcher matcher = DELETE_PATTERN.matcher(requestURI);
            if (matcher.matches()) {
                String filename = matcher.group(1);
                Path gameDir = FabricLoader.getInstance().getGameDir();
                Path targetFile = gameDir.resolve("./screenshotUploader/screenshots/" + filename);
                Path jsonFile = gameDir.resolve("./screenshotUploader/screenshots/" + filename.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                try {
                    if (Files.exists(targetFile, new LinkOption[0])) {
                        Files.delete(targetFile);
                    }
                    if (Files.exists(jsonFile, new LinkOption[0])) {
                        Files.delete(jsonFile);
                        exchange.sendResponseHeaders(200, -1L);
                    }
                    exchange.sendResponseHeaders(404, -1L);
                }
                catch (IOException e) {
                    exchange.sendResponseHeaders(500, -1L);
                }
                finally {
                    exchange.getResponseBody().close();
                }
            } else {
                exchange.sendResponseHeaders(400, -1L);
            }
        }
    }

    private static class StaticFileHandler
    implements HttpHandler {
        private StaticFileHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String path = exchange.getRequestURI().getPath().replace("/static", "");
            File staticFile = new File("screenshotUploader/static", path);
            if (!staticFile.exists() || !staticFile.isFile()) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            String mimeType = Files.probeContentType(Paths.get(staticFile.getAbsolutePath(), new String[0]));
            if (mimeType == null) {
                mimeType = StaticFileHandler.getMimeType(path);
            }
            byte[] fileContent = Files.readAllBytes(staticFile.toPath());
            exchange.getResponseHeaders().add("Content-Type", mimeType);
            exchange.sendResponseHeaders(200, fileContent.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(fileContent);
            }
        }

        private static String getMimeType(String filename) {
            if (filename.endsWith(".css")) {
                return "text/css";
            }
            if (filename.endsWith(".js")) {
                return "application/javascript";
            }
            if (filename.endsWith(".html")) {
                return "text/html";
            }
            if (filename.endsWith(".png")) {
                return "image/png";
            }
            if (filename.endsWith(".jpg") || filename.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            return "application/octet-stream";
        }
    }

    private static class ScreenshotFileHandler
    implements HttpHandler {
        private ScreenshotFileHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String rawPath = exchange.getRequestURI().getPath();
            String path = rawPath.startsWith("/screenshots") ? rawPath.replaceFirst("/screenshots", "") : rawPath.replaceFirst("/scr", "");
            File staticFile = new File("screenshotUploader/screenshots", path);
            if (!staticFile.exists() || !staticFile.isFile()) {
                exchange.sendResponseHeaders(404, -1L);
                return;
            }
            String mimeType = Files.probeContentType(Paths.get(staticFile.getAbsolutePath(), new String[0]));
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            byte[] fileContent = Files.readAllBytes(staticFile.toPath());
            exchange.getResponseHeaders().add("Content-Type", mimeType);
            if (mimeType.startsWith("image/")) {
                exchange.getResponseHeaders().add("Cache-Control", "public, max-age=31536000, immutable");
            } else {
                exchange.getResponseHeaders().add("Cache-Control", "no-cache, must-revalidate");
            }
            exchange.sendResponseHeaders(200, fileContent.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(fileContent);
            }
        }
    }

    private static class ScreenshotListHandler
    implements HttpHandler {
        private static String urlString;

        public ScreenshotListHandler(String urlString) {
            ScreenshotListHandler.urlString = urlString;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            File dir = new File("./screenshotUploader/screenshots/");
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".jpg") || name.endsWith(".png"));
            String jsonResponse = this.getString(files);
            exchange.getResponseHeaders().add("Content-Type", "application/json; charset=UTF-8");
            exchange.sendResponseHeaders(200, jsonResponse != null ? (long)jsonResponse.getBytes().length : 0L);
            try (OutputStream os = exchange.getResponseBody();){
                if (jsonResponse != null) {
                    os.write(jsonResponse.getBytes());
                }
            }
        }

        private String getString(File[] files) {
            JsonArray fileArray = new JsonArray();
            if (files != null) {
                for (File file : files) {
                    JsonObject fileObject = new JsonObject();
                    fileObject.addProperty("filename", file.getName());
                    fileObject.addProperty("url", urlString + "/screenshots/" + file.getName());
                    fileObject.addProperty("username", this.getUsername(file.getName()));
                    fileObject.addProperty("date", (Number)file.lastModified());
                    String fileName = file.getName();
                    String jsonFileName = fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) + ".json" : fileName + ".json";
                    File jsonFile = new File(file.getParent(), jsonFileName);
                    if (jsonFile.exists() && jsonFile.isFile()) {
                        try (FileReader reader = new FileReader(jsonFile);){
                            JsonObject metaData = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            fileObject.add("metaData", (JsonElement)metaData);
                        }
                        catch (IOException e) {
                            fileObject.add("metaData", null);
                        }
                    } else {
                        fileObject.add("metaData", null);
                    }
                    fileArray.add((JsonElement)fileObject);
                }
            }
            return fileArray.toString();
        }

        private String getUsername(String name) {
            if (name.split("-").length > 1 && name.split("-")[1].split("_").length > 1) {
                return name.split("-")[1].split("_")[0];
            }
            return "Unknown";
        }
    }

    private static class GetCommentsHandler
    implements HttpHandler {
        private static final Pattern COMMENT_PATTERN = Pattern.compile("/comments/([^/]+)");

        private GetCommentsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String requestURI = exchange.getRequestURI().toString();
            Matcher matcher = COMMENT_PATTERN.matcher(requestURI);
            if (matcher.matches()) {
                String filename = matcher.group(1);
                Path gameDir = FabricLoader.getInstance().getGameDir();
                Path commentFile = gameDir.resolve("./screenshotUploader/screenshots/" + filename.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json"));
                try {
                    if (Files.exists(commentFile, new LinkOption[0])) {
                        String existingContent = new String(Files.readAllBytes(commentFile));
                        JsonObject existingJson = JsonParser.parseString((String)existingContent).getAsJsonObject();
                        JsonArray commentsArray = existingJson.has("comments") ? existingJson.getAsJsonArray("comments") : new JsonArray();
                        String jsonResponse = commentsArray.toString();
                        exchange.getResponseHeaders().set("Content-Type", "application/json");
                        exchange.sendResponseHeaders(200, jsonResponse.getBytes().length);
                        exchange.getResponseBody().write(jsonResponse.getBytes());
                    }
                    exchange.sendResponseHeaders(404, -1L);
                }
                catch (IOException e) {
                    exchange.sendResponseHeaders(500, -1L);
                }
                finally {
                    exchange.getResponseBody().close();
                }
            } else {
                exchange.sendResponseHeaders(400, -1L);
            }
        }
    }

    private static class StatisticsHandler
    implements HttpHandler {
        private JsonObject cachedStats = null;
        private long lastCacheTime = 0L;
        private static final long CACHE_DURATION = 60000L;

        private StatisticsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            try {
                String query = exchange.getRequestURI().getQuery();
                Map<String, String> params = this.parseQueryParams(query);
                boolean useCache = !params.containsKey("noCache") && !params.containsKey("from") && !params.containsKey("to");
                long currentTime = System.currentTimeMillis();
                if (useCache && this.cachedStats != null && currentTime - this.lastCacheTime < 60000L) {
                    this.sendJsonResponse(exchange, this.cachedStats.toString());
                    return;
                }
                File screenshotsDir = new File("./screenshotUploader/screenshots/");
                File[] files = screenshotsDir.listFiles((dir, name) -> name.endsWith(".jpg") || name.endsWith(".png"));
                if (files == null) {
                    exchange.sendResponseHeaders(404, -1L);
                    return;
                }
                files = this.filterFilesByTime(files, params);
                JsonObject statistics = this.generateStatistics(files);
                if (useCache) {
                    this.cachedStats = statistics;
                    this.lastCacheTime = currentTime;
                }
                this.sendJsonResponse(exchange, statistics.toString());
            }
            catch (Exception e) {
                exchange.sendResponseHeaders(500, -1L);
            }
            finally {
                exchange.getResponseBody().close();
            }
        }

        private void sendJsonResponse(HttpExchange exchange, String jsonString) throws IOException {
            exchange.getResponseHeaders().set("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, jsonString.getBytes().length);
            exchange.getResponseBody().write(jsonString.getBytes());
        }

        private Map<String, String> parseQueryParams(String query) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] keyValue = param.split("=", 2);
                    if (keyValue.length <= 1) continue;
                    params.put(keyValue[0], keyValue[1]);
                }
            }
            return params;
        }

        private File[] filterFilesByTime(File[] files, Map<String, String> params) {
            if (!params.containsKey("from") && !params.containsKey("to")) {
                return files;
            }
            long fromDate = params.containsKey("from") ? Long.parseLong(params.get("from")) : 0L;
            long toDate = params.containsKey("to") ? Long.parseLong(params.get("to")) : System.currentTimeMillis();
            return (File[])Arrays.stream(files).filter(file -> {
                long fileDate = file.lastModified();
                return fileDate >= fromDate && fileDate <= toDate;
            }).toArray(File[]::new);
        }

        private JsonObject generateStatistics(File[] files) {
            JsonObject statistics = new JsonObject();
            JsonObject globalStats = new JsonObject();
            JsonObject serverStats = new JsonObject();
            JsonObject fileStats = new JsonObject();
            JsonObject timeStats = new JsonObject();
            JsonObject worldStats = new JsonObject();
            JsonObject userStats = new JsonObject();
            JsonArray recentUploads = new JsonArray();
            this.collectStandardStatistics(files, statistics, globalStats, serverStats, fileStats, timeStats, worldStats, userStats, recentUploads);
            this.addPerformanceMetrics(statistics, files);
            JsonObject metadataStats = this.getMetadataStats(files);
            globalStats.add("metadataStats", (JsonElement)metadataStats);
            this.addLocationHeatMap(worldStats, files);
            return statistics;
        }

        private void collectStandardStatistics(File[] files, JsonObject statistics, JsonObject globalStats, JsonObject serverStats, JsonObject fileStats, JsonObject timeStats, JsonObject worldStats, JsonObject userStats, JsonArray recentUploads) {
            String[] supportedExtensions;
            JsonObject globalBiomeStats = new JsonObject();
            JsonObject globalDimensionStats = new JsonObject();
            JsonObject fileSizeStats = new JsonObject();
            long[] sizeCategories = new long[]{50000L, 100000L, 500000L, 1000000L, 5000000L};
            String[] sizeCategoryNames = new String[]{"0-50KB", "50-100KB", "100-500KB", "500KB-1MB", "1-5MB", "5MB+"};
            int[] sizeCategoryCounts = new int[sizeCategories.length + 1];
            JsonObject fileTypeStats = new JsonObject();
            for (String ext : supportedExtensions = new String[]{".jpg", ".jpeg", ".png"}) {
                fileTypeStats.addProperty(ext, (Number)0);
            }
            long totalSize = 0L;
            PriorityQueue<File> mostRecentFiles = new PriorityQueue<File>(10, (f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
            serverStats.addProperty("totalScreenshots", (Number)files.length);
            for (File file : files) {
                String hourKey;
                JsonObject hourStats;
                String month;
                String username = this.getUsername(file.getName());
                if (!userStats.has(username)) {
                    JsonObject newUserObject = new JsonObject();
                    newUserObject.addProperty("uploadCount", (Number)0);
                    newUserObject.addProperty("totalSizeBytes", (Number)0L);
                    newUserObject.addProperty("totalSizeMB", (Number)0.0);
                    userStats.add(username, (JsonElement)newUserObject);
                }
                JsonObject userObject = userStats.getAsJsonObject(username);
                int currentCount = userObject.get("uploadCount").getAsInt();
                userObject.addProperty("uploadCount", (Number)(currentCount + 1));
                long fileSize = file.length();
                long currentUserSize = userObject.get("totalSizeBytes").getAsLong();
                userObject.addProperty("totalSizeBytes", (Number)(currentUserSize + fileSize));
                String fileName = file.getName();
                String jsonFileName = fileName.replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json");
                File jsonFile = new File(file.getParent(), jsonFileName);
                long timestamp = file.lastModified();
                if (jsonFile.exists() && jsonFile.isFile()) {
                    try (FileReader reader2 = new FileReader(jsonFile);){
                        JsonObject metaData = JsonParser.parseReader((Reader)reader2).getAsJsonObject();
                        if (metaData.has("current_time")) {
                            try {
                                timestamp = Long.parseLong(metaData.get("current_time").getAsString());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (metaData.has("biome")) {
                            String biome = metaData.get("biome").getAsString();
                            if (globalBiomeStats.has(biome)) {
                                globalBiomeStats.addProperty(biome, (Number)(globalBiomeStats.get(biome).getAsInt() + 1));
                            } else {
                                globalBiomeStats.addProperty(biome, (Number)1);
                            }
                        }
                        if (metaData.has("dimension")) {
                            String dimension = metaData.get("dimension").getAsString();
                            if (globalDimensionStats.has(dimension)) {
                                globalDimensionStats.addProperty(dimension, (Number)(globalDimensionStats.get(dimension).getAsInt() + 1));
                            } else {
                                globalDimensionStats.addProperty(dimension, (Number)1);
                            }
                        }
                    }
                    catch (IOException reader2) {
                        // empty catch block
                    }
                }
                if (timeStats.has(month = new SimpleDateFormat("yyyy-MM").format(new Date(timestamp)))) {
                    timeStats.addProperty(month, (Number)(timeStats.get(month).getAsInt() + 1));
                } else {
                    timeStats.addProperty(month, (Number)1);
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(timestamp);
                int hour = calendar.get(11);
                if (!userObject.has("activityByHour")) {
                    userObject.add("activityByHour", (JsonElement)new JsonObject());
                }
                if ((hourStats = userObject.getAsJsonObject("activityByHour")).has(hourKey = String.format("%02d:00", hour))) {
                    hourStats.addProperty(hourKey, (Number)(hourStats.get(hourKey).getAsInt() + 1));
                } else {
                    hourStats.addProperty(hourKey, (Number)1);
                }
                String extension = file.getName().substring(file.getName().lastIndexOf(".")).toLowerCase();
                if (fileTypeStats.has(extension)) {
                    fileTypeStats.addProperty(extension, (Number)(fileTypeStats.get(extension).getAsInt() + 1));
                }
                totalSize += fileSize;
                int categoryIndex = sizeCategories.length;
                for (int i = 0; i < sizeCategories.length; ++i) {
                    if (fileSize >= sizeCategories[i]) continue;
                    categoryIndex = i;
                    break;
                }
                int n = categoryIndex;
                sizeCategoryCounts[n] = sizeCategoryCounts[n] + 1;
                mostRecentFiles.offer(file);
                if (mostRecentFiles.size() <= 10) continue;
                mostRecentFiles.poll();
            }
            for (String username : userStats.keySet()) {
                JsonObject hourStats;
                String mostActiveHour;
                JsonObject userObject = userStats.getAsJsonObject(username);
                int uploadCount = userObject.get("uploadCount").getAsInt();
                long totalUserSize = userObject.get("totalSizeBytes").getAsLong();
                if (uploadCount > 0) {
                    userObject.addProperty("averageFileSizeBytes", (Number)((double)totalUserSize / (double)uploadCount));
                } else {
                    userObject.addProperty("averageFileSizeBytes", (Number)0);
                }
                if (!userObject.has("activityByHour") || (mostActiveHour = this.getMostFrequentHour(hourStats = userObject.getAsJsonObject("activityByHour"))) == null) continue;
                int hour = Integer.parseInt(mostActiveHour.substring(0, 2));
                userObject.addProperty("mostActiveTime", String.format("%02d:00-%02d:59", hour, hour));
            }
            for (int i = 0; i < sizeCategoryNames.length; ++i) {
                fileSizeStats.addProperty(sizeCategoryNames[i], (Number)(i < sizeCategoryCounts.length ? sizeCategoryCounts[i] : 0));
            }
            double averageSize = files.length > 0 ? (double)totalSize / (double)files.length : 0.0;
            serverStats.addProperty("averageFileSizeBytes", (Number)averageSize);
            serverStats.addProperty("totalFileSizeBytes", (Number)totalSize);
            ArrayList sortedRecentFiles = new ArrayList(mostRecentFiles);
            sortedRecentFiles.sort((f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
            for (File file : sortedRecentFiles) {
                JsonObject fileObj = new JsonObject();
                fileObj.addProperty("filename", file.getName());
                fileObj.addProperty("username", this.getUsername(file.getName()));
                fileObj.addProperty("timestamp", (Number)file.lastModified());
                fileObj.addProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(file.lastModified())));
                fileObj.addProperty("sizeBytes", (Number)file.length());
                recentUploads.add((JsonElement)fileObj);
            }
            fileStats.add("typeDistribution", (JsonElement)fileTypeStats);
            fileStats.add("sizeDistribution", (JsonElement)fileSizeStats);
            worldStats.add("biomes", (JsonElement)globalBiomeStats);
            worldStats.add("dimensions", (JsonElement)globalDimensionStats);
            globalStats.add("serverStats", (JsonElement)serverStats);
            globalStats.add("fileStats", (JsonElement)fileStats);
            globalStats.add("timeStats", (JsonElement)timeStats);
            globalStats.add("worldStats", (JsonElement)worldStats);
            statistics.add("globalStats", (JsonElement)globalStats);
            statistics.add("userStats", (JsonElement)userStats);
            statistics.add("recentUploads", (JsonElement)recentUploads);
        }

        private void addPerformanceMetrics(JsonObject statistics, File[] files) {
            JsonObject performanceStats = new JsonObject();
            HashMap<String, Integer> uploadsPerDay = new HashMap<String, Integer>();
            for (File file : files) {
                String day = new SimpleDateFormat("yyyy-MM-dd").format(file.lastModified());
                uploadsPerDay.put(day, uploadsPerDay.getOrDefault(day, 0) + 1);
            }
            JsonObject dailyUploads = new JsonObject();
            for (Map.Entry entry : uploadsPerDay.entrySet()) {
                dailyUploads.addProperty((String)entry.getKey(), (Number)entry.getValue());
            }
            performanceStats.add("uploadsPerDay", (JsonElement)dailyUploads);
            if (files.length > 0) {
                ArrayList<Map.Entry<String, Integer>> sortedUploads = new ArrayList<Map.Entry<String, Integer>>(uploadsPerDay.entrySet());
                sortedUploads.sort(Map.Entry.comparingByKey());
                JsonObject weeklyAverage = StatisticsHandler.getWeeklyAverageStatistics(sortedUploads);
                performanceStats.add("weeklyMovingAverage", (JsonElement)weeklyAverage);
            }
            statistics.add("performanceStats", (JsonElement)performanceStats);
        }

        @NotNull
        private static JsonObject getWeeklyAverageStatistics(List<Map.Entry<String, Integer>> sortedUploads) {
            JsonObject weeklyAverage = new JsonObject();
            if (sortedUploads.size() >= 7) {
                for (int i = 6; i < sortedUploads.size(); ++i) {
                    int sum = 0;
                    for (int j = i - 6; j <= i; ++j) {
                        sum += sortedUploads.get(j).getValue().intValue();
                    }
                    double average = (double)sum / 7.0;
                    weeklyAverage.addProperty(sortedUploads.get(i).getKey(), (Number)average);
                }
            }
            return weeklyAverage;
        }

        private JsonObject getMetadataStats(File[] files) {
            JsonObject metadataStats = new JsonObject();
            JsonObject clientVersionStats = new JsonObject();
            JsonObject renderDistanceStats = new JsonObject();
            JsonObject graphicsSettings = new JsonObject();
            for (File file : files) {
                String jsonFileName = file.getName().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json");
                File jsonFile = new File(file.getParent(), jsonFileName);
                if (!jsonFile.exists()) continue;
                try (FileReader reader = new FileReader(jsonFile);){
                    String graphicsSetting;
                    String sysInfo;
                    JsonObject metadata = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (metadata.has("system_info") && (sysInfo = metadata.get("system_info").getAsString()).contains("Version:")) {
                        String version;
                        clientVersionStats.addProperty(version, (Number)(clientVersionStats.has(version = sysInfo.substring(sysInfo.indexOf("Version:") + 9).split(",")[0].trim()) ? clientVersionStats.get(version).getAsInt() + 1 : 1));
                    }
                    if (!metadata.has("client_settings")) continue;
                    String settings = metadata.get("client_settings").getAsString();
                    if (settings.contains("Render Distance:")) {
                        String renderDistance;
                        renderDistanceStats.addProperty(renderDistance, (Number)(renderDistanceStats.has(renderDistance = settings.substring(settings.indexOf("Render Distance:") + 16).split(",")[0].trim()) ? renderDistanceStats.get(renderDistance).getAsInt() + 1 : 1));
                    }
                    if (!settings.contains("Graphics:")) continue;
                    graphicsSettings.addProperty(graphicsSetting, (Number)(graphicsSettings.has(graphicsSetting = settings.substring(settings.indexOf("Graphics:") + 9).split(",")[0].trim()) ? graphicsSettings.get(graphicsSetting).getAsInt() + 1 : 1));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            metadataStats.add("clientVersions", (JsonElement)clientVersionStats);
            metadataStats.add("renderDistances", (JsonElement)renderDistanceStats);
            metadataStats.add("graphicsSettings", (JsonElement)graphicsSettings);
            return metadataStats;
        }

        private void addLocationHeatMap(JsonObject worldStats, File[] files) {
            JsonArray locationData = new JsonArray();
            HashMap<CallSite, ClusterPoint> clusters = new HashMap<CallSite, ClusterPoint>();
            int gridSize = 100;
            for (File file : files) {
                String jsonFileName = file.getName().replaceFirst("(?i)\\.(png|jpg|jpeg|gif|bmp|webp)$", ".json");
                File jsonFile = new File(file.getParent(), jsonFileName);
                if (!jsonFile.exists()) continue;
                try (FileReader reader = new FileReader(jsonFile);){
                    JsonObject metadata = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    if (!metadata.has("coordinates")) continue;
                    String coords = metadata.get("coordinates").getAsString();
                    Pattern pattern = Pattern.compile("X: (-?\\d+), Y: (-?\\d+), Z: (-?\\d+)");
                    Matcher matcher = pattern.matcher(coords);
                    if (!matcher.find()) continue;
                    int x = Integer.parseInt(matcher.group(1));
                    int y = Integer.parseInt(matcher.group(2));
                    int z = Integer.parseInt(matcher.group(3));
                    JsonObject point = new JsonObject();
                    point.addProperty("x", (Number)x);
                    point.addProperty("y", (Number)y);
                    point.addProperty("z", (Number)z);
                    String dimension = "overworld";
                    if (metadata.has("dimension")) {
                        dimension = metadata.get("dimension").getAsString();
                        point.addProperty("dimension", dimension);
                    }
                    locationData.add((JsonElement)point);
                    int gridX = Math.floorDiv(x, gridSize);
                    int gridZ = Math.floorDiv(z, gridSize);
                    String clusterKey = dimension + ":" + gridX + ":" + gridZ;
                    if (clusters.containsKey(clusterKey)) {
                        ClusterPoint cluster = (ClusterPoint)clusters.get(clusterKey);
                        ++cluster.count;
                        cluster.totalX += x;
                        cluster.totalY += y;
                        cluster.totalZ += z;
                        continue;
                    }
                    clusters.put((CallSite)((Object)clusterKey), new ClusterPoint(x, y, z, dimension));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ArrayList<ClusterPoint> sortedClusters = new ArrayList<ClusterPoint>(clusters.values());
            sortedClusters.sort((c1, c2) -> Integer.compare(c2.count, c1.count));
            JsonArray clusteredData = this.getClusterStatistics(sortedClusters);
            worldStats.add("locations", (JsonElement)locationData);
            worldStats.add("clusteredLocations", (JsonElement)clusteredData);
        }

        @NotNull
        private JsonArray getClusterStatistics(List<ClusterPoint> sortedClusters) {
            JsonArray clusteredData = new JsonArray();
            for (ClusterPoint cluster : sortedClusters) {
                JsonObject clusterPoint = new JsonObject();
                clusterPoint.addProperty("x", (Number)(cluster.totalX / cluster.count));
                clusterPoint.addProperty("y", (Number)(cluster.totalY / cluster.count));
                clusterPoint.addProperty("z", (Number)(cluster.totalZ / cluster.count));
                clusterPoint.addProperty("count", (Number)cluster.count);
                clusterPoint.addProperty("dimension", cluster.dimension);
                clusteredData.add((JsonElement)clusterPoint);
            }
            return clusteredData;
        }

        private String getUsername(String name) {
            if (name.split("-").length > 1 && name.split("-")[1].split("_").length > 1) {
                return name.split("-")[1].split("_")[0];
            }
            return "Unknown";
        }

        private String getMostFrequentHour(JsonObject hourStats) {
            String mostFrequentHour = null;
            int maxCount = 0;
            for (String hour : hourStats.keySet()) {
                int count = hourStats.get(hour).getAsInt();
                if (count <= maxCount) continue;
                maxCount = count;
                mostFrequentHour = hour;
            }
            return mostFrequentHour;
        }

        private static class ClusterPoint {
            public int count = 1;
            public int totalX;
            public int totalY;
            public int totalZ;
            public String dimension;

            public ClusterPoint(int x, int y, int z, String dimension) {
                this.totalX = x;
                this.totalY = y;
                this.totalZ = z;
                this.dimension = dimension;
            }
        }
    }

    private record UrlShortenerHandler(String baseUrl) implements HttpHandler
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!ConfigManager.getServerConfig().allowShortenedUrls) {
                exchange.sendResponseHeaders(423, -1L);
                return;
            }
            if (!"POST".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String providedPassphrase = exchange.getRequestHeaders().getFirst("X-Shortener-Passphrase");
            if (!(ConfigManager.getServerConfig().shortenerPassphrase == null || ConfigManager.getServerConfig().shortenerPassphrase.isEmpty() || providedPassphrase != null && providedPassphrase.equals(ConfigManager.getServerConfig().shortenerPassphrase))) {
                exchange.sendResponseHeaders(403, -1L);
                return;
            }
            try {
                String requestBody = new String(exchange.getRequestBody().readAllBytes());
                JsonObject requestJson = JsonParser.parseString((String)requestBody).getAsJsonObject();
                String originalUrl = requestJson.get("url").getAsString();
                if (originalUrl == null || originalUrl.isEmpty()) {
                    exchange.sendResponseHeaders(400, -1L);
                    return;
                }
                String shortCode = WebServer.generateShortCode();
                shortenedUrls.put(shortCode, originalUrl);
                if (ConfigManager.getServerConfig().saveShortenedUrlsToFile) {
                    WebServer.saveShortenedUrls();
                }
                JsonObject responseJson = new JsonObject();
                responseJson.addProperty("shortUrl", this.baseUrl + "/s/" + shortCode);
                exchange.getResponseHeaders().set("Content-Type", "application/json");
                exchange.sendResponseHeaders(200, responseJson.toString().getBytes().length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(responseJson.toString().getBytes());
                }
            }
            catch (Exception e) {
                exchange.sendResponseHeaders(500, -1L);
            }
            finally {
                exchange.getResponseBody().close();
            }
        }
    }

    private static class ShortUrlRedirectHandler
    implements HttpHandler {
        private ShortUrlRedirectHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod()) && !"HEAD".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String requestURI = exchange.getRequestURI().toString();
            String shortCode = requestURI.substring(requestURI.lastIndexOf(47) + 1);
            String originalUrl = shortenedUrls.get(shortCode);
            if (originalUrl != null) {
                exchange.getResponseHeaders().set("Location", originalUrl);
                exchange.sendResponseHeaders(302, -1L);
            } else {
                exchange.sendResponseHeaders(404, -1L);
            }
        }
    }

    private static class ShortenerPageHandler
    implements HttpHandler {
        private ShortenerPageHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            File staticFile = new File("screenshotUploader/static/html", "/shortener.html");
            if (staticFile.exists() && staticFile.isFile()) {
                byte[] fileContent = Files.readAllBytes(staticFile.toPath());
                exchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
                exchange.sendResponseHeaders(200, fileContent.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(fileContent);
                }
            }
        }
    }
}

