#ifdef OVERWORLD
vec3 GetSkyColor(vec3 viewPos, bool isReflection) {
    vec3 nViewPos = normalize(viewPos);

    float VoU = clamp(dot(nViewPos,  upVec), -1.0, 1.0);
    float VoL = clamp(dot(nViewPos, sunVec), -1.0, 1.0);

    float density = 0.4;
    float nightDensity = 0.64;
    float weatherDensity = 16.0;
    float groundDensity = 0.08 * (4.0 - 3.0 * sunVisibility22) *
                          (10.0 * rainStrength * rainStrength + 1.0);
    
    float exposure = clamp((dot(sunVec22, upVec) + 0.05) * 3.0, 0.0, 1.0) * clamp((dot(sunVec22, upVec) + 0.05) * 3.0, 0.0, 1.0);
    float nightExposure = 1.08 - clamp((dot(-sunVec22, upVec) + 0.05) * 9.9, 0.0, 1.0);

    float baseGradient = exp(-(1.0 - pow(1.0 - max(VoU, 0.0)*0.81, (1.2 + 0.6 * clamp((dot(sunVecM22, upVec) + 0.04) * 2.2, 0.0, 1.0) - 0.6 * clamp((dot(sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0)) * (1.0 + 0.2 * clamp((dot(-sunVec, upVec) + 0.12) * 8.8, 0.0, 1.0)) - (0.2 + 0.6 * clamp((dot(sunVecM22, upVec) + 0.04) * 6.6, 0.0, 1.0) + 0.6 * moonVisibility) * VoL)) / density);

    #if SKY_GROUND > 0
    float groundVoU = clamp(-VoU * 1.015 - 0.015, 0.0, 1.0);
    float ground = 1.0 - exp(-groundDensity * FOG_DENSITY / groundVoU);
    #if SKY_GROUND == 1
    if (!isReflection) ground = 1.0;
    #endif
    #else
    float ground = 1.0;
    #endif

    vec3 sky = skyCol * baseGradient / (SKY_I * SKY_I);

    sky = sky / sqrt(sky * sky + 1.0) * exposure * sunVisibility22 * (SKY_I * SKY_I);

    float sunMix = (VoL * 0.5 + 0.5) * pow(clamp(1.0 - VoU, 0.0, 1.0), 5.0 + 3.0*clamp((dot(-sunVec, upVec) + 0.05) * 6.0, 0.0, 1.0)) * pow(1.0 - timeBrightness * 0.6, 9.0);
    float moonMix = (-VoL * 0.5) * pow(clamp(1.0 - VoU, 0.0, 1.0), 6.6) * pow(1.0 - timeBrightness * 0.32, 9.0);
    float horizonMix = pow(1.0 - abs(VoU), 2.5) * 0.125 * (1.0 - timeBrightness * 2.2);
    float lightMix = (1.0 - (1.0 - sunMix) * (1.0 - horizonMix));
    float lightMix2 = (1.0 - (1.0 - moonMix));

    vec3 lightSky = pow(lightSun*(0.88 + 0.12*clamp((dot(sunVec, upVec) + 0.04) * 4.0, 0.0, 1.0)), vec3(4.0 - sunVisibility22)) * baseGradient;
    lightSky = lightSky / (1.0 + lightSky * rainStrength);

    vec3 lightSky2 = pow(vec3(
	40.0 + 80.0*clamp((dot(sunVec, upVec) + 0.04) * 6.0, 0.0, 1.0), 
	152.0 + 40.0*clamp((dot(-sunVec, upVec) + 0.04) * 6.0, 0.0, 1.0), 
	208.0 + 44.0*clamp((dot(-sunVec, upVec) + 0.04) * 6.0, 0.0, 1.0)
	) *(0.66 + 0.4*clamp((dot(sunVec, upVec) + 0.04), 0.0, 1.0)
		 - 0.4*clamp((dot(-sunVec, upVec) + 0.04) * 12.0, 0.0, 1.0)
		) / 255.0, vec3(4.0 - sunVisibility22)) * baseGradient;
    lightSky2 = lightSky2 / (1.0 + lightSky2 * rainStrength);

    //Horizon Fog
    sky = mix(
	sqrt(sky * (1.0 - lightMix2)), 
	sqrt(lightSky2), 
	lightMix2
    );
    sky *= sky;

    sky = mix(
	sqrt(sky * (1.0 - lightMix)), 
	sqrt(lightSky), 
	lightMix
    );
    sky *= sky;

    float nightGradient = exp(-max(VoU, 0.0) / nightDensity);
    vec3 nightSky = lightNight * lightNight * nightGradient * nightExposure;
    sky = mix(nightSky, sky, sunVisibility22 * sunVisibility22);

    float rainGradient = exp(-max(VoU, 0.0) / weatherDensity);
    vec3 weatherSky = weatherCol.rgb * weatherCol.rgb;
    weatherSky *= GetLuminance(ambientCol / (weatherSky)) * (0.24 * sunVisibility22 + 0.2);
    sky = mix(sky, weatherSky * rainGradient, rainStrength);

    sky *= ground;

	#if MC_VERSION >= 11800
	sky *= clamp((cameraPosition.y + 70.0) / 8.0, 0.0, 1.0);
	#else
	sky *= clamp((cameraPosition.y + 6.0) / 8.0, 0.0, 1.0);
	#endif

	if (isEyeInWater == 3.0) {
	sky = vec3(0.1, 0.16, 0.2) * (1.0 - 0.99 * moonVisibility) * eBS;
	}

    return sky;
}

#endif