
#ifdef MOON_PHASES
uniform int moonPhase;

float moonPhase_I_Multiplier = mix(
	1.0,
	moonPhase == 0 ? FULL_MOON_I_MULTIPLIER :	
	moonPhase == 1 || moonPhase == 7 ? GIBBOUS_I_MULTIPLIER : 
	moonPhase == 2 || moonPhase == 6 ? QUARTER_I_MULTIPLIER : 
	moonPhase == 3 || moonPhase == 5 ? CRESCENT_I_MULTIPLIER : 
	NEW_MOON_I_MULTIPLIER,
	1.0
);

#else
float moonPhase_I_Multiplier = 1.0;
#endif


float nightsEdge = clamp((dot(sunVec22, upVec) + 0.05) * 4.4, 0.0, 1.0);

vec3 lightMorning    = vec3(LIGHT_MR,   LIGHT_MG * (0.7 + 0.3*clamp((dot(sunVec, upVec) + 0.02) * 5.0, 0.0, 1.0)),   LIGHT_MB * (1.0 - 0.6*clamp((dot(-sunVec, upVec) + 0.02) * 2.0, 0.0, 1.0))) * LIGHT_MI * (0.44 + 0.34*clamp((dot(sunVec, upVec) + 0.12) * 8.0, 0.0, 1.0) + 0.22*clamp((dot(sunVec22, upVec) + 0.02) * 8.0, 0.0, 1.0))  / 255.0;
vec3 lightDay        = vec3(LIGHT_DR,   LIGHT_DG,   LIGHT_DB) * LIGHT_DI / 255.0;
vec3 lightEvening    = vec3(LIGHT_ER,   LIGHT_EG * (0.7 + 0.3*clamp((dot(sunVec, upVec) + 0.02) * 5.0, 0.0, 1.0)),   LIGHT_EB * (1.0 - 0.6*clamp((dot(-sunVec, upVec) + 0.02) * 2.0, 0.0, 1.0))) * LIGHT_EI * (0.44 + 0.34*clamp((dot(sunVec, upVec) + 0.12) * 8.0, 0.0, 1.0) + 0.22*clamp((dot(sunVec22, upVec) + 0.02) * 8.0, 0.0, 1.0))  / 255.0;
vec3 lightNight      = vec3(LIGHT_NR * (1.0 + 0.22*nightsEdge),   LIGHT_NG * (1.0 + 0.18*nightsEdge),   LIGHT_NB) * LIGHT_NI * moonPhase_I_Multiplier * 0.3 * (1.0 + (0.2*nightsEdge)/pow(moonPhase_I_Multiplier, 1.8)) / 255.0;

vec3 ambientMorning  = vec3(AMBIENT_MR, AMBIENT_MG, AMBIENT_MB) * AMBIENT_MI / 255.0;
vec3 ambientDay      = vec3(AMBIENT_DR, AMBIENT_DG, AMBIENT_DB) * AMBIENT_DI / 255.0;
vec3 ambientEvening  = vec3(AMBIENT_ER, AMBIENT_EG, AMBIENT_EB) * AMBIENT_EI / 255.0;
vec3 ambientNight    = vec3(AMBIENT_NR * (1.0 + 0.22*nightsEdge), AMBIENT_NG * (1.0 + 0.18*nightsEdge), AMBIENT_NB) * (AMBIENT_NI * moonPhase_I_Multiplier * 0.3) * (1.0 + (0.6*nightsEdge)/pow(moonPhase_I_Multiplier, 1.8)) / 255.0;

uniform float isCold, isSwamp;

#ifdef IS_IRIS
#ifdef OVERWORLD
#if  WATER_MODE == 1 || WATER_MODE == 3

uniform float isWaterCold, isWaterFrozen, isWaterLukewarm, isWaterWarm, isMangroveSwamp, isMeadow, isCherryGrove, isPaleGarden;

vec4 waterDefaultColorSqrt = vec4(vec3(WATER_R, WATER_G, WATER_B) / 255.0, 1.0) * (WATER_I / 10.0);
vec4 waterDefaultColor = waterDefaultColorSqrt * waterDefaultColorSqrt;

vec4 waterColdColorSqrt = vec4(vec3(WATER_COLD_R, WATER_COLD_G, WATER_COLD_B) / 255.0, 1.0) * (WATER_COLD_I / 10.0);
vec4 waterColdColor = waterColdColorSqrt * waterColdColorSqrt;

vec4 waterFrozenColorSqrt = vec4(vec3(WATER_FROZEN_R, WATER_FROZEN_G, WATER_FROZEN_B) / 255.0, 1.0) * (WATER_FROZEN_I / 10.0);
vec4 waterFrozenColor = waterFrozenColorSqrt * waterFrozenColorSqrt;

vec4 waterLukewarmColorSqrt = vec4(vec3(WATER_LUKEWARM_R, WATER_LUKEWARM_G, WATER_LUKEWARM_B) / 255.0, 1.0) * (WATER_LUKEWARM_I / 10.0);
vec4 waterLukewarmColor = waterLukewarmColorSqrt * waterLukewarmColorSqrt;

vec4 waterWarmColorSqrt = vec4(vec3(WATER_WARM_R, WATER_WARM_G, WATER_WARM_B) / 255.0, 1.0) * (WATER_WARM_I / 10.0);
vec4 waterWarmColor = waterWarmColorSqrt * waterWarmColorSqrt;

vec4 waterSwampColorSqrt = vec4(vec3(WATER_SWAMP_R, WATER_SWAMP_G, WATER_SWAMP_B) / 255.0, 1.0) * (WATER_SWAMP_I / 10.0);
vec4 waterSwampColor = waterSwampColorSqrt * waterSwampColorSqrt;

vec4 waterMangroveSwampColorSqrt = vec4(vec3(WATER_MANGROVE_SWAMP_R, WATER_MANGROVE_SWAMP_G, WATER_MANGROVE_SWAMP_B) / 255.0, 1.0) * (WATER_MANGROVE_SWAMP_I / 10.0);
vec4 waterMangroveSwampColor = waterMangroveSwampColorSqrt * waterMangroveSwampColorSqrt;

vec4 waterMeadowColorSqrt = vec4(vec3(WATER_MEADOW_R, WATER_MEADOW_G, WATER_MEADOW_B) / 255.0, 1.0) * (WATER_MEADOW_I / 10.0);
vec4 waterMeadowColor = waterMeadowColorSqrt * waterMeadowColorSqrt;

vec4 waterCherryGroveColorSqrt = vec4(vec3(WATER_CHERRY_GROVE_R, WATER_CHERRY_GROVE_G, WATER_CHERRY_GROVE_B) / 255.0, 1.0) * (WATER_CHERRY_GROVE_I / 10.0);
vec4 waterCherryGroveColor = waterCherryGroveColorSqrt * waterCherryGroveColorSqrt;

vec4 waterPaleGardenColorSqrt = vec4(vec3(WATER_PALE_GARDEN_R, WATER_PALE_GARDEN_G, WATER_PALE_GARDEN_B) / 255.0, 1.0) * (WATER_PALE_GARDEN_I / 10.0);
vec4 waterPaleGardenColor = waterPaleGardenColorSqrt * waterPaleGardenColorSqrt;

float waterWeight = isWaterCold + isWaterFrozen + isWaterLukewarm + isWaterWarm + isMangroveSwamp + isSwamp + isMeadow + isCherryGrove + isPaleGarden;

vec4 waterColor = mix(
	waterDefaultColor,
	(
		waterColdColor * isWaterCold + waterFrozenColor * isWaterFrozen + waterLukewarmColor * isWaterLukewarm + waterWarmColor * isWaterWarm + 
		waterMangroveSwampColor * isMangroveSwamp + waterSwampColor * isSwamp + waterMeadowColor * isMeadow + waterCherryGroveColor * isCherryGrove + waterPaleGardenColor * isPaleGarden
	) / max(waterWeight, 0.0001),
	waterWeight
);

vec3 waterCol = vec3(waterColor);


float waterIntensity = mix(
	(WATER_I / 10.0),
	(
		WATER_COLD_I * isWaterCold + WATER_FROZEN_I * isWaterFrozen + WATER_LUKEWARM_I * isWaterLukewarm + WATER_WARM_I * isWaterWarm + 
		WATER_MANGROVE_SWAMP_I * isMangroveSwamp + WATER_SWAMP_I * isSwamp + WATER_MEADOW_I * isMeadow + WATER_CHERRY_GROVE_I * isCherryGrove + WATER_PALE_GARDEN_I * isPaleGarden
	) / 10.0 / max(waterWeight, 0.0001),
	waterWeight
);


float waterFogDensityPerBiome = mix(
	WATER_FOG_DENSITY,
	(
		WATER_COLD_FOG_DENSITY * isWaterCold + WATER_FROZEN_FOG_DENSITY * isWaterFrozen + WATER_LUKEWARM_FOG_DENSITY * isWaterLukewarm + WATER_WARM_FOG_DENSITY * isWaterWarm + 
		WATER_MANGROVE_SWAMP_FOG_DENSITY * isMangroveSwamp + WATER_SWAMP_FOG_DENSITY * isSwamp + WATER_MEADOW_FOG_DENSITY * isMeadow + WATER_CHERRY_GROVE_FOG_DENSITY * isCherryGrove + WATER_PALE_GARDEN_FOG_DENSITY * isPaleGarden
	) / max(waterWeight, 0.0001),
	waterWeight
);


const float waterAlpha = WATER_A;

float waterFogRange = 64.0 / waterFogDensityPerBiome;

#endif
#endif
#endif


#ifdef WEATHER_PERBIOME
uniform float isDesert, isMesa, isMushroom, isSavanna;

vec4 weatherRain     = vec4(vec3(WEATHER_RR, WEATHER_RG, WEATHER_RB) / 255.0, 1.0) * WEATHER_RI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherCold     = vec4(vec3(WEATHER_CR, WEATHER_CG, WEATHER_CB) / 255.0, 1.0) * WEATHER_CI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherDesert   = vec4(vec3(WEATHER_DR, WEATHER_DG, WEATHER_DB) / 255.0, 1.0) * WEATHER_DI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherBadlands = vec4(vec3(WEATHER_BR, WEATHER_BG, WEATHER_BB) / 255.0, 1.0) * WEATHER_BI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherSwamp    = vec4(vec3(WEATHER_SR, WEATHER_SG, WEATHER_SB) / 255.0, 1.0) * WEATHER_SI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherMushroom = vec4(vec3(WEATHER_MR, WEATHER_MG, WEATHER_MB) / 255.0, 1.0) * WEATHER_MI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));
vec4 weatherSavanna  = vec4(vec3(WEATHER_VR, WEATHER_VG, WEATHER_VB) / 255.0, 1.0) * WEATHER_VI * (1.0 - 0.5 * clamp((dot(-sunVec, upVec) + 0.04) * 8.8, 0.0, 1.0));

float weatherWeight = isCold + isDesert + isMesa + isSwamp + isMushroom + isSavanna;

vec4 weatherCol = mix(
	weatherRain,
	(
		weatherCold  * isCold  + weatherDesert   * isDesert   + weatherBadlands * isMesa    +
		weatherSwamp * isSwamp + weatherMushroom * isMushroom + weatherSavanna  * isSavanna
	) / max(weatherWeight, 0.0001),
	weatherWeight
);

#else
vec4 weatherCol = vec4(vec3(WEATHER_RR, WEATHER_RG, WEATHER_RB) / 255.0, 1.0) * WEATHER_RI;
#endif

float mefade = 1.0 - clamp(abs(timeAngle - 0.5) * 8.0 - 1.5, 0.0, 1.0);
float dfade = (1.0 - timeBrightness)*(1.0 - timeBrightness)*(1.0 - timeBrightness);

vec3 CalcSunColor(vec3 morning, vec3 day, vec3 evening) {
	vec3 me = mix(morning, evening, mefade);
	return mix(me, day, 1.0 - dfade * sqrt(dfade));
}

vec3 CalcLightColor(vec3 sun, vec3 night, vec3 weatherCol) {
	vec3 c = mix(night, sun, sunVisibility);
	c = mix(c, dot(c, vec3(0.299, 0.587, 0.114)) * weatherCol, rainStrength);

	#ifdef IS_IRIS
	#ifdef OVERWORLD
   	 #if  WATER_MODE == 1 || WATER_MODE == 3
		c = mix(c, dot(c, vec3(0.47)) * 
		 ((sqrt(waterCol) / waterIntensity) * 5.0 + c) / 6.0
		, clamp(isEyeInWater, 0.0, 1.0));
  	 #endif
	#endif
	#endif

	return c * c;
}

vec3 lightSun   = CalcSunColor(lightMorning, lightDay, lightEvening);
vec3 ambientSun = CalcSunColor(ambientMorning, ambientDay, ambientEvening);

vec3 lightCol   = CalcLightColor(lightSun, lightNight, weatherCol.rgb);
vec3 ambientCol = CalcLightColor(ambientSun, ambientNight, weatherCol.rgb);