package org.tanjimkamal.the_idea_anvil;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8935;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import java.util.regex.Matcher;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.DataResult;


public class The_idea_anvil implements ModInitializer {
    public static final String MOD_ID = "the_idea_anvil";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

private static final String BASE_URL = "https://ai.hackclub.com/chat/completions";
private static String sysprompt;


private void loadSystemPrompt() {
    try {
        InputStream inputStream = getClass().getResourceAsStream("/sysprompt.md");
        if (inputStream == null) {
            throw new RuntimeException("sysprompt.md not found in resources");
        }
        sysprompt = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        inputStream.close();
    } catch (IOException e) {
        throw new RuntimeException("Failed to load sysprompt.md", e);
    }
}

/**
 * Extract JSON from a model response and return the parsed JsonObject.
 * Strategy:
 * 1) Prefer a ```json fenced code block (case-insensitive).
 * 2) Fallback to any fenced code block.
 * 3) Find balanced JSON (handles strings/escapes)
 *
 * @param text The response text to parse
 * @param returnText If true, returns the raw JSON string instead of parsed JsonObject
 * @return JsonObject or String depending on returnText parameter
 * @throws IllegalArgumentException if no valid JSON is found
 */
@SuppressWarnings("SameParameterValue")
private Object extractJsonFromResponse(String text, boolean returnText) {
    // look for a ```json fenced block
    Pattern jsonPattern = Pattern.compile("```json\\s*\\n([\\s\\S]*?)\\n```", Pattern.CASE_INSENSITIVE);
    Matcher matcher = jsonPattern.matcher(text);
    if (matcher.find()) {
        String candidate = matcher.group(1).strip();
        try {
            return returnText ? candidate : JsonParser.parseString(candidate).getAsJsonObject();
        } catch (JsonSyntaxException e) {
            // continue
        }
    }

    // other fenced code block
    Pattern codePattern = Pattern.compile("```[\\w+-]*\\n([\\s\\S]*?)\\n```");
    matcher = codePattern.matcher(text);
    if (matcher.find()) {
        String candidate = matcher.group(1).strip();
        try {
            return returnText ? candidate : JsonParser.parseString(candidate).getAsJsonObject();
        } catch (JsonSyntaxException e) {
            // continue to fallbacks
        }
    }

    // find balanced {} / []
    for (int idx = 0; idx < text.length(); idx++) {
        char ch = text.charAt(idx);
        if (ch == '{' || ch == '[') {
            String candidate = extractBalancedFrom(text, idx);
            if (candidate != null) {
                try {
                    return returnText ? candidate : JsonParser.parseString(candidate).getAsJsonObject();
                } catch (JsonSyntaxException e) {
                    // maybe malformed
                }
            }
        }
    }

    throw new IllegalArgumentException("No valid JSON found in the provided text.");
}

private Object extractJsonFromResponse(String text) {
    return extractJsonFromResponse(text, false);
}

private String extractBalancedFrom(String text, int start) {
    Stack<Character> stack = new Stack<>();
    boolean inStr = false;
    boolean esc = false;

    for (int i = start; i < text.length(); i++) {
        char ch = text.charAt(i);

        if (esc) {
            esc = false;
            continue;
        }

        if (ch == '\\') {
            esc = true;
            continue;
        }

        if (ch == '"') {
            inStr = !inStr;
            continue;
        }

        if (inStr) {
            continue;
        }

        if (ch == '{') {
            stack.push('}');
        } else if (ch == '[') {
            stack.push(']');
        } else if (ch == '}' || ch == ']') {
            if (stack.isEmpty() || ch != stack.peek()) {
                return null;
            }
            stack.pop();
            if (stack.isEmpty()) {
                return text.substring(start, i + 1);
            }
        }
    }

    return null;
}

public JsonObject getItem(String itemDesc) {
    try {
        JsonObject requestBody = getRequestBody(itemDesc);
        String content;
        try(HttpClient client = HttpClient.newHttpClient()) {
            HttpRequest request = HttpRequest.newBuilder()
                    .uri(URI.create(BASE_URL))
                    .header("Content-Type", "application/json")
                    .POST(HttpRequest.BodyPublishers.ofString(requestBody.toString()))
                    .build();

            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());

            JsonObject responseJson = JsonParser.parseString(response.body()).getAsJsonObject();
            System.out.println(responseJson.toString().substring(0, Math.min(100, responseJson.toString().length())));

            content = responseJson.getAsJsonArray("choices")
                    .get(0).getAsJsonObject()
                    .getAsJsonObject("message")
                    .get("content").getAsString();

            System.out.println(content);
        }
        return (JsonObject) extractJsonFromResponse(content);

    } catch (IOException | InterruptedException e) {
        throw new RuntimeException("Failed to get item", e);
    }
}

    private static @NotNull JsonObject getRequestBody(String itemDesc) {
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();

        JsonObject systemMessage = new JsonObject();
        systemMessage.addProperty("role", "system");
        systemMessage.addProperty("content", sysprompt);
        messages.add(systemMessage);

        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", itemDesc);
        messages.add(userMessage);

        requestBody.add("messages", messages);
        requestBody.addProperty("model", "moonshotai/kimi-k2-instruct-0905");
        requestBody.addProperty("temperature", 0.1);
        return requestBody;
    }
    public void giveItemToPlayer(class_3222 player, String itemId, JsonElement components) {
    try {
        class_2960 itemIdentifier = class_2960.method_60654(itemId);
        class_1792 item = class_7923.field_41178.method_63535(itemIdentifier);

        class_1799 itemStack = new class_1799(item);

        if (components != null && components.isJsonObject()) {
            DataResult<class_9323> result = class_9323.field_50234.parse(JsonOps.INSTANCE, components);

            if (result.result().isPresent()) {
                class_9323 componentMap = result.result().get();
                itemStack.method_57365(componentMap);
            } else {
                LOGGER.warn("Failed to parse components: {}", result.error().map(Object::toString).orElse("Unknown error"));
                return;
            }
        }

        boolean success = player.method_31548().method_7394(itemStack);

        if (!success) {
            player.method_7328(itemStack, false);
        }

    } catch (Exception e) {
        LOGGER.warn(e.toString());
    }
}

    @Override
    public void onInitialize() {
        ModItems.initialize();
        ModComponents.initialize();
        loadSystemPrompt();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(class_2170.method_9247("idea")
                .then(class_2170.method_9244("value", StringArgumentType.greedyString())
                .executes(this::ideaCommand))));

        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(class_2170.method_9247("ai")
                .then(class_2170.method_9244("value", StringArgumentType.greedyString())
                .executes(this::ideaCommand))));
        /* if any problems near here then try this
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register(CommandManager.literal("idea")
                    .then(CommandManager.argument("value", StringArgumentType.greedyString())
                    .executes(this::ideaCommand)));
        });
        */
    }

    private int ideaCommand(CommandContext<class_2168> context) {
        context.getSource().method_9226(() -> class_2561.method_43470("Getting item..."), true);
        String value = StringArgumentType.getString(context, "value");
        JsonObject response;
        try{
            response = getItem(value);
        }catch(Exception e){
            context.getSource().method_9226(() -> class_2561.method_43470("An error occurred. Most likely, the AI thought your item was too OP or didn't understand you. You might want to try refining your prompt or adding OPERATOR to the start of your request."+value), true);
            return 0;
        }
        if (!response.get("accepted").getAsBoolean()) {
            context.getSource().method_9226(() -> class_2561.method_43470("Sorry, the AI determined your item is too OP or didn't understand you. You might want to try refining your prompt or adding OPERATOR to the start of your request."+value), true);
            return 0;
        }
        class_3222 player = context.getSource().method_44023();
        JsonObject components = response.get("components").getAsJsonObject();
        giveItemToPlayer(player,"the_idea_anvil:custom_item",components);
        context.getSource().method_9226(() -> class_2561.method_43470("Enjoy your item! "+value), true);
        return 1;
    }

    public static class ModComponents {
        protected static void initialize() {
            The_idea_anvil.LOGGER.info("Registering {} components", The_idea_anvil.MOD_ID);
            // Technically this method can stay empty, but some developers like to notify
            // the console, that certain parts of the mod have been successfully initialized
        }
        public static final class_9331<String> USE_CMD = class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(The_idea_anvil.MOD_ID, "use_cmd"),
            class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );

        public static final class_9331<String> POST_HIT_CMD = class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(The_idea_anvil.MOD_ID, "post_hit_cmd"),
            class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );

        public static final class_9331<String> POST_MINE_CMD = class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(The_idea_anvil.MOD_ID, "post_mine_cmd"),
            class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );

        public static final class_9331<String> INVENTORY_TICK_CMD = class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(The_idea_anvil.MOD_ID, "inventory_tick_cmd"),
            class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );

        public static final class_9331<String> USE_ON_BLOCK_CMD = class_2378.method_10230(
            class_7923.field_49658,
            class_2960.method_60655(The_idea_anvil.MOD_ID, "use_on_block_cmd"),
            class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880()
        );
    }

    public static class ModItems {
        public static void initialize() {
            ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062)
		    .register((itemGroup) -> itemGroup.method_45421(ModItems.CUSTOM_ITEM));
        }
        public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
            // Create the item key.
            class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(The_idea_anvil.MOD_ID, name));

            // Create the item instance.
            class_1792 item = itemFactory.apply(settings.method_63686(itemKey));

            // Register the item.
            class_2378.method_39197(class_7923.field_41178, itemKey, item);

            return item;
        }
        public static class CustomItem extends class_1792{
            public CustomItem(class_1793 settings) {
                super(settings);
            }
            public static String applyRegexes(String input, List<Pattern> patterns, List<String> replacements) {
                if (patterns.size() != replacements.size()) {
                    throw new IllegalArgumentException("Patterns and replacements must have the same size");
                }

                String result = input;
                for (int i = 0; i < patterns.size(); i++) {
                    result = patterns.get(i).matcher(result).replaceAll(replacements.get(i));
                }
                return result;
            }
            public String[] getCommands(String cmdc,String targetUUID, String selfUUID,String posX,String posY, String posZ){
                Pattern regexS=Pattern.compile("(?<!#)#s");
                Pattern regexT=Pattern.compile("(?<!#)#t");
                Pattern regexX=Pattern.compile("(?<!#)#x");
                Pattern regexY=Pattern.compile("(?<!#)#y");
                Pattern regexZ=Pattern.compile("(?<!#)#z");
                Pattern regexP=Pattern.compile("(?<!#)#p");
                List<Pattern> patterns = Arrays.asList(regexS,regexT,regexX,regexY,regexZ,regexP);
                List<String> replacements = Arrays.asList(selfUUID,targetUUID,posX,posY,posZ,posX+" "+posY+" "+posZ);
                String cmdc1 = applyRegexes(cmdc,patterns,replacements);
                return cmdc1.split("(?<!#)#/ *");
            }
            @Override
            public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
                if (world.field_9236) {
                    return class_1269.field_5811;
                }
                String userUUID = user.method_5845();
                String cmdc = user.method_5998(hand).method_58695(ModComponents.USE_CMD, "");
                if (cmdc.isEmpty()) {
                    return class_1269.field_5811;
                }

                String[] cmds = getCommands(cmdc, "", userUUID, "", "", "");
                executeCommands(cmds, user);

                return class_1269.field_5812;
            }

            @Override
            public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
                if (target.method_37908().method_8608()) {
                    return;
                }
                String targetUUID = target.method_5845();
                String attackerUUID = attacker.method_5845();
                String cmdc = stack.method_58695(ModComponents.POST_HIT_CMD, "");
                if (cmdc.isEmpty()) {
                    return;
                }

                String[] cmds = getCommands(cmdc, targetUUID, attackerUUID, "", "", "");
                executeCommands(cmds, attacker);
            }

            private void executeCommands(String[] commands, class_1297 executor) {
                try {
                    if (executor == null || executor.method_37908().method_8608()) {
                        return;
                    }

                    MinecraftServer server = executor.method_5682();
                    if (server == null) {
                        LOGGER.warn("Could not execute commands for entity {} because its server instance was null.", executor.method_5845());
                        return;
                    }

                    if (!(executor.method_37908() instanceof class_3218 serverWorld)) {
                        return;
                    }

                    // Step 1: Create the command source. This part was already correct.
                    // It provides the "who, where, and with what permission level" context.
                    class_2168 source = executor.method_5671(serverWorld).method_9206(2).method_9231(class_8935.field_47158);

                    // Step 2: Get the server's manager for functions.
                    var functionManager = server.method_3740();

                    // Step 3: Parse our command strings into a list of executable command actions.
                    // This uses the same parsing logic as real functions.
                    List<String> parsedCommands = Arrays.stream(commands)
                            .map(String::strip)
                            .filter(s -> !s.isEmpty())
                            .toList();

                    // Step 4: Create a temporary, in-memory function from our parsed commands.
                    // We give it a dummy ID as it's never registered.
                    var dynamicFunction = net.minecraft.class_2158.method_9195(
                            class_2960.method_60655(MOD_ID, "dynamic/" + java.util.UUID.randomUUID()),
                            source.method_54310(), source, parsedCommands
                    );

                    // Step 5: Execute the dynamic function using the function manager.
                    // This is the key step, as this method correctly creates the control-flow-aware context.
                    try {
                        functionManager.method_12904(dynamicFunction, source);
                    } catch (Exception e) {
                        // This will now properly catch any errors from within the commands themselves.
                        source.method_9213(class_2561.method_43470("An error occurred while running a command from the item."));
                        LOGGER.error("An unexpected error occurred executing dynamic function for entity {}", executor.method_5845(), e);
                    }
                }catch(Exception e){
                    LOGGER.error("An unexpected error (outer try-catch) occurred executing dynamic function for entity {}", executor.method_5845(), e);
                }
            }


            @Override
            public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
                class_9424 toolComponent = stack.method_58694(class_9334.field_50077);
                if (toolComponent != null) {
                    if (!world.field_9236 && state.method_26214(world, pos) != 0.0F && toolComponent.comp_2500() > 0) {
                        stack.method_7970(toolComponent.comp_2500(), miner, class_1304.field_6173);
                    }
                }

                if (!world.field_9236) {
                    String minerUUID = miner.method_5845();
                    String blockX = String.valueOf(pos.method_10263());
                    String blockY = String.valueOf(pos.method_10264());
                    String blockZ = String.valueOf(pos.method_10260());
                    String cmdc = stack.method_58695(ModComponents.POST_MINE_CMD, "");

                    if (!cmdc.isEmpty()) {
                        String[] cmds = getCommands(cmdc, "", minerUUID, blockX, blockY, blockZ);
                        executeCommands(cmds, miner);
                    }
                }
                return true;
}
        @Override
        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            String selfUUID = entity.method_5845();
            String cmdc = stack.method_58695(ModComponents.INVENTORY_TICK_CMD, "");
            if (cmdc.isEmpty()) {
                return;
            }

            String[] cmds = getCommands(cmdc, "", selfUUID, "", "", "");
            executeCommands(cmds, entity);
        }
        @Override
        public class_1269 method_7884(class_1838 context) {
            class_1657 player = context.method_8036();
            if (player == null || player.method_37908().field_9236) {
                return class_1269.field_5811;
            }

            String selfUUID = player.method_5845();
            String blockX = String.valueOf(context.method_8037().method_10263());
            String blockY = String.valueOf(context.method_8037().method_10264());
            String blockZ = String.valueOf(context.method_8037().method_10260());

            String cmdc = context.method_8041().method_58695(ModComponents.USE_ON_BLOCK_CMD, "");
            if (cmdc.isEmpty()) {
                return class_1269.field_5811;
            }

            String[] cmds = getCommands(cmdc, "", selfUUID, blockX, blockY, blockZ);
            executeCommands(cmds, player);
            return class_1269.field_5812;
        }

        }

        public static final class_1792 CUSTOM_ITEM = register("custom_item", CustomItem::new, new CustomItem.Settings());

    }

}
