/*
 * Decompiled with CFR 0.152.
 */
package org.tanjimkamal.the_idea_anvil;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2991;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8839;
import net.minecraft.class_8935;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class The_idea_anvil
implements ModInitializer {
    public static final String MOD_ID = "the_idea_anvil";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"the_idea_anvil");
    private static final String BASE_URL = "https://ai.hackclub.com/chat/completions";
    private static String sysprompt;

    private void loadSystemPrompt() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/sysprompt.md");
            if (inputStream == null) {
                throw new RuntimeException("sysprompt.md not found in resources");
            }
            sysprompt = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load sysprompt.md", e);
        }
    }

    private Object extractJsonFromResponse(String text, boolean returnText) {
        Pattern codePattern;
        Pattern jsonPattern = Pattern.compile("```json\\s*\\n([\\s\\S]*?)\\n```", 2);
        Matcher matcher = jsonPattern.matcher(text);
        if (matcher.find()) {
            String candidate = matcher.group(1).strip();
            try {
                return returnText ? candidate : JsonParser.parseString((String)candidate).getAsJsonObject();
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        if ((matcher = (codePattern = Pattern.compile("```[\\w+-]*\\n([\\s\\S]*?)\\n```")).matcher(text)).find()) {
            String candidate = matcher.group(1).strip();
            try {
                return returnText ? candidate : JsonParser.parseString((String)candidate).getAsJsonObject();
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        for (int idx = 0; idx < text.length(); ++idx) {
            String candidate;
            char ch = text.charAt(idx);
            if (ch != '{' && ch != '[' || (candidate = this.extractBalancedFrom(text, idx)) == null) continue;
            try {
                return returnText ? candidate : JsonParser.parseString((String)candidate).getAsJsonObject();
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("No valid JSON found in the provided text.");
    }

    private Object extractJsonFromResponse(String text) {
        return this.extractJsonFromResponse(text, false);
    }

    private String extractBalancedFrom(String text, int start) {
        Stack<Character> stack = new Stack<Character>();
        boolean inStr = false;
        boolean esc = false;
        for (int i = start; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (esc) {
                esc = false;
                continue;
            }
            if (ch == '\\') {
                esc = true;
                continue;
            }
            if (ch == '\"') {
                inStr = !inStr;
                continue;
            }
            if (inStr) continue;
            if (ch == '{') {
                stack.push(Character.valueOf('}'));
                continue;
            }
            if (ch == '[') {
                stack.push(Character.valueOf(']'));
                continue;
            }
            if (ch != '}' && ch != ']') continue;
            if (stack.isEmpty() || ch != ((Character)stack.peek()).charValue()) {
                return null;
            }
            stack.pop();
            if (!stack.isEmpty()) continue;
            return text.substring(start, i + 1);
        }
        return null;
    }

    public JsonObject getItem(String itemDesc) {
        try {
            String content;
            JsonObject requestBody = The_idea_anvil.getRequestBody(itemDesc);
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(BASE_URL)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody.toString())).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                JsonObject responseJson = JsonParser.parseString((String)response.body()).getAsJsonObject();
                System.out.println(responseJson.toString().substring(0, Math.min(100, responseJson.toString().length())));
                content = responseJson.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
                System.out.println(content);
            }
            return (JsonObject)this.extractJsonFromResponse(content);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to get item", e);
        }
    }

    @NotNull
    private static JsonObject getRequestBody(String itemDesc) {
        JsonObject requestBody = new JsonObject();
        JsonArray messages = new JsonArray();
        JsonObject systemMessage = new JsonObject();
        systemMessage.addProperty("role", "system");
        systemMessage.addProperty("content", sysprompt);
        messages.add((JsonElement)systemMessage);
        JsonObject userMessage = new JsonObject();
        userMessage.addProperty("role", "user");
        userMessage.addProperty("content", itemDesc);
        messages.add((JsonElement)userMessage);
        requestBody.add("messages", (JsonElement)messages);
        requestBody.addProperty("model", "moonshotai/kimi-k2-instruct-0905");
        requestBody.addProperty("temperature", (Number)0.1);
        return requestBody;
    }

    public void giveItemToPlayer(class_3222 player, String itemId, JsonElement components) {
        try {
            boolean success;
            class_2960 itemIdentifier = class_2960.method_60654((String)itemId);
            class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemIdentifier);
            class_1799 itemStack = new class_1799((class_1935)item);
            if (components != null && components.isJsonObject()) {
                DataResult result = class_9323.field_50234.parse((DynamicOps)JsonOps.INSTANCE, (Object)components);
                if (result.result().isPresent()) {
                    class_9323 componentMap = (class_9323)result.result().get();
                    itemStack.method_57365(componentMap);
                } else {
                    LOGGER.warn("Failed to parse components: {}", (Object)result.error().map(Object::toString).orElse("Unknown error"));
                    return;
                }
            }
            if (!(success = player.method_31548().method_7394(itemStack))) {
                player.method_7328(itemStack, false);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.toString());
        }
    }

    public void onInitialize() {
        ModItems.initialize();
        ModComponents.initialize();
        this.loadSystemPrompt();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"idea").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::ideaCommand))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"ai").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::ideaCommand))));
    }

    private int ideaCommand(CommandContext<class_2168> context) {
        JsonObject response;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Getting item..."), true);
        String value = StringArgumentType.getString(context, (String)"value");
        try {
            response = this.getItem(value);
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("An error occurred. Most likely, the AI thought your item was too OP or didn't understand you. You might want to try refining your prompt or adding OPERATOR to the start of your request." + value)), true);
            return 0;
        }
        if (!response.get("accepted").getAsBoolean()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Sorry, the AI determined your item is too OP or didn't understand you. You might want to try refining your prompt or adding OPERATOR to the start of your request." + value)), true);
            return 0;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        JsonObject components = response.get("components").getAsJsonObject();
        this.giveItemToPlayer(player, "the_idea_anvil:custom_item", (JsonElement)components);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Enjoy your item! " + value)), true);
        return 1;
    }

    public static class ModItems {
        public static final class_1792 CUSTOM_ITEM = ModItems.register("custom_item", CustomItem::new, new class_1792.class_1793());

        public static void initialize() {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41062).register(itemGroup -> itemGroup.method_45421((class_1935)CUSTOM_ITEM));
        }

        public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
            class_5321 itemKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)The_idea_anvil.MOD_ID, (String)name));
            class_1792 item = itemFactory.apply(settings.method_63686(itemKey));
            class_2378.method_39197((class_2378)class_7923.field_41178, (class_5321)itemKey, (Object)item);
            return item;
        }

        public static class CustomItem
        extends class_1792 {
            public CustomItem(class_1792.class_1793 settings) {
                super(settings);
            }

            public static String applyRegexes(String input, List<Pattern> patterns, List<String> replacements) {
                if (patterns.size() != replacements.size()) {
                    throw new IllegalArgumentException("Patterns and replacements must have the same size");
                }
                String result = input;
                for (int i = 0; i < patterns.size(); ++i) {
                    result = patterns.get(i).matcher(result).replaceAll(replacements.get(i));
                }
                return result;
            }

            public String[] getCommands(String cmdc, String targetUUID, String selfUUID, String posX, String posY, String posZ) {
                Pattern regexS = Pattern.compile("(?<!#)#s");
                Pattern regexT = Pattern.compile("(?<!#)#t");
                Pattern regexX = Pattern.compile("(?<!#)#x");
                Pattern regexY = Pattern.compile("(?<!#)#y");
                Pattern regexZ = Pattern.compile("(?<!#)#z");
                Pattern regexP = Pattern.compile("(?<!#)#p");
                List<Pattern> patterns = Arrays.asList(regexS, regexT, regexX, regexY, regexZ, regexP);
                List<String> replacements = Arrays.asList(selfUUID, targetUUID, posX, posY, posZ, posX + " " + posY + " " + posZ);
                String cmdc1 = CustomItem.applyRegexes(cmdc, patterns, replacements);
                return cmdc1.split("(?<!#)#/ *");
            }

            public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
                if (world.field_9236) {
                    return class_1269.field_5811;
                }
                String userUUID = user.method_5845();
                String cmdc = (String)user.method_5998(hand).method_58695(ModComponents.USE_CMD, (Object)"");
                if (cmdc.isEmpty()) {
                    return class_1269.field_5811;
                }
                String[] cmds = this.getCommands(cmdc, "", userUUID, "", "", "");
                this.executeCommands(cmds, (class_1297)user);
                return class_1269.field_5812;
            }

            public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
                if (target.method_37908().method_8608()) {
                    return;
                }
                String targetUUID = target.method_5845();
                String attackerUUID = attacker.method_5845();
                String cmdc = (String)stack.method_58695(ModComponents.POST_HIT_CMD, (Object)"");
                if (cmdc.isEmpty()) {
                    return;
                }
                String[] cmds = this.getCommands(cmdc, targetUUID, attackerUUID, "", "", "");
                this.executeCommands(cmds, (class_1297)attacker);
            }

            private void executeCommands(String[] commands, class_1297 executor) {
                try {
                    if (executor == null || executor.method_37908().method_8608()) {
                        return;
                    }
                    MinecraftServer server = executor.method_5682();
                    if (server == null) {
                        LOGGER.warn("Could not execute commands for entity {} because its server instance was null.", (Object)executor.method_5845());
                        return;
                    }
                    class_1937 class_19372 = executor.method_37908();
                    if (!(class_19372 instanceof class_3218)) {
                        return;
                    }
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_2168 source = executor.method_5671(serverWorld).method_9206(2).method_9231(class_8935.field_47158);
                    class_2991 functionManager = server.method_3740();
                    List<String> parsedCommands = Arrays.stream(commands).map(String::strip).filter(s -> !s.isEmpty()).toList();
                    class_2158 dynamicFunction = class_2158.method_9195((class_2960)class_2960.method_60655((String)The_idea_anvil.MOD_ID, (String)("dynamic/" + String.valueOf(UUID.randomUUID()))), (CommandDispatcher)source.method_54310(), (class_8839)source, parsedCommands);
                    try {
                        functionManager.method_12904(dynamicFunction, source);
                    }
                    catch (Exception e) {
                        source.method_9213((class_2561)class_2561.method_43470((String)"An error occurred while running a command from the item."));
                        LOGGER.error("An unexpected error occurred executing dynamic function for entity {}", (Object)executor.method_5845(), (Object)e);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An unexpected error (outer try-catch) occurred executing dynamic function for entity {}", (Object)executor.method_5845(), (Object)e);
                }
            }

            public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
                class_9424 toolComponent = (class_9424)stack.method_58694(class_9334.field_50077);
                if (toolComponent != null && !world.field_9236 && state.method_26214((class_1922)world, pos) != 0.0f && toolComponent.comp_2500() > 0) {
                    stack.method_7970(toolComponent.comp_2500(), miner, class_1304.field_6173);
                }
                if (!world.field_9236) {
                    String minerUUID = miner.method_5845();
                    String blockX = String.valueOf(pos.method_10263());
                    String blockY = String.valueOf(pos.method_10264());
                    String blockZ = String.valueOf(pos.method_10260());
                    String cmdc = (String)stack.method_58695(ModComponents.POST_MINE_CMD, (Object)"");
                    if (!cmdc.isEmpty()) {
                        String[] cmds = this.getCommands(cmdc, "", minerUUID, blockX, blockY, blockZ);
                        this.executeCommands(cmds, (class_1297)miner);
                    }
                }
                return true;
            }

            public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
                String selfUUID = entity.method_5845();
                String cmdc = (String)stack.method_58695(ModComponents.INVENTORY_TICK_CMD, (Object)"");
                if (cmdc.isEmpty()) {
                    return;
                }
                String[] cmds = this.getCommands(cmdc, "", selfUUID, "", "", "");
                this.executeCommands(cmds, entity);
            }

            public class_1269 method_7884(class_1838 context) {
                class_1657 player = context.method_8036();
                if (player == null || player.method_37908().field_9236) {
                    return class_1269.field_5811;
                }
                String selfUUID = player.method_5845();
                String blockX = String.valueOf(context.method_8037().method_10263());
                String blockY = String.valueOf(context.method_8037().method_10264());
                String blockZ = String.valueOf(context.method_8037().method_10260());
                String cmdc = (String)context.method_8041().method_58695(ModComponents.USE_ON_BLOCK_CMD, (Object)"");
                if (cmdc.isEmpty()) {
                    return class_1269.field_5811;
                }
                String[] cmds = this.getCommands(cmdc, "", selfUUID, blockX, blockY, blockZ);
                this.executeCommands(cmds, (class_1297)player);
                return class_1269.field_5812;
            }
        }
    }

    public static class ModComponents {
        public static final class_9331<String> USE_CMD = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"the_idea_anvil", (String)"use_cmd"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());
        public static final class_9331<String> POST_HIT_CMD = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"the_idea_anvil", (String)"post_hit_cmd"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());
        public static final class_9331<String> POST_MINE_CMD = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"the_idea_anvil", (String)"post_mine_cmd"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());
        public static final class_9331<String> INVENTORY_TICK_CMD = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"the_idea_anvil", (String)"inventory_tick_cmd"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());
        public static final class_9331<String> USE_ON_BLOCK_CMD = (class_9331)class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)class_2960.method_60655((String)"the_idea_anvil", (String)"use_on_block_cmd"), (Object)class_9331.method_57873().method_57881((Codec)Codec.STRING).method_57880());

        protected static void initialize() {
            LOGGER.info("Registering {} components", (Object)The_idea_anvil.MOD_ID);
        }
    }
}

