/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.enchantingcommands_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.enchantingcommands_common_neoforge.config.ConfigHandler;
import com.natamus.enchantingcommands_common_neoforge.util.Util;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class CommandEc {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)ConfigHandler.enchantCommandString).requires(iCommandSender -> iCommandSender.hasPermission(2))).executes(command -> {
            CommandEc.sendUsage((CommandSourceStack)command.getSource());
            return 1;
        })).then(Commands.literal((String)"list").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            String joined = String.join((CharSequence)", ", Util.getEnchantmentKeys((Level)source.getLevel()));
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"--- Enchanting Commands List ---", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" " + joined), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))).then(Commands.literal((String)"enchant").then(Commands.argument((String)"enchantment", (ArgumentType)ResourceArgument.resource((CommandBuildContext)commandBuildContext, (ResourceKey)Registries.ENCHANTMENT)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)127)).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            Entity entity = source.getEntity();
            if (!(entity instanceof ServerPlayer)) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            ServerPlayer player = (ServerPlayer)entity;
            Registry enchantmentRegistry = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            ItemStack held = player.getMainHandItem();
            Enchantment enchantment = (Enchantment)ResourceArgument.getEnchantment((CommandContext)command, (String)"enchantment").value();
            int level = IntegerArgumentType.getInteger((CommandContext)command, (String)"level");
            if (!player.hasItemInSlot(EquipmentSlot.MAINHAND)) {
                MessageFunctions.sendMessage((Player)player, (String)"You do not have an enchantable item in your main hand.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            ItemEnchantments heldItemEnchantments = held.getEnchantments();
            boolean removed = false;
            for (Object2IntMap.Entry holderEntry : heldItemEnchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)holderEntry.getKey();
                Enchantment heldEnchantment = (Enchantment)enchantmentHolder.value();
                if (!heldEnchantment.equals((Object)enchantment)) continue;
                ItemEnchantments.Mutable heldItemEnchantmentsMutable = new ItemEnchantments.Mutable(heldItemEnchantments);
                heldItemEnchantmentsMutable.set(enchantmentRegistry.wrapAsHolder((Object)heldEnchantment), 0);
                held.set(DataComponents.ENCHANTMENTS, (Object)heldItemEnchantmentsMutable.toImmutable());
                removed = true;
                break;
            }
            String enchantmentname = enchantmentRegistry.getKey((Object)enchantment).getPath();
            if (level != 0) {
                held.enchant(enchantmentRegistry.wrapAsHolder((Object)enchantment), level);
                MessageFunctions.sendMessage((Player)player, (String)("The enchantment '" + enchantmentname + "' has been added to the item with a level of " + level + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            } else if (removed) {
                MessageFunctions.sendMessage((Player)player, (String)("The enchantment '" + enchantmentname + "' has been removed from the item."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            } else {
                MessageFunctions.sendMessage((Player)player, (String)("The enchantment '" + enchantmentname + "' does not exist on the item."), (ChatFormatting)ChatFormatting.RED);
            }
            return 1;
        })))));
    }

    public static void sendUsage(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"--- Enchanting Commands Usage ---", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" /" + ConfigHandler.enchantCommandString + " list"), (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)(" /" + ConfigHandler.enchantCommandString + " enchant <enchant> <lvl>"), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    public static void sendUsage(Player player) {
        MessageFunctions.sendMessage((Player)player, (String)"--- Enchanting Commands Usage ---", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((Player)player, (String)(" /" + ConfigHandler.enchantCommandString + " list"), (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((Player)player, (String)(" /" + ConfigHandler.enchantCommandString + " enchant <enchant> <lvl>"), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }
}

