/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles;

import fr.ax_dev.universeProfiles.cache.PlaceholderCacheManager;
import fr.ax_dev.universeProfiles.commands.ProfileCommand;
import fr.ax_dev.universeProfiles.config.ConfigManager;
import fr.ax_dev.universeProfiles.config.GuiConfigManager;
import fr.ax_dev.universeProfiles.config.LanguageManager;
import fr.ax_dev.universeProfiles.database.DatabaseManager;
import fr.ax_dev.universeProfiles.database.DatabaseType;
import fr.ax_dev.universeProfiles.integrations.ECosmeticsIntegration;
import fr.ax_dev.universeProfiles.integrations.HMCCosmeticsIntegration;
import fr.ax_dev.universeProfiles.listeners.PlayerListener;
import fr.ax_dev.universeProfiles.managers.ProfileManager;
import fr.ax_dev.universeProfiles.placeholders.ProfilePlaceholderExpansion;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class UniverseProfiles
extends JavaPlugin {
    private static UniverseProfiles instance;
    private ConfigManager configManager;
    private GuiConfigManager guiConfigManager;
    private LanguageManager languageManager;
    private DatabaseManager databaseManager;
    private ProfileManager profileManager;
    private PlaceholderCacheManager placeholderCacheManager;
    private HMCCosmeticsIntegration hmcCosmeticsIntegration;
    private ECosmeticsIntegration eCosmeticsIntegration;

    public void onEnable() {
        instance = this;
        this.loadManagers();
        this.registerCommands();
        this.registerListeners();
        this.registerPlaceholders();
        this.registerIntegrations();
        this.getLogger().info("UniverseProfiles enabled!");
    }

    public void onDisable() {
        if (this.profileManager != null) {
            this.profileManager.saveAllProfiles();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.placeholderCacheManager != null) {
            this.placeholderCacheManager.close();
        }
        if (this.databaseManager != null) {
            this.databaseManager.close();
        }
        this.getLogger().info("UniverseProfiles disabled!");
    }

    private void loadManagers() {
        this.configManager = new ConfigManager(this);
        this.guiConfigManager = new GuiConfigManager(this);
        this.languageManager = new LanguageManager(this);
        DatabaseType dbType = DatabaseType.valueOf(this.configManager.getConfig().getString("database.type", "SQLITE").toUpperCase());
        this.databaseManager = new DatabaseManager(this, dbType);
        this.databaseManager.initialize();
        this.profileManager = new ProfileManager(this);
        this.placeholderCacheManager = new PlaceholderCacheManager(this);
    }

    private void registerCommands() {
        ProfileCommand profileCommand = new ProfileCommand(this);
        this.getCommand("profile").setExecutor((CommandExecutor)profileCommand);
        this.getCommand("profile").setTabCompleter((TabCompleter)profileCommand);
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
    }

    private void registerPlaceholders() {
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new ProfilePlaceholderExpansion(this).register();
        }
    }

    private void registerIntegrations() {
        String cosmeticPlugin = this.getConfig().getString("settings.cosmetics_plugin", "NONE");
        if (cosmeticPlugin.equalsIgnoreCase("HMCCOSMETICS")) {
            this.hmcCosmeticsIntegration = new HMCCosmeticsIntegration(this);
        } else if (cosmeticPlugin.equalsIgnoreCase("ECOSMETICS")) {
            this.eCosmeticsIntegration = new ECosmeticsIntegration(this);
        } else {
            this.getLogger().info("No cosmetics plugin integration enabled");
        }
    }

    public void reload() {
        this.configManager.reload();
        this.guiConfigManager.reload();
        this.languageManager.reload();
        if (this.profileManager != null) {
            this.profileManager.clearCache();
        }
        this.registerIntegrations();
    }

    public static UniverseProfiles getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public GuiConfigManager getGuiConfigManager() {
        return this.guiConfigManager;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public HMCCosmeticsIntegration getHMCCosmeticsIntegration() {
        return this.hmcCosmeticsIntegration;
    }

    public ECosmeticsIntegration getECosmeticsIntegration() {
        return this.eCosmeticsIntegration;
    }

    public Object getCosmeticsIntegration() {
        if (this.hmcCosmeticsIntegration != null && this.hmcCosmeticsIntegration.isEnabled()) {
            return this.hmcCosmeticsIntegration;
        }
        if (this.eCosmeticsIntegration != null && this.eCosmeticsIntegration.isEnabled()) {
            return this.eCosmeticsIntegration;
        }
        return null;
    }

    public PlaceholderCacheManager getPlaceholderCacheManager() {
        return this.placeholderCacheManager;
    }
}

