/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.cache;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlaceholderCacheManager {
    private final UniverseProfiles plugin;
    private Connection connection;
    private final List<String> cachedPlaceholders;

    public PlaceholderCacheManager(UniverseProfiles plugin) {
        this.plugin = plugin;
        this.cachedPlaceholders = plugin.getConfig().getStringList("settings.cached_placeholders");
        this.initialize();
    }

    private void initialize() {
        try {
            File dataFolder = this.plugin.getDataFolder();
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            File dbFile = new File(dataFolder, "placeholder_cache.db");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS placeholder_cache (uuid TEXT NOT NULL, placeholder TEXT NOT NULL, value TEXT, updated_at INTEGER, PRIMARY KEY (uuid, placeholder))");
            }
            this.plugin.getLogger().info("PlaceholderCacheManager initialized with " + this.cachedPlaceholders.size() + " placeholders");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to initialize placeholder cache: " + e.getMessage());
        }
    }

    public void cachePlaceholders(UUID uuid, Player player) {
        if (this.cachedPlaceholders.isEmpty()) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            return;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (String placeholder : this.cachedPlaceholders) {
            String value = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            values.put(placeholder, value);
        }
        this.savePlaceholders(uuid, values);
    }

    private void savePlaceholders(UUID uuid, Map<String, String> values) {
        try (PreparedStatement stmt = this.connection.prepareStatement("INSERT OR REPLACE INTO placeholder_cache (uuid, placeholder, value, updated_at) VALUES (?, ?, ?, ?)");){
            long timestamp = System.currentTimeMillis();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                stmt.setString(1, uuid.toString());
                stmt.setString(2, entry.getKey());
                stmt.setString(3, entry.getValue());
                stmt.setLong(4, timestamp);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to save placeholders: " + e.getMessage());
        }
    }

    public String getPlaceholder(UUID uuid, String placeholder, Player fallbackPlayer) {
        String cached = this.getCachedPlaceholder(uuid, placeholder);
        if (cached != null) {
            return cached;
        }
        if (fallbackPlayer != null && fallbackPlayer.isOnline() && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            return PlaceholderAPI.setPlaceholders((Player)fallbackPlayer, (String)placeholder);
        }
        return placeholder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCachedPlaceholder(UUID uuid, String placeholder) {
        try (PreparedStatement stmt = this.connection.prepareStatement("SELECT value FROM placeholder_cache WHERE uuid = ? AND placeholder = ?");){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, placeholder);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return null;
                String string = rs.getString("value");
                return string;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to get cached placeholder: " + e.getMessage());
        }
        return null;
    }

    public void clearCache(UUID uuid) {
        try (PreparedStatement stmt = this.connection.prepareStatement("DELETE FROM placeholder_cache WHERE uuid = ?");){
            stmt.setString(1, uuid.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to clear cache: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to close placeholder cache: " + e.getMessage());
        }
    }
}

