/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.config;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuiConfigManager {
    private final UniverseProfiles plugin;
    private FileConfiguration guiConfig;
    private File guiFile;

    public GuiConfigManager(UniverseProfiles plugin) {
        this.plugin = plugin;
        this.loadGuiConfig();
    }

    private void loadGuiConfig() {
        this.guiFile = new File(this.plugin.getDataFolder(), "gui.yml");
        if (!this.guiFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                InputStream inputStream = this.plugin.getResource("gui.yml");
                if (inputStream != null) {
                    Files.copy(inputStream, this.guiFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Created gui.yml from resources");
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create gui.yml file: " + e.getMessage());
            }
        }
        this.guiConfig = YamlConfiguration.loadConfiguration((File)this.guiFile);
        this.plugin.getLogger().info("Loaded gui.yml with " + this.guiConfig.getKeys(false).size() + " root keys");
    }

    public void reload() {
        try {
            this.guiConfig = YamlConfiguration.loadConfiguration((File)this.guiFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u00a7cErreur lors du rechargement de gui.yml: " + e.getMessage());
            throw new RuntimeException("Erreur lors du rechargement de gui.yml", e);
        }
    }

    public FileConfiguration getConfig() {
        return this.guiConfig;
    }

    public String getTitle() {
        return this.guiConfig.getString("title", "Profile");
    }

    public int getSize() {
        return this.guiConfig.getInt("size", 54);
    }

    public ConfigurationSection getEquipments() {
        return this.guiConfig.getConfigurationSection("equipments");
    }

    public ConfigurationSection getCustomItems() {
        return this.guiConfig.getConfigurationSection("customs_items");
    }

    public ConfigurationSection getCustomItem(String itemName) {
        ConfigurationSection customs = this.getCustomItems();
        return customs != null ? customs.getConfigurationSection(itemName) : null;
    }

    public void updateFromResources() {
        if (this.guiFile.exists()) {
            this.guiFile.delete();
            this.plugin.getLogger().info("Deleted old gui.yml");
        }
        this.loadGuiConfig();
    }

    public String getString(String path, String def) {
        return this.guiConfig.getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.guiConfig.getInt(path, def);
    }

    public List<String> getStringList(String path) {
        return this.guiConfig.getStringList(path);
    }
}

