/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.integrations;

import com.hibiscusmc.hmccosmetics.api.HMCCosmeticsAPI;
import com.hibiscusmc.hmccosmetics.api.events.PlayerCosmeticEquipEvent;
import com.hibiscusmc.hmccosmetics.api.events.PlayerCosmeticRemoveEvent;
import com.hibiscusmc.hmccosmetics.cosmetic.Cosmetic;
import com.hibiscusmc.hmccosmetics.cosmetic.CosmeticSlot;
import com.hibiscusmc.hmccosmetics.user.CosmeticUser;
import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HMCCosmeticsIntegration
implements Listener {
    private final UniverseProfiles plugin;
    private boolean enabled = false;

    public HMCCosmeticsIntegration(UniverseProfiles plugin) {
        this.plugin = plugin;
        if (Bukkit.getPluginManager().getPlugin("HMCCosmetics") != null) {
            this.enabled = true;
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            plugin.getLogger().info("HMCCosmetics integration enabled!");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Cosmetic> getPlayerCosmetics(Player player) {
        if (!this.enabled) {
            return new ArrayList<Cosmetic>();
        }
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            return new ArrayList<Cosmetic>();
        }
        try {
            Object cosmetics = user.getClass().getMethod("getCosmetics", new Class[0]).invoke((Object)user, new Object[0]);
            if (cosmetics instanceof Map) {
                return new ArrayList<Cosmetic>(((Map)cosmetics).values());
            }
            if (cosmetics instanceof Collection) {
                return new ArrayList<Cosmetic>((Collection)cosmetics);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to get cosmetics: " + e.getMessage());
        }
        return new ArrayList<Cosmetic>();
    }

    public List<String> getEquippedCosmetics(Player player) {
        if (!this.enabled) {
            return new ArrayList<String>();
        }
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> equipped = new ArrayList<String>();
        for (Cosmetic cosmetic : this.getPlayerCosmetics(player)) {
            equipped.add(cosmetic.getId());
        }
        return equipped;
    }

    public Map<String, List<String>> getCosmeticsByType(Player player) {
        if (!this.enabled) {
            return new HashMap<String, List<String>>();
        }
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> cosmeticsByType = new HashMap<String, List<String>>();
        for (Cosmetic cosmetic : this.getPlayerCosmetics(player)) {
            String type = cosmetic.getSlot().name();
            cosmeticsByType.computeIfAbsent(type, k -> new ArrayList()).add(cosmetic.getId());
        }
        return cosmeticsByType;
    }

    public boolean hasCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        for (Cosmetic cosmetic : this.getPlayerCosmetics(player)) {
            if (!cosmetic.getId().equals(cosmeticId)) continue;
            return true;
        }
        return false;
    }

    public boolean equipCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            return false;
        }
        Cosmetic cosmetic = HMCCosmeticsAPI.getCosmetic((String)cosmeticId);
        if (cosmetic == null) {
            return false;
        }
        if (!this.hasCosmetic(player, cosmeticId)) {
            return false;
        }
        HMCCosmeticsAPI.equipCosmetic((CosmeticUser)user, (Cosmetic)cosmetic);
        return true;
    }

    public boolean unequipCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            return false;
        }
        Cosmetic cosmetic = HMCCosmeticsAPI.getCosmetic((String)cosmeticId);
        if (cosmetic == null) {
            return false;
        }
        HMCCosmeticsAPI.unequipCosmetic((CosmeticUser)user, (Cosmetic)cosmetic);
        return true;
    }

    @EventHandler
    public void onCosmeticEquip(PlayerCosmeticEquipEvent event) {
        Player player = event.getUser().getPlayer();
        if (player != null) {
            this.plugin.getProfileManager().updateProfile(player);
        }
    }

    @EventHandler
    public void onCosmeticRemove(PlayerCosmeticRemoveEvent event) {
        Player player = event.getUser().getPlayer();
        if (player != null) {
            this.plugin.getProfileManager().updateProfile(player);
        }
    }

    public int getTotalCosmeticsCount(Player player) {
        if (!this.enabled) {
            return 0;
        }
        return this.getPlayerCosmetics(player).size();
    }

    public String getCosmeticDisplayName(String cosmeticId) {
        if (!this.enabled) {
            return cosmeticId;
        }
        Cosmetic cosmetic = HMCCosmeticsAPI.getCosmetic((String)cosmeticId);
        if (cosmetic == null) {
            return cosmeticId;
        }
        return cosmetic.getDisplayName();
    }

    public ItemStack getCosmeticItemBySlot(Player player, String slotName) {
        if (!this.enabled) {
            return null;
        }
        boolean debug = this.plugin.getConfig().getBoolean("settings.debug", false);
        CosmeticUser user = HMCCosmeticsAPI.getUser((UUID)player.getUniqueId());
        if (user == null) {
            if (debug) {
                this.plugin.getLogger().info("[HMC] CosmeticUser is null for player: " + player.getName());
            }
            return null;
        }
        List<Cosmetic> cosmetics = this.getPlayerCosmetics(player);
        if (debug) {
            this.plugin.getLogger().info("[HMC] Player " + player.getName() + " has " + cosmetics.size() + " cosmetics");
        }
        for (Cosmetic cosmetic : cosmetics) {
            try {
                CosmeticSlot slot = cosmetic.getSlot();
                String slotNameStr = null;
                try {
                    slotNameStr = (String)slot.getClass().getMethod("name", new Class[0]).invoke((Object)slot, new Object[0]);
                }
                catch (Exception e1) {
                    slotNameStr = slot.toString();
                }
                if (debug) {
                    this.plugin.getLogger().info("[HMC] Checking cosmetic: " + cosmetic.getId() + " with slot: " + slotNameStr);
                }
                if (slotNameStr == null || !slotNameStr.equals(slotName)) continue;
                if (debug) {
                    this.plugin.getLogger().info("[HMC] Found matching cosmetic: " + cosmetic.getId());
                }
                try {
                    Object item = cosmetic.getClass().getMethod("getItem", new Class[0]).invoke((Object)cosmetic, new Object[0]);
                    if (!(item instanceof ItemStack)) continue;
                    ItemStack itemStack = (ItemStack)item;
                    if (debug) {
                        this.plugin.getLogger().info("[HMC] Cosmetic item type: " + String.valueOf(itemStack.getType()));
                    }
                    return itemStack;
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("[HMC] Failed to get cosmetic item: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[HMC] Failed to process cosmetic: " + e.getMessage());
            }
        }
        if (debug) {
            this.plugin.getLogger().info("[HMC] No cosmetic found for slot: " + slotName);
        }
        return null;
    }
}

