/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.listeners;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import fr.ax_dev.universeProfiles.models.PlayerProfile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final UniverseProfiles plugin;

    public PlayerListener(UniverseProfiles plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.getProfileManager().getProfile(event.getPlayer().getUniqueId()).thenAccept(profile -> {
            profile.updateFromPlayer(event.getPlayer());
            this.plugin.getProfileManager().saveProfile((PlayerProfile)profile);
        });
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getProfileManager().updateProfile(event.getPlayer());
        this.plugin.getPlaceholderCacheManager().cachePlaceholders(event.getPlayer().getUniqueId(), event.getPlayer());
        if (this.plugin.getConfigManager().getBoolean("settings.cache_offline_players", true)) {
            return;
        }
        this.plugin.getProfileManager().unloadProfile(event.getPlayer().getUniqueId());
    }
}

