/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.managers;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import fr.ax_dev.universeProfiles.models.PlayerProfile;
import fr.ax_dev.universeProfiles.util.SchedulerUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProfileManager {
    private final UniverseProfiles plugin;
    private final Map<UUID, PlayerProfile> profileCache;

    public ProfileManager(UniverseProfiles plugin) {
        this.plugin = plugin;
        this.profileCache = new ConcurrentHashMap<UUID, PlayerProfile>();
        this.startAutoSaveTask();
    }

    private void startAutoSaveTask() {
        int saveInterval = this.plugin.getConfigManager().getInt("settings.save_interval_minutes", 5) * 20 * 60;
        SchedulerUtil.runTaskTimerAsynchronously((Plugin)this.plugin, this::saveAllProfiles, saveInterval, saveInterval);
    }

    public CompletableFuture<PlayerProfile> getProfile(UUID uuid) {
        if (this.profileCache.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.profileCache.get(uuid));
        }
        return this.plugin.getDatabaseManager().loadProfile(uuid).thenApply(profile -> {
            if (profile == null) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                String name = offlinePlayer.getName() != null ? offlinePlayer.getName() : "Unknown";
                profile = new PlayerProfile(uuid, name);
            }
            this.profileCache.put(uuid, (PlayerProfile)profile);
            return profile;
        });
    }

    public PlayerProfile getCachedProfile(UUID uuid) {
        return this.profileCache.get(uuid);
    }

    public void updateProfile(Player player) {
        this.getProfile(player.getUniqueId()).thenAccept(profile -> {
            profile.updateFromPlayer(player);
            this.saveProfile((PlayerProfile)profile);
        });
    }

    public void saveProfile(PlayerProfile profile) {
        this.plugin.getDatabaseManager().saveProfile(profile);
    }

    public void saveAllProfiles() {
        this.profileCache.values().forEach(this::saveProfile);
    }

    public void unloadProfile(UUID uuid) {
        PlayerProfile profile = this.profileCache.remove(uuid);
        if (profile != null) {
            this.saveProfile(profile);
        }
    }

    public boolean canViewProfile(Player viewer, UUID targetUuid) {
        if (viewer.getUniqueId().equals(targetUuid)) {
            return true;
        }
        if (viewer.hasPermission("uprofiles.private.bypass")) {
            return true;
        }
        PlayerProfile profile = this.profileCache.get(targetUuid);
        if (profile != null) {
            return profile.isPublic();
        }
        return true;
    }

    public void togglePrivacy(Player player) {
        this.getProfile(player.getUniqueId()).thenAccept(profile -> {
            profile.setPublic(!profile.isPublic());
            this.saveProfile((PlayerProfile)profile);
            String messageKey = profile.isPublic() ? "messages.profile_now_public" : "messages.profile_now_private";
            this.plugin.getLanguageManager().sendMessage(player, messageKey);
        });
    }

    public void setPrivacy(UUID uuid, boolean isPublic) {
        this.getProfile(uuid).thenAccept(profile -> {
            profile.setPublic(isPublic);
            this.saveProfile((PlayerProfile)profile);
        });
    }

    public void giveStar(Player giver, UUID receiver) {
        if (giver.getUniqueId().equals(receiver) && !this.plugin.getConfigManager().getBoolean("settings.allow_self_star", false)) {
            this.plugin.getLanguageManager().sendMessage(giver, "messages.cannot_star_self");
            return;
        }
        this.getProfile(receiver).thenAccept(profile -> {
            if (!profile.canReceiveStarFrom(giver.getUniqueId())) {
                this.plugin.getLanguageManager().sendMessage(giver, "messages.already_starred");
                return;
            }
            profile.addStar(giver.getUniqueId());
            this.saveProfile((PlayerProfile)profile);
            Map<String, String> placeholders = Map.of("%player%", profile.getPlayerName());
            this.plugin.getLanguageManager().sendMessage(giver, "messages.star_given", placeholders);
            Player target = Bukkit.getPlayer((UUID)receiver);
            if (target != null && target.isOnline()) {
                Map<String, String> targetPlaceholders = Map.of("%player%", giver.getName());
                this.plugin.getLanguageManager().sendMessage(target, "messages.star_received", targetPlaceholders);
            }
        });
    }

    public void addStars(UUID uuid, int amount) {
        this.getProfile(uuid).thenAccept(profile -> {
            profile.setStars(profile.getStars() + amount);
            this.saveProfile((PlayerProfile)profile);
        });
    }

    public void clearCache() {
        this.saveAllProfiles();
        this.profileCache.clear();
    }
}

