/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.config;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final UniverseProfiles plugin;
    private FileConfiguration config;

    public ConfigManager(UniverseProfiles plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
    }

    public void reload() {
        try {
            this.plugin.reloadConfig();
            this.config = this.plugin.getConfig();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u00a7cErreur lors du rechargement de config.yml: " + e.getMessage());
            throw new RuntimeException("Erreur lors du rechargement de config.yml", e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }
}

