/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.gui;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import fr.ax_dev.universeProfiles.integrations.ECosmeticsIntegration;
import fr.ax_dev.universeProfiles.integrations.HMCCosmeticsIntegration;
import fr.ax_dev.universeProfiles.models.PlayerProfile;
import fr.ax_dev.universeProfiles.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class ProfileGUI
implements InventoryHolder,
Listener {
    private final UniverseProfiles plugin;
    private final Player viewer;
    private final PlayerProfile profile;
    private final Inventory inventory;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ProfileGUI(UniverseProfiles plugin, Player viewer, PlayerProfile profile) {
        this.plugin = plugin;
        this.viewer = viewer;
        this.profile = profile;
        Player profileOwner = Bukkit.getPlayer((UUID)profile.getUuid());
        if (profileOwner != null && profileOwner.isOnline()) {
            profile.updateFromPlayer(profileOwner);
        }
        String title = plugin.getGuiConfigManager().getTitle().replace("%player_name%", profile.getPlayerName());
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            title = PlaceholderAPI.setPlaceholders((Player)viewer, (String)title);
        }
        int size = plugin.getGuiConfigManager().getSize();
        this.inventory = InventoryUtil.createInventory(this, size, this.miniMessage.deserialize(title));
        this.setupItems();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void setupItems() {
        this.setupEquipmentItems();
        this.setupCustomItems();
    }

    private void setupEquipmentItems() {
        ConfigurationSection equipments = this.plugin.getGuiConfigManager().getEquipments();
        if (equipments == null) {
            return;
        }
        for (String equipmentType : equipments.getKeys(false)) {
            int slot;
            ConfigurationSection equipment = equipments.getConfigurationSection(equipmentType);
            if (equipment == null || (slot = equipment.getInt("slot", -1)) == -1) continue;
            ItemStack equipmentItem = this.getEquipmentItem(equipmentType);
            if (equipmentItem != null) {
                this.inventory.setItem(slot, equipmentItem);
                continue;
            }
            this.setupEmptyEquipment(equipment, slot, equipmentType);
        }
    }

    private void setupEmptyEquipment(ConfigurationSection equipment, int slot, String equipmentType) {
        ConfigurationSection emptyConfig = equipment.getConfigurationSection("empty_config");
        if (emptyConfig == null) {
            ItemStack emptySlot = new ItemStack(Material.BARRIER);
            ItemMeta meta = emptySlot.getItemMeta();
            InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white><gray>" + equipmentType + "</gray>"));
            InventoryUtil.setLore(meta, List.of(this.miniMessage.deserialize("<!italic><white><gray>Empty</gray>")));
            emptySlot.setItemMeta(meta);
            this.inventory.setItem(slot, emptySlot);
            return;
        }
        Material material = Material.valueOf((String)emptyConfig.getString("material", "BARRIER"));
        String displayName = emptyConfig.getString("display_name", "<gray>" + equipmentType + "</gray>");
        List lore = emptyConfig.getStringList("lore");
        int customModelData = emptyConfig.getInt("custom_model_data", 0);
        boolean hideTooltip = emptyConfig.getBoolean("hideTooltip", false);
        ItemStack emptySlot = new ItemStack(material);
        ItemMeta meta = emptySlot.getItemMeta();
        if (!hideTooltip) {
            InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white>" + displayName));
            if (!lore.isEmpty()) {
                ArrayList<Component> finalLore = new ArrayList<Component>();
                for (String line : lore) {
                    finalLore.add((Component)this.miniMessage.deserialize("<!italic><white>" + line));
                }
                InventoryUtil.setLore(meta, finalLore);
            }
        } else {
            try {
                meta.setHideTooltip(hideTooltip);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        emptySlot.setItemMeta(meta);
        this.inventory.setItem(slot, emptySlot);
    }

    private ItemStack getEquipmentItem(String equipmentType) {
        return switch (equipmentType) {
            case "helmet" -> {
                if (this.profile.getArmorContents() != null) {
                    yield this.profile.getArmorContents()[3];
                }
                yield null;
            }
            case "chestplate" -> {
                if (this.profile.getArmorContents() != null) {
                    yield this.profile.getArmorContents()[2];
                }
                yield null;
            }
            case "leggings" -> {
                if (this.profile.getArmorContents() != null) {
                    yield this.profile.getArmorContents()[1];
                }
                yield null;
            }
            case "boots" -> {
                if (this.profile.getArmorContents() != null) {
                    yield this.profile.getArmorContents()[0];
                }
                yield null;
            }
            case "main_hand" -> this.profile.getMainHand();
            case "off_hand" -> this.profile.getOffHand();
            default -> null;
        };
    }

    private void setupCustomItems() {
        ConfigurationSection customItems = this.plugin.getGuiConfigManager().getCustomItems();
        if (customItems == null) {
            this.plugin.getLogger().warning("customs_items section not found in gui.yml");
            return;
        }
        this.plugin.getLogger().info("Found " + customItems.getKeys(false).size() + " custom items");
        for (String key : customItems.getKeys(false)) {
            this.plugin.getLogger().info("Processing custom item: " + key);
            ConfigurationSection item = customItems.getConfigurationSection(key);
            if (item == null) {
                this.plugin.getLogger().warning("Could not get configuration for item: " + key);
                continue;
            }
            if (!this.canViewItem(item)) {
                this.plugin.getLogger().info("Item " + key + " hidden by view requirements");
                continue;
            }
            this.plugin.getLogger().info("Item " + key + " - has your_slot: " + item.contains("your_slot") + ", slot: " + item.getInt("slot", -1));
            if (item.contains("your_slot")) {
                this.setupInventorySlot(item);
                continue;
            }
            if (item.contains("type")) {
                this.setupCosmeticItem(item);
                continue;
            }
            this.setupActionItem(item);
        }
    }

    private boolean canViewItem(ConfigurationSection item) {
        ConfigurationSection viewReqs = item.getConfigurationSection("view_requirements");
        if (viewReqs == null) {
            return true;
        }
        for (String reqKey : viewReqs.getKeys(false)) {
            boolean result;
            ConfigurationSection req = viewReqs.getConfigurationSection(reqKey);
            if (req == null) continue;
            String placeholder = req.getString("placeholder", "");
            String operation = req.getString("operation", "equals");
            String value = req.getString("value", "");
            if (placeholder.isEmpty()) continue;
            String actualValue = "";
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                actualValue = PlaceholderAPI.setPlaceholders((Player)this.viewer, (String)placeholder);
            }
            if (result = (switch (operation) {
                case "equals" -> actualValue.equals(value);
                case "not_equals" -> {
                    if (!actualValue.equals(value)) {
                        yield true;
                    }
                    yield false;
                }
                case "contains" -> actualValue.contains(value);
                case "starts_with" -> actualValue.startsWith(value);
                case "ends_with" -> actualValue.endsWith(value);
                default -> false;
            })) continue;
            return false;
        }
        return true;
    }

    private void setupInventorySlot(ConfigurationSection item) {
        int yourSlot = item.getInt("your_slot", -1);
        int slot = item.getInt("slot", -1);
        if (yourSlot == -1 || slot == -1) {
            return;
        }
        ItemStack[] playerInventory = this.profile.getInventory();
        if (playerInventory != null && yourSlot < playerInventory.length) {
            ItemStack stackItem = playerInventory[yourSlot];
            if (stackItem != null && stackItem.getType() != Material.AIR) {
                ItemMeta meta;
                ItemStack clonedItem = stackItem.clone();
                boolean hideTooltip = item.getBoolean("hideTooltip", false);
                if (hideTooltip && (meta = clonedItem.getItemMeta()) != null) {
                    try {
                        meta.setHideTooltip(true);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    clonedItem.setItemMeta(meta);
                }
                this.inventory.setItem(slot, clonedItem);
            } else {
                this.setupEmptySlot(item, slot);
            }
        } else {
            this.setupEmptySlot(item, slot);
        }
    }

    private void setupEmptySlot(ConfigurationSection item, int slot) {
        ConfigurationSection emptyConfig = item.getConfigurationSection("empty_config");
        if (emptyConfig == null) {
            ItemStack emptySlot = new ItemStack(Material.BARRIER);
            ItemMeta meta = emptySlot.getItemMeta();
            InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white><gray>Empty</gray>"));
            emptySlot.setItemMeta(meta);
            this.inventory.setItem(slot, emptySlot);
            return;
        }
        Material material = Material.valueOf((String)emptyConfig.getString("material", "BARRIER"));
        String displayName = emptyConfig.getString("display_name", "<gray>Empty</gray>");
        List lore = emptyConfig.getStringList("lore");
        int customModelData = emptyConfig.getInt("custom_model_data", 0);
        boolean hideTooltip = emptyConfig.getBoolean("hideTooltip", false);
        ItemStack emptySlot = new ItemStack(material);
        ItemMeta meta = emptySlot.getItemMeta();
        if (!hideTooltip) {
            InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white>" + displayName));
            if (!lore.isEmpty()) {
                ArrayList<Component> finalLore = new ArrayList<Component>();
                for (String line : lore) {
                    finalLore.add((Component)this.miniMessage.deserialize("<!italic><white>" + line));
                }
                InventoryUtil.setLore(meta, finalLore);
            }
        } else {
            try {
                meta.setHideTooltip(hideTooltip);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        emptySlot.setItemMeta(meta);
        this.inventory.setItem(slot, emptySlot);
    }

    private void setupCosmeticItem(ConfigurationSection item) {
        ItemStack clonedItem;
        ItemMeta meta;
        Player profileOwner;
        String type = item.getString("type", "");
        int slot = item.getInt("slot", -1);
        if (slot == -1) {
            return;
        }
        boolean debug = this.plugin.getConfig().getBoolean("settings.debug", false);
        HMCCosmeticsIntegration hmcIntegration = this.plugin.getHMCCosmeticsIntegration();
        ECosmeticsIntegration eIntegration = this.plugin.getECosmeticsIntegration();
        Object activeIntegration = null;
        String pluginName = "";
        if (hmcIntegration != null && hmcIntegration.isEnabled()) {
            activeIntegration = hmcIntegration;
            pluginName = "HMCCosmetics";
        } else if (eIntegration != null && eIntegration.isEnabled()) {
            activeIntegration = eIntegration;
            pluginName = "ECosmetics";
        }
        if (activeIntegration == null) {
            if (debug) {
                this.plugin.getLogger().info("[GUI] No cosmetics integration available");
            }
            this.setupEmptySlot(item, slot);
            return;
        }
        if (debug) {
            this.plugin.getLogger().info("[GUI] Cosmetics plugin loaded: " + pluginName);
        }
        if ((profileOwner = Bukkit.getPlayer((UUID)this.profile.getUuid())) == null) {
            if (debug) {
                this.plugin.getLogger().info("[GUI] Profile owner is offline for cosmetic type: " + type);
            }
            this.setupEmptySlot(item, slot);
            return;
        }
        if (debug) {
            this.plugin.getLogger().info("[GUI] Searching cosmetic for player " + profileOwner.getName() + " with type: " + type);
        }
        ItemStack cosmeticItem = null;
        if (activeIntegration instanceof HMCCosmeticsIntegration) {
            cosmeticItem = ((HMCCosmeticsIntegration)activeIntegration).getCosmeticItemBySlot(profileOwner, type);
        } else if (activeIntegration instanceof ECosmeticsIntegration) {
            cosmeticItem = ((ECosmeticsIntegration)activeIntegration).getCosmeticItemBySlot(profileOwner, type);
        }
        if (cosmeticItem == null) {
            if (debug) {
                this.plugin.getLogger().info("[GUI] No cosmetic found for type: " + type);
            }
            this.setupEmptySlot(item, slot);
            return;
        }
        if (cosmeticItem.getType() == Material.AIR) {
            if (debug) {
                this.plugin.getLogger().info("[GUI] Cosmetic is AIR for type: " + type);
            }
            this.setupEmptySlot(item, slot);
            return;
        }
        if (debug) {
            this.plugin.getLogger().info("[GUI] Found cosmetic for type " + type + ": " + String.valueOf(cosmeticItem.getType()));
        }
        if ((meta = (clonedItem = cosmeticItem.clone()).getItemMeta()) != null) {
            List<Component> lore;
            Component displayName;
            if (meta.hasDisplayName() && (displayName = InventoryUtil.getDisplayName(meta)) != null) {
                InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white>").append(displayName));
            }
            if (meta.hasLore() && (lore = InventoryUtil.getLore(meta)) != null) {
                ArrayList<Component> newLore = new ArrayList<Component>();
                for (Component line : lore) {
                    newLore.add(this.miniMessage.deserialize("<!italic><white>").append(line));
                }
                InventoryUtil.setLore(meta, newLore);
            }
            clonedItem.setItemMeta(meta);
        }
        this.inventory.setItem(slot, clonedItem);
    }

    private void setupActionItem(ConfigurationSection item) {
        Material material = Material.valueOf((String)item.getString("material", "STONE"));
        String displayName = item.getString("display_name", "Custom Button");
        List lore = item.getStringList("lore");
        boolean hideTooltip = item.getBoolean("hideTooltip", false);
        boolean hideAttributes = item.getBoolean("hideAttributes", false);
        String head = item.getString("head", "");
        int customModelData = item.getInt("custom_model_data", 0);
        displayName = this.processPlaceholders(displayName);
        ItemStack actionItem = new ItemStack(material);
        ItemMeta meta = actionItem.getItemMeta();
        if (material == Material.PLAYER_HEAD && !head.isEmpty()) {
            SkullMeta skullMeta = (SkullMeta)meta;
            String processedHead = this.processPlaceholders(head);
            skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)processedHead));
            meta = skullMeta;
        }
        if (customModelData > 0) {
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        if (hideAttributes) {
            try {
                meta.setHideTooltip(true);
            }
            catch (NoSuchMethodError skullMeta) {
                // empty catch block
            }
        }
        if (!hideTooltip) {
            InventoryUtil.setDisplayName(meta, this.miniMessage.deserialize("<!italic><white>" + displayName));
            ArrayList<Component> finalLore = new ArrayList<Component>();
            for (String line : lore) {
                String processedLine = this.processPlaceholders(line);
                finalLore.add((Component)this.miniMessage.deserialize("<!italic><white>" + processedLine));
            }
            InventoryUtil.setLore(meta, finalLore);
        } else {
            meta.setHideTooltip(hideTooltip);
        }
        actionItem.setItemMeta(meta);
        if (item.contains("slots")) {
            List slots = item.getStringList("slots");
            for (String slotRange : slots) {
                if (slotRange.contains("-")) {
                    String[] parts = slotRange.split("-");
                    int start = Integer.parseInt(parts[0]);
                    int end = Integer.parseInt(parts[1]);
                    for (int i = start; i <= end; ++i) {
                        this.inventory.setItem(i, actionItem);
                    }
                    continue;
                }
                this.inventory.setItem(Integer.parseInt(slotRange), actionItem);
            }
        } else {
            int slot = item.getInt("slot", -1);
            if (slot != -1) {
                this.inventory.setItem(slot, actionItem);
            }
        }
    }

    private String processPlaceholders(String text) {
        text = text.replace("%player_name%", this.profile.getPlayerName());
        text = text.replace("%uprofiles_star%", String.valueOf(this.profile.getStars()));
        String state = this.profile.isPublic() ? this.plugin.getLanguageManager().getMessage("privacy.public") : this.plugin.getLanguageManager().getMessage("privacy.private");
        text = text.replace("%uprofiles_state%", state);
        HMCCosmeticsIntegration hmcIntegration = this.plugin.getHMCCosmeticsIntegration();
        ECosmeticsIntegration eIntegration = this.plugin.getECosmeticsIntegration();
        Player targetPlayer = Bukkit.getPlayer((UUID)this.profile.getUuid());
        text = hmcIntegration != null && hmcIntegration.isEnabled() && targetPlayer != null ? text.replace("%hmccosmetics_total%", String.valueOf(hmcIntegration.getTotalCosmeticsCount(targetPlayer))).replace("%hmccosmetics_equipped%", String.valueOf(hmcIntegration.getEquippedCosmetics(targetPlayer).size())) : (eIntegration != null && eIntegration.isEnabled() && targetPlayer != null ? text.replace("%hmccosmetics_total%", String.valueOf(eIntegration.getTotalCosmeticsCount(targetPlayer))).replace("%hmccosmetics_equipped%", String.valueOf(eIntegration.getEquippedCosmetics(targetPlayer).size())) : text.replace("%hmccosmetics_total%", "N/A").replace("%hmccosmetics_equipped%", "N/A"));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            text = PlaceholderAPI.setPlaceholders((Player)this.viewer, (String)text);
        }
        return text;
    }

    public void open() {
        this.viewer.openInventory(this.inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getInventory().equals((Object)this.inventory)) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        ClickType clickType = event.getClick();
        this.handleCustomClick(player, slot, clickType);
    }

    private void handleCustomClick(Player player, int slot, ClickType clickType) {
        ConfigurationSection customItems = this.plugin.getGuiConfigManager().getCustomItems();
        if (customItems == null) {
            return;
        }
        for (String key : customItems.getKeys(false)) {
            ConfigurationSection item = customItems.getConfigurationSection(key);
            if (item == null || item.getInt("slot") != slot) continue;
            if (!this.canClickItem(item, player)) {
                return;
            }
            ConfigurationSection actions = item.getConfigurationSection("actions");
            if (actions == null) {
                return;
            }
            String clickTypeName = this.getClickTypeName(clickType);
            ConfigurationSection clickActions = actions.getConfigurationSection(clickTypeName);
            if (clickActions == null) {
                return;
            }
            this.executeActions(clickActions, player);
            return;
        }
    }

    private boolean canClickItem(ConfigurationSection item, Player player) {
        ConfigurationSection clickReqs = item.getConfigurationSection("click_requirements");
        if (clickReqs == null) {
            return true;
        }
        for (String reqKey : clickReqs.getKeys(false)) {
            String permission;
            ConfigurationSection req;
            String permission2;
            if (!(reqKey.equals("permission") ? !(permission2 = clickReqs.getString("permission", "")).isEmpty() && !player.hasPermission(permission2) : (req = clickReqs.getConfigurationSection(reqKey)) != null && !(permission = req.getString("permission", "")).isEmpty() && !player.hasPermission(permission))) continue;
            return false;
        }
        return true;
    }

    private String getClickTypeName(ClickType clickType) {
        return switch (clickType) {
            case ClickType.LEFT, ClickType.SHIFT_LEFT -> "LEFT_CLICK";
            case ClickType.RIGHT, ClickType.SHIFT_RIGHT -> "RIGHT_CLICK";
            case ClickType.MIDDLE -> "MIDDLE_CLICK";
            default -> "LEFT_CLICK";
        };
    }

    private void executeActions(ConfigurationSection clickActions, Player player) {
        block19: for (String actionKey : clickActions.getKeys(false)) {
            String action;
            ConfigurationSection actionSection = clickActions.getConfigurationSection(actionKey);
            if (actionSection == null) continue;
            switch (action = actionSection.getString("action", "NONE")) {
                case "ADD_STAR": {
                    this.plugin.getProfileManager().giveStar(player, this.profile.getUuid());
                    this.setupCustomItems();
                    break;
                }
                case "REMOVE_STAR": {
                    break;
                }
                case "STATE_TOGGLE": 
                case "PRIVACY": {
                    if (!player.getUniqueId().equals(this.profile.getUuid())) break;
                    this.plugin.getProfileManager().togglePrivacy(player);
                    this.setupCustomItems();
                    break;
                }
                case "PUBLIC": {
                    if (!player.getUniqueId().equals(this.profile.getUuid())) break;
                    this.profile.setPublic(true);
                    this.setupCustomItems();
                    break;
                }
                case "PRIVATE": {
                    if (!player.getUniqueId().equals(this.profile.getUuid())) break;
                    this.profile.setPublic(false);
                    this.setupCustomItems();
                    break;
                }
                case "COMMAND": {
                    List commands = actionSection.getStringList("commands");
                    for (String command : commands) {
                        command = command.replace("%player_name%", this.profile.getPlayerName()).replace("%viewer_name%", player.getName());
                        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                            command = PlaceholderAPI.setPlaceholders((Player)player, (String)command);
                        }
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    }
                    continue block19;
                }
                case "COMMAND_PLAYER": {
                    List playerCommands = actionSection.getStringList("commands");
                    for (String command : playerCommands) {
                        command = command.replace("%player_name%", this.profile.getPlayerName()).replace("%viewer_name%", player.getName());
                        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                            command = PlaceholderAPI.setPlaceholders((Player)player, (String)command);
                        }
                        player.performCommand(command);
                    }
                    break;
                }
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory)) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

