/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.integrations;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ru.sculmix.ecosmetics.api.Cosmetic;
import ru.sculmix.ecosmetics.api.CosmeticType;
import ru.sculmix.ecosmetics.api.MagicAPI;
import ru.sculmix.ecosmetics.cache.PlayerData;
import ru.sculmix.ecosmetics.cache.cosmetics.Hat;
import ru.sculmix.ecosmetics.events.CosmeticEquipEvent;
import ru.sculmix.ecosmetics.events.CosmeticUnEquipEvent;

public class ECosmeticsIntegration
implements Listener {
    private final UniverseProfiles plugin;
    private boolean enabled = false;

    public ECosmeticsIntegration(UniverseProfiles plugin) {
        this.plugin = plugin;
        if (Bukkit.getPluginManager().getPlugin("ECosmetics") != null) {
            this.enabled = true;
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            plugin.getLogger().info("ECosmetics integration enabled!");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Cosmetic> getPlayerCosmetics(Player player) {
        if (!this.enabled) {
            return new ArrayList<Cosmetic>();
        }
        try {
            PlayerData playerData = PlayerData.getPlayer((OfflinePlayer)player);
            if (playerData == null) {
                return new ArrayList<Cosmetic>();
            }
            Map cosmetics = playerData.getCosmetics();
            return new ArrayList<Cosmetic>(cosmetics.values());
        }
        catch (Exception e) {
            return new ArrayList<Cosmetic>();
        }
    }

    public List<String> getEquippedCosmetics(Player player) {
        if (!this.enabled) {
            return new ArrayList<String>();
        }
        ArrayList<String> equipped = new ArrayList<String>();
        try {
            PlayerData playerData = PlayerData.getPlayer((OfflinePlayer)player);
            if (playerData == null) {
                return equipped;
            }
            if (playerData.getHat() != null) {
                equipped.add(playerData.getHat().getId());
            }
            if (playerData.getBag() != null) {
                equipped.add(playerData.getBag().getId());
            }
            if (playerData.getWStick() != null) {
                equipped.add(playerData.getWStick().getId());
            }
            if (playerData.getBalloon() != null) {
                equipped.add(playerData.getBalloon().getId());
            }
            if (playerData.getSpray() != null) {
                equipped.add(playerData.getSpray().getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return equipped;
    }

    public Map<String, List<String>> getCosmeticsByType(Player player) {
        if (!this.enabled) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> cosmeticsByType = new HashMap<String, List<String>>();
        try {
            for (Cosmetic cosmetic : this.getPlayerCosmetics(player)) {
                String type = cosmetic.getCosmeticType().name();
                cosmeticsByType.computeIfAbsent(type, k -> new ArrayList()).add(cosmetic.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cosmeticsByType;
    }

    public boolean hasCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        try {
            return MagicAPI.hasCosmetic((Player)player, (String)cosmeticId);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equipCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        try {
            Cosmetic cosmetic = Cosmetic.getCosmetic((String)cosmeticId);
            if (cosmetic == null) {
                return false;
            }
            if (!this.hasCosmetic(player, cosmeticId)) {
                return false;
            }
            MagicAPI.EquipCosmetic((Player)player, (String)cosmeticId, null, (boolean)false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean unequipCosmetic(Player player, String cosmeticId) {
        if (!this.enabled) {
            return false;
        }
        try {
            Cosmetic cosmetic = Cosmetic.getCosmetic((String)cosmeticId);
            if (cosmetic == null) {
                return false;
            }
            MagicAPI.UnEquipCosmetic((Player)player, (CosmeticType)cosmetic.getCosmeticType());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @EventHandler
    public void onCosmeticEquip(CosmeticEquipEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            this.plugin.getProfileManager().updateProfile(player);
        }
    }

    @EventHandler
    public void onCosmeticUnequip(CosmeticUnEquipEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            this.plugin.getProfileManager().updateProfile(player);
        }
    }

    public int getTotalCosmeticsCount(Player player) {
        if (!this.enabled) {
            return 0;
        }
        return this.getPlayerCosmetics(player).size();
    }

    public String getCosmeticDisplayName(String cosmeticId) {
        if (!this.enabled) {
            return cosmeticId;
        }
        try {
            Cosmetic cosmetic = Cosmetic.getCosmetic((String)cosmeticId);
            if (cosmetic == null) {
                return cosmeticId;
            }
            return cosmetic.getName();
        }
        catch (Exception e) {
            return cosmeticId;
        }
    }

    public ItemStack getCosmeticItemBySlot(Player player, String slotName) {
        if (!this.enabled) {
            return null;
        }
        boolean debug = this.plugin.getConfig().getBoolean("settings.debug", false);
        try {
            PlayerData playerData = PlayerData.getPlayer((OfflinePlayer)player);
            if (playerData == null) {
                if (debug) {
                    this.plugin.getLogger().info("[ECosmetics] PlayerData is null for player: " + player.getName());
                }
                return null;
            }
            CosmeticType type = null;
            try {
                type = CosmeticType.valueOf((String)slotName);
            }
            catch (IllegalArgumentException e) {
                if (debug) {
                    this.plugin.getLogger().info("[ECosmetics] Invalid slot name: " + slotName);
                }
                return null;
            }
            Hat cosmetic = null;
            switch (type) {
                case HAT: {
                    cosmetic = playerData.getHat();
                    break;
                }
                case BAG: {
                    cosmetic = playerData.getBag();
                    break;
                }
                case WALKING_STICK: {
                    cosmetic = playerData.getWStick();
                    break;
                }
                case BALLOON: {
                    cosmetic = playerData.getBalloon();
                    break;
                }
                case SPRAY: {
                    cosmetic = playerData.getSpray();
                }
            }
            if (cosmetic == null) {
                if (debug) {
                    this.plugin.getLogger().info("[ECosmetics] No cosmetic equipped for slot: " + slotName);
                }
                return null;
            }
            ItemStack itemStack = cosmetic.getItemStack();
            if (debug) {
                this.plugin.getLogger().info("[ECosmetics] Found cosmetic: " + cosmetic.getId() + " for slot: " + slotName);
            }
            return itemStack;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[ECosmetics] Failed to get cosmetic: " + e.getMessage());
            return null;
        }
    }
}

