/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.models;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerProfile {
    private final UUID uuid;
    private String playerName;
    private boolean isPublic;
    private int stars;
    private Set<UUID> starGivers;
    private ItemStack[] inventory;
    private ItemStack[] armorContents;
    private ItemStack mainHand;
    private ItemStack offHand;
    private long lastSeen;

    public PlayerProfile(UUID uuid, String playerName) {
        this.uuid = uuid;
        this.playerName = playerName;
        this.isPublic = true;
        this.stars = 0;
        this.starGivers = new HashSet<UUID>();
        this.lastSeen = System.currentTimeMillis();
    }

    public void updateFromPlayer(Player player) {
        this.playerName = player.getName();
        this.inventory = (ItemStack[])player.getInventory().getContents().clone();
        this.armorContents = (ItemStack[])player.getInventory().getArmorContents().clone();
        this.mainHand = player.getInventory().getItemInMainHand();
        this.offHand = player.getInventory().getItemInOffHand();
        this.lastSeen = System.currentTimeMillis();
    }

    public boolean canReceiveStarFrom(UUID giver) {
        return !this.starGivers.contains(giver);
    }

    public void addStar(UUID giver) {
        if (this.canReceiveStarFrom(giver)) {
            this.starGivers.add(giver);
            ++this.stars;
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public int getStars() {
        return this.stars;
    }

    public void setStars(int stars) {
        this.stars = stars;
    }

    public Set<UUID> getStarGivers() {
        return new HashSet<UUID>(this.starGivers);
    }

    public void setStarGivers(Set<UUID> starGivers) {
        this.starGivers = new HashSet<UUID>(starGivers);
    }

    public ItemStack[] getInventory() {
        return this.inventory;
    }

    public void setInventory(ItemStack[] inventory) {
        this.inventory = inventory;
    }

    public ItemStack[] getArmorContents() {
        return this.armorContents;
    }

    public void setArmorContents(ItemStack[] armorContents) {
        this.armorContents = armorContents;
    }

    public ItemStack getMainHand() {
        return this.mainHand;
    }

    public void setMainHand(ItemStack mainHand) {
        this.mainHand = mainHand;
    }

    public ItemStack getOffHand() {
        return this.offHand;
    }

    public void setOffHand(ItemStack offHand) {
        this.offHand = offHand;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }
}

