/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.placeholders;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import fr.ax_dev.universeProfiles.models.PlayerProfile;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class ProfilePlaceholderExpansion
extends PlaceholderExpansion {
    private final UniverseProfiles plugin;

    public ProfilePlaceholderExpansion(UniverseProfiles plugin) {
        this.plugin = plugin;
    }

    public boolean canRegister() {
        return true;
    }

    public String getIdentifier() {
        return "uprofiles";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        PlayerProfile profile = this.plugin.getProfileManager().getCachedProfile(player.getUniqueId());
        if (profile == null) {
            return "";
        }
        return switch (identifier.toLowerCase()) {
            case "state" -> {
                if (profile.isPublic()) {
                    yield this.plugin.getLanguageManager().getMessage("privacy.public");
                }
                yield this.plugin.getLanguageManager().getMessage("privacy.private");
            }
            case "star", "stars" -> String.valueOf(profile.getStars());
            case "ispublic" -> String.valueOf(profile.isPublic());
            case "isprivate" -> String.valueOf(!profile.isPublic());
            case "player_name" -> profile.getPlayerName();
            default -> null;
        };
    }
}

