/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.util;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryUtil {
    private static Boolean isPaperServer = null;
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();

    public static Inventory createInventory(InventoryHolder holder, int size, Component title) {
        String legacyTitle = LEGACY_SERIALIZER.serialize(title);
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)legacyTitle);
    }

    public static void setDisplayName(ItemMeta meta, Component component) {
        if (InventoryUtil.isPaper()) {
            try {
                Method method = ItemMeta.class.getMethod("displayName", Component.class);
                method.invoke((Object)meta, component);
                return;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        String legacy = LEGACY_SERIALIZER.serialize(component);
        meta.setDisplayName(legacy);
    }

    public static void setLore(ItemMeta meta, List<Component> lore) {
        if (InventoryUtil.isPaper()) {
            try {
                Method method = ItemMeta.class.getMethod("lore", List.class);
                method.invoke((Object)meta, lore);
                return;
            }
            catch (Exception method) {
            }
        }
        List legacyLore = lore.stream().map(LEGACY_SERIALIZER::serialize).collect(Collectors.toList());
        meta.setLore(legacyLore);
    }

    public static Component getDisplayName(ItemMeta meta) {
        if (InventoryUtil.isPaper()) {
            try {
                Method method = ItemMeta.class.getMethod("displayName", new Class[0]);
                return (Component)method.invoke((Object)meta, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (meta.hasDisplayName()) {
            return LEGACY_SERIALIZER.deserialize(meta.getDisplayName());
        }
        return null;
    }

    public static List<Component> getLore(ItemMeta meta) {
        List lore;
        if (InventoryUtil.isPaper()) {
            try {
                Method method = ItemMeta.class.getMethod("lore", new Class[0]);
                return (List)method.invoke((Object)meta, new Object[0]);
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        if (meta.hasLore() && (lore = meta.getLore()) != null) {
            return lore.stream().map(LEGACY_SERIALIZER::deserialize).collect(Collectors.toList());
        }
        return null;
    }

    private static boolean isPaper() {
        if (isPaperServer == null) {
            try {
                Method method = ItemMeta.class.getMethod("displayName", Component.class);
                isPaperServer = true;
            }
            catch (NoSuchMethodException e) {
                isPaperServer = false;
            }
        }
        return isPaperServer;
    }
}

