/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.commands;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import fr.ax_dev.universeProfiles.gui.ProfileGUI;
import fr.ax_dev.universeProfiles.models.PlayerProfile;
import fr.ax_dev.universeProfiles.util.SchedulerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProfileCommand
implements CommandExecutor,
TabCompleter {
    private final UniverseProfiles plugin;

    public ProfileCommand(UniverseProfiles plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.openProfile(player, (OfflinePlayer)player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "public": {
                if (!player.hasPermission("uprofiles.public")) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.no_permission");
                    return true;
                }
                this.plugin.getProfileManager().setPrivacy(player.getUniqueId(), true);
                this.plugin.getLanguageManager().sendMessage(player, "messages.profile_now_public");
                break;
            }
            case "private": {
                if (!player.hasPermission("uprofiles.private")) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.no_permission");
                    return true;
                }
                this.plugin.getProfileManager().setPrivacy(player.getUniqueId(), false);
                this.plugin.getLanguageManager().sendMessage(player, "messages.profile_now_private");
                break;
            }
            case "reload": {
                if (!player.hasPermission("uprofiles.reload")) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.no_permission");
                    return true;
                }
                try {
                    this.plugin.reload();
                    this.plugin.getLanguageManager().sendMessage(player, "messages.reload_success");
                }
                catch (Exception e) {
                    player.sendMessage("\u00a7c[UniverseProfiles] Erreur lors du rechargement: " + e.getMessage());
                    e.printStackTrace();
                }
                break;
            }
            case "update-gui": {
                if (!player.hasPermission("uprofiles.admin")) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.no_permission");
                    return true;
                }
                this.plugin.getGuiConfigManager().updateFromResources();
                player.sendMessage("\u00a7a[UniverseProfiles] gui.yml a \u00e9t\u00e9 mis \u00e0 jour depuis les ressources du plugin");
                break;
            }
            case "admin": {
                if (!player.hasPermission("uprofiles.admin")) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.no_permission");
                    return true;
                }
                this.handleAdminCommand(player, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    Map<String, String> placeholders = Map.of("%player%", args[0]);
                    this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                    return true;
                }
                if (!this.plugin.getProfileManager().canViewProfile(player, target.getUniqueId())) {
                    this.plugin.getLanguageManager().sendMessage(player, "messages.profile_private");
                    return true;
                }
                this.openProfile(player, target);
            }
        }
        return true;
    }

    private void handleAdminCommand(Player player, String[] args) {
        if (args.length == 0) {
            this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
            return;
        }
        switch (args[0].toLowerCase()) {
            case "open": {
                if (args.length < 2) {
                    this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    Map<String, String> placeholders = Map.of("%player%", args[1]);
                    this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                    return;
                }
                Player viewer = player;
                if (args.length >= 3) {
                    Player targetViewer = Bukkit.getPlayer((String)args[2]);
                    if (targetViewer == null || !targetViewer.isOnline()) {
                        Map<String, String> placeholders = Map.of("%player%", args[2]);
                        this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                        return;
                    }
                    viewer = targetViewer;
                }
                this.openProfile(viewer, target);
                break;
            }
            case "forcepublic": {
                if (args.length < 2) {
                    this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    Map<String, String> placeholders = Map.of("%player%", args[1]);
                    this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                    return;
                }
                this.plugin.getProfileManager().setPrivacy(target.getUniqueId(), true);
                Map<String, String> placeholders = Map.of("%player%", target.getName());
                this.plugin.getLanguageManager().sendMessage(player, "messages.profile_now_public", placeholders);
                break;
            }
            case "forceprivate": {
                if (args.length < 2) {
                    this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    Map<String, String> placeholders = Map.of("%player%", args[1]);
                    this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                    return;
                }
                this.plugin.getProfileManager().setPrivacy(target.getUniqueId(), false);
                Map<String, String> placeholders = Map.of("%player%", target.getName());
                this.plugin.getLanguageManager().sendMessage(player, "messages.profile_now_private", placeholders);
                break;
            }
            case "give": {
                if (args.length < 4 || !args[1].equalsIgnoreCase("star")) {
                    this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
                    return;
                }
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
                if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                    Map<String, String> placeholders = Map.of("%player%", args[2]);
                    this.plugin.getLanguageManager().sendMessage(player, "messages.player_not_found", placeholders);
                    return;
                }
                try {
                    int amount = Integer.parseInt(args[3]);
                    this.plugin.getProfileManager().addStars(target.getUniqueId(), amount);
                    Map<String, String> placeholders = Map.of("%player%", target.getName(), "%amount%", String.valueOf(amount));
                    this.plugin.getLanguageManager().sendMessage(player, "messages.star_given", placeholders);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
                }
                break;
            }
            default: {
                this.plugin.getLanguageManager().sendMessage(player, "commands.usage.admin");
            }
        }
    }

    private void openProfile(Player viewer, OfflinePlayer target) {
        this.plugin.getProfileManager().getProfile(target.getUniqueId()).thenAccept(profile -> SchedulerUtil.runTask((Plugin)this.plugin, () -> {
            ProfileGUI gui = new ProfileGUI(this.plugin, viewer, (PlayerProfile)profile);
            gui.open();
        }));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("public");
            completions.add("private");
            if (player.hasPermission("uprofiles.reload")) {
                completions.add("reload");
            }
            if (player.hasPermission("uprofiles.admin")) {
                completions.add("admin");
            }
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                completions.add(onlinePlayer.getName());
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("admin")) {
            if (player.hasPermission("uprofiles.admin")) {
                completions.addAll(Arrays.asList("open", "forcepublic", "forceprivate", "give"));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("admin")) {
            if (args[1].equalsIgnoreCase("give")) {
                completions.add("star");
            } else {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    completions.add(onlinePlayer.getName());
                }
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("open")) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                completions.add(onlinePlayer.getName());
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("give") && args[2].equalsIgnoreCase("star")) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                completions.add(onlinePlayer.getName());
            }
        } else if (args.length == 5 && args[0].equalsIgnoreCase("admin") && args[1].equalsIgnoreCase("give") && args[2].equalsIgnoreCase("star")) {
            completions.addAll(Arrays.asList("1", "5", "10"));
        }
        return completions.stream().filter(completion -> completion.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).sorted().toList();
    }
}

