/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universeProfiles.config;

import fr.ax_dev.universeProfiles.UniverseProfiles;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LanguageManager {
    private final UniverseProfiles plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private FileConfiguration languageConfig;
    private String currentLanguage;

    public LanguageManager(UniverseProfiles plugin) {
        this.plugin = plugin;
        this.loadLanguage();
    }

    private void loadLanguage() {
        this.currentLanguage = this.plugin.getConfigManager().getString("language", "EN_US");
        File languageFile = new File(this.plugin.getDataFolder(), "languages/" + this.currentLanguage + ".yml");
        if (!languageFile.exists()) {
            this.plugin.saveResource("languages/" + this.currentLanguage + ".yml", false);
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
        InputStream defConfigStream = this.plugin.getResource("languages/" + this.currentLanguage + ".yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.languageConfig.setDefaults((Configuration)defConfig);
        }
    }

    public void reload() {
        try {
            this.loadLanguage();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u00a7cErreur lors du rechargement du fichier de langue: " + e.getMessage());
            throw new RuntimeException("Erreur lors du rechargement du fichier de langue", e);
        }
    }

    public String getMessage(String path) {
        return this.languageConfig.getString(path, "Message not found: " + path);
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.getMessage(path);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace(entry.getKey(), entry.getValue());
        }
        return message;
    }

    public Component getComponent(String path) {
        return this.miniMessage.deserialize(this.getMessage(path));
    }

    public Component getComponent(String path, Map<String, String> placeholders) {
        return this.miniMessage.deserialize(this.getMessage(path, placeholders));
    }

    public void sendMessage(Player player, String path) {
        Object message = this.getMessage("prefix") + this.getMessage(path);
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        player.sendMessage(this.miniMessage.deserialize(message));
    }

    public void sendMessage(Player player, String path, Map<String, String> placeholders) {
        Object message = this.getMessage("prefix") + this.getMessage(path, placeholders);
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        player.sendMessage(this.miniMessage.deserialize(message));
    }
}

