/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunar1156mods.pipe_networks.content.pipes;

import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipeBlock;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipes;
import io.github.lunar1156mods.pipe_networks.content.pipes.PipeKey;
import io.github.lunar1156mods.pipe_networks.registry.CPNPartialModels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ColoredPipeAttachmentModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<PipeModelData> PIPE_PROPERTY = new ModelProperty();
    public final ColoredPipes.PipeColor color;
    public final ColoredPipes.PipeMaterial material;
    private final boolean useAO;

    public ColoredPipeAttachmentModel(BakedModel template, boolean useAO, ColoredPipes.PipeColor color, ColoredPipes.PipeMaterial material) {
        super(template);
        this.useAO = useAO;
        this.color = color;
        this.material = material;
    }

    public static ColoredPipeAttachmentModel withAO(BakedModel template, ColoredPipes.PipeColor color, ColoredPipes.PipeMaterial material) {
        return new ColoredPipeAttachmentModel(template, true, color, material);
    }

    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        PipeModelData data = new PipeModelData();
        FluidTransportBehaviour transport = (FluidTransportBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)FluidTransportBehaviour.TYPE);
        BracketedBlockEntityBehaviour bracket = (BracketedBlockEntityBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, (BehaviourType)BracketedBlockEntityBehaviour.TYPE);
        if (transport != null) {
            for (Direction d : Iterate.directions) {
                FluidTransportBehaviour.AttachmentTypes attachment = transport.getRenderedRimAttachment(world, pos, state, d);
                BlockPos neighborPos = pos.m_121945_(d);
                BlockState neighborState = world.m_8055_(neighborPos);
                Block block = neighborState.m_60734_();
                if (block instanceof ColoredPipeBlock) {
                    boolean sameColor;
                    ColoredPipeBlock coloredPipe = (ColoredPipeBlock)block;
                    boolean bl = sameColor = coloredPipe.color == this.color;
                    if (!sameColor) {
                        boolean neighborConnected;
                        BooleanProperty thisDirProp = (BooleanProperty)FluidPipeBlock.f_55154_.get(d);
                        BooleanProperty oppDirProp = (BooleanProperty)FluidPipeBlock.f_55154_.get(d.m_122424_());
                        boolean thisConnected = state.m_61138_((Property)thisDirProp) && (Boolean)state.m_61143_((Property)thisDirProp) != false;
                        boolean bl2 = neighborConnected = neighborState.m_61138_((Property)oppDirProp) && (Boolean)neighborState.m_61143_((Property)oppDirProp) != false;
                        if (thisConnected && !neighborConnected) {
                            attachment = FluidTransportBehaviour.AttachmentTypes.RIM;
                        }
                    }
                }
                data.putAttachment(d, attachment);
            }
        }
        if (bracket != null) {
            data.putBracket(bracket.getBracket());
        }
        data.setEncased(FluidPipeBlock.shouldDrawCasing((BlockAndTintGetter)world, (BlockPos)pos, (BlockState)state));
        return builder.with(PIPE_PROPERTY, (Object)data);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ArrayList<ChunkRenderTypeSet> set = new ArrayList<ChunkRenderTypeSet>();
        PipeKey pipeKey = new PipeKey(this.material, this.color);
        set.add(super.getRenderTypes(state, rand, data));
        set.add(CPNPartialModels.PIPE_CASINGS.get(pipeKey).get().getRenderTypes(state, rand, data));
        if (data.has(PIPE_PROPERTY)) {
            PipeModelData pipeData = (PipeModelData)data.get(PIPE_PROPERTY);
            for (Direction d : Iterate.directions) {
                FluidTransportBehaviour.AttachmentTypes type = Objects.requireNonNull(pipeData).getAttachment(d);
                for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial : type.partials) {
                    ChunkRenderTypeSet attachmentRenderTypeSet = CPNPartialModels.getPipeAttachment(pipeKey, partial, d).get().getRenderTypes(state, rand, data);
                    set.add(attachmentRenderTypeSet);
                }
            }
        }
        return ChunkRenderTypeSet.union(set);
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @NotNull RandomSource rand, @NotNull ModelData data, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, data, renderType);
        if (data.has(PIPE_PROPERTY)) {
            PipeModelData pipeData = (PipeModelData)data.get(PIPE_PROPERTY);
            quads = new ArrayList<BakedQuad>(quads);
            this.addQuads(quads, state, side, rand, data, Objects.requireNonNull(pipeData), renderType);
        }
        return quads;
    }

    public boolean useAmbientOcclusion(@NotNull BlockState state, @NotNull RenderType renderType) {
        return this.useAO;
    }

    public boolean useAmbientOcclusion(@NotNull BlockState state) {
        return this.useAO;
    }

    public boolean m_7541_() {
        return this.useAO;
    }

    private void addQuads(List<BakedQuad> quads, BlockState state, Direction side, RandomSource rand, ModelData data, PipeModelData pipeData, RenderType renderType) {
        BakedModel bracket = pipeData.getBracket();
        if (bracket != null) {
            quads.addAll(bracket.getQuads(state, side, rand, data, renderType));
        }
        PipeKey key = new PipeKey(this.material, this.color);
        for (Direction d : Iterate.directions) {
            FluidTransportBehaviour.AttachmentTypes type = pipeData.getAttachment(d);
            for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial : type.partials) {
                quads.addAll(CPNPartialModels.getPipeAttachment(key, partial, d).get().getQuads(state, side, rand, data, renderType));
            }
        }
        if (pipeData.isEncased()) {
            quads.addAll(CPNPartialModels.getPipeCasing(key).get().getQuads(state, side, rand, data, renderType));
        }
    }

    private static class PipeModelData {
        private final FluidTransportBehaviour.AttachmentTypes[] attachments = new FluidTransportBehaviour.AttachmentTypes[6];
        private boolean encased;
        private BakedModel bracket;

        public PipeModelData() {
            Arrays.fill(this.attachments, FluidTransportBehaviour.AttachmentTypes.NONE);
        }

        public void putBracket(BlockState state) {
            if (state != null) {
                this.bracket = Minecraft.m_91087_().m_91289_().m_110910_(state);
            }
        }

        public BakedModel getBracket() {
            return this.bracket;
        }

        public void putAttachment(Direction face, FluidTransportBehaviour.AttachmentTypes rim) {
            this.attachments[face.m_122411_()] = rim;
        }

        public FluidTransportBehaviour.AttachmentTypes getAttachment(Direction face) {
            return this.attachments[face.m_122411_()];
        }

        public boolean isEncased() {
            return this.encased;
        }

        public void setEncased(boolean encased) {
            this.encased = encased;
        }
    }
}

