/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunar1156mods.pipe_networks.compat;

import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipes;
import io.github.lunar1156mods.pipe_networks.registry.CPNTags;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class TFMGCompat {
    public static final String TFMG_MODID = "tfmg";

    public static boolean isLoaded() {
        return ModList.get().isLoaded(TFMG_MODID) || TFMGCompat.isDataGenEnvironment();
    }

    private static boolean isDataGenEnvironment() {
        return System.getProperty("forge.datagen") != null;
    }

    public static boolean isLockedPipe(BlockEntity blockEntity) {
        if (blockEntity == null || !TFMGCompat.isLoaded()) {
            return false;
        }
        try {
            if (blockEntity.getClass().getSimpleName().equals("LockablePipeBlockEntity")) {
                return blockEntity.getClass().getField("locked").getBoolean(blockEntity);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    public static void register() {
        ColoredPipes.enableMaterial(ColoredPipes.PipeMaterial.STEEL);
        ColoredPipes.enableMaterial(ColoredPipes.PipeMaterial.CAST_IRON);
        ColoredPipes.enableMaterial(ColoredPipes.PipeMaterial.BRASS);
        ColoredPipes.enableMaterial(ColoredPipes.PipeMaterial.PLASTIC);
        ColoredPipes.enableMaterial(ColoredPipes.PipeMaterial.ALUMINUM);
    }

    public static void addRecipes(Consumer<FinishedRecipe> consumer) {
        if (!TFMGCompat.isLoaded()) {
            return;
        }
        ColoredPipes.COLORED_PIPES.get((Object)ColoredPipes.PipeMaterial.STEEL).forEach((color, pipeVariants) -> {
            Block resultPipe = (Block)((BlockEntry)pipeVariants.get(0)).get();
            Item dye = TFMGCompat.getDyeItem(color);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_126209_((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"steel_pipe")))).m_126209_((ItemLike)dye).m_126132_("has_steel_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"steel_pipe")))))).m_176500_(consumer, "pipe_networks/" + color.name + "_steel_pipe_from_steel_pipe");
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_206419_(CPNTags.Items.STEEL_COLORED_PIPES).m_126209_((ItemLike)dye).m_126132_("has_colored_steel_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CPNTags.Items.STEEL_COLORED_PIPES)).m_176500_(consumer, "pipe_networks/" + color.name + "_steel_pipe_recolor");
        });
        ColoredPipes.COLORED_PIPES.get((Object)ColoredPipes.PipeMaterial.CAST_IRON).forEach((color, pipeVariants) -> {
            Block resultPipe = (Block)((BlockEntry)pipeVariants.get(0)).get();
            Item dye = TFMGCompat.getDyeItem(color);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_126209_((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"cast_iron_pipe")))).m_126209_((ItemLike)dye).m_126132_("has_cast_iron_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"cast_iron_pipe")))))).m_176500_(consumer, "pipe_networks/" + color.name + "_cast_iron_pipe_from_cast_iron_pipe");
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_206419_(CPNTags.Items.CAST_IRON_COLORED_PIPES).m_126209_((ItemLike)dye).m_126132_("has_colored_cast_iron_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CPNTags.Items.CAST_IRON_COLORED_PIPES)).m_176500_(consumer, "pipe_networks/" + color.name + "_cast_iron_pipe_recolor");
        });
        ColoredPipes.COLORED_PIPES.get((Object)ColoredPipes.PipeMaterial.BRASS).forEach((color, pipeVariants) -> {
            Block resultPipe = (Block)((BlockEntry)pipeVariants.get(0)).get();
            Item dye = TFMGCompat.getDyeItem(color);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_126209_((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"brass_pipe")))).m_126209_((ItemLike)dye).m_126132_("has_brass_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"brass_pipe")))))).m_176500_(consumer, "pipe_networks/" + color.name + "_brass_pipe_from_brass_pipe");
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_206419_(CPNTags.Items.BRASS_COLORED_PIPES).m_126209_((ItemLike)dye).m_126132_("has_colored_brass_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CPNTags.Items.BRASS_COLORED_PIPES)).m_176500_(consumer, "pipe_networks/" + color.name + "_brass_pipe_recolor");
        });
        ColoredPipes.COLORED_PIPES.get((Object)ColoredPipes.PipeMaterial.PLASTIC).forEach((color, pipeVariants) -> {
            Block resultPipe = (Block)((BlockEntry)pipeVariants.get(0)).get();
            Item dye = TFMGCompat.getDyeItem(color);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_126209_((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"plastic_pipe")))).m_126209_((ItemLike)dye).m_126132_("has_plastic_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"plastic_pipe")))))).m_176500_(consumer, "pipe_networks/" + color.name + "_plastic_pipe_from_plastic_pipe");
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_206419_(CPNTags.Items.PLASTIC_COLORED_PIPES).m_126209_((ItemLike)dye).m_126132_("has_colored_plastic_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CPNTags.Items.PLASTIC_COLORED_PIPES)).m_176500_(consumer, "pipe_networks/" + color.name + "_plastic_pipe_recolor");
        });
        ColoredPipes.COLORED_PIPES.get((Object)ColoredPipes.PipeMaterial.ALUMINUM).forEach((color, pipeVariants) -> {
            Block resultPipe = (Block)((BlockEntry)pipeVariants.get(0)).get();
            Item dye = TFMGCompat.getDyeItem(color);
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_126209_((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"aluminum_pipe")))).m_126209_((ItemLike)dye).m_126132_("has_aluminum_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_125977_((ItemLike)((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.fromNamespaceAndPath((String)TFMG_MODID, (String)"aluminum_pipe")))))).m_176500_(consumer, "pipe_networks/" + color.name + "_aluminum_pipe_from_aluminum_pipe");
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)resultPipe, (int)1).m_206419_(CPNTags.Items.ALUMINUM_COLORED_PIPES).m_126209_((ItemLike)dye).m_126132_("has_colored_aluminum_pipe", (CriterionTriggerInstance)RegistrateRecipeProvider.m_206406_(CPNTags.Items.ALUMINUM_COLORED_PIPES)).m_176500_(consumer, "pipe_networks/" + color.name + "_aluminum_pipe_recolor");
        });
    }

    private static Item getDyeItem(ColoredPipes.PipeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case ColoredPipes.PipeColor.WHITE -> Items.f_42535_;
            case ColoredPipes.PipeColor.LIGHT_GRAY -> Items.f_42491_;
            case ColoredPipes.PipeColor.GRAY -> Items.f_42490_;
            case ColoredPipes.PipeColor.BLACK -> Items.f_42498_;
            case ColoredPipes.PipeColor.BROWN -> Items.f_42495_;
            case ColoredPipes.PipeColor.RED -> Items.f_42497_;
            case ColoredPipes.PipeColor.ORANGE -> Items.f_42536_;
            case ColoredPipes.PipeColor.YELLOW -> Items.f_42539_;
            case ColoredPipes.PipeColor.LIME -> Items.f_42540_;
            case ColoredPipes.PipeColor.GREEN -> Items.f_42496_;
            case ColoredPipes.PipeColor.CYAN -> Items.f_42492_;
            case ColoredPipes.PipeColor.LIGHT_BLUE -> Items.f_42538_;
            case ColoredPipes.PipeColor.BLUE -> Items.f_42494_;
            case ColoredPipes.PipeColor.PURPLE -> Items.f_42493_;
            case ColoredPipes.PipeColor.MAGENTA -> Items.f_42537_;
            case ColoredPipes.PipeColor.PINK -> Items.f_42489_;
        };
    }
}

