/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunar1156mods.pipe_networks.content.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import io.github.lunar1156mods.pipe_networks.PipeNetworks;
import io.github.lunar1156mods.pipe_networks.base.CPNCreativeTabs;
import io.github.lunar1156mods.pipe_networks.base.CPNRegistrate;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipeAttachmentModel;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipeBlock;
import io.github.lunar1156mods.pipe_networks.content.pipes.EncasedColoredPipeBlock;
import io.github.lunar1156mods.pipe_networks.content.pipes.GlassColoredPipeBlock;
import io.github.lunar1156mods.pipe_networks.registry.CPNTags;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class ColoredPipes {
    public static final Map<PipeMaterial, Map<PipeColor, List<BlockEntry<? extends Block>>>> COLORED_PIPES = new HashMap<PipeMaterial, Map<PipeColor, List<BlockEntry<? extends Block>>>>();
    public static final Set<PipeMaterial> ENABLED_MATERIALS = EnumSet.of(PipeMaterial.COPPER);

    private static CPNRegistrate registrate() {
        return (CPNRegistrate)PipeNetworks.REGISTRATE.setCreativeTab(CPNCreativeTabs.CPN_MAIN);
    }

    public static Map<PipeColor, List<BlockEntry<? extends Block>>> genAllPipeEntriesForMaterial(PipeMaterial material) {
        HashMap<PipeColor, List<BlockEntry<? extends Block>>> colored_pipes = new HashMap<PipeColor, List<BlockEntry<? extends Block>>>();
        for (PipeColor color : PipeColor.values()) {
            colored_pipes.put(color, ColoredPipes.genPipeEntries(material, color));
        }
        return colored_pipes;
    }

    public static List<BlockEntry<? extends Block>> genPipeEntries(PipeMaterial material, PipeColor color) {
        ArrayList<BlockEntry<? extends Block>> pipes = new ArrayList<BlockEntry<? extends Block>>();
        BlockEntry<ColoredPipeBlock> pipe = ColoredPipes.genPipeEntry(material, color);
        pipes.add(pipe);
        BlockEntry<EncasedColoredPipeBlock> encased_pipe = ColoredPipes.genEncasedPipeEntry(material, color, pipe);
        pipes.add(encased_pipe);
        BlockEntry<GlassColoredPipeBlock> glass_pipe = ColoredPipes.genGlassPipeEntry(material, color, pipe);
        pipes.add(glass_pipe);
        return pipes;
    }

    public static BlockEntry<ColoredPipeBlock> genPipeEntry(PipeMaterial material, PipeColor color) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)ColoredPipes.registrate().block(ColoredPipes.genPipeName(material, color), p -> new ColoredPipeBlock((BlockBehaviour.Properties)p, material, color)).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).blockstate(BlockStateGen.pipe()).onRegister(CreateRegistrate.blockModel(() -> template -> ColoredPipeAttachmentModel.withAO(template, material, color)))).item().tag(new TagKey[]{ColoredPipes.getTag(material)}).transform(ModelGen.customItemModel())).register();
    }

    public static BlockEntry<EncasedColoredPipeBlock> genEncasedPipeEntry(PipeMaterial material, PipeColor color, BlockEntry<ColoredPipeBlock> pipe) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)ColoredPipes.registrate().block("encased_" + ColoredPipes.genPipeName(material, color), p -> new EncasedColoredPipeBlock((BlockBehaviour.Properties)p, () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), material, color)).initialProperties(SharedProperties::copperMetal).properties(p -> p.m_60955_().m_284180_(MapColor.f_283907_)).transform(TagGen.axeOrPickaxe())).blockstate(BlockStateGen.encasedPipe()).onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(AllSpriteShifts.COPPER_CASING)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, AllSpriteShifts.COPPER_CASING, (s, f) -> (Boolean)s.m_61143_((Property)EncasedColoredPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false)))).onRegister(CreateRegistrate.blockModel(() -> template -> ColoredPipeAttachmentModel.withAO(template, material, color)))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)pipe.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo(pipe))).register();
    }

    public static BlockEntry<GlassColoredPipeBlock> genGlassPipeEntry(PipeMaterial material, PipeColor color, BlockEntry<ColoredPipeBlock> pipe) {
        return ((BlockBuilder)((BlockBuilder)ColoredPipes.registrate().block("glass_" + ColoredPipes.genPipeName(material, color), p -> new GlassColoredPipeBlock((BlockBehaviour.Properties)p, material, color)).initialProperties(SharedProperties::copperMetal).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> p.getVariantBuilder((Block)c.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + ColoredPipes.genPipeName(material, color) + "/window"))).uvLock(false).rotationX(axis == Direction.Axis.Y ? 0 : 90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.f_61362_})).onRegister(CreateRegistrate.blockModel(() -> template -> ColoredPipeAttachmentModel.withAO(template, material, color)))).loot((p, b) -> p.m_246125_((Block)b, (ItemLike)pipe.get())).register();
    }

    public static String genPipeName(PipeMaterial material, PipeColor color) {
        if (material != PipeMaterial.COPPER) {
            return color.name + "_" + material.name + "_pipe";
        }
        return color.name + "_pipe";
    }

    public static TagKey<Item> getTag(PipeMaterial material) {
        if (material == PipeMaterial.STEEL) {
            return CPNTags.Items.STEEL_COLORED_PIPES;
        }
        if (material == PipeMaterial.CAST_IRON) {
            return CPNTags.Items.CAST_IRON_COLORED_PIPES;
        }
        if (material == PipeMaterial.BRASS) {
            return CPNTags.Items.BRASS_COLORED_PIPES;
        }
        if (material == PipeMaterial.PLASTIC) {
            return CPNTags.Items.PLASTIC_COLORED_PIPES;
        }
        if (material == PipeMaterial.ALUMINUM) {
            return CPNTags.Items.ALUMINUM_COLORED_PIPES;
        }
        return CPNTags.Items.COPPER_COLORED_PIPES;
    }

    public static void preInit() {
        ENABLED_MATERIALS.add(PipeMaterial.COPPER);
    }

    public static void init() {
        for (PipeMaterial material : ENABLED_MATERIALS) {
            COLORED_PIPES.put(material, ColoredPipes.genAllPipeEntriesForMaterial(material));
        }
    }

    public static void enableMaterial(PipeMaterial material) {
        ENABLED_MATERIALS.add(material);
    }

    public static enum PipeColor {
        WHITE("white"),
        LIGHT_GRAY("light_gray"),
        GRAY("gray"),
        BLACK("black"),
        BROWN("brown"),
        RED("red"),
        ORANGE("orange"),
        YELLOW("yellow"),
        LIME("lime"),
        GREEN("green"),
        CYAN("cyan"),
        LIGHT_BLUE("light_blue"),
        BLUE("blue"),
        PURPLE("purple"),
        MAGENTA("magenta"),
        PINK("pink");

        public final String name;

        private PipeColor(String name) {
            this.name = name;
        }
    }

    public static enum PipeMaterial {
        COPPER("copper"),
        STEEL("steel"),
        CAST_IRON("cast_iron"),
        BRASS("brass"),
        PLASTIC("plastic"),
        ALUMINUM("aluminum");

        public final String name;

        private PipeMaterial(String name) {
            this.name = name;
        }
    }
}

