/*
 * Decompiled with CFR 0.152.
 */
package io.github.lunar1156mods.pipe_networks.registry;

import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.lunar1156mods.pipe_networks.PipeNetworks;
import io.github.lunar1156mods.pipe_networks.content.pipes.ColoredPipes;
import io.github.lunar1156mods.pipe_networks.content.pipes.PipeKey;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class CPNPartialModels {
    public static final Map<PipeKey, PartialModel> PIPE_CASINGS = new HashMap<PipeKey, PartialModel>();
    public static final Map<PipeKey, Map<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>>> PIPE_ATTACHMENTS = new HashMap<PipeKey, Map<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>>>();

    public static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)PipeNetworks.asResource("block/" + path));
    }

    public static Map<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>> genAttachments(ColoredPipes.PipeMaterial material, ColoredPipes.PipeColor color) {
        EnumMap<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>> attachments = new EnumMap<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>>(FluidTransportBehaviour.AttachmentTypes.ComponentPartials.class);
        for (FluidTransportBehaviour.AttachmentTypes.ComponentPartials type : FluidTransportBehaviour.AttachmentTypes.ComponentPartials.values()) {
            EnumMap<Direction, PartialModel> dirmap = new EnumMap<Direction, PartialModel>(Direction.class);
            for (Direction d : Iterate.directions) {
                dirmap.put(d, CPNPartialModels.block(CPNPartialModels.genAttachmentModelPath(material, color, type, d)));
            }
            attachments.put(type, dirmap);
        }
        return attachments;
    }

    public static String genAttachmentModelPath(ColoredPipes.PipeMaterial material, ColoredPipes.PipeColor color, FluidTransportBehaviour.AttachmentTypes.ComponentPartials type, Direction direction) {
        String typeId = Lang.asId((String)type.name());
        String directionId = Lang.asId((String)direction.m_7912_());
        return material != ColoredPipes.PipeMaterial.COPPER ? color.name + "_" + material.name + "_pipe/" + typeId + "/" + directionId : color.name + "_pipe/" + typeId + "/" + directionId;
    }

    public static String genCasingModelPath(ColoredPipes.PipeMaterial material, ColoredPipes.PipeColor color) {
        return material != ColoredPipes.PipeMaterial.COPPER ? color.name + "_" + material.name + "_pipe/casing" : color.name + "_pipe/casing";
    }

    public static void init() {
    }

    public static PartialModel getPipeAttachment(PipeKey key, FluidTransportBehaviour.AttachmentTypes.ComponentPartials partial, Direction direction) {
        Map<FluidTransportBehaviour.AttachmentTypes.ComponentPartials, Map<Direction, PartialModel>> byPartial = PIPE_ATTACHMENTS.get(key);
        if (byPartial == null) {
            throw new IllegalArgumentException("Missing attachment map for key: " + String.valueOf(key));
        }
        Map<Direction, PartialModel> byDirection = byPartial.get(partial);
        if (byDirection == null) {
            throw new IllegalArgumentException("Missing attachment partial '" + String.valueOf(partial) + "' for key: " + String.valueOf(key));
        }
        PartialModel model = byDirection.get(direction);
        if (model == null) {
            throw new IllegalArgumentException("Missing attachment model for key: " + String.valueOf(key) + " partial: " + String.valueOf(partial) + " direction: " + String.valueOf(direction));
        }
        return model;
    }

    public static PartialModel getPipeCasing(PipeKey key) {
        PartialModel model = PIPE_CASINGS.get(key);
        if (model == null) {
            throw new IllegalArgumentException("Missing casing model for key: " + String.valueOf(key));
        }
        return model;
    }

    static {
        for (ColoredPipes.PipeMaterial material : ColoredPipes.ENABLED_MATERIALS) {
            for (ColoredPipes.PipeColor color : ColoredPipes.PipeColor.values()) {
                PIPE_ATTACHMENTS.put(new PipeKey(material, color), CPNPartialModels.genAttachments(material, color));
                PIPE_CASINGS.put(new PipeKey(material, color), CPNPartialModels.block(CPNPartialModels.genCasingModelPath(material, color)));
            }
        }
    }
}

