/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.rasberrypisprogressionchanges.init;

import net.mcreator.rasberrypisprogressionchanges.potion.ArcaneCurseMobEffect;
import net.mcreator.rasberrypisprogressionchanges.potion.TranquilityMobEffect;
import net.mcreator.rasberrypisprogressionchanges.procedures.TranquilityEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class RasberrypisProgressionChangesModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"rasberrypis_progression_changes");
    public static final DeferredHolder<MobEffect, MobEffect> ARCANE_CURSE = REGISTRY.register("arcane_curse", () -> new ArcaneCurseMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TRANQUILITY = REGISTRY.register("tranquility", () -> new TranquilityMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            RasberrypisProgressionChangesModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            RasberrypisProgressionChangesModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(TRANQUILITY)) {
            TranquilityEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

