/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sTutorials;

import dev.losterixx.sTutorials.Main;
import dev.losterixx.sTutorials.listeners.TutorialListener;
import dev.losterixx.sTutorials.utils.ConfigManager;
import dev.losterixx.sTutorials.utils.UpdateChecker;
import dev.losterixx.sTutorials.utils.bStats.Metrics;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Ldev/losterixx/sTutorials/Main;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "getMiniMessage", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "onEnable", "", "onDisable", "loadConfigFiles", "loadLangFiles", "isLatestVersion", "", "Companion", "S-Tutorials"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\ndev/losterixx/sTutorials/Main\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1869#2,2:115\n*S KotlinDebug\n*F\n+ 1 Main.kt\ndev/losterixx/sTutorials/Main\n*L\n95#1:115,2\n*E\n"})
public final class Main
extends JavaPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MiniMessage miniMessage;
    private static Main instance;
    @NotNull
    public static final String DEFAULT_PREFIX = "<#27D699><b>S-Tutorials</b> <dark_gray>\u26a1 <gray>";

    public Main() {
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue(miniMessage, "miniMessage(...)");
        this.miniMessage = miniMessage;
    }

    @NotNull
    public final MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    public void onEnable() {
        this.getLogger().info("Plugin is being enabled...");
        instance = this;
        this.loadLangFiles();
        this.loadConfigFiles();
        this.getLogger().info("Loaded " + ConfigManager.INSTANCE.getAllConfigs().size() + " configs!");
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, (LifecycleEventHandler)onEnable.1.INSTANCE);
        this.getServer().getPluginManager().registerEvents((Listener)new TutorialListener(), (Plugin)Companion.getInstance());
        new Metrics((Plugin)this, 26922);
        if (ConfigManager.INSTANCE.getConfig("config").getBoolean("updateChecker.consoleMessage").booleanValue()) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)Companion.getInstance(), () -> Main.onEnable$lambda$0(this));
        }
        this.getLogger().info("Plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Plugin has been disabled!");
    }

    public final void loadConfigFiles() {
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "config", "config.yml", null, 4, null);
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "tutorials", "tutorials.yml", null, 4, null);
        ConfigManager.createConfig$default(ConfigManager.INSTANCE, "data", "data.yml", null, 4, null);
        this.loadLangFiles();
        String langFile = ConfigManager.INSTANCE.getConfig("config").getString("langFile", null);
        if (langFile == null) {
            this.getLogger().warning("No language file specified in config.yml! Defaulting to english.yml.");
            this.getConfig().set("langFile", (Object)"english");
            ConfigManager.INSTANCE.saveConfig("config");
        }
        Intrinsics.checkNotNull(langFile);
        ConfigManager.INSTANCE.createConfig(langFile, "lang/" + langFile + ".yml", "lang");
        this.getLogger().info("Using language file: " + langFile + ".yml");
    }

    public final void loadLangFiles() {
        Path langDirectory = this.getDataFolder().toPath().resolve("lang");
        if (!Files.exists(langDirectory, new LinkOption[0])) {
            Files.createDirectories(langDirectory, new FileAttribute[0]);
        }
        String[] stringArray = new String[]{"english.yml", "german.yml"};
        List<String> defaultLangFiles = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = defaultLangFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName = (String)element$iv;
            boolean bl = false;
            String langConfig = StringsKt.removeSuffix(fileName, (CharSequence)".yml");
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + fileName, "lang");
        }
        Files.list(langDirectory).filter(arg_0 -> Main.loadLangFiles$lambda$2(Main::loadLangFiles$lambda$1, arg_0)).forEach(arg_0 -> Main.loadLangFiles$lambda$4(Main::loadLangFiles$lambda$3, arg_0));
    }

    public final boolean isLatestVersion() {
        String string = this.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        String currentVersion = string;
        String latestVersion = UpdateChecker.INSTANCE.getLatestModrinthRelease("s-tutorials.yml");
        return latestVersion != null && Intrinsics.areEqual(latestVersion, currentVersion);
    }

    private static final void onEnable$lambda$0(Main this$0) {
        if (!this$0.isLatestVersion()) {
            this$0.getLogger().warning("You are not using the latest version of S-Tutorials! Please update to the latest version.");
            this$0.getLogger().warning("Latest version: " + UpdateChecker.INSTANCE.getLatestModrinthRelease("s-tutorials.yml"));
            this$0.getLogger().warning("Your version: " + this$0.getPluginMeta().getVersion());
        } else {
            this$0.getLogger().info("You are using the latest version of S-Tutorials!");
        }
    }

    private static final boolean loadLangFiles$lambda$1(Path it) {
        return StringsKt.endsWith$default(((Object)it).toString(), ".yml", false, 2, null);
    }

    private static final boolean loadLangFiles$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit loadLangFiles$lambda$3(Path langFile) {
        String langConfig = StringsKt.removeSuffix(((Object)langFile.getFileName()).toString(), (CharSequence)".yml");
        if (!ConfigManager.INSTANCE.existsConfig(langConfig)) {
            ConfigManager.INSTANCE.createConfig(langConfig, "lang/" + langFile.getFileName(), "lang");
        }
        return Unit.INSTANCE;
    }

    private static final void loadLangFiles$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/losterixx/sTutorials/Main$Companion;", "", "<init>", "()V", "value", "Ldev/losterixx/sTutorials/Main;", "instance", "getInstance", "()Ldev/losterixx/sTutorials/Main;", "DEFAULT_PREFIX", "", "S-Tutorials"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Main getInstance() {
            Main main = instance;
            if (main != null) {
                return main;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

