/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sTutorials.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.losterixx.sTutorials.Main;
import dev.losterixx.sTutorials.manager.TutorialManager;
import dev.losterixx.sTutorials.utils.ConfigManager;
import dev.losterixx.simpleTimber.libs.YamlDocument;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Ldev/losterixx/sTutorials/commands/TutorialCommand;", "", "<init>", "()V", "main", "Ldev/losterixx/sTutorials/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "config", "Ldev/losterixx/simpleTimber/libs/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "messages", "getMessages", "prefix", "", "getPrefix", "()Ljava/lang/String;", "get", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "S-Tutorials"})
public final class TutorialCommand {
    @NotNull
    public static final TutorialCommand INSTANCE = new TutorialCommand();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final MiniMessage mm = main.getMiniMessage();

    private TutorialCommand() {
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#27D699><b>S-Tutorials</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    @NotNull
    public final LiteralArgumentBuilder<CommandSourceStack> get() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tutorial").executes(TutorialCommand::get$lambda$0)).then(Commands.literal((String)"start").then(Commands.argument((String)"tutorial", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(TutorialCommand::get$lambda$1)))).then(Commands.literal((String)"startFor").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).then(Commands.argument((String)"tutorial", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(TutorialCommand::get$lambda$2))))).then(Commands.literal((String)"skip").executes(TutorialCommand::get$lambda$3))).then(Commands.literal((String)"skipFor").then(Commands.argument((String)"player", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(TutorialCommand::get$lambda$4)));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "then(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    private static final int get$lambda$0(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!sender.hasPermission("sTutorials.use")) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPerms"))));
            return 0;
        }
        sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("commands.tutorial.usage"))));
        return 1;
    }

    private static final int get$lambda$1(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!(sender instanceof Player)) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPlayer"))));
            return 0;
        }
        if (!sender.hasPermission("sTutorials.start")) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPerms"))));
            return 0;
        }
        String tutorialKey = StringArgumentType.getString((CommandContext)ctx, (String)"tutorial");
        Player player = (Player)sender;
        Intrinsics.checkNotNull(tutorialKey);
        TutorialManager.INSTANCE.startTutorial(player, tutorialKey);
        return 1;
    }

    private static final int get$lambda$2(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!sender.hasPermission("sTutorials.startFor")) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPerms"))));
            return 0;
        }
        String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
        String tutorialKey = StringArgumentType.getString((CommandContext)ctx, (String)"tutorial");
        Player target = Bukkit.getPlayerExact((String)playerName);
        if (target == null) {
            String string = INSTANCE.getPrefix();
            String string2 = INSTANCE.getMessages().getString("general.playerNotFound");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            Intrinsics.checkNotNull(playerName);
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%player%", playerName, false, 4, null))));
            return 0;
        }
        Intrinsics.checkNotNull(tutorialKey);
        TutorialManager.INSTANCE.startTutorialFor(sender, target, tutorialKey);
        return 1;
    }

    private static final int get$lambda$3(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!(sender instanceof Player)) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPlayer"))));
            return 0;
        }
        if (!sender.hasPermission("sTutorials.skip")) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPerms"))));
            return 0;
        }
        TutorialManager.INSTANCE.skipTutorial((Player)sender);
        return 1;
    }

    private static final int get$lambda$4(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (!sender.hasPermission("sTutorials.skipFor")) {
            sender.sendMessage(mm.deserialize((Object)(INSTANCE.getPrefix() + INSTANCE.getMessages().getString("general.noPerms"))));
            return 0;
        }
        String playerName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
        Player target = Bukkit.getPlayerExact((String)playerName);
        if (target == null) {
            String string = INSTANCE.getPrefix();
            String string2 = INSTANCE.getMessages().getString("general.playerNotFound");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            Intrinsics.checkNotNull(playerName);
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%player%", playerName, false, 4, null))));
            return 0;
        }
        TutorialManager.INSTANCE.skipTutorialFor(sender, target);
        return 1;
    }
}

