/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sTutorials.listeners;

import dev.losterixx.sTutorials.Main;
import dev.losterixx.sTutorials.manager.TutorialManager;
import dev.losterixx.sTutorials.utils.ConfigManager;
import dev.losterixx.sTutorials.utils.MMUtil;
import dev.losterixx.simpleTimber.libs.YamlDocument;
import dev.losterixx.simpleTimber.libs.block.implementation.Section;
import io.papermc.paper.event.player.AsyncChatEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020 H\u0007J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Ldev/losterixx/sTutorials/listeners/TutorialListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "main", "Ldev/losterixx/sTutorials/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "config", "Ldev/losterixx/simpleTimber/libs/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "messages", "getMessages", "tutorials", "getTutorials", "prefix", "", "getPrefix", "()Ljava/lang/String;", "onJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerChat", "Lio/papermc/paper/event/player/AsyncChatEvent;", "onPlayerCommand", "Lorg/bukkit/event/player/PlayerCommandPreprocessEvent;", "onPlayerMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "sendNextStepOrFinish", "player", "Lorg/bukkit/entity/Player;", "tutorialKey", "S-Tutorials"})
public final class TutorialListener
implements Listener {
    @NotNull
    private final Main main = Main.Companion.getInstance();
    @NotNull
    private final MiniMessage mm = this.main.getMiniMessage();

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final YamlDocument getTutorials() {
        return ConfigManager.INSTANCE.getConfig("tutorials");
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#27D699><b>S-Tutorials</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    @EventHandler
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String autoTutorial = this.getConfig().getString("autoTutorial");
        if (autoTutorial == null || ((CharSequence)autoTutorial).length() == 0 || player2.hasPlayedBefore()) {
            return;
        }
        if (this.getTutorials().contains("tutorials." + autoTutorial) && !TutorialManager.INSTANCE.hasTutorialStarted(player2)) {
            TutorialManager.INSTANCE.startTutorial(player2, autoTutorial);
        }
    }

    @EventHandler
    public final void onQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (TutorialManager.INSTANCE.hasTutorialStarted(player2)) {
            TutorialManager.INSTANCE.skipTutorial(player2);
        }
    }

    @EventHandler
    public final void onPlayerChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Component component = event.message();
        Intrinsics.checkNotNullExpressionValue(component, "message(...)");
        String message = MMUtil.INSTANCE.getTextFromComponent(component);
        if (!TutorialManager.INSTANCE.hasTutorialStarted(player2)) {
            return;
        }
        String string = TutorialManager.INSTANCE.getTutorial(player2);
        if (string == null) {
            return;
        }
        String tutorialKey = string;
        int step = TutorialManager.INSTANCE.getCurrentStep(player2);
        Section section = this.getTutorials().getSection("tutorials." + tutorialKey + ".steps." + step);
        if (section == null) {
            return;
        }
        Section stepSection = section;
        String string2 = stepSection.getString("action.type");
        if (string2 == null) {
            return;
        }
        String actionType = string2;
        if (StringsKt.equals(actionType, "MESSAGE", true)) {
            String string3 = stepSection.getString("action.content");
            if (string3 == null) {
                return;
            }
            String expected = string3;
            if (StringsKt.equals(message, expected, true)) {
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> TutorialListener.onPlayerChat$lambda$0(player2, this, tutorialKey));
            }
        }
    }

    @EventHandler
    public final void onPlayerCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = event.getMessage();
        Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
        String command = string;
        if (!TutorialManager.INSTANCE.hasTutorialStarted(player2)) {
            return;
        }
        String string2 = TutorialManager.INSTANCE.getTutorial(player2);
        if (string2 == null) {
            return;
        }
        String tutorialKey = string2;
        int step = TutorialManager.INSTANCE.getCurrentStep(player2);
        Section section = this.getTutorials().getSection("tutorials." + tutorialKey + ".steps." + step);
        if (section == null) {
            return;
        }
        Section stepSection = section;
        String string3 = stepSection.getString("action.type");
        if (string3 == null) {
            return;
        }
        String actionType = string3;
        if (StringsKt.equals(actionType, "COMMAND", true)) {
            String string4 = stepSection.getString("action.command");
            if (string4 == null) {
                return;
            }
            String expected = string4;
            if (StringsKt.equals(command, expected, true)) {
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> TutorialListener.onPlayerCommand$lambda$0(player2, this, tutorialKey));
            }
        }
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (!TutorialManager.INSTANCE.hasTutorialStarted(player2)) {
            return;
        }
        String string = TutorialManager.INSTANCE.getTutorial(player2);
        if (string == null) {
            return;
        }
        String tutorialKey = string;
        int step = TutorialManager.INSTANCE.getCurrentStep(player2);
        Section section = this.getTutorials().getSection("tutorials." + tutorialKey + ".steps." + step);
        if (section == null) {
            return;
        }
        Section stepSection = section;
        String string2 = stepSection.getString("action.type");
        if (string2 == null) {
            return;
        }
        String actionType = string2;
        if (StringsKt.equals(actionType, "REACH_COORDINATES", true)) {
            Section section2 = stepSection.getSection("action.coordinates");
            if (section2 == null) {
                return;
            }
            Section coords = section2;
            String string3 = coords.getString("world");
            if (string3 == null) {
                TutorialListener $this$onPlayerMove_u24lambda_u240 = this;
                boolean bl = false;
                player2.sendMessage($this$onPlayerMove_u24lambda_u240.mm.deserialize((Object)($this$onPlayerMove_u24lambda_u240.getPrefix() + $this$onPlayerMove_u24lambda_u240.getMessages().getString("events.coordinatesWorldNotFound"))));
                return;
            }
            String world = string3;
            Integer x = coords.getInt("x");
            Integer y = coords.getInt("y");
            Integer z = coords.getInt("z");
            Location loc = new Location(player2.getWorld(), (double)x.intValue(), (double)y.intValue(), (double)z.intValue());
            if (player2.getLocation().distance(loc) < 2.5) {
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> TutorialListener.onPlayerMove$lambda$1(player2, this, tutorialKey));
            }
        }
    }

    private final void sendNextStepOrFinish(Player player, String tutorialKey) {
        int step = TutorialManager.INSTANCE.getCurrentStep(player);
        Section stepSection = this.getTutorials().getSection("tutorials." + tutorialKey + ".steps." + step);
        if (stepSection != null) {
            String string;
            String title;
            Object object = stepSection.getString("title");
            if (object == null) {
                object = title = "Step " + step;
            }
            if ((string = stepSection.getString("description")) == null) {
                string = "No description provided.";
            }
            String desc = string;
            String string2 = this.getPrefix();
            String string3 = this.getMessages().getString("events.nextStep");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            player.sendMessage(this.mm.deserialize((Object)(string2 + StringsKt.replace$default(StringsKt.replace$default(string3, "%step_title%", title, false, 4, null), "%step_description%", desc, false, 4, null))));
        } else {
            String string = this.getPrefix();
            String string4 = this.getMessages().getString("events.tutorialFinished");
            Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
            player.sendMessage(this.mm.deserialize((Object)(string + StringsKt.replace$default(string4, "%tutorial%", tutorialKey, false, 4, null))));
            TutorialManager.INSTANCE.completeTutorial(player);
        }
    }

    private static final void onPlayerChat$lambda$0(Player $player, TutorialListener this$0, String $tutorialKey) {
        TutorialManager.INSTANCE.nextStep($player);
        this$0.sendNextStepOrFinish($player, $tutorialKey);
    }

    private static final void onPlayerCommand$lambda$0(Player $player, TutorialListener this$0, String $tutorialKey) {
        TutorialManager.INSTANCE.nextStep($player);
        this$0.sendNextStepOrFinish($player, $tutorialKey);
    }

    private static final void onPlayerMove$lambda$1(Player $player, TutorialListener this$0, String $tutorialKey) {
        TutorialManager.INSTANCE.nextStep($player);
        this$0.sendNextStepOrFinish($player, $tutorialKey);
    }
}

