/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sTutorials.manager;

import dev.losterixx.sTutorials.Main;
import dev.losterixx.sTutorials.utils.ConfigManager;
import dev.losterixx.simpleTimber.libs.YamlDocument;
import dev.losterixx.simpleTimber.libs.block.implementation.Section;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010%\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u0012J\u0016\u0010,\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001fJ\u000e\u0010-\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001f\u0010.\u001a\t\u0018\u00010/\u00a2\u0006\u0002\b02\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Ldev/losterixx/sTutorials/manager/TutorialManager;", "", "<init>", "()V", "main", "Ldev/losterixx/sTutorials/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "config", "Ldev/losterixx/simpleTimber/libs/YamlDocument;", "getConfig", "()Ldev/dejvokep/boostedyaml/YamlDocument;", "messages", "getMessages", "tutorials", "getTutorials", "prefix", "", "getPrefix", "()Ljava/lang/String;", "tutorialMap", "", "Ljava/util/UUID;", "Ldev/losterixx/sTutorials/manager/TutorialManager$PlayerTutorialData;", "getTutorialMap", "()Ljava/util/Map;", "", "hasTutorialStarted", "", "player", "Lorg/bukkit/entity/Player;", "getTutorial", "getCurrentStep", "", "nextStep", "", "startTutorial", "tutorial", "skipTutorial", "startTutorialFor", "sender", "Lorg/bukkit/command/CommandSender;", "target", "skipTutorialFor", "completeTutorial", "getSound", "Lorg/bukkit/Sound;", "Lorg/jetbrains/annotations/Nullable;", "path", "default", "PlayerTutorialData", "S-Tutorials"})
@SourceDebugExtension(value={"SMAP\nTutorialManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TutorialManager.kt\ndev/losterixx/sTutorials/manager/TutorialManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class TutorialManager {
    @NotNull
    public static final TutorialManager INSTANCE = new TutorialManager();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final MiniMessage mm = main.getMiniMessage();
    @NotNull
    private static final Map<UUID, PlayerTutorialData> tutorialMap = new LinkedHashMap();

    private TutorialManager() {
    }

    private final YamlDocument getConfig() {
        return ConfigManager.INSTANCE.getConfig("config");
    }

    private final YamlDocument getMessages() {
        String string = this.getConfig().getString("langFile", "english");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        return ConfigManager.INSTANCE.getConfig(string);
    }

    private final YamlDocument getTutorials() {
        return ConfigManager.INSTANCE.getConfig("tutorials");
    }

    private final String getPrefix() {
        String string = this.getConfig().getString("prefix");
        if (string == null) {
            string = "<#27D699><b>S-Tutorials</b> <dark_gray>\u26a1 <gray>";
        }
        return string;
    }

    @NotNull
    public final Map<UUID, PlayerTutorialData> getTutorialMap() {
        return tutorialMap;
    }

    @NotNull
    public final List<String> getTutorials() {
        Object object = this.getTutorials().getSection("tutorials");
        if (object == null || (object = ((Section)object).getRoutesAsStrings(false)) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public final boolean hasTutorialStarted(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return tutorialMap.containsKey(player.getUniqueId());
    }

    @Nullable
    public final String getTutorial(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (tutorialMap.containsKey(player.getUniqueId())) {
            PlayerTutorialData playerTutorialData = tutorialMap.get(player.getUniqueId());
            Intrinsics.checkNotNull(playerTutorialData);
            return playerTutorialData.getTutorial();
        }
        return null;
    }

    public final int getCurrentStep(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerTutorialData playerTutorialData = tutorialMap.get(player.getUniqueId());
        return playerTutorialData != null ? playerTutorialData.getStep() : -1;
    }

    public final void nextStep(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        PlayerTutorialData playerTutorialData = tutorialMap.get(player.getUniqueId());
        if (playerTutorialData == null) {
            return;
        }
        PlayerTutorialData data = playerTutorialData;
        data.setStep(data.getStep() + 1);
        Section stepsSection = this.getTutorials().getSection("tutorials." + data.getTutorial() + ".steps");
        Object object = stepsSection;
        int totalSteps = object != null && (object = ((Section)object).getRoutesAsStrings(false)) != null ? object.size() : 1;
        float progress = (float)(data.getStep() - 1) / (float)totalSteps;
        data.getBossBar().progress(RangesKt.coerceIn(progress, 0.0f, 1.0f));
        if (this.getTutorials().contains("tutorials." + data.getTutorial() + ".steps." + data.getStep())) {
            data.getBossBar().name(mm.deserialize((Object)this.getTutorials().getString("tutorials." + data.getTutorial() + ".steps." + data.getStep() + ".bossBarTitle", "<gray>No BossBarTitle provided for this step!")));
        }
        if (this.getConfig().getBoolean("sounds.nextStep.enabled").booleanValue()) {
            Sound sound = this.getSound("sounds.nextStep.sound", "minecraft:entity.player.levelup");
            if (sound != null) {
                Sound sound2 = sound;
                boolean bl = false;
                Entity entity = (Entity)player;
                Float f = INSTANCE.getConfig().getFloat("sounds.nextStep.volume");
                Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                float f2 = ((Number)f).floatValue();
                Float f3 = INSTANCE.getConfig().getFloat("sounds.nextStep.pitch");
                Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                player.playSound(entity, sound2, f2, ((Number)f3).floatValue());
            }
        }
        if (!this.getTutorials().contains("tutorials." + data.getTutorial() + ".steps." + data.getStep())) {
            this.completeTutorial(player);
        }
    }

    public final void startTutorial(@NotNull Player player, @NotNull String tutorial) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(tutorial, "tutorial");
        if (!this.getTutorials().contains("tutorials." + tutorial)) {
            String string = this.getPrefix();
            String string2 = this.getMessages().getString("commands.tutorial.start.tutorialNotFound");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            player.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%tutorial%", tutorial, false, 4, null))));
            return;
        }
        if (this.hasTutorialStarted(player)) {
            String string = this.getPrefix();
            String string3 = this.getMessages().getString("commands.tutorial.start.alreadyStarted");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            player.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string3, "%tutorial%", tutorial, false, 4, null))));
            return;
        }
        if (this.getConfig().getBoolean("sounds.startTutorial.enabled").booleanValue()) {
            Sound sound = this.getSound("sounds.startTutorial.sound", "minecraft:entity.player.levelup");
            if (sound != null) {
                Sound sound2 = sound;
                boolean bl = false;
                Entity entity = (Entity)player;
                Float f = INSTANCE.getConfig().getFloat("sounds.startTutorial.volume");
                Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                float f2 = ((Number)f).floatValue();
                Float f3 = INSTANCE.getConfig().getFloat("sounds.startTutorial.pitch");
                Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                player.playSound(entity, sound2, f2, ((Number)f3).floatValue());
            }
        }
        Map<UUID, PlayerTutorialData> map = tutorialMap;
        UUID uUID = player.getUniqueId();
        Component component = mm.deserialize((Object)this.getConfig().getString("bossBar.loadingTitle", "<gray>Loading..."));
        String string = this.getConfig().getString("bossBar.color", "WHITE");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string4 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        Object object = BossBar.bossBar((Component)component, (float)0.0f, (BossBar.Color)BossBar.Color.valueOf((String)string4), (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        Intrinsics.checkNotNullExpressionValue(object, "bossBar(...)");
        object = new PlayerTutorialData(tutorial, 1, (BossBar)object);
        map.put(uUID, (PlayerTutorialData)object);
        PlayerTutorialData playerTutorialData = tutorialMap.get(player.getUniqueId());
        if (playerTutorialData == null) {
            return;
        }
        PlayerTutorialData data = playerTutorialData;
        player.showBossBar(data.getBossBar());
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> TutorialManager.startTutorial$lambda$1(data), 5L);
        String string5 = this.getPrefix();
        String string6 = this.getMessages().getString("commands.tutorial.start.started");
        Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
        player.sendMessage(mm.deserialize((Object)(string5 + StringsKt.replace$default(string6, "%tutorial%", tutorial, false, 4, null))));
    }

    public final void skipTutorial(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.hasTutorialStarted(player)) {
            PlayerTutorialData playerTutorialData;
            if (this.getConfig().getBoolean("sounds.skipTutorial.enabled").booleanValue()) {
                Sound sound = this.getSound("sounds.skipTutorial.sound", "minecraft:entity.player.levelup");
                if (sound != null) {
                    Sound sound2 = sound;
                    boolean bl = false;
                    Entity entity = (Entity)player;
                    Float f = INSTANCE.getConfig().getFloat("sounds.skipTutorial.volume");
                    Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                    float f2 = ((Number)f).floatValue();
                    Float f3 = INSTANCE.getConfig().getFloat("sounds.skipTutorial.pitch");
                    Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                    player.playSound(entity, sound2, f2, ((Number)f3).floatValue());
                }
            }
            if ((playerTutorialData = tutorialMap.get(player.getUniqueId())) != null && (playerTutorialData = playerTutorialData.getBossBar()) != null) {
                PlayerTutorialData it = playerTutorialData;
                boolean bl = false;
                player.hideBossBar((BossBar)it);
            }
            tutorialMap.remove(player.getUniqueId());
            player.sendMessage(mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.tutorial.skip.skipped"))));
        } else {
            player.sendMessage(mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.tutorial.skip.notStarted"))));
        }
    }

    public final void startTutorialFor(@NotNull CommandSender sender, @NotNull Player target, @NotNull String tutorial) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(tutorial, "tutorial");
        if (!this.getTutorials().contains("tutorials." + tutorial)) {
            String string = this.getPrefix();
            String string2 = this.getMessages().getString("commands.tutorial.start.tutorialNotFound");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string2, "%tutorial%", tutorial, false, 4, null))));
            return;
        }
        if (this.hasTutorialStarted(target)) {
            String string = this.getPrefix();
            String string3 = this.getMessages().getString("commands.tutorial.start.alreadyStartedFor");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            String string4 = target.getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(StringsKt.replace$default(string3, "%player%", string4, false, 4, null), "%tutorial%", tutorial, false, 4, null))));
            return;
        }
        if (this.getConfig().getBoolean("sounds.startTutorial.enabled").booleanValue()) {
            Sound sound = this.getSound("sounds.startTutorial.sound", "minecraft:entity.player.levelup");
            if (sound != null) {
                Sound sound2 = sound;
                boolean bl = false;
                Entity entity = (Entity)target;
                Float f = INSTANCE.getConfig().getFloat("sounds.startTutorial.volume");
                Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                float f2 = ((Number)f).floatValue();
                Float f3 = INSTANCE.getConfig().getFloat("sounds.startTutorial.pitch");
                Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                target.playSound(entity, sound2, f2, ((Number)f3).floatValue());
            }
        }
        Map<UUID, PlayerTutorialData> map = tutorialMap;
        UUID uUID = target.getUniqueId();
        Component component = mm.deserialize((Object)this.getConfig().getString("bossBar.loadingTitle", "<gray>Loading..."));
        String string = this.getConfig().getString("bossBar.color", "WHITE");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        String string5 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
        Object object = BossBar.bossBar((Component)component, (float)0.0f, (BossBar.Color)BossBar.Color.valueOf((String)string5), (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        Intrinsics.checkNotNullExpressionValue(object, "bossBar(...)");
        object = new PlayerTutorialData(tutorial, 1, (BossBar)object);
        map.put(uUID, (PlayerTutorialData)object);
        PlayerTutorialData playerTutorialData = tutorialMap.get(target.getUniqueId());
        if (playerTutorialData == null) {
            return;
        }
        PlayerTutorialData data = playerTutorialData;
        target.showBossBar(data.getBossBar());
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> TutorialManager.startTutorialFor$lambda$1(data), 5L);
        String string6 = this.getPrefix();
        String string7 = this.getMessages().getString("commands.tutorial.start.startedFor");
        Intrinsics.checkNotNullExpressionValue(string7, "getString(...)");
        String string8 = target.getName();
        Intrinsics.checkNotNullExpressionValue(string8, "getName(...)");
        sender.sendMessage(mm.deserialize((Object)(string6 + StringsKt.replace$default(StringsKt.replace$default(string7, "%player%", string8, false, 4, null), "%tutorial%", tutorial, false, 4, null))));
        String string9 = this.getPrefix();
        String string10 = this.getMessages().getString("commands.tutorial.start.started");
        Intrinsics.checkNotNullExpressionValue(string10, "getString(...)");
        target.sendMessage(mm.deserialize((Object)(string9 + StringsKt.replace$default(string10, "%tutorial%", tutorial, false, 4, null))));
    }

    public final void skipTutorialFor(@NotNull CommandSender sender, @NotNull Player target) {
        PlayerTutorialData playerTutorialData;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(target, "target");
        String tutorial = this.getTutorial(target);
        if (!this.hasTutorialStarted(target) || tutorial == null) {
            String string = this.getPrefix();
            String string2 = this.getMessages().getString("commands.tutorial.skip.notStartedFor");
            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
            String string3 = target.getName();
            Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
            String string4 = StringsKt.replace$default(string2, "%player%", string3, false, 4, null);
            String string5 = tutorial;
            if (string5 == null) {
                string5 = "???";
            }
            sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(string4, "%tutorial%", string5, false, 4, null))));
            return;
        }
        if (this.getConfig().getBoolean("sounds.skipTutorial.enabled").booleanValue()) {
            Sound sound = this.getSound("sounds.skipTutorial.sound", "minecraft:entity.player.levelup");
            if (sound != null) {
                Sound sound2 = sound;
                boolean bl = false;
                Entity entity = (Entity)target;
                Float f = INSTANCE.getConfig().getFloat("sounds.skipTutorial.volume");
                Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                float f2 = ((Number)f).floatValue();
                Float f3 = INSTANCE.getConfig().getFloat("sounds.skipTutorial.pitch");
                Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                target.playSound(entity, sound2, f2, ((Number)f3).floatValue());
            }
        }
        if ((playerTutorialData = tutorialMap.get(target.getUniqueId())) != null && (playerTutorialData = playerTutorialData.getBossBar()) != null) {
            PlayerTutorialData it = playerTutorialData;
            boolean bl = false;
            target.hideBossBar((BossBar)it);
        }
        tutorialMap.remove(target.getUniqueId());
        String string = this.getPrefix();
        String string6 = this.getMessages().getString("commands.tutorial.skip.skippedFor");
        Intrinsics.checkNotNullExpressionValue(string6, "getString(...)");
        String string7 = target.getName();
        Intrinsics.checkNotNullExpressionValue(string7, "getName(...)");
        sender.sendMessage(mm.deserialize((Object)(string + StringsKt.replace$default(StringsKt.replace$default(string6, "%player%", string7, false, 4, null), "%tutorial%", tutorial, false, 4, null))));
        String string8 = this.getPrefix();
        String string9 = this.getMessages().getString("commands.tutorial.skip.skipped");
        Intrinsics.checkNotNullExpressionValue(string9, "getString(...)");
        String string10 = StringsKt.replace$default(string9, "%tutorial%", tutorial, false, 4, null);
        String string11 = target.getName();
        Intrinsics.checkNotNullExpressionValue(string11, "getName(...)");
        target.sendMessage(mm.deserialize((Object)(string8 + StringsKt.replace$default(string10, "%player%", string11, false, 4, null))));
    }

    public final void completeTutorial(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.hasTutorialStarted(player)) {
            String string = this.getTutorial(player);
            if (string == null) {
                return;
            }
            String tutorial = string;
            PlayerTutorialData playerTutorialData = tutorialMap.get(player.getUniqueId());
            if (playerTutorialData != null && (playerTutorialData = playerTutorialData.getBossBar()) != null) {
                PlayerTutorialData it = playerTutorialData;
                boolean bl = false;
                player.hideBossBar((BossBar)it);
            }
            tutorialMap.remove(player.getUniqueId());
            if (this.getConfig().getBoolean("sounds.completeTutorial.enabled").booleanValue()) {
                Sound sound = this.getSound("sounds.completeTutorial.sound", "minecraft:entity.player.levelup");
                if (sound != null) {
                    Sound sound2 = sound;
                    boolean bl = false;
                    Entity entity = (Entity)player;
                    Float f = INSTANCE.getConfig().getFloat("sounds.completeTutorial.volume");
                    Intrinsics.checkNotNullExpressionValue(f, "getFloat(...)");
                    float f2 = ((Number)f).floatValue();
                    Float f3 = INSTANCE.getConfig().getFloat("sounds.completeTutorial.pitch");
                    Intrinsics.checkNotNullExpressionValue(f3, "getFloat(...)");
                    player.playSound(entity, sound2, f2, ((Number)f3).floatValue());
                }
            }
            String string2 = this.getPrefix();
            String string3 = this.getMessages().getString("events.tutorialCompleted");
            Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
            player.sendMessage(mm.deserialize((Object)(string2 + StringsKt.replace$default(string3, "%tutorial%", tutorial, false, 4, null))));
        } else {
            player.sendMessage(mm.deserialize((Object)(this.getPrefix() + this.getMessages().getString("commands.tutorial.complete.notStarted"))));
        }
    }

    private final Sound getSound(String path, String string) {
        Sound sound;
        String string2 = this.getConfig().getString(path, string);
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)string3);
        if (namespacedKey != null) {
            NamespacedKey it = namespacedKey;
            boolean bl = false;
            sound = (Sound)Registry.SOUNDS.get(it);
        } else {
            sound = null;
        }
        return sound;
    }

    private static final void startTutorial$lambda$1(PlayerTutorialData $data) {
        $data.getBossBar().name(mm.deserialize((Object)INSTANCE.getTutorials().getString("tutorials." + $data.getTutorial() + ".steps." + $data.getStep() + ".bossBarTitle", "<gray>No BossBarTitle provided for this step!")));
    }

    private static final void startTutorialFor$lambda$1(PlayerTutorialData $data) {
        $data.getBossBar().name(mm.deserialize((Object)INSTANCE.getTutorials().getString("tutorials." + $data.getTutorial() + ".steps." + $data.getStep() + ".bossBarTitle", "<gray>No BossBarTitle provided for this step!")));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Ldev/losterixx/sTutorials/manager/TutorialManager$PlayerTutorialData;", "", "tutorial", "", "step", "", "bossBar", "Lnet/kyori/adventure/bossbar/BossBar;", "<init>", "(Ljava/lang/String;ILnet/kyori/adventure/bossbar/BossBar;)V", "getTutorial", "()Ljava/lang/String;", "getStep", "()I", "setStep", "(I)V", "getBossBar", "()Lnet/kyori/adventure/bossbar/BossBar;", "setBossBar", "(Lnet/kyori/adventure/bossbar/BossBar;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "S-Tutorials"})
    public static final class PlayerTutorialData {
        @NotNull
        private final String tutorial;
        private int step;
        @NotNull
        private BossBar bossBar;

        public PlayerTutorialData(@NotNull String tutorial, int step, @NotNull BossBar bossBar) {
            Intrinsics.checkNotNullParameter(tutorial, "tutorial");
            Intrinsics.checkNotNullParameter(bossBar, "bossBar");
            this.tutorial = tutorial;
            this.step = step;
            this.bossBar = bossBar;
        }

        @NotNull
        public final String getTutorial() {
            return this.tutorial;
        }

        public final int getStep() {
            return this.step;
        }

        public final void setStep(int n) {
            this.step = n;
        }

        @NotNull
        public final BossBar getBossBar() {
            return this.bossBar;
        }

        public final void setBossBar(@NotNull BossBar bossBar) {
            Intrinsics.checkNotNullParameter(bossBar, "<set-?>");
            this.bossBar = bossBar;
        }

        @NotNull
        public final String component1() {
            return this.tutorial;
        }

        public final int component2() {
            return this.step;
        }

        @NotNull
        public final BossBar component3() {
            return this.bossBar;
        }

        @NotNull
        public final PlayerTutorialData copy(@NotNull String tutorial, int step, @NotNull BossBar bossBar) {
            Intrinsics.checkNotNullParameter(tutorial, "tutorial");
            Intrinsics.checkNotNullParameter(bossBar, "bossBar");
            return new PlayerTutorialData(tutorial, step, bossBar);
        }

        public static /* synthetic */ PlayerTutorialData copy$default(PlayerTutorialData playerTutorialData, String string, int n, BossBar bossBar, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = playerTutorialData.tutorial;
            }
            if ((n2 & 2) != 0) {
                n = playerTutorialData.step;
            }
            if ((n2 & 4) != 0) {
                bossBar = playerTutorialData.bossBar;
            }
            return playerTutorialData.copy(string, n, bossBar);
        }

        @NotNull
        public String toString() {
            return "PlayerTutorialData(tutorial=" + this.tutorial + ", step=" + this.step + ", bossBar=" + this.bossBar + ")";
        }

        public int hashCode() {
            int result = this.tutorial.hashCode();
            result = result * 31 + Integer.hashCode(this.step);
            result = result * 31 + this.bossBar.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlayerTutorialData)) {
                return false;
            }
            PlayerTutorialData playerTutorialData = (PlayerTutorialData)other;
            if (!Intrinsics.areEqual(this.tutorial, playerTutorialData.tutorial)) {
                return false;
            }
            if (this.step != playerTutorialData.step) {
                return false;
            }
            return Intrinsics.areEqual(this.bossBar, playerTutorialData.bossBar);
        }
    }
}

