/*
 * Decompiled with CFR 0.152.
 */
package dev.losterixx.sTutorials.utils;

import dev.losterixx.sTutorials.Main;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/losterixx/sTutorials/utils/MMUtil;", "", "<init>", "()V", "main", "Ldev/losterixx/sTutorials/Main;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "translateLegacyCodes", "", "message", "getTextFromComponent", "component", "Lnet/kyori/adventure/text/Component;", "getColorfulTextFromComponent", "S-Tutorials"})
public final class MMUtil {
    @NotNull
    public static final MMUtil INSTANCE = new MMUtil();
    @NotNull
    private static final Main main = Main.Companion.getInstance();
    @NotNull
    private static final MiniMessage mm = main.getMiniMessage();

    private MMUtil() {
    }

    @NotNull
    public final String translateLegacyCodes(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        CharSequence charSequence = message;
        Regex regex = new Regex("&([0-9a-fA-Fk-orK-OR])");
        Function1<MatchResult, CharSequence> function1 = MMUtil::translateLegacyCodes$lambda$0;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public final String getTextFromComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        String string = PlainTextComponentSerializer.plainText().serialize(component);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        return string;
    }

    @NotNull
    public final String getColorfulTextFromComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        Object object = mm.serialize(component);
        Intrinsics.checkNotNullExpressionValue(object, "serialize(...)");
        return (String)object;
    }

    private static final CharSequence translateLegacyCodes$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        String string = matchResult.getGroupValues().get(1).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return switch (string) {
            case "0" -> "<black>";
            case "1" -> "<dark_blue>";
            case "2" -> "<dark_green>";
            case "3" -> "<dark_aqua>";
            case "4" -> "<dark_red>";
            case "5" -> "<dark_purple>";
            case "6" -> "<gold>";
            case "7" -> "<gray>";
            case "8" -> "<dark_gray>";
            case "9" -> "<blue>";
            case "a" -> "<green>";
            case "b" -> "<aqua>";
            case "c" -> "<red>";
            case "d" -> "<light_purple>";
            case "e" -> "<yellow>";
            case "f" -> "<white>";
            case "k" -> "<obfuscated>";
            case "l" -> "<bold>";
            case "m" -> "<strikethrough>";
            case "n" -> "<underlined>";
            case "o" -> "<italic>";
            case "r" -> "<reset>";
            default -> matchResult.getValue();
        };
    }
}

