/*
 * Decompiled with CFR 0.152.
 */
package dev.wooferz.armorhud.element;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.impl.controller.TickBoxControllerBuilderImpl;
import dev.wooferz.armorhud.config.ArmorHudAnchor;
import dev.wooferz.armorhud.config.ArmorHudConfig;
import dev.wooferz.hudlib.HudAnchor;
import dev.wooferz.hudlib.hud.HUDConfig;
import dev.wooferz.hudlib.hud.HUDElement;
import dev.wooferz.hudlib.utils.TextUtils;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ArmorHudElement
extends HUDElement {
    private boolean inEditor = false;
    public ArmorHudConfig config = new ArmorHudConfig();

    public ArmorHudElement() {
        super("Armor HUD", 10, 0, 48, 70, 1, "armor-hud", "armor-hud", HudAnchor.HorizontalAnchor.RIGHT, HudAnchor.VerticalAnchor.MIDDLE);
    }

    public void render(int x, int y, int width, int height, class_332 graphics, float v) {
        class_310 mc = class_310.method_1551();
        int distance = 17;
        if (mc.field_1724 != null) {
            boolean armorEmpty;
            class_1661 inv = mc.field_1724.method_31548();
            class_1799 helmet = inv.method_7372(3);
            class_1799 chest = inv.method_7372(2);
            class_1799 leggings = inv.method_7372(1);
            class_1799 boots = inv.method_7372(0);
            boolean bl = armorEmpty = helmet.method_7960() && chest.method_7960() && leggings.method_7960() && boots.method_7960();
            if (armorEmpty && this.inEditor) {
                helmet = new class_1799((class_1935)class_1802.field_8805);
                chest = new class_1799((class_1935)class_1802.field_8058);
                leggings = new class_1799((class_1935)class_1802.field_8348);
                boots = new class_1799((class_1935)class_1802.field_8285);
            }
            class_1799[] armor = new class_1799[]{helmet, chest, leggings, boots};
            int armourAmount = 0;
            for (class_1799 class_17992 : armor) {
                if (class_17992.method_7960()) continue;
                ++armourAmount;
            }
            int startY = 0;
            if (this.config.compactAnchor == ArmorHudAnchor.BOTTOM) {
                startY = 70 - (armourAmount * distance + 2);
            } else if (this.config.compactAnchor == ArmorHudAnchor.MIDDLE) {
                startY = 35 - (armourAmount * distance + 2) / 2;
            }
            int actualY = 0;
            int heightNegate = 0;
            for (class_1799 itemStack : armor) {
                int itemX = x + 2;
                int itemY = y + 2 + distance * actualY;
                int textX = x + 20;
                int textY = y + 6 + distance * actualY;
                graphics.method_51427(itemStack, itemX, startY + itemY);
                if (this.config.chroma.booleanValue()) {
                    TextUtils.drawText((class_332)graphics, (class_327)mc.field_1772, (String)this.getDurabilityString(itemStack).getString(), (int)textX, (int)(startY + textY), (int)0, (boolean)true, (boolean)false, (boolean)true);
                } else {
                    graphics.method_27535(mc.field_1772, this.getDurabilityString(itemStack), textX, startY + textY, -1);
                }
                if (!this.config.compactDisplay.booleanValue() || !itemStack.method_7960()) {
                    ++actualY;
                }
                if (!this.config.compactDisplay.booleanValue() || !itemStack.method_7960()) continue;
                heightNegate += distance;
            }
            if (!armorEmpty || this.inEditor) {
                int n = this.config.bgColor.getAlpha() << 24 | this.config.bgColor.getRed() << 16 | this.config.bgColor.getGreen() << 8 | this.config.bgColor.getBlue();
                graphics.method_25294(x, startY + y, x + width, startY + (y + height - heightNegate), n);
            }
        }
    }

    private class_2561 getDurabilityString(class_1799 item) {
        if (item.method_7963()) {
            class_124 color;
            int maxDurability = item.method_7936();
            int durability = maxDurability - item.method_7919();
            Integer percentage = (int)((float)durability / (float)maxDurability * 100.0f);
            Integer color2 = null;
            if (this.config.durabilityColor.booleanValue()) {
                color = class_124.field_1077;
                if (percentage < 20) {
                    color = class_124.field_1061;
                } else if (percentage < 50) {
                    color = class_124.field_1054;
                } else if (percentage < 80) {
                    color = class_124.field_1060;
                }
            } else {
                color = class_124.field_1068;
                color2 = this.config.color.getAlpha() << 24 | this.config.color.getRed() << 16 | this.config.color.getGreen() << 8 | this.config.color.getBlue();
            }
            Object text = percentage.toString() + "%";
            if (this.config.durabilityValue.booleanValue()) {
                text = String.valueOf(durability);
            }
            class_5250 component = class_2561.method_43470((String)text).method_27692(color);
            if (color2 != null) {
                component = component.method_27661().method_27696(class_2583.field_24360.method_36139(color2.intValue()));
            }
            return component;
        }
        return class_2561.method_43473();
    }

    public void editorClosed() {
        this.inEditor = false;
    }

    public void editorOpened() {
        this.inEditor = true;
    }

    public Class<?> getConfigType() {
        return ArmorHudConfig.class;
    }

    public HUDConfig getConfig() {
        return this.config;
    }

    public void setConfig(HUDConfig config) {
        if (config != null && config instanceof ArmorHudConfig) {
            this.config = (ArmorHudConfig)config;
        }
    }

    public OptionGroup generateConfig() {
        OptionGroup optionGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43470((String)this.displayName)).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Durability Color")).binding((Object)false, () -> this.config.durabilityColor, value -> {
            this.config.durabilityColor = value;
        }).controller(TickBoxControllerBuilderImpl::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Text Color")).binding((Object)Color.WHITE, () -> this.config.color, newColor -> {
            this.config.color = newColor;
        }).controller(ColorControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Background Color")).binding((Object)new Color(-1728053248, true), () -> this.config.bgColor, newColor -> {
            this.config.bgColor = newColor;
        }).controller(opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Chroma")).binding((Object)false, () -> this.config.chroma, newValue -> {
            this.config.chroma = newValue;
        }).controller(TickBoxControllerBuilderImpl::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Durability Value")).binding((Object)false, () -> this.config.durabilityValue, value -> {
            this.config.durabilityValue = value;
        }).controller(TickBoxControllerBuilderImpl::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Compact Display")).binding((Object)false, () -> this.config.compactDisplay, value -> {
            this.config.compactDisplay = value;
        }).controller(TickBoxControllerBuilderImpl::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Compact Display Anchor")).binding((Object)ArmorHudAnchor.TOP, () -> this.config.compactAnchor, value -> {
            this.config.compactAnchor = value;
        }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(ArmorHudAnchor.class)).build()).build();
        return optionGroup;
    }
}

