/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.backup;

import de.mcjunky33.backupmod.config.BackupConfig;
import de.mcjunky33.backupmod.lang.LangManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BackupManager {
    private static final String BACKUP_DIR = "backups";
    private static final String LOG_DIR = "backups" + File.separator + "logs";
    private static final String CONFIG_FILE_PATH = BackupConfig.CONFIG_FILE.replace("\\", "/");
    private static final List<String> DEFAULT_EXCLUDE = Arrays.asList("session.lock", CONFIG_FILE_PATH);
    private static BufferedWriter logWriter = null;

    private static void openLogFile(String backupFileName) {
        try {
            File logDir = new File(LOG_DIR);
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            String logFileName = backupFileName.replace(".zip", "") + ".log";
            File logFile = new File(LOG_DIR, logFileName);
            logWriter = new BufferedWriter(new FileWriter(logFile, true));
        }
        catch (IOException e) {
            System.out.println("[BackupMod] Could not open log file for backup: " + backupFileName);
            logWriter = null;
        }
    }

    private static void writeLog(String msg) {
        try {
            if (logWriter != null) {
                logWriter.write(msg);
                logWriter.newLine();
                logWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void closeLogFile() {
        if (logWriter != null) {
            try {
                logWriter.flush();
                logWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logWriter = null;
        }
    }

    public static void createBackupAsync(MinecraftServer server, String customName) {
        new Thread(() -> BackupManager.createBackup(server, customName), "BackupMod-BackupThread").start();
    }

    public static String createAutoBackupWithTimestamp(MinecraftServer server, String plannedTimestamp) {
        String backupFileName = "autobackup-" + plannedTimestamp + ".zip";
        BackupManager.createBackupAsync(server, backupFileName);
        return backupFileName;
    }

    public static String createBackup(MinecraftServer server) {
        return BackupManager.createBackup(server, null);
    }

    public static String createBackup(MinecraftServer server, String customName) {
        String timestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
        String backupFileName = customName != null && !customName.isEmpty() ? customName + "-" + timestamp + ".zip" : "backup-" + timestamp + ".zip";
        return BackupManager.createBackupInternal(server, backupFileName);
    }

    private static String createBackupInternal(MinecraftServer server, String backupFileName) {
        String zipFilePath = BACKUP_DIR + File.separator + backupFileName;
        BackupManager.openLogFile(backupFileName);
        BackupManager.broadcastAllPlayers(server, LangManager.tr("backup.started", new Object[0]), class_124.field_1060);
        BackupManager.writeLog("[BackupMod] Backup started.");
        final HashSet<String> excludeList = new HashSet<String>(DEFAULT_EXCLUDE);
        if (BackupConfig.excludePaths != null) {
            for (String path : BackupConfig.excludePaths) {
                String cleanPath = path.replace("\\", "/");
                excludeList.add(cleanPath);
            }
        }
        excludeList.add(CONFIG_FILE_PATH);
        Thread backupThread = new Thread(() -> {
            try (FileOutputStream fos = new FileOutputStream(zipFilePath);
                 final ZipOutputStream zos = new ZipOutputStream(fos);){
                final ArrayList filesToBackup = new ArrayList();
                Files.walkFileTree(Paths.get(".", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        String name = dir.getFileName().toString();
                        String dirPath = dir.toString().replace("\\", "/");
                        if (name.equals(BackupManager.BACKUP_DIR) || name.equals(".temp")) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (excludeList.contains(name) || excludeList.contains(dirPath)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (!dir.equals(Paths.get(".", new String[0]))) {
                            String zipDirName = dir.toString().replace("\\", "/");
                            if (zipDirName.startsWith("./")) {
                                zipDirName = zipDirName.substring(2);
                            }
                            ZipEntry zipEntry = new ZipEntry(zipDirName + "/");
                            try {
                                zos.putNextEntry(zipEntry);
                                zos.closeEntry();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String name = file.getFileName().toString();
                        String filePath = file.toString().replace("\\", "/");
                        if (excludeList.contains(name) || excludeList.contains(filePath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (!file.toFile().isFile()) {
                            return FileVisitResult.CONTINUE;
                        }
                        filesToBackup.add(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
                int totalFiles = filesToBackup.size();
                if (totalFiles == 0) {
                    BackupManager.broadcastAllPlayers(server, LangManager.tr("backup.failed", "No files to backup"), class_124.field_1061);
                    BackupManager.writeLog("[BackupMod] Backup failed: No files to backup.");
                    BackupManager.closeLogFile();
                    return;
                }
                File tempDir = new File(".temp");
                if (!tempDir.exists()) {
                    tempDir.mkdirs();
                }
                int copied = 0;
                for (Path file : filesToBackup) {
                    ++copied;
                    File f = file.toFile();
                    boolean copiedToZip = false;
                    String zipEntryName = file.toString().replace("\\", "/");
                    if (zipEntryName.startsWith("./")) {
                        zipEntryName = zipEntryName.substring(2);
                    }
                    try (FileInputStream fis = new FileInputStream(f);){
                        int len;
                        ZipEntry zipEntry = new ZipEntry(zipEntryName);
                        zos.putNextEntry(zipEntry);
                        byte[] buffer = new byte[4096];
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        copiedToZip = true;
                    }
                    catch (Exception e) {
                        BackupManager.writeLog("Direct copy failed for " + String.valueOf(file.toAbsolutePath()) + ": " + e.getMessage());
                    }
                    if (!copiedToZip) {
                        try {
                            Path rel = Paths.get(".", new String[0]).toAbsolutePath().relativize(file.toAbsolutePath());
                            File tempFile = new File(tempDir, rel.toString());
                            File parent = tempFile.getParentFile();
                            if (parent != null && !parent.exists()) {
                                parent.mkdirs();
                            }
                            Files.copy(f.toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            try (FileInputStream fis = new FileInputStream(tempFile);){
                                int len;
                                ZipEntry zipEntry = new ZipEntry(zipEntryName);
                                zos.putNextEntry(zipEntry);
                                byte[] buffer = new byte[4096];
                                while ((len = fis.read(buffer)) > 0) {
                                    zos.write(buffer, 0, len);
                                }
                                zos.closeEntry();
                            }
                            BackupManager.deleteFileAndEmptyParents(tempFile, tempDir);
                            copiedToZip = true;
                        }
                        catch (Exception e2) {
                            BackupManager.writeLog("Temp copy failed for " + String.valueOf(file.toAbsolutePath()) + ": " + e2.getMessage());
                        }
                    }
                    int percent = (int)((double)copied / (double)totalFiles * 100.0);
                    String percentMsg = percent + "%";
                    BackupManager.broadcastAllPlayers(server, percentMsg, class_124.field_1054);
                    BackupManager.writeLog(percentMsg);
                    String progressFileMsg = "[BackupMod] Progress: " + copied + "/" + totalFiles + " - " + file.toString();
                    BackupManager.writeLog(progressFileMsg);
                    System.out.println(progressFileMsg);
                    for (class_3222 player : server.method_3760().method_14571()) {
                        boolean isPerm = BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
                        boolean isOp = player.method_64475(2);
                        if (!isOp && !isPerm || !BackupConfig.permlogEnabled) continue;
                        player.method_64398((class_2561)class_2561.method_43470((String)progressFileMsg).method_27692(class_124.field_1080));
                    }
                }
                BackupManager.broadcastAllPlayers(server, LangManager.tr("backup.completed_no_file", new Object[0]), class_124.field_1060);
                BackupManager.writeLog("[BackupMod] Backup completed.");
                String savedMsg = "[BackupMod] saved file as " + backupFileName;
                for (class_3222 player : server.method_3760().method_14571()) {
                    boolean isPerm = BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
                    boolean isOp = player.method_64475(2);
                    if (!isOp && !isPerm || !BackupConfig.permlogEnabled) continue;
                    player.method_64398((class_2561)class_2561.method_43470((String)savedMsg).method_27692(class_124.field_1080));
                }
                BackupManager.writeLog(savedMsg);
                System.out.println(savedMsg);
                BackupManager.deleteOldBackupsIfNeeded();
            }
            catch (Exception e) {
                BackupManager.broadcastAllPlayers(server, LangManager.tr("backup.failed", e.getMessage()), class_124.field_1061);
                BackupManager.writeLog("[BackupMod] Backup failed: " + e.getMessage());
            }
            BackupManager.closeLogFile();
        }, "BackupMod-ZipThread");
        backupThread.setPriority(1);
        backupThread.start();
        return backupFileName;
    }

    private static void deleteFileAndEmptyParents(File file, File rootDir) {
        if (file.exists()) {
            file.delete();
        }
        for (File parent = file.getParentFile(); parent != null && !parent.equals(rootDir) && parent.list().length == 0; parent = parent.getParentFile()) {
            parent.delete();
        }
    }

    private static void broadcastAllPlayers(MinecraftServer server, String msg, class_124 color) {
        if (server == null) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean isOp = player.method_64475(2);
            boolean isPerm = BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
            if (!BackupConfig.normallogEnabled && (!isOp && !isPerm || !BackupConfig.permlogEnabled)) continue;
            player.method_64398((class_2561)class_2561.method_43470((String)msg).method_27692(color));
        }
    }

    public static List<String> listBackups() {
        File dir = new File(BACKUP_DIR);
        File[] backups = dir.listFiles((d, name) -> name.endsWith(".zip"));
        ArrayList<String> names = new ArrayList<String>();
        if (backups != null) {
            for (File f : backups) {
                names.add(f.getName());
            }
        }
        return names;
    }

    public static String getLatestBackup() {
        File dir = new File(BACKUP_DIR);
        File[] backups = dir.listFiles((d, name) -> name.endsWith(".zip"));
        if (backups == null || backups.length == 0) {
            return null;
        }
        Arrays.sort(backups, Comparator.comparingLong(File::lastModified).reversed());
        return backups[0].getName();
    }

    public static void deleteOldBackupsIfNeeded() {
        File dir = new File(BACKUP_DIR);
        File[] backups = dir.listFiles((d, name) -> name.endsWith(".zip"));
        if (backups == null) {
            return;
        }
        if (backups.length > BackupConfig.maxBackups) {
            Arrays.sort(backups, Comparator.comparingLong(File::lastModified));
            int toDelete = backups.length - BackupConfig.maxBackups;
            for (int i = 0; i < toDelete; ++i) {
                backups[i].delete();
            }
        }
    }

    public static void runServerCommand(MinecraftServer server, String cmd) {
        try {
            server.method_3734().method_9235().execute(cmd, (Object)server.method_3739());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

