/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.backup;

import de.mcjunky33.backupmod.config.BackupConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;

public class BackupScheduler {
    private static final String HISTORY_FILE = "backups/.temp/schedule-history.json";
    private static final String SCHEDULE_FILE = "backups/.temp/schedulesystem.yml";
    private static List<LocalDateTime> todayBackups = new ArrayList<LocalDateTime>();
    private static LocalDate lastCheckedDay = null;
    private static boolean isDebugTimerActive = false;
    private static int debugSeconds = 0;
    private static LocalDateTime lastBackupTime = null;
    private static double lastIntervalSeconds = 2160.0;
    private static long secondsRemaining = -1L;
    private static int tickCounter = 0;

    private static void saveScheduleState() {
        File file = new File(SCHEDULE_FILE);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write("lastBackupTime: " + (lastBackupTime == null ? "" : lastBackupTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)) + "\n");
            writer.write("isDebugTimerActive: " + isDebugTimerActive + "\n");
            writer.write("debugSeconds: " + debugSeconds + "\n");
            writer.write("lastIntervalSeconds: " + lastIntervalSeconds + "\n");
            writer.write("secondsRemaining: " + secondsRemaining + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadScheduleState() {
        File file = new File(SCHEDULE_FILE);
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            LocalDateTime lbTime = null;
            boolean debugActive = false;
            int dbgSeconds = 0;
            double liSeconds = 2160.0;
            long secRem = -1L;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("lastBackupTime: ")) {
                    String tLine = line.substring("lastBackupTime: ".length()).trim();
                    LocalDateTime localDateTime = lbTime = tLine.isEmpty() ? null : LocalDateTime.parse(tLine, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                if (line.startsWith("isDebugTimerActive: ")) {
                    debugActive = "true".equals(line.substring("isDebugTimerActive: ".length()).trim());
                }
                if (line.startsWith("debugSeconds: ")) {
                    try {
                        dbgSeconds = Integer.parseInt(line.substring("debugSeconds: ".length()).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (line.startsWith("lastIntervalSeconds: ")) {
                    try {
                        liSeconds = Double.parseDouble(line.substring("lastIntervalSeconds: ".length()).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!line.startsWith("secondsRemaining: ")) continue;
                try {
                    secRem = Long.parseLong(line.substring("secondsRemaining: ".length()).trim());
                }
                catch (Exception exception) {}
            }
            lastBackupTime = lbTime;
            isDebugTimerActive = debugActive;
            debugSeconds = dbgSeconds;
            lastIntervalSeconds = liSeconds;
            secondsRemaining = secRem;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAutoBackupTimes(int backupsPerDay) {
        if (backupsPerDay < 1) {
            BackupConfig.autoBackupTimes = 0;
            BackupConfig.autoBackupEnabled = 0;
            BackupConfig.saveConfig();
            BackupScheduler.resetSchedule();
            return;
        }
        BackupConfig.autoBackupTimes = backupsPerDay;
        BackupConfig.autoBackupEnabled = 1;
        BackupConfig.saveConfig();
        todayBackups.clear();
        lastIntervalSeconds = 86400.0 / (double)backupsPerDay;
        lastBackupTime = LocalDateTime.now();
        isDebugTimerActive = false;
        debugSeconds = 0;
        secondsRemaining = (long)lastIntervalSeconds;
        tickCounter = 0;
        BackupScheduler.saveScheduleState();
    }

    public static void setDebugTimer(int hours, int minutes, int seconds, MinecraftServer server) {
        int totalSeconds = hours * 3600 + minutes * 60 + seconds;
        isDebugTimerActive = true;
        debugSeconds = totalSeconds;
        lastBackupTime = LocalDateTime.now();
        secondsRemaining = -1L;
        tickCounter = 0;
        BackupScheduler.saveScheduleState();
        todayBackups.clear();
    }

    public static String getNextScheduledBackupTimerString() {
        BackupScheduler.loadScheduleState();
        if (isDebugTimerActive) {
            long secondsRem = debugSeconds;
            if (secondsRem <= 0L) {
                return "Debug timer finished! Backup will be executed automatically.";
            }
            long hours = secondsRem / 3600L;
            long minutes = secondsRem % 3600L / 60L;
            long seconds = secondsRem % 60L;
            return String.format("%02dh %02dmin %02dsec", hours, minutes, seconds);
        }
        if (secondsRemaining >= 0L) {
            long secondsRem = secondsRemaining;
            long hours = secondsRem / 3600L;
            long minutes = secondsRem % 3600L / 60L;
            long seconds = secondsRem % 60L;
            return String.format("%02dh %02dmin %02dsec", hours, minutes, seconds);
        }
        int timesPerDay = Math.max(BackupConfig.autoBackupTimes, 1);
        double intervalSeconds = 86400.0 / (double)timesPerDay;
        long secondsRem = (long)intervalSeconds;
        long hours = secondsRem / 3600L;
        long minutes = secondsRem % 3600L / 60L;
        long seconds = secondsRem % 60L;
        return String.format("%02dh %02dmin %02dsec", hours, minutes, seconds);
    }

    public static void checkAndRunBackup(MinecraftServer server) {
        boolean success;
        BackupScheduler.loadScheduleState();
        int timesPerDay = Math.max(BackupConfig.autoBackupTimes, 1);
        lastIntervalSeconds = 86400.0 / (double)timesPerDay;
        if (secondsRemaining < 0L) {
            secondsRemaining = (long)lastIntervalSeconds;
            BackupScheduler.saveScheduleState();
        }
        boolean doBackup = false;
        if (++tickCounter >= 20) {
            tickCounter = 0;
            if (secondsRemaining > 0L) {
                --secondsRemaining;
                BackupScheduler.saveScheduleState();
            } else if (secondsRemaining == 0L) {
                doBackup = true;
            }
        }
        if (doBackup && (success = BackupScheduler.runScheduledBackup(server))) {
            lastBackupTime = LocalDateTime.now();
            todayBackups.add(lastBackupTime);
            secondsRemaining = (long)lastIntervalSeconds;
            tickCounter = 0;
            BackupScheduler.saveScheduleState();
        }
    }

    public static boolean runScheduledBackup(MinecraftServer server) {
        String cmd = "backup create autobackup";
        try {
            server.method_3734().method_9235().execute(cmd, (Object)server.method_3739().method_9206(4));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void resetSchedule() {
        todayBackups.clear();
        lastCheckedDay = LocalDate.now();
        File file = new File(HISTORY_FILE);
        File file2 = new File(SCHEDULE_FILE);
        if (file.exists()) {
            file.delete();
        }
        if (file2.exists()) {
            file2.delete();
        }
        lastBackupTime = null;
        isDebugTimerActive = false;
        debugSeconds = 0;
        lastIntervalSeconds = 2160.0;
        secondsRemaining = -1L;
        tickCounter = 0;
    }

    public static boolean isDebugTimerActive() {
        return isDebugTimerActive;
    }
}

