/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BackupConfig {
    public static String lang = "en_us";
    public static List<String> excludePaths = new ArrayList<String>();
    public static int maxBackups = Integer.MAX_VALUE;
    public static int autoBackupTimes = 0;
    public static int autoBackupEnabled = 0;
    public static boolean normallogEnabled = true;
    public static boolean permlogEnabled = true;
    public static List<PermUser> permissionUsers = new ArrayList<PermUser>();
    public static final String BACKUP_DIR = "backups";
    public static final String CONFIG_FILE = "backups" + File.separator + "backup-config.json";

    public static void load() {
        boolean created;
        File dir = new File(BACKUP_DIR);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            System.err.println("Could not create backup folder!");
            return;
        }
        File f = new File(CONFIG_FILE);
        if (!f.exists() || f.length() == 0L) {
            BackupConfig.saveDefaults();
            return;
        }
        try (FileReader reader = new FileReader(f);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            lang = json.has("lang") ? json.get("lang").getAsString() : "en_us";
            excludePaths = new ArrayList<String>();
            if (json.has("excludePaths") && json.get("excludePaths").isJsonArray()) {
                for (JsonElement el : json.getAsJsonArray("excludePaths")) {
                    excludePaths.add(el.getAsString());
                }
            }
            maxBackups = json.has("maxBackups") ? json.get("maxBackups").getAsInt() : Integer.MAX_VALUE;
            autoBackupTimes = json.has("autoBackupTimes") ? json.get("autoBackupTimes").getAsInt() : 0;
            autoBackupEnabled = json.has("autoBackupEnabled") ? json.get("autoBackupEnabled").getAsInt() : 0;
            normallogEnabled = json.has("normallogEnabled") ? json.get("normallogEnabled").getAsBoolean() : true;
            permlogEnabled = json.has("permlogEnabled") ? json.get("permlogEnabled").getAsBoolean() : true;
            permissionUsers = new ArrayList<PermUser>();
            if (json.has("permissionUsers") && json.get("permissionUsers").isJsonArray()) {
                for (JsonElement el : json.getAsJsonArray("permissionUsers")) {
                    String name;
                    JsonObject obj = el.getAsJsonObject();
                    String uuid = obj.has("uuid") ? obj.get("uuid").getAsString() : "";
                    String string = name = obj.has("name") ? obj.get("name").getAsString() : "";
                    if (uuid.isEmpty() || name.isEmpty()) continue;
                    permissionUsers.add(new PermUser(uuid, name));
                }
            }
        }
        catch (Exception e) {
            System.err.println("BackupConfig error loading: " + e.getMessage());
            BackupConfig.saveDefaults();
        }
    }

    public static void saveDefaults() {
        lang = "en_us";
        excludePaths = new ArrayList<String>();
        maxBackups = Integer.MAX_VALUE;
        autoBackupTimes = 0;
        autoBackupEnabled = 0;
        normallogEnabled = true;
        permlogEnabled = true;
        permissionUsers = new ArrayList<PermUser>();
        BackupConfig.saveConfig();
    }

    public static void saveConfig() {
        boolean created;
        File dir = new File(BACKUP_DIR);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            System.err.println(" could not create backup folder!");
            return;
        }
        File f = new File(CONFIG_FILE);
        try (FileWriter writer = new FileWriter(f);){
            JsonObject json = new JsonObject();
            json.addProperty("lang", lang);
            JsonArray excludes = new JsonArray();
            for (String string : excludePaths != null ? excludePaths : Collections.emptyList()) {
                excludes.add((JsonElement)new JsonPrimitive(string));
            }
            json.add("excludePaths", (JsonElement)excludes);
            json.addProperty("maxBackups", (Number)maxBackups);
            json.addProperty("autoBackupTimes", (Number)autoBackupTimes);
            json.addProperty("autoBackupEnabled", (Number)autoBackupEnabled);
            json.addProperty("normallogEnabled", Boolean.valueOf(normallogEnabled));
            json.addProperty("permlogEnabled", Boolean.valueOf(permlogEnabled));
            JsonArray perms = new JsonArray();
            for (PermUser user : permissionUsers) {
                JsonObject obj = new JsonObject();
                obj.addProperty("uuid", user.uuid);
                obj.addProperty("name", user.name);
                perms.add((JsonElement)obj);
            }
            json.add("permissionUsers", (JsonElement)perms);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson((JsonElement)json));
        }
        catch (Exception e) {
            System.err.println("BackupConfig failed to save: " + e.getMessage());
        }
    }

    public static boolean hasBackupPerm(String uuid, String name) {
        if (uuid == null || name == null) {
            return false;
        }
        for (PermUser u : permissionUsers) {
            if (!u.uuid.equals(uuid) && !u.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void addPermUser(String uuid, String name) {
        if (!BackupConfig.hasBackupPerm(uuid, name)) {
            permissionUsers.add(new PermUser(uuid, name));
            BackupConfig.saveConfig();
        }
    }

    public static void removePermUser(String uuid, String name) {
        permissionUsers.removeIf(u -> u.uuid.equals(uuid) || u.name.equalsIgnoreCase(name));
        BackupConfig.saveConfig();
    }

    public static class PermUser {
        public String uuid;
        public String name;

        public PermUser(String uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }
    }
}

