/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.lang;

import com.google.gson.Gson;
import de.mcjunky33.backupmod.config.BackupConfig;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class LangManager {
    private static Map<String, String> translations = new HashMap<String, String>();
    private static Map<String, String> fallbackTranslations = new HashMap<String, String>();

    public static void load() {
        try {
            InputStream fallbackStream = LangManager.class.getResourceAsStream("/assets/backupmod/lang/en_us.json");
            if (fallbackStream != null) {
                InputStreamReader fallbackReader = new InputStreamReader(fallbackStream);
                fallbackTranslations = (Map)new Gson().fromJson((Reader)fallbackReader, Map.class);
                fallbackReader.close();
            } else {
                fallbackTranslations = new HashMap<String, String>();
            }
            String lang = BackupConfig.lang;
            String file = "/assets/backupmod/lang/" + lang + ".json";
            InputStream stream = LangManager.class.getResourceAsStream(file);
            if (stream != null) {
                InputStreamReader reader = new InputStreamReader(stream);
                translations = (Map)new Gson().fromJson((Reader)reader, Map.class);
                reader.close();
            } else {
                translations = new HashMap<String, String>();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            translations = new HashMap<String, String>();
            fallbackTranslations = new HashMap<String, String>();
        }
    }

    public static String tr(String key, Object ... args) {
        String s = translations.getOrDefault(key, fallbackTranslations.getOrDefault(key, key));
        for (int i = 0; i < args.length; ++i) {
            s = s.replace("{" + i + "}", args[i].toString());
        }
        return s;
    }
}

