/*
 * Decompiled with CFR 0.152.
 */
package com.Mateitaa1.PlayRewardZ;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayRewardZ
extends JavaPlugin
implements Listener {
    private File playerDataFile;
    private File milestonesFile;
    private FileConfiguration playerData;
    private FileConfiguration milestones;
    private Map<UUID, Long> onlinePlayers = new ConcurrentHashMap<UUID, Long>();
    private Map<UUID, Long> totalPlaytimes = new ConcurrentHashMap<UUID, Long>();
    private List<Milestone> milestoneList = new ArrayList<Milestone>();

    @Override
    public void onEnable() {
        this.getServer().getPluginManager().registerEvents(this, this);
        this.saveDefaultConfig();
        this.setupFiles();
        this.loadMilestones();
        this.loadPlayerData();
        this.registerCommands();
        this.startPlaytimeTracker();
        this.getLogger().info(String.valueOf((Object)ChatColor.GREEN) + "PlayRewardZ has been enabled!");
    }

    @Override
    public void onDisable() {
        this.saveAllPlaytimes();
        this.getLogger().info(String.valueOf((Object)ChatColor.RED) + "PlayRewardZ has been disabled!");
    }

    private void setupFiles() {
        this.playerDataFile = new File(this.getDataFolder(), "playerdata.yml");
        this.milestonesFile = new File(this.getDataFolder(), "milestones.yml");
        if (!this.playerDataFile.exists()) {
            this.playerDataFile.getParentFile().mkdirs();
            this.saveResource("playerdata.yml", false);
        }
        if (!this.milestonesFile.exists()) {
            this.milestonesFile.getParentFile().mkdirs();
            this.saveResource("milestones.yml", false);
        }
        this.playerData = YamlConfiguration.loadConfiguration(this.playerDataFile);
        this.milestones = YamlConfiguration.loadConfiguration(this.milestonesFile);
    }

    private void savePlayerData() {
        for (Map.Entry<UUID, Long> entry : this.totalPlaytimes.entrySet()) {
            this.playerData.set("players." + entry.getKey().toString() + ".playtime", entry.getValue());
            this.playerData.set("players." + entry.getKey().toString() + ".lastUsername", Bukkit.getOfflinePlayer(entry.getKey()).getName());
        }
        try {
            this.playerData.save(this.playerDataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save player data file!");
            e.printStackTrace();
        }
    }

    private void loadPlayerData() {
        ConfigurationSection playersSection;
        if (this.playerData.contains("players") && (playersSection = this.playerData.getConfigurationSection("players")) != null) {
            for (String uuidString : playersSection.getKeys(false)) {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    long playtime = this.playerData.getLong("players." + uuidString + ".playtime", 0L);
                    this.totalPlaytimes.put(uuid, playtime);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid UUID found in player data: " + uuidString);
                }
            }
        }
    }

    private void saveMilestones() {
        this.milestones.set("milestones", null);
        for (int i = 0; i < this.milestoneList.size(); ++i) {
            Milestone milestone = this.milestoneList.get(i);
            String path = "milestones." + i;
            this.milestones.set(path + ".hours", milestone.getHours());
            ArrayList<Map<String, Object>> serializedItems = new ArrayList<Map<String, Object>>();
            for (ItemStack item : milestone.getRewards()) {
                serializedItems.add(item.serialize());
            }
            this.milestones.set(path + ".rewards", serializedItems);
        }
        try {
            this.milestones.save(this.milestonesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save milestones file!");
            e.printStackTrace();
        }
    }

    private void loadMilestones() {
        ConfigurationSection milestonesSection;
        this.milestoneList.clear();
        if (this.milestones.contains("milestones") && (milestonesSection = this.milestones.getConfigurationSection("milestones")) != null) {
            for (String key : milestonesSection.getKeys(false)) {
                String path = "milestones." + key;
                int hours = this.milestones.getInt(path + ".hours");
                ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
                List<?> serializedItems = this.milestones.getList(path + ".rewards");
                if (serializedItems != null) {
                    for (Object obj : serializedItems) {
                        if (!(obj instanceof Map)) continue;
                        Map map = (Map)obj;
                        ItemStack item = ItemStack.deserialize(map);
                        rewards.add(item);
                    }
                }
                this.milestoneList.add(new Milestone(hours, rewards));
            }
        }
        this.milestoneList.sort(Comparator.comparingInt(Milestone::getHours));
    }

    private void registerCommands() {
        this.getCommand("playtime").setExecutor(new PlaytimeCommand());
        this.getCommand("milestone").setExecutor(new MilestoneCommand());
    }

    private void startPlaytimeTracker() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (UUID uuid : this.onlinePlayers.keySet()) {
                Player player = Bukkit.getPlayer(uuid);
                if (this.getConfig().getBoolean("ignore-afk-time", false) && this.isPlayerAFK(player)) continue;
                long currentTotal = this.totalPlaytimes.getOrDefault(uuid, 0L);
                this.totalPlaytimes.put(uuid, currentTotal + 60000L);
                this.checkMilestones(player);
            }
            if (Bukkit.getScheduler().getPendingTasks().size() % (1200 * this.getConfig().getInt("save-interval-minutes", 10)) == 0) {
                this.savePlayerData();
            }
        }, 1200L, 1200L);
    }

    private boolean isPlayerAFK(Player player) {
        return false;
    }

    private void saveAllPlaytimes() {
        for (UUID uuid : this.onlinePlayers.keySet()) {
            long joinTime = this.onlinePlayers.get(uuid);
            long currentTime = System.currentTimeMillis();
            long sessionTime = currentTime - joinTime;
            long currentTotal = this.totalPlaytimes.getOrDefault(uuid, 0L);
            this.totalPlaytimes.put(uuid, currentTotal + sessionTime);
        }
        this.savePlayerData();
    }

    private void checkMilestones(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        UUID uuid = player.getUniqueId();
        long playtimeMillis = this.totalPlaytimes.getOrDefault(uuid, 0L);
        long playtimeHours = playtimeMillis / 3600000L;
        for (Milestone milestone : this.milestoneList) {
            if (this.playerData.contains("players." + String.valueOf(uuid) + ".claimed-milestones") && this.playerData.getList("players." + String.valueOf(uuid) + ".claimed-milestones").contains(milestone.getHours()) || playtimeHours < (long)milestone.getHours()) continue;
            this.giveRewards(player, milestone);
            List<Integer> claimedMilestones = this.playerData.getIntegerList("players." + String.valueOf(uuid) + ".claimed-milestones");
            claimedMilestones.add(milestone.getHours());
            this.playerData.set("players." + String.valueOf(uuid) + ".claimed-milestones", claimedMilestones);
            String message = ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.milestone-reached", "&a[PlayRewardZ] &fCongratulations! You've reached the &e{hours}h &fplaytime milestone!").replace("{hours}", String.valueOf(milestone.getHours())));
            player.sendMessage(message);
            if (!this.getConfig().getBoolean("sounds.milestone-reached.enabled", true)) continue;
            try {
                player.playSound(player.getLocation(), this.getConfig().getString("sounds.milestone-reached.sound", "ENTITY_PLAYER_LEVELUP"), 1.0f, 1.0f);
            }
            catch (Exception e) {
                this.getLogger().warning("Invalid sound specified in config for milestone-reached!");
            }
        }
    }

    private void giveRewards(Player player, Milestone milestone) {
        for (ItemStack reward : milestone.getRewards()) {
            HashMap<Integer, ItemStack> leftover = player.getInventory().addItem(reward.clone());
            if (leftover.isEmpty()) continue;
            for (ItemStack item : leftover.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.getConfig().getString("messages.inventory-full", "&a[PlayRewardZ] &cYour inventory is full! Some items were dropped at your feet.")));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.onlinePlayers.put(uuid, System.currentTimeMillis());
        if (!this.totalPlaytimes.containsKey(uuid)) {
            this.totalPlaytimes.put(uuid, 0L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.onlinePlayers.containsKey(uuid)) {
            long joinTime = this.onlinePlayers.get(uuid);
            long quitTime = System.currentTimeMillis();
            long sessionTime = quitTime - joinTime;
            long currentTotal = this.totalPlaytimes.getOrDefault(uuid, 0L);
            this.totalPlaytimes.put(uuid, currentTotal + sessionTime);
            this.onlinePlayers.remove(uuid);
        }
    }

    public static class Milestone {
        private final int hours;
        private final List<ItemStack> rewards;

        public Milestone(int hours, List<ItemStack> rewards) {
            this.hours = hours;
            this.rewards = rewards;
        }

        public int getHours() {
            return this.hours;
        }

        public List<ItemStack> getRewards() {
            return this.rewards;
        }

        public void addReward(ItemStack item) {
            this.rewards.add(item);
        }
    }

    private class PlaytimeCommand
    implements CommandExecutor {
        private PlaytimeCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            Player target;
            if (!(sender instanceof Player) && args.length == 0) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Only players can check their own playtime. Please specify a player name.");
                return true;
            }
            if (args.length > 0 && sender.hasPermission("playrewardz.playtime.others")) {
                target = Bukkit.getPlayer(args[0]);
                if (target == null) {
                    UUID offlineUUID = null;
                    String offlineName = null;
                    for (String uuidStr : PlayRewardZ.this.playerData.getConfigurationSection("players").getKeys(false)) {
                        String name = PlayRewardZ.this.playerData.getString("players." + uuidStr + ".lastUsername");
                        if (name == null || !name.equalsIgnoreCase(args[0])) continue;
                        offlineUUID = UUID.fromString(uuidStr);
                        offlineName = name;
                        break;
                    }
                    if (offlineUUID != null) {
                        long playtimeMillis = PlayRewardZ.this.playerData.getLong("players." + offlineUUID.toString() + ".playtime", 0L);
                        this.sendPlaytimeMessage(sender, offlineName, playtimeMillis, true);
                        return true;
                    }
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Player not found: " + args[0]);
                    return true;
                }
            } else {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Console must specify a player name.");
                    return true;
                }
                target = (Player)sender;
            }
            UUID uuid = target.getUniqueId();
            long storedTime = PlayRewardZ.this.totalPlaytimes.getOrDefault(uuid, 0L);
            if (PlayRewardZ.this.onlinePlayers.containsKey(uuid)) {
                long joinTime = PlayRewardZ.this.onlinePlayers.get(uuid);
                long currentTime = System.currentTimeMillis();
                long sessionTime = currentTime - joinTime;
                storedTime += sessionTime;
            }
            this.sendPlaytimeMessage(sender, target.getName(), storedTime, false);
            return true;
        }

        private void sendPlaytimeMessage(CommandSender sender, String playerName, long playtimeMillis, boolean isOffline) {
            long totalSeconds = playtimeMillis / 1000L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            long seconds = totalSeconds % 60L;
            String message = sender.getName().equals(playerName) && !isOffline ? ChatColor.translateAlternateColorCodes('&', PlayRewardZ.this.getConfig().getString("messages.playtime-self", "&a[PlayRewardZ] &fYou have played for &e{hours}h {minutes}m {seconds}s&f.")) : ChatColor.translateAlternateColorCodes('&', PlayRewardZ.this.getConfig().getString("messages.playtime-other", "&a[PlayRewardZ] &f{player} has played for &e{hours}h {minutes}m {seconds}s&f.") + (isOffline ? " &7(Offline)" : ""));
            message = message.replace("{player}", playerName).replace("{hours}", String.valueOf(hours)).replace("{minutes}", String.valueOf(minutes)).replace("{seconds}", String.valueOf(seconds));
            sender.sendMessage(message);
        }
    }

    private class MilestoneCommand
    implements CommandExecutor {
        private MilestoneCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            String subCommand;
            if (args.length == 0) {
                this.showMilestoneHelp(sender);
                return true;
            }
            switch (subCommand = args[0].toLowerCase()) {
                case "list": {
                    this.listMilestones(sender);
                    break;
                }
                case "create": {
                    if (!sender.hasPermission("playrewardz.milestone.create")) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to create milestones.");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /milestone create <hours>");
                        return true;
                    }
                    try {
                        int hours = Integer.parseInt(args[1]);
                        if (hours <= 0) {
                            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Hours must be a positive number.");
                            return true;
                        }
                        this.createMilestone(sender, hours);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Hours must be a valid number.");
                    }
                    break;
                }
                case "item": {
                    if (!sender.hasPermission("playrewardz.milestone.edit")) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to edit milestones.");
                        return true;
                    }
                    if (args.length < 4) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /milestone item <add|remove> <hours> [item-index]");
                        return true;
                    }
                    String action = args[1].toLowerCase();
                    try {
                        int hours = Integer.parseInt(args[2]);
                        if (action.equals("add")) {
                            this.addItemToMilestone(sender, hours);
                            break;
                        }
                        if (action.equals("remove")) {
                            if (args.length < 4) {
                                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /milestone item remove <hours> <item-index>");
                                return true;
                            }
                            try {
                                int index = Integer.parseInt(args[3]);
                                this.removeItemFromMilestone(sender, hours, index);
                            }
                            catch (NumberFormatException e) {
                                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Item index must be a valid number.");
                            }
                            break;
                        }
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Unknown action: " + action);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Hours must be a valid number.");
                    }
                    break;
                }
                case "delete": {
                    if (!sender.hasPermission("playrewardz.milestone.delete")) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to delete milestones.");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Usage: /milestone delete <hours>");
                        return true;
                    }
                    try {
                        int hours = Integer.parseInt(args[1]);
                        this.deleteMilestone(sender, hours);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Hours must be a valid number.");
                    }
                    break;
                }
                default: {
                    this.showMilestoneHelp(sender);
                }
            }
            return true;
        }

        private void showMilestoneHelp(CommandSender sender) {
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "===== PlayRewardZ Milestone Commands =====");
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/milestone list " + String.valueOf((Object)ChatColor.WHITE) + "- List all milestones");
            if (sender.hasPermission("playrewardz.milestone.create")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/milestone create <hours> " + String.valueOf((Object)ChatColor.WHITE) + "- Create a new milestone");
            }
            if (sender.hasPermission("playrewardz.milestone.edit")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/milestone item add <hours> " + String.valueOf((Object)ChatColor.WHITE) + "- Add item in hand to a milestone");
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/milestone item remove <hours> <index> " + String.valueOf((Object)ChatColor.WHITE) + "- Remove an item from a milestone");
            }
            if (sender.hasPermission("playrewardz.milestone.delete")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "/milestone delete <hours> " + String.valueOf((Object)ChatColor.WHITE) + "- Delete a milestone");
            }
        }

        private void listMilestones(CommandSender sender) {
            if (PlayRewardZ.this.milestoneList.isEmpty()) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "No milestones have been created yet.");
                return;
            }
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "===== PlayRewardZ Milestones =====");
            for (Milestone milestone : PlayRewardZ.this.milestoneList) {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "\u2022 " + milestone.getHours() + " hours - " + String.valueOf((Object)ChatColor.WHITE) + milestone.getRewards().size() + " rewards");
                if (!sender.hasPermission("playrewardz.milestone.view.details")) continue;
                for (int i = 0; i < milestone.getRewards().size(); ++i) {
                    ItemStack item = milestone.getRewards().get(i);
                    sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "  " + (i + 1) + ". " + this.formatItemName(item) + " x" + item.getAmount());
                }
            }
        }

        private String formatItemName(ItemStack item) {
            String name = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : this.capitalizeWords(item.getType().toString().replace('_', ' ').toLowerCase());
            return name;
        }

        private String capitalizeWords(String str) {
            String[] words = str.split("\\s");
            StringBuilder result = new StringBuilder();
            for (String word : words) {
                if (word.length() <= 0) continue;
                result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
            }
            return result.toString().trim();
        }

        private void createMilestone(CommandSender sender, int hours) {
            for (Milestone milestone : PlayRewardZ.this.milestoneList) {
                if (milestone.getHours() != hours) continue;
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "A milestone for " + hours + " hours already exists.");
                return;
            }
            Milestone newMilestone = new Milestone(hours, new ArrayList<ItemStack>());
            PlayRewardZ.this.milestoneList.add(newMilestone);
            PlayRewardZ.this.milestoneList.sort(Comparator.comparingInt(Milestone::getHours));
            PlayRewardZ.this.saveMilestones();
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Created new milestone for " + hours + " hours of playtime.");
            sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "Use '/milestone item add " + hours + "' to add rewards.");
        }

        private void addItemToMilestone(CommandSender sender, int hours) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Only players can add items to milestones.");
                return;
            }
            Player player = (Player)sender;
            ItemStack handItem = player.getInventory().getItemInMainHand();
            if (handItem == null || handItem.getType() == Material.AIR) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You must hold an item in your main hand to add it as a reward.");
                return;
            }
            Milestone targetMilestone = null;
            for (Milestone milestone : PlayRewardZ.this.milestoneList) {
                if (milestone.getHours() != hours) continue;
                targetMilestone = milestone;
                break;
            }
            if (targetMilestone == null) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "No milestone found for " + hours + " hours. Create it first with /milestone create " + hours);
                return;
            }
            targetMilestone.addReward(handItem.clone());
            PlayRewardZ.this.saveMilestones();
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Added " + this.formatItemName(handItem) + " x" + handItem.getAmount() + " to the " + hours + " hour milestone.");
        }

        private void removeItemFromMilestone(CommandSender sender, int hours, int index) {
            Milestone targetMilestone = null;
            for (Milestone milestone : PlayRewardZ.this.milestoneList) {
                if (milestone.getHours() != hours) continue;
                targetMilestone = milestone;
                break;
            }
            if (targetMilestone == null) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "No milestone found for " + hours + " hours.");
                return;
            }
            List<ItemStack> rewards = targetMilestone.getRewards();
            if (index < 1 || index > rewards.size()) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Invalid item index. Use '/milestone list' to see available items.");
                return;
            }
            ItemStack removedItem = rewards.get(index - 1);
            rewards.remove(index - 1);
            PlayRewardZ.this.saveMilestones();
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Removed " + this.formatItemName(removedItem) + " from the " + hours + " hour milestone.");
        }

        private void deleteMilestone(CommandSender sender, int hours) {
            Milestone targetMilestone = null;
            int index = -1;
            for (int i = 0; i < PlayRewardZ.this.milestoneList.size(); ++i) {
                if (PlayRewardZ.this.milestoneList.get(i).getHours() != hours) continue;
                targetMilestone = PlayRewardZ.this.milestoneList.get(i);
                index = i;
                break;
            }
            if (targetMilestone == null) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "No milestone found for " + hours + " hours.");
                return;
            }
            PlayRewardZ.this.milestoneList.remove(index);
            PlayRewardZ.this.saveMilestones();
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Deleted the " + hours + " hour milestone.");
        }
    }
}

