/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers.trophies;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import trofers.trophy.builder.TrophyBuilder;

public abstract class TrophyProvider {
    private final Map<ResourceLocation, TrophyBuilder<?>> trophies = new HashMap();

    public abstract void addTrophies();

    public List<LootTableProvider.SubProviderEntry> getLootTables() {
        return Collections.emptyList();
    }

    protected void addTrophy(ResourceLocation id, TrophyBuilder<?> builder) {
        if (this.trophies.containsKey(id)) {
            throw new IllegalStateException("Duplicate trophy: " + id.toString());
        }
        this.trophies.put(id, builder);
    }

    public Map<ResourceLocation, TrophyBuilder<?>> getTrophies() {
        return ImmutableMap.copyOf(this.trophies);
    }

    public String getModId() {
        return "trofers";
    }

    protected ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.getModId(), (String)path);
    }

    protected CompoundTag item(String itemName) {
        CompoundTag result = new CompoundTag();
        result.putString("id", this.id(itemName).toString());
        return result;
    }
}

