/*
 * Decompiled with CFR 0.152.
 */
package trofers.block;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.entity.TrophyBlockEntity;
import trofers.registry.ModBlockEntityTypes;
import trofers.screen.TrophySelectionScreen;
import trofers.trophy.Trophy;

public class TrophyBlock
extends class_2237 {
    public static final String DESCRIPTION_ID = class_156.method_646((String)"block", (class_2960)Trofers.id("trophy"));
    private final int height;
    private final class_265 shape;

    private TrophyBlock(class_4970.class_2251 properties, int height, class_265 shape) {
        super(properties);
        this.height = height;
        this.shape = shape;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043));
    }

    public static TrophyBlock createPillarTrophy(class_4970.class_2251 properties, int size) {
        return new TrophyBlock(properties, size, TrophyBlock.createPillarShape(size));
    }

    public static TrophyBlock createPlateTrophy(class_4970.class_2251 properties, int size) {
        return new TrophyBlock(properties, 2, TrophyBlock.createPlateShape(size));
    }

    private static class_265 createPillarShape(int size) {
        int width = 2 * (size - 2);
        return class_259.method_17786((class_265)TrophyBlock.centeredBox(width, 0, 2), (class_265[])new class_265[]{TrophyBlock.centeredBox(width - 2, 2, size - 2), TrophyBlock.centeredBox(width, size - 2, size)});
    }

    private static class_265 createPlateShape(int size) {
        int width = 2 * (size - 2);
        return TrophyBlock.method_9541((double)(8.0 - (double)width / 2.0), (double)0.0, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)2.0, (double)(8.0 + (double)width / 2.0));
    }

    private static class_265 centeredBox(int width, int minY, int maxY) {
        return TrophyBlock.method_9541((double)(8.0 - (double)width / 2.0), (double)minY, (double)(8.0 - (double)width / 2.0), (double)(8.0 + (double)width / 2.0), (double)maxY, (double)(8.0 + (double)width / 2.0));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shape;
    }

    public int getHeight() {
        return this.height;
    }

    public String method_9539() {
        return DESCRIPTION_ID;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null) {
            tooltip.addAll(trophy.tooltip());
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TrophyBlockEntity) {
            TrophyBlockEntity blockEntity = (TrophyBlockEntity)class_25862;
            if (placer instanceof class_1657) {
                class_1657 player = (class_1657)placer;
                if (!level.method_8608() && player.method_7337()) {
                    blockEntity.removeCooldown();
                }
            }
        }
    }

    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12508});
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        boolean isWaterlogged = context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910;
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 pos, class_2338 facingPos) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, facing, facingState, level, pos, facingPos);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ((class_2591)ModBlockEntityTypes.TROPHY.get()).method_11032(pos, state);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        TrophyBlockEntity blockEntity;
        class_1799 result = super.method_9574(level, pos, state);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)class_25862).getTrophyID() != null) {
            result.method_7911("BlockEntityTag").method_10582("Trophy", blockEntity.getTrophyID().toString());
        }
        return result;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        TrophyBlockEntity blockEntity;
        if (player.method_7337()) {
            if (level.method_8608()) {
                TrophySelectionScreen.open(state, pos);
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TrophyBlockEntity && (blockEntity = (TrophyBlockEntity)class_25862).applyEffect(player, hand)) {
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> blockEntityType) {
        return level.method_8608() ? null : TrophyBlock.method_31618(blockEntityType, (class_2591)((class_2591)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntity.TICKER);
    }
}

