/*
 * Decompiled with CFR 0.152.
 */
package trofers.network;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import trofers.trophy.Trophy;
import trofers.trophy.TrophyManager;
import trofers.trophy.TrophySearchTreeManager;

public class TrophySyncPacket {
    private final Map<class_2960, Trophy> trophies;

    public TrophySyncPacket(class_2540 buffer) {
        this.trophies = new HashMap<class_2960, Trophy>();
        while (buffer.readBoolean()) {
            Trophy trophy = Trophy.fromNetwork(buffer);
            this.trophies.put(trophy.id(), trophy);
        }
    }

    public TrophySyncPacket(Map<class_2960, Trophy> trophies) {
        this.trophies = trophies;
    }

    void encode(class_2540 buffer) {
        this.trophies.values().forEach(trophy -> {
            buffer.writeBoolean(true);
            trophy.toNetwork(buffer);
        });
        buffer.writeBoolean(false);
    }

    void apply(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            TrophyManager.setTrophies(this.trophies);
            TrophySearchTreeManager.createSearchTree();
        });
    }
}

