/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import trofers.util.JsonHelper;

public class EntityInfo {
    private final class_1299<?> type;
    private final class_2487 nbt;
    private final boolean isAnimated;
    @Nullable
    private class_1297 entity;

    public EntityInfo(class_1299<?> type, class_2487 nbt, boolean isAnimated) {
        this.type = type;
        this.nbt = nbt;
        this.isAnimated = isAnimated;
    }

    @Nullable
    public class_1299<?> getType() {
        return this.type;
    }

    public class_2487 getTag() {
        return this.nbt;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    @Nullable
    public class_1297 getOrCreateEntity(class_1937 level) {
        if (this.entity == null || this.entity.method_37908() != level) {
            this.createEntity(level);
        }
        return this.entity;
    }

    private void createEntity(class_1937 level) {
        if (this.type == null || !this.type.method_45322().method_45400(level.method_45162())) {
            return;
        }
        class_2487 entityTag = this.nbt.method_10553();
        entityTag.method_10582("id", class_7923.field_41177.method_10221(this.getType()).toString());
        if (!entityTag.method_25928("UUID")) {
            entityTag.method_25927("UUID", new UUID(1L, 1L));
        }
        this.entity = class_1299.method_17842((class_2487)entityTag, (class_1937)level, Function.identity());
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_10812(class_7923.field_41177.method_10221(this.getType()));
        buffer.method_10794(this.nbt);
        buffer.writeBoolean(this.isAnimated);
    }

    public static EntityInfo fromNetwork(class_2540 buffer) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(buffer.method_10810());
        return new EntityInfo(type, buffer.method_10798(), buffer.readBoolean());
    }

    public static EntityInfo fromJson(JsonObject object) {
        class_2960 typeID = new class_2960(class_3518.method_15265((JsonObject)object, (String)"type"));
        if (!class_7923.field_41177.method_10250(typeID)) {
            throw new JsonParseException(String.format("Unknown entity type %s", typeID));
        }
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(typeID);
        class_2487 nbt = new class_2487();
        if (object.has("nbt")) {
            JsonElement nbtElement = object.get("nbt");
            nbt = JsonHelper.deserializeNBT(nbtElement);
        }
        boolean isAnimated = false;
        if (object.has("animated")) {
            isAnimated = class_3518.method_15270((JsonObject)object, (String)"animated");
        }
        return new EntityInfo(type, nbt, isAnimated);
    }
}

